/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.formlayout;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.JsonSerializable;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.NativeLabel;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.dom.Element;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

@Tag(value="vaadin-form-layout")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.8.7"), @NpmPackage(value="@vaadin/form-layout", version="24.8.7")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/form-layout/src/vaadin-form-layout.js")})
public class FormLayout
extends Component
implements HasSize,
HasStyle,
HasComponents,
ClickNotifier<FormLayout> {
    public FormLayout() {
    }

    public FormLayout(Component ... components) {
        this.add(components);
    }

    public void setColspan(Component component, int colspan) {
        Objects.requireNonNull(component, "component cannot be null");
        component.getElement().setAttribute("colspan", String.valueOf(Math.max(1, colspan)));
    }

    public void add(Component component, int colspan) {
        this.add(new Component[]{component});
        this.setColspan(component, colspan);
    }

    public int getColspan(Component component) {
        String colspan = component.getElement().getAttribute("colspan");
        if (colspan != null && colspan.matches("\\d+")) {
            return Integer.parseInt(colspan);
        }
        return 1;
    }

    public List<ResponsiveStep> getResponsiveSteps() {
        JsonArray stepsJsonArray = (JsonArray)this.getElement().getPropertyRaw("responsiveSteps");
        if (stepsJsonArray == null) {
            return Collections.emptyList();
        }
        ArrayList<ResponsiveStep> steps = new ArrayList<ResponsiveStep>();
        for (int i = 0; i < stepsJsonArray.length(); ++i) {
            steps.add(new ResponsiveStep(null, 0).readJson((JsonObject)stepsJsonArray.get(i)));
        }
        return steps;
    }

    public void setResponsiveSteps(List<ResponsiveStep> steps) {
        AtomicInteger index = new AtomicInteger();
        this.getElement().setPropertyJson("responsiveSteps", (JsonValue)steps.stream().map(ResponsiveStep::toJson).collect(Json::createArray, (arr, value) -> arr.set(index.getAndIncrement(), (JsonValue)value), (arr, arrOther) -> {
            int startIndex = arr.length();
            for (int i = 0; i < arrOther.length(); ++i) {
                JsonValue value = arrOther.get(i);
                arr.set(startIndex + i, value);
            }
        }));
    }

    public void setResponsiveSteps(ResponsiveStep ... steps) {
        this.setResponsiveSteps(Arrays.asList(steps));
    }

    public FormItem addFormItem(Component field, String label) {
        return this.addFormItem(field, (Component)new NativeLabel(label));
    }

    public FormItem addFormItem(Component field, Component label) {
        FormItem formItem = new FormItem(field);
        formItem.addToLabel(label);
        this.add(new Component[]{formItem});
        return formItem;
    }

    public FormRow addFormRow(Component ... components) {
        FormRow formRow = new FormRow();
        formRow.add(components);
        this.add(new Component[]{formRow});
        return formRow;
    }

    public void setLabelWidth(String width) {
        this.getStyle().set("--vaadin-form-layout-label-width", width);
    }

    public void setLabelWidth(float width, Unit unit) {
        Objects.requireNonNull(unit, "Unit cannot be null");
        this.setLabelWidth(width + unit.toString());
    }

    public String getLabelWidth() {
        return this.getStyle().get("--vaadin-form-layout-label-width");
    }

    public void setLabelSpacing(String labelSpacing) {
        this.getStyle().set("--vaadin-form-layout-label-spacing", labelSpacing);
    }

    public void setLabelSpacing(float labelSpacing, Unit unit) {
        Objects.requireNonNull(unit, "Unit cannot be null");
        this.setLabelSpacing(labelSpacing + unit.toString());
    }

    public String getLabelSpacing() {
        return this.getStyle().get("--vaadin-form-layout-label-spacing");
    }

    public void setColumnSpacing(String columnSpacing) {
        this.getStyle().set("--vaadin-form-layout-column-spacing", columnSpacing);
    }

    public void setColumnSpacing(float columnSpacing, Unit unit) {
        Objects.requireNonNull(unit, "Unit cannot be null");
        this.setColumnSpacing(columnSpacing + unit.toString());
    }

    public String getColumnSpacing() {
        return this.getStyle().get("--vaadin-form-layout-column-spacing");
    }

    public void setRowSpacing(String rowSpacing) {
        this.getStyle().set("--vaadin-form-layout-row-spacing", rowSpacing);
    }

    public void setRowSpacing(float rowSpacing, Unit unit) {
        Objects.requireNonNull(unit, "Unit cannot be null");
        this.setRowSpacing(rowSpacing + unit.toString());
    }

    public String getRowSpacing() {
        return this.getStyle().get("--vaadin-form-layout-row-spacing");
    }

    public void setAutoResponsive(boolean autoResponsive) {
        this.getElement().setProperty("autoResponsive", autoResponsive);
    }

    public void setAutoRows(boolean autoRows) {
        this.getElement().setProperty("autoRows", autoRows);
    }

    public boolean isAutoRows() {
        return this.getElement().getProperty("autoRows", false);
    }

    public void setColumnWidth(String columnWidth) {
        this.getElement().setProperty("columnWidth", columnWidth);
    }

    public void setColumnWidth(float columnWidth, Unit unit) {
        Objects.requireNonNull(unit, "Unit cannot be null");
        this.setColumnWidth(columnWidth + unit.toString());
    }

    public String getColumnWidth() {
        return this.getElement().getProperty("columnWidth");
    }

    public void setMaxColumns(int maxColumns) {
        this.getElement().setProperty("maxColumns", (double)maxColumns);
    }

    public int getMaxColumns() {
        return this.getElement().getProperty("maxColumns", 0);
    }

    public void setMinColumns(int minColumns) {
        this.getElement().setProperty("minColumns", (double)minColumns);
    }

    public int getMinColumns() {
        return this.getElement().getProperty("minColumns", 0);
    }

    public void setExpandColumns(boolean expandColumns) {
        this.getElement().setProperty("expandColumns", expandColumns);
    }

    public boolean isExpandColumns() {
        return this.getElement().getProperty("expandColumns", false);
    }

    public void setExpandFields(boolean expandFields) {
        this.getElement().setProperty("expandFields", expandFields);
    }

    public boolean isExpandFields() {
        return this.getElement().getProperty("expandFields", false);
    }

    public void setLabelsAside(boolean labelsAside) {
        this.getElement().setProperty("labelsAside", labelsAside);
    }

    public boolean isLabelsAside() {
        return this.getElement().getProperty("labelsAside", false);
    }

    public static class ResponsiveStep
    implements JsonSerializable {
        private static final String MIN_WIDTH_JSON_KEY = "minWidth";
        private static final String COLUMNS_JSON_KEY = "columns";
        private static final String LABELS_POSITION_JSON_KEY = "labelsPosition";
        private String minWidth;
        private int columns;
        private LabelsPosition labelsPosition;

        public ResponsiveStep(String minWidth, int columns) {
            this.minWidth = minWidth;
            this.columns = columns;
        }

        public ResponsiveStep(String minWidth, int columns, LabelsPosition labelsPosition) {
            this.minWidth = minWidth;
            this.columns = columns;
            this.labelsPosition = labelsPosition;
        }

        public JsonObject toJson() {
            JsonObject json = Json.createObject();
            if (this.minWidth != null && !this.minWidth.trim().isEmpty()) {
                json.put(MIN_WIDTH_JSON_KEY, this.minWidth);
            }
            json.put(COLUMNS_JSON_KEY, (double)this.columns);
            if (this.labelsPosition != null) {
                json.put(LABELS_POSITION_JSON_KEY, this.labelsPosition.toString());
            }
            return json;
        }

        public ResponsiveStep readJson(JsonObject value) {
            JsonValue minWidthValue = value.get(MIN_WIDTH_JSON_KEY);
            this.minWidth = minWidthValue != null ? minWidthValue.asString() : null;
            this.columns = (int)value.getNumber(COLUMNS_JSON_KEY);
            JsonValue labelsPositionValue = value.get(LABELS_POSITION_JSON_KEY);
            if (labelsPositionValue != null) {
                String labelsPositionString = labelsPositionValue.asString();
                if ("aside".equals(labelsPositionString)) {
                    this.labelsPosition = LabelsPosition.ASIDE;
                } else if ("top".equals(labelsPositionString)) {
                    this.labelsPosition = LabelsPosition.TOP;
                }
            } else {
                this.labelsPosition = null;
            }
            return this;
        }

        public static enum LabelsPosition {
            ASIDE,
            TOP;


            public String toString() {
                return this.name().toLowerCase(Locale.ENGLISH);
            }
        }
    }

    @Tag(value="vaadin-form-item")
    @NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.8.7"), @NpmPackage(value="@vaadin/form-layout", version="24.8.7")})
    @JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/form-layout/src/vaadin-form-item.js")})
    public static class FormItem
    extends Component
    implements HasComponents,
    HasStyle,
    ClickNotifier<FormItem> {
        public FormItem() {
        }

        public FormItem(Component ... components) {
            this.add(components);
        }

        protected void addToLabel(Component ... components) {
            SlotUtils.addToSlot((HasElement)this, (String)"label", (Component[])components);
        }

        public void removeAll() {
            this.getElement().getChildren().forEach(child -> child.removeAttribute("slot"));
            this.getElement().removeAllChildren();
        }

        public void remove(Component ... components) {
            for (Component component : components) {
                if (!this.getElement().equals((Object)component.getElement().getParent())) {
                    throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
                }
                component.getElement().removeAttribute("slot");
                this.getElement().removeChild(new Element[]{component.getElement()});
            }
        }
    }

    @Tag(value="vaadin-form-row")
    @NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.8.7"), @NpmPackage(value="@vaadin/form-layout", version="24.8.7")})
    @JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/form-layout/src/vaadin-form-row.js")})
    public static class FormRow
    extends Component
    implements HasComponents {
        public void add(Component component, int colspan) {
            this.add(new Component[]{component});
            this.setColspan(component, colspan);
        }

        public void setColspan(Component component, int colspan) {
            Objects.requireNonNull(component, "component cannot be null");
            component.getElement().setAttribute("colspan", String.valueOf(Math.max(1, colspan)));
        }

        public int getColspan(Component component) {
            String colspan = component.getElement().getAttribute("colspan");
            if (colspan != null && colspan.matches("\\d+")) {
                return Integer.parseInt(colspan);
            }
            return 1;
        }

        public FormItem addFormItem(Component field, String label) {
            return this.addFormItem(field, (Component)new NativeLabel(label));
        }

        public FormItem addFormItem(Component field, Component label) {
            FormItem formItem = new FormItem(field);
            formItem.addToLabel(label);
            this.add(new Component[]{formItem});
            return formItem;
        }
    }
}

