/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.AbstractSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.model.BatchId;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.transport.AbstractTransportManager;
import org.jumpmind.symmetric.transport.IHttpConnectionHandler;
import org.jumpmind.symmetric.transport.IIncomingTransport;
import org.jumpmind.symmetric.transport.IOutgoingWithResponseTransport;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.transport.TransportUtils;
import org.jumpmind.symmetric.transport.http.HttpConnection;
import org.jumpmind.symmetric.transport.http.HttpIncomingTransport;
import org.jumpmind.symmetric.transport.http.HttpOutgoingTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTransportManager
extends AbstractTransportManager
implements ITransportManager {
    private static final Logger log = LoggerFactory.getLogger(HttpTransportManager.class);
    public static final int DEFAULT_MAX_FORM_KEYS = 100000;
    protected ISymmetricEngine engine;
    protected Map<String, String> sessionIdByUri = new HashMap<String, String>();
    protected boolean useHeaderSecurityToken;
    protected boolean useSessionAuth;
    protected int backOffPostCount;

    public HttpTransportManager() {
    }

    public HttpTransportManager(ISymmetricEngine engine) {
        super(engine.getExtensionService());
        this.engine = engine;
        this.useHeaderSecurityToken = engine.getParameterService().is("http.use.header.security.token");
        this.useSessionAuth = engine.getParameterService().is("http.use.session.auth");
    }

    @Override
    public int sendCopyRequest(Node local) throws IOException {
        StringBuilder data = new StringBuilder();
        Map<String, BatchId> batchIds = this.engine.getIncomingBatchService().findMaxBatchIdsByChannel();
        for (String channelId : batchIds.keySet()) {
            if ("config".equals(channelId) || "heartbeat".equals(channelId) || "system".equals(channelId)) continue;
            BatchId batchId = batchIds.get(channelId);
            HttpTransportManager.append(data, channelId + "-" + batchId.getNodeId(), batchId.getBatchId());
        }
        String securityToken = this.engine.getNodeService().findNodeSecurity(local.getNodeId()).getNodePassword();
        String url = this.addNodeInfo(this.engine.getParameterService().getRegistrationUrl() + "/copy", local.getNodeId(), securityToken, false);
        url = this.add(url, "externalId", this.engine.getParameterService().getExternalId(), "&");
        url = this.add(url, "nodeGroupId", this.engine.getParameterService().getNodeGroupId(), "&");
        log.info("Contact server to do node copy using a url of: " + url);
        return this.sendMessage(new URL(url), local.getNodeId(), securityToken, null, data.toString());
    }

    @Override
    public int sendStatusRequest(Node local, Map<String, String> statuses) throws IOException {
        String securityToken = this.engine.getNodeService().findNodeSecurity(local.getNodeId()).getNodePassword();
        String url = this.addNodeInfo(this.engine.getParameterService().getRegistrationUrl() + "/pushstatus/", local.getNodeId(), securityToken, false);
        url = this.add(url, "externalId", this.engine.getParameterService().getExternalId(), "&");
        url = this.add(url, "nodeGroupId", this.engine.getParameterService().getNodeGroupId(), "&");
        for (String key : statuses.keySet()) {
            url = this.add(url, key, statuses.get(key), "&");
        }
        log.debug("Sending status with URL: " + url);
        return this.sendMessage(new URL(url), local.getNodeId(), securityToken, null, "");
    }

    @Override
    public int sendAcknowledgement(Node remote, List<IncomingBatch> list, Node local, String securityToken, String registrationUrl) throws IOException {
        return this.sendAcknowledgement(remote, list, local, securityToken, null, registrationUrl);
    }

    @Override
    public int sendAcknowledgement(Node remote, List<IncomingBatch> list, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        int statusCode = 200;
        if (list != null && list.size() > 0) {
            int maxFormKeys = this.engine.getParameterService().getInt("transport.max.form.keys");
            if (this.backOffPostCount > 0 && maxFormKeys <= 0) {
                maxFormKeys = 100000;
            }
            for (int i = 0; i < this.backOffPostCount && maxFormKeys > 1; maxFormKeys /= 2, ++i) {
            }
            int maxByteSize = this.engine.getParameterService().getInt("transport.max.bytes.to.sync");
            for (String data : this.getAcknowledgementData(remote.requires13Compatiblity(), local.getNodeId(), list, maxFormKeys, maxByteSize)) {
                log.debug("Sending ack: {}", (Object)data);
                statusCode = this.sendMessage("ack", remote, local, data, securityToken, requestProperties, registrationUrl);
                if (statusCode == 200) continue;
                if (statusCode == 657 || statusCode == 667 || statusCode == 658 || statusCode == 659 || statusCode == 669) break;
                if (maxFormKeys > 0 && maxFormKeys <= 24) {
                    log.error("Ack received a {} response from node {}. The form key limit of {} cannot be reduced any further.", new Object[]{statusCode, remote.getNodeId(), maxFormKeys});
                    break;
                }
                ++this.backOffPostCount;
                if (maxFormKeys > 24) {
                    log.warn("Ack received a {} response from node {}. The form key limit will be reduced from {} to {} during the next attempt.", new Object[]{statusCode, remote.getNodeId(), maxFormKeys, Math.max(maxFormKeys / 2, 24)});
                    break;
                }
                log.warn("Ack received a {} response from node {}. A form key limit of {} will take effect during the next attempt.", new Object[]{statusCode, remote.getNodeId(), 50000});
                break;
            }
        }
        return statusCode;
    }

    @Override
    public void writeAcknowledgement(OutputStream out, Node remote, List<IncomingBatch> list, Node local, String securityToken) throws IOException {
        for (String data : this.getAcknowledgementData(remote.requires13Compatiblity(), local.getNodeId(), list, -1, -1)) {
            log.debug("Sending ack: {}", (Object)data);
            this.writeMessage(out, data);
        }
    }

    protected int sendMessage(String action, Node remote, Node local, String data, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        return this.sendMessage(new URL(this.buildURL(action, remote, local, securityToken, registrationUrl)), local.getNodeId(), securityToken, requestProperties, data);
    }

    protected int sendMessage(URL url, String nodeId, String securityToken, Map<String, String> requestProperties, String data) throws IOException {
        int rc;
        block21: {
            rc = 0;
            try (HttpConnection conn = this.openConnection(url, nodeId, securityToken);){
                if (requestProperties != null) {
                    for (String key : requestProperties.keySet()) {
                        conn.addRequestProperty(key, requestProperties.get(key));
                    }
                }
                conn.setRequestMethod("POST");
                conn.setAllowUserInteraction(false);
                conn.setDoOutput(true);
                conn.setConnectTimeout(this.getHttpConnectTimeOutInMs());
                conn.setReadTimeout(this.getHttpTimeOutInMs());
                try (OutputStream os = conn.getOutputStream();){
                    this.writeMessage(os, data);
                    this.checkForConnectionUpgrade(conn);
                    rc = conn.getResponseCode();
                    if (rc != 200) break block21;
                    try (InputStream is = conn.getInputStream();){
                        byte[] bytes = new byte[32];
                        while (is.read(bytes) != -1) {
                            log.debug("Read keep-alive");
                        }
                    }
                }
            }
        }
        return rc;
    }

    protected void checkForConnectionUpgrade(HttpConnection conn) {
    }

    public HttpConnection openConnection(URL url, String nodeId, String securityToken) throws IOException {
        String sessionId;
        HttpConnection conn = new HttpConnection(url);
        IHttpConnectionHandler handler = this.extensionService.getExtensionPoint(IHttpConnectionHandler.class);
        if (handler != null) {
            handler.prepare(conn);
        }
        conn.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
        boolean hasSession = false;
        if (this.useSessionAuth && (sessionId = this.sessionIdByUri.get(this.getUri(conn))) != null) {
            conn.setRequestProperty("Session-ID", sessionId);
            hasSession = true;
        }
        if (securityToken != null && this.useHeaderSecurityToken && !hasSession) {
            conn.setRequestProperty("Security-Token", securityToken);
        }
        return conn;
    }

    public void checkResponseCode(HttpConnection conn, int responseCode) {
        IHttpConnectionHandler handler = this.extensionService.getExtensionPoint(IHttpConnectionHandler.class);
        if (handler != null) {
            handler.checkResponse(conn, responseCode);
        }
    }

    public void updateSession(HttpConnection conn) {
        String sessionId;
        if (this.useSessionAuth && (sessionId = conn.getHeaderField("Set-Session-ID")) != null) {
            this.sessionIdByUri.put(this.getUri(conn), sessionId);
        }
    }

    public void clearSession(HttpConnection conn) {
        if (this.useSessionAuth) {
            this.sessionIdByUri.remove(this.getUri(conn));
        }
    }

    protected String getUri(HttpConnection conn) {
        String uri = conn.getURL().toExternalForm();
        uri = uri.substring(0, uri.lastIndexOf("/"));
        return uri;
    }

    public int getOutputStreamSize() {
        return this.engine.getParameterService().getInt("http.push.stream.output.size");
    }

    public boolean isOutputStreamEnabled() {
        return this.engine.getParameterService().is("http.push.stream.output.enabled");
    }

    public int getHttpTimeOutInMs() {
        return this.engine.getParameterService().getInt("http.timeout.ms");
    }

    public int getHttpConnectTimeOutInMs() {
        return this.engine.getParameterService().getInt("http.connect.timeout.ms");
    }

    public boolean isUseCompression(Node targetNode) {
        ISymmetricEngine targetEngine = AbstractSymmetricEngine.findEngineByUrl(targetNode.getSyncUrl());
        return this.engine.getParameterService().is("http.compression") && targetEngine == null;
    }

    public int getCompressionLevel() {
        return this.engine.getParameterService().getInt("compression.level");
    }

    public int getCompressionStrategy() {
        return this.engine.getParameterService().getInt("compression.strategy");
    }

    public void writeMessage(OutputStream out, String data) throws IOException {
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8), true);
        pw.println(data);
        pw.flush();
    }

    @Override
    public IIncomingTransport getFilePullTransport(Node remote, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        HttpConnection conn = this.createGetConnectionFor(new URL(this.buildURL("filesync/pull", remote, local, securityToken, registrationUrl)), local.getNodeId(), securityToken);
        if (requestProperties != null) {
            for (String key : requestProperties.keySet()) {
                conn.addRequestProperty(key, requestProperties.get(key));
            }
        }
        return new HttpIncomingTransport(this, conn, this.engine.getParameterService(), local.getNodeId(), securityToken);
    }

    @Override
    public IIncomingTransport getPullTransport(Node remote, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        HttpConnection conn = this.createGetConnectionFor(new URL(this.buildURL("pull", remote, local, securityToken, registrationUrl)), local.getNodeId(), securityToken);
        if (requestProperties != null) {
            for (String key : requestProperties.keySet()) {
                conn.addRequestProperty(key, requestProperties.get(key));
            }
        }
        return new HttpIncomingTransport(this, conn, this.engine.getParameterService(), local.getNodeId(), securityToken);
    }

    @Override
    public IIncomingTransport getPingTransport(Node remote, Node local, String registrationUrl) throws IOException {
        HttpConnection conn = this.createGetConnectionFor(new URL(this.resolveURL(remote.getSyncUrl(), registrationUrl) + "/ping"));
        return new HttpIncomingTransport(this, conn, this.engine.getParameterService());
    }

    @Override
    public IOutgoingWithResponseTransport getPushTransport(Node remote, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        URL url = new URL(this.buildURL("push", remote, local, securityToken, registrationUrl));
        return new HttpOutgoingTransport(this, url, this.getHttpTimeOutInMs(), this.getHttpConnectTimeOutInMs(), this.isUseCompression(remote), this.getCompressionStrategy(), this.getCompressionLevel(), local.getNodeId(), securityToken, this.isOutputStreamEnabled(), this.getOutputStreamSize(), false, requestProperties);
    }

    @Override
    public IOutgoingWithResponseTransport getPushTransport(Node remote, Node local, String securityToken, String registrationUrl) throws IOException {
        URL url = new URL(this.buildURL("push", remote, local, securityToken, registrationUrl));
        return new HttpOutgoingTransport(this, url, this.getHttpTimeOutInMs(), this.getHttpConnectTimeOutInMs(), this.isUseCompression(remote), this.getCompressionStrategy(), this.getCompressionLevel(), local.getNodeId(), securityToken, this.isOutputStreamEnabled(), this.getOutputStreamSize(), false);
    }

    @Override
    public IOutgoingWithResponseTransport getFilePushTransport(Node remote, Node local, String securityToken, String registrationUrl) throws IOException {
        URL url = new URL(this.buildURL("filesync/push", remote, local, securityToken, registrationUrl));
        return new HttpOutgoingTransport(this, url, this.getHttpTimeOutInMs(), this.getHttpConnectTimeOutInMs(), this.isUseCompression(remote), this.getCompressionStrategy(), this.getCompressionLevel(), local.getNodeId(), securityToken, this.isOutputStreamEnabled(), this.getOutputStreamSize(), true);
    }

    @Override
    public IIncomingTransport getConfigTransport(Node remote, Node local, String securityToken, String symmetricVersion, String configVersion, String registrationUrl) throws IOException {
        StringBuilder builder = new StringBuilder(this.buildURL("config", remote, local, securityToken, registrationUrl));
        HttpTransportManager.append(builder, "symmetricVersion", symmetricVersion);
        HttpTransportManager.append(builder, "configVersion", configVersion);
        HttpConnection conn = this.createGetConnectionFor(new URL(builder.toString()), local.getNodeId(), securityToken);
        return new HttpIncomingTransport(this, conn, this.engine.getParameterService());
    }

    @Override
    public IIncomingTransport getRegisterTransport(Node node, String registrationUrl) throws IOException {
        return this.getRegisterTransport(node, registrationUrl, null);
    }

    @Override
    public IIncomingTransport getRegisterTransport(Node node, String registrationUrl, Map<String, String> requestProperties) throws IOException {
        return new HttpIncomingTransport(this, this.createGetConnectionFor(new URL(HttpTransportManager.buildRegistrationUrl(registrationUrl, node))), this.engine.getParameterService(), TransportUtils.convertNodeToProperties(node, requestProperties));
    }

    @Override
    public IOutgoingWithResponseTransport getRegisterPushTransport(Node remote, Node local) throws IOException {
        StringBuilder builder = new StringBuilder(HttpTransportManager.buildRegistrationUrl(remote.getSyncUrl(), remote)).append("?");
        HttpTransportManager.append(builder, "pushRegistration", Boolean.TRUE);
        HttpTransportManager.append(builder, "nodeId", local.getNodeId());
        HttpTransportManager.append(builder, "nodeGroupId", local.getNodeGroupId());
        HttpTransportManager.append(builder, "externalId", local.getExternalId());
        HttpTransportManager.append(builder, "syncURL", local.getSyncUrl());
        URL url = new URL(builder.toString());
        return new HttpOutgoingTransport(this, url, this.getHttpTimeOutInMs(), this.getHttpConnectTimeOutInMs(), this.isUseCompression(remote), this.getCompressionStrategy(), this.getCompressionLevel(), local.getNodeId(), null, this.isOutputStreamEnabled(), this.getOutputStreamSize(), false);
    }

    @Override
    public IIncomingTransport getBandwidthPullTransport(Node remote, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl, long sampleSize) throws IOException {
        boolean supportsPropertiesInHeader;
        StringBuilder urlBuilder = new StringBuilder(this.buildURL("bandwidth", remote, local, securityToken, registrationUrl));
        boolean bl = supportsPropertiesInHeader = !Version.isOlderThanVersion(remote.getSymmetricVersion(), "3.16.4");
        if (!supportsPropertiesInHeader) {
            if (requestProperties != null) {
                for (Map.Entry<String, String> entry : requestProperties.entrySet()) {
                    HttpTransportManager.append(urlBuilder, entry.getKey(), entry.getValue());
                }
            }
            HttpTransportManager.append(urlBuilder, "direction", "pull");
            HttpTransportManager.append(urlBuilder, "sampleSize", String.valueOf(sampleSize));
        }
        String localNodeId = local.getNodeId();
        HttpConnection conn = this.createGetConnectionFor(new URL(urlBuilder.toString()), localNodeId, securityToken);
        if (supportsPropertiesInHeader) {
            if (requestProperties != null) {
                for (Map.Entry<String, String> entry : requestProperties.entrySet()) {
                    conn.addRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            conn.addRequestProperty("Direction", "pull");
            conn.addRequestProperty("Sample-Size", String.valueOf(sampleSize));
        }
        return new HttpIncomingTransport(this, conn, this.engine.getParameterService(), localNodeId, securityToken);
    }

    @Override
    public IOutgoingWithResponseTransport getBandwidthPushTransport(Node remote, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        boolean supportsPropertiesInHeader;
        StringBuilder urlBuilder = new StringBuilder(this.buildURL("bandwidth", remote, local, securityToken, registrationUrl));
        boolean bl = supportsPropertiesInHeader = !Version.isOlderThanVersion(remote.getSymmetricVersion(), "3.16.4");
        if (supportsPropertiesInHeader) {
            if (requestProperties == null) {
                requestProperties = new HashMap<String, String>();
            }
            requestProperties.put("Direction", "push");
        } else {
            if (requestProperties != null) {
                for (Map.Entry<String, String> entry : requestProperties.entrySet()) {
                    HttpTransportManager.append(urlBuilder, entry.getKey(), entry.getValue());
                }
            }
            HttpTransportManager.append(urlBuilder, "direction", "push");
        }
        URL url = new URL(urlBuilder.toString());
        return new HttpOutgoingTransport(this, url, this.getHttpTimeOutInMs(), this.getHttpConnectTimeOutInMs(), this.isUseCompression(remote), this.getCompressionStrategy(), this.getCompressionLevel(), local.getNodeId(), securityToken, this.isOutputStreamEnabled(), this.getOutputStreamSize(), false, requestProperties);
    }

    @Override
    public IIncomingTransport getComparePullTransport(Node remote, Node local, String securityToken, String registrationUrl, Map<String, String> requestParameters) throws IOException {
        StringBuilder builder = new StringBuilder(this.buildURL("compare/pull", remote, local, securityToken, registrationUrl));
        for (Map.Entry<String, String> entry : requestParameters.entrySet()) {
            HttpTransportManager.append(builder, entry.getKey(), entry.getValue());
        }
        URL url = new URL(builder.toString());
        HttpConnection conn = this.createGetConnectionFor(url, local.getNodeId(), securityToken);
        conn.addRequestProperty("threadChannel", requestParameters.get("threadChannel"));
        return new HttpIncomingTransport(this, conn, this.engine.getParameterService(), local.getNodeId(), securityToken);
    }

    @Override
    public IOutgoingWithResponseTransport getComparePushTransport(Node remote, Node local, String securityToken, String registrationUrl, Map<String, String> requestParameters) throws IOException {
        StringBuilder builder = new StringBuilder(this.buildURL("compare/push", remote, local, securityToken, registrationUrl));
        for (Map.Entry<String, String> entry : requestParameters.entrySet()) {
            HttpTransportManager.append(builder, entry.getKey(), entry.getValue());
        }
        URL url = new URL(builder.toString());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("threadChannel", requestParameters.get("threadChannel"));
        return new HttpOutgoingTransport(this, url, this.getHttpTimeOutInMs(), this.getHttpConnectTimeOutInMs(), this.isUseCompression(remote), this.getCompressionStrategy(), this.getCompressionLevel(), local.getNodeId(), securityToken, this.isOutputStreamEnabled(), this.getOutputStreamSize(), false, param);
    }

    public static String buildRegistrationUrl(String baseUrl, Node node) {
        if (baseUrl == null) {
            baseUrl = "";
        }
        StringBuilder builder = new StringBuilder(baseUrl);
        builder.append("/registration");
        return builder.toString();
    }

    protected HttpConnection createGetConnectionFor(URL url, String nodeId, String securityToken) throws IOException {
        HttpConnection conn = this.openConnection(url, nodeId, securityToken);
        conn.setRequestProperty("accept-encoding", "gzip");
        conn.setConnectTimeout(this.getHttpConnectTimeOutInMs());
        conn.setReadTimeout(this.getHttpTimeOutInMs());
        conn.setRequestMethod("GET");
        return conn;
    }

    protected HttpConnection createGetConnectionFor(URL url) throws IOException {
        return this.createGetConnectionFor(url, null, null);
    }

    protected static InputStream getInputStreamFrom(HttpConnection connection) throws IOException {
        String type = connection.getContentEncoding();
        InputStream in = connection.getInputStream();
        if (!StringUtils.isBlank((CharSequence)type) && type.equals("gzip")) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    protected static BufferedReader getReaderFrom(HttpConnection connection) throws IOException {
        String type = connection.getContentEncoding();
        InputStream in = connection.getInputStream();
        if (!StringUtils.isBlank((CharSequence)type) && type.equals("gzip")) {
            in = new GZIPInputStream(in);
        }
        return TransportUtils.toReader(in);
    }

    protected String buildURL(String action, Node remote, Node local, String securityToken, String registrationUrl) throws IOException {
        boolean forceParamSecurityToken = Version.isOlderMinorVersion(remote.getSymmetricVersion(), "3.11");
        String url = this.addNodeInfo(this.resolveURL(remote.getSyncUrl(), registrationUrl) + "/" + action, local.getNodeId(), securityToken, forceParamSecurityToken);
        log.debug("Building transport url: {}", (Object)url);
        return url;
    }

    protected String addNodeInfo(String base, String nodeId, String securityToken, boolean forceParamSecurityToken) {
        StringBuilder sb = new StringBuilder(this.addNodeId(base, nodeId, "?"));
        if (!this.useHeaderSecurityToken || forceParamSecurityToken) {
            sb.append("&").append("securityToken").append("=").append(securityToken);
        }
        return sb.toString();
    }

    protected String addNodeId(String base, String nodeId, String connector) {
        return this.add(base, "nodeId", nodeId, connector);
    }

    protected String add(String base, String key, String value, String connector) {
        StringBuilder sb = new StringBuilder(base);
        sb.append(connector);
        sb.append(key);
        sb.append("=");
        try {
            sb.append(URLEncoder.encode(value, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new IoException((Exception)e);
        }
        return sb.toString();
    }

    protected ISymmetricEngine getEngine() {
        return this.engine;
    }
}

