/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.model.BatchAck;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeCommunication;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.model.RemoteNodeStatus;
import org.jumpmind.symmetric.model.RemoteNodeStatuses;
import org.jumpmind.symmetric.service.IAcknowledgeService;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.INodeCommunicationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IPushService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.impl.AbstractOfflineDetectorService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.IOutgoingTransport;
import org.jumpmind.symmetric.transport.IOutgoingWithResponseTransport;
import org.jumpmind.symmetric.transport.ITransportManager;

public class PushService
extends AbstractOfflineDetectorService
implements IPushService,
INodeCommunicationService.INodeCommunicationExecutor {
    private IDataExtractorService dataExtractorService;
    private IAcknowledgeService acknowledgeService;
    private IRegistrationService registrationService;
    private ITransportManager transportManager;
    private INodeService nodeService;
    private IClusterService clusterService;
    private INodeCommunicationService nodeCommunicationService;
    private IStatisticManager statisticManager;
    private IConfigurationService configurationService;
    private IOutgoingBatchService outgoingBatchService;
    private Map<String, Date> startTimesOfNodesBeingPushedTo = new HashMap<String, Date>();

    public PushService(ISymmetricEngine engine) {
        super(engine.getParameterService(), engine.getSymmetricDialect(), engine.getExtensionService());
        this.dataExtractorService = engine.getDataExtractorService();
        this.acknowledgeService = engine.getAcknowledgeService();
        this.registrationService = engine.getRegistrationService();
        this.transportManager = engine.getTransportManager();
        this.nodeService = engine.getNodeService();
        this.clusterService = engine.getClusterService();
        this.nodeCommunicationService = engine.getNodeCommunicationService();
        this.statisticManager = engine.getStatisticManager();
        this.configurationService = engine.getConfigurationService();
        this.outgoingBatchService = engine.getOutgoingBatchService();
    }

    @Override
    public Map<String, Date> getStartTimesOfNodesBeingPushedTo() {
        return new HashMap<String, Date>(this.startTimesOfNodesBeingPushedTo);
    }

    @Override
    public synchronized RemoteNodeStatuses pushData(boolean force) {
        RemoteNodeStatuses statuses = new RemoteNodeStatuses(this.configurationService.getChannels(false));
        Node identity = this.nodeService.findIdentity();
        if (identity != null && identity.isSyncEnabled()) {
            long minimumPeriodMs = this.parameterService.getLong("push.period.minimum.ms", -1L);
            if (force || !this.clusterService.isInfiniteLocked("Push")) {
                List<NodeCommunication> nodes = this.nodeCommunicationService.list(NodeCommunication.CommunicationType.PUSH);
                if (nodes.size() > 0) {
                    NodeSecurity identitySecurity = this.nodeService.findNodeSecurity(identity.getNodeId(), true);
                    if (identitySecurity != null) {
                        int availableThreads = this.nodeCommunicationService.getAvailableThreads(NodeCommunication.CommunicationType.PUSH);
                        boolean isMasterToMaster = this.configurationService.isMasterToMaster();
                        nodes = this.filterForReadyQueues(nodes);
                        for (NodeCommunication nodeCommunication : nodes) {
                            boolean meetsMinimumTime = true;
                            if (minimumPeriodMs > 0L && nodeCommunication.getLastLockTime() != null && System.currentTimeMillis() - nodeCommunication.getLastLockTime().getTime() < minimumPeriodMs) {
                                meetsMinimumTime = false;
                            }
                            boolean m2mLoadInProgress = false;
                            if (isMasterToMaster && this.nodeService.isDataLoadStarted(nodeCommunication.getNodeId())) {
                                NodeSecurity nodeSecurity = this.nodeService.findNodeSecurity(nodeCommunication.getNodeId(), true);
                                boolean bl = m2mLoadInProgress = nodeSecurity != null && "registration".equals(nodeSecurity.getInitialLoadCreateBy()) && !identitySecurity.getNodeId().equals(nodeSecurity.getCreatedAtNodeId());
                                if (m2mLoadInProgress) {
                                    this.log.debug("Not pushing to node {} until initial load from {} is complete", (Object)nodeCommunication.getNodeId(), (Object)nodeSecurity.getCreatedAtNodeId());
                                }
                            }
                            if (availableThreads <= 0 || !meetsMinimumTime || m2mLoadInProgress || !this.nodeCommunicationService.execute(nodeCommunication, statuses, this)) continue;
                            --availableThreads;
                        }
                    } else {
                        identity = this.nodeService.findIdentity(false);
                        if (identity != null && this.nodeService.findNodeSecurity(identity.getNodeId(), false) == null) {
                            this.log.error("Could not find my node security row, which is needed to authenticate as node {}", (Object)identity.getNodeId());
                        }
                    }
                }
            } else {
                this.log.debug("Did not run the push process because it has been stopped");
            }
        }
        return statuses;
    }

    protected List<NodeCommunication> filterForReadyQueues(List<NodeCommunication> nodes) {
        List<NodeCommunication> filteredNodes = nodes;
        if (this.parameterService.is("sync.use.ready.queues") && this.configurationService.getQueues(false).size() > 1 && !this.parameterService.is("route.on.extract")) {
            filteredNodes = new ArrayList<NodeCommunication>();
            for (NodeCommunication nodeCommunication : nodes) {
                Collection<String> readyQueues = this.outgoingBatchService.getReadyQueues(nodeCommunication.getNodeId(), false);
                if (!readyQueues.contains(nodeCommunication.getQueue())) continue;
                filteredNodes.add(nodeCommunication);
            }
        }
        return filteredNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(NodeCommunication nodeCommunication, RemoteNodeStatus status) {
        Node node = nodeCommunication.getNode();
        boolean immediatePushIfDataFound = this.parameterService.is("push.immediate.if.data.found", false);
        if (StringUtils.isNotBlank((CharSequence)node.getSyncUrl()) || !this.parameterService.isRegistrationServer()) {
            try {
                this.startTimesOfNodesBeingPushedTo.put(nodeCommunication.getIdentifier(), new Date());
                long lastBatchesProcessed = 0L;
                long lastDataProcessed = 0L;
                long lastReloadBatchesProcessed = 0L;
                long cumulativeBatchesProcessed = 0L;
                long cumulativeDataProcessed = 0L;
                long cumulativeReloadBatchesProcessed = 0L;
                do {
                    if (lastBatchesProcessed > 0L) {
                        if (lastReloadBatchesProcessed > 0L) {
                            this.log.info("Pushing to {} again because the last push contained reload batches", (Object)node);
                        } else {
                            this.log.debug("Pushing to {} again because the last push contained batches", (Object)node);
                        }
                    }
                    this.log.debug("Push requested for node {} channel {}", (Object)node, (Object)nodeCommunication.getQueue());
                    this.pushToNode(node, status);
                    lastBatchesProcessed = status.getBatchesProcessed() - cumulativeBatchesProcessed;
                    lastDataProcessed = status.getDataProcessed() - cumulativeDataProcessed;
                    lastReloadBatchesProcessed = status.getReloadBatchesProcessed() - cumulativeReloadBatchesProcessed;
                    if (!status.failed() && lastBatchesProcessed > 0L) {
                        this.log.info("Pushed data to node {} on queue {}. {} data and {} batches were processed. ({})", new Object[]{node, nodeCommunication.getQueue(), lastDataProcessed, lastBatchesProcessed, status.getTableSummary()});
                    } else if (status.failed()) {
                        this.log.debug("There was a failure while pushing data to {} on queue {}. {} data and {} batches were processed. ({})", new Object[]{node, nodeCommunication.getQueue(), lastDataProcessed, lastBatchesProcessed, status.getTableSummary()});
                    }
                    this.log.debug("Push completed for {} on queue {}", (Object)node, (Object)nodeCommunication.getQueue());
                    cumulativeReloadBatchesProcessed = status.getReloadBatchesProcessed();
                    cumulativeDataProcessed = status.getDataProcessed();
                    cumulativeBatchesProcessed = status.getBatchesProcessed();
                    status.resetTableSummary();
                    if (!Thread.interrupted()) continue;
                    throw new SymmetricException("Thread was interrupted", new Object[0]);
                } while ((immediatePushIfDataFound && lastBatchesProcessed > 0L || lastReloadBatchesProcessed > 0L) && !status.failed());
            }
            finally {
                this.startTimesOfNodesBeingPushedTo.remove(node.getNodeId());
            }
        } else {
            this.log.debug("Cannot push to node '{}' in the group '{}'.  The sync url is blank", (Object)node.getNodeId(), (Object)node.getNodeGroupId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushToNode(Node remote, RemoteNodeStatus status) {
        Node identity = this.nodeService.findIdentity();
        NodeSecurity identitySecurity = this.nodeService.findNodeSecurity(identity.getNodeId(), true);
        NodeSecurity nodeSecurity = this.nodeService.findNodeSecurity(remote.getNodeId(), true);
        IOutgoingTransport transport = null;
        ProcessInfo processInfo = this.statisticManager.newProcessInfo(new ProcessInfoKey(identity.getNodeId(), status.getQueue(), remote.getNodeId(), ProcessType.PUSH_JOB_EXTRACT));
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        requestProperties.put("threadChannel", status.getQueue());
        try {
            List<OutgoingBatch> extractedBatches = null;
            if (nodeSecurity != null && nodeSecurity.isRegistrationEnabled()) {
                if (identity.getNodeId().equals(nodeSecurity.getCreatedAtNodeId()) && nodeSecurity.isRegistrationAllowedNow() && this.parameterService.is("registration.push.config.allowed") && (status.getQueue() == null || status.getQueue().equals("default"))) {
                    transport = this.transportManager.getRegisterPushTransport(remote, identity);
                    extractedBatches = this.registrationService.registerWithClient(remote, (IOutgoingWithResponseTransport)transport);
                }
            } else {
                transport = this.transportManager.getPushTransport(remote, identity, identitySecurity.getNodePassword(), requestProperties, this.parameterService.getRegistrationUrl());
                extractedBatches = this.dataExtractorService.extract(processInfo, remote, status.getQueue(), transport);
            }
            if (extractedBatches != null && extractedBatches.size() > 0) {
                this.log.info("Push data sent to {}", (Object)remote);
                List<BatchAck> batchAcks = this.readAcks(extractedBatches, remote.getNodeId(), (IOutgoingWithResponseTransport)transport, this.transportManager, this.acknowledgeService, this.dataExtractorService);
                status.updateOutgoingStatus(extractedBatches, batchAcks);
            }
            if (processInfo.getStatus() != ProcessInfo.ProcessStatus.ERROR) {
                processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
            }
            this.fireOnline(remote, status);
        }
        catch (Exception ex) {
            processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
            this.fireOffline(ex, remote, status);
            if (this.isRegistrationRequired(ex)) {
                if (identity.getNodeId().equals(remote.getCreatedAtNodeId())) {
                    this.log.info("Re-opening registration for {} because registration is required", (Object)remote);
                    this.registrationService.reOpenRegistration(remote.getNodeId());
                } else if (!this.parameterService.isRegistrationServer() && this.parameterService.isRemoteNodeRegistrationServer(remote)) {
                    this.log.info("Removing identity because registration is required");
                    this.nodeService.deleteIdentity();
                    this.nodeService.deleteNodeSecurity(identity.getNodeId());
                    this.nodeService.deleteNode(identity.getNodeId(), remote.getNodeId(), false);
                }
            }
        }
        finally {
            try {
                transport.close();
            }
            catch (Exception exception) {}
        }
    }
}

