/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.List;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.BatchAck;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeCommunication;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.model.RemoteNodeStatus;
import org.jumpmind.symmetric.model.RemoteNodeStatuses;
import org.jumpmind.symmetric.service.IAcknowledgeService;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.INodeCommunicationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOfflinePushService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.transport.file.FileOutgoingTransport;

public class OfflinePushService
extends AbstractService
implements IOfflinePushService,
INodeCommunicationService.INodeCommunicationExecutor {
    private IDataExtractorService dataExtractorService;
    private IAcknowledgeService acknowledgeService;
    private ITransportManager transportManager;
    private INodeService nodeService;
    private IClusterService clusterService;
    private INodeCommunicationService nodeCommunicationService;
    private IStatisticManager statisticManager;
    private IConfigurationService configurationService;

    public OfflinePushService(IParameterService parameterService, ISymmetricDialect symmetricDialect, IDataExtractorService dataExtractorService, IAcknowledgeService acknowledgeService, ITransportManager transportManager, INodeService nodeService, IClusterService clusterService, INodeCommunicationService nodeCommunicationService, IStatisticManager statisticManager, IConfigurationService configrationService, IExtensionService extensionService) {
        super(parameterService, symmetricDialect);
        this.dataExtractorService = dataExtractorService;
        this.acknowledgeService = acknowledgeService;
        this.transportManager = transportManager;
        this.nodeService = nodeService;
        this.clusterService = clusterService;
        this.nodeCommunicationService = nodeCommunicationService;
        this.statisticManager = statisticManager;
        this.configurationService = configrationService;
    }

    @Override
    public synchronized RemoteNodeStatuses pushData(boolean force) {
        RemoteNodeStatuses statuses = new RemoteNodeStatuses(this.configurationService.getChannels(false));
        Node identity = this.nodeService.findIdentity();
        if (identity != null && identity.isSyncEnabled()) {
            if (force || !this.clusterService.isInfiniteLocked("Offline Push")) {
                List<NodeCommunication> nodes = this.nodeCommunicationService.list(NodeCommunication.CommunicationType.OFFLN_PUSH);
                int availableThreads = this.nodeCommunicationService.getAvailableThreads(NodeCommunication.CommunicationType.OFFLN_PUSH);
                for (NodeCommunication nodeCommunication : nodes) {
                    if (availableThreads <= 0 || !this.nodeCommunicationService.execute(nodeCommunication, statuses, this)) continue;
                    --availableThreads;
                }
            } else {
                this.log.debug("Did not run the offline push process because it has been stopped");
            }
        }
        return statuses;
    }

    @Override
    public void execute(NodeCommunication nodeCommunication, RemoteNodeStatus status) {
        Node node = nodeCommunication.getNode();
        long batchesProcessedCount = 0L;
        do {
            batchesProcessedCount = status.getBatchesProcessed();
            this.log.debug("Offline push requested for {}", (Object)node);
            this.pushToNode(node, status);
            if (!status.failed() && status.getBatchesProcessed() > batchesProcessedCount) {
                this.log.info("Offline push data written for {}. {} data and {} batches were processed", new Object[]{node, status.getDataProcessed(), status.getBatchesProcessed()});
            } else if (status.failed()) {
                this.log.info("There was a failure while writing offline push data for {}. {} data and {} batches were processed", new Object[]{node, status.getDataProcessed(), status.getBatchesProcessed()});
            }
            this.log.debug("Offline push completed for {}", (Object)node);
        } while (!status.failed() && status.getBatchesProcessed() > batchesProcessedCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushToNode(Node remote, RemoteNodeStatus status) {
        Node identity = this.nodeService.findIdentity();
        FileOutgoingTransport transport = null;
        ProcessInfo processInfo = this.statisticManager.newProcessInfo(new ProcessInfoKey(identity.getNodeId(), status.getQueue(), remote.getNodeId(), ProcessType.OFFLINE_PUSH));
        List<OutgoingBatch> extractedBatches = null;
        try {
            transport = (FileOutgoingTransport)this.transportManager.getPushTransport(remote, identity, null, null);
            extractedBatches = this.dataExtractorService.extract(processInfo, remote, status.getQueue(), transport);
            if (extractedBatches.size() > 0) {
                this.log.info("Offline push data written for {} at {}", (Object)remote, (Object)transport.getOutgoingDir());
                List<BatchAck> batchAcks = this.readAcks(extractedBatches, remote.getNodeId(), transport, this.transportManager, this.acknowledgeService, this.dataExtractorService);
                status.updateOutgoingStatus(extractedBatches, batchAcks);
            }
            if (processInfo.getStatus() != ProcessInfo.ProcessStatus.ERROR) {
                processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
            }
            if (transport != null) {
                transport.close();
                transport.complete(processInfo.getStatus() == ProcessInfo.ProcessStatus.OK);
            }
        }
        catch (Exception ex) {
            try {
                processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                this.log.error("Failed to write offline file", (Throwable)ex);
                if (transport != null) {
                    transport.close();
                    transport.complete(processInfo.getStatus() == ProcessInfo.ProcessStatus.OK);
                }
            }
            catch (Throwable throwable) {
                if (transport != null) {
                    transport.close();
                    transport.complete(processInfo.getStatus() == ProcessInfo.ProcessStatus.OK);
                }
                throw throwable;
            }
        }
    }
}

