/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.zip.ZipException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.TableNotFoundException;
import org.jumpmind.db.sql.UniqueKeyException;
import org.jumpmind.exception.IoException;
import org.jumpmind.exception.ParseException;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.IDataProcessorListener;
import org.jumpmind.symmetric.io.data.ProtocolException;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.ConflictException;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.IncomingError;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IIncomingBatchListener;
import org.jumpmind.symmetric.service.IIncomingBatchService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.TransportException;
import org.jumpmind.util.ExceptionUtils;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ManageIncomingBatchListener
implements IDataProcessorListener {
    private static final Logger log = LoggerFactory.getLogger(ManageIncomingBatchListener.class);
    protected List<IncomingBatch> batchesProcessed = new ArrayList<IncomingBatch>();
    protected IncomingBatch currentBatch;
    protected boolean isNewErrorForCurrentBatch;
    protected boolean isNewErrorSuppressed;
    protected ProcessInfo processInfo;
    private ISymmetricEngine engine;
    private IParameterService parameterService;
    private IIncomingBatchService incomingBatchService;
    private IStatisticManager statisticManager;
    private ISymmetricDialect symmetricDialect;
    private IDataLoaderService dataLoaderService;
    private IIncomingBatchListener incomingBatchListener;

    public ManageIncomingBatchListener(ProcessInfo processInfo, ISymmetricEngine engine) {
        this.processInfo = processInfo;
        this.engine = engine;
        this.parameterService = engine.getParameterService();
        this.symmetricDialect = engine.getSymmetricDialect();
        this.dataLoaderService = engine.getDataLoaderService();
        this.incomingBatchService = engine.getIncomingBatchService();
        this.statisticManager = engine.getStatisticManager();
        this.incomingBatchListener = engine.getExtensionService().getExtensionPoint(IIncomingBatchListener.class);
        if (this.incomingBatchListener != null && !this.incomingBatchListener.isInterestedInBatches()) {
            this.incomingBatchListener = null;
        }
    }

    public void beforeBatchEnd(DataContext context) {
        if (this.incomingBatchListener != null) {
            this.incomingBatchListener.batchStarted(context, this.symmetricDialect);
        }
        this.enableSyncTriggers(context);
    }

    public boolean beforeBatchStarted(DataContext context) {
        this.currentBatch = null;
        Batch batch = context.getBatch();
        this.currentBatch = null;
        context.remove("currentBatch");
        if (this.parameterService.is("dataloader.enable") || batch.getChannelId() != null && (batch.getChannelId().equals("config") || batch.getChannelId().equals("system"))) {
            if (batch.getBatchId() == -9999L && batch.getSourceNodeId() != null) {
                log.info("Preparing to receive registration from node {} by clearing its outgoing config batches", (Object)batch.getSourceNodeId());
                IOutgoingBatchService outgoingBatchService = this.engine.getOutgoingBatchService();
                IDataService dataService = this.engine.getDataService();
                dataService.deleteCapturedConfigChannelData();
                outgoingBatchService.markAllConfigAsSentForNode(batch.getSourceNodeId());
            }
            IncomingBatch incomingBatch = new IncomingBatch(batch);
            this.batchesProcessed.add(incomingBatch);
            if (batch.getStatistics() != null) {
                incomingBatch.mergeInjectedBatchStatistics(batch.getStatistics());
                this.processInfo.setTotalDataCount(incomingBatch.getExtractRowCount());
                this.processInfo.setCurrentLoadId(incomingBatch.getLoadId());
            }
            this.currentBatch = incomingBatch;
            context.put("currentBatch", (Object)this.currentBatch);
            if (this.incomingBatchService.acquireIncomingBatch(incomingBatch)) {
                if (batch.getBatchId() == -9999L) {
                    log.info("Loading registration batch from {}", (Object)batch.getSourceNodeId());
                }
                return true;
            }
        }
        return false;
    }

    public void afterBatchStarted(DataContext context) {
        Batch batch = context.getBatch();
        ISqlTransaction transaction = context.findSymmetricTransaction(this.engine.getTablePrefix());
        if (transaction != null) {
            this.symmetricDialect.disableSyncTriggers(transaction, batch.getSourceNodeId());
        }
    }

    public void batchSuccessful(DataContext context) {
        Batch batch = context.getBatch();
        this.currentBatch.setValues((Statistics)context.getReader().getStatistics().get(batch), (Statistics)context.getWriter().getStatistics().get(batch), true);
        this.currentBatch.setBulkLoaderFlag(batch.isBulkLoaderFlag());
        this.statisticManager.incrementDataLoaded(this.currentBatch.getChannelId(), this.currentBatch.getLoadRowCount());
        this.statisticManager.incrementDataBytesLoaded(this.currentBatch.getChannelId(), this.currentBatch.getByteCount());
        this.statisticManager.incrementTableRows(this.currentBatch.getTableLoadedCount(), true);
        if (this.incomingBatchListener != null) {
            this.incomingBatchListener.batchCommitted(context, this.symmetricDialect);
        }
        AbstractBatch.Status oldStatus = this.currentBatch.getStatus();
        try {
            this.currentBatch.setStatus(AbstractBatch.Status.OK);
            if (this.incomingBatchService.isRecordOkBatchesEnabled()) {
                if (this.currentBatch.getIgnoreCount() > 0L) {
                    log.info("Ignoring batch {}", (Object)this.currentBatch.getNodeBatchId());
                }
                this.incomingBatchService.updateIncomingBatch(this.currentBatch);
            } else if (this.currentBatch.isRetry()) {
                this.incomingBatchService.deleteIncomingBatch(this.currentBatch);
            }
        }
        catch (RuntimeException ex) {
            this.currentBatch.setStatus(oldStatus);
            throw ex;
        }
    }

    protected void enableSyncTriggers(DataContext context) {
        try {
            ISqlTransaction transaction = context.findSymmetricTransaction(this.engine.getTablePrefix());
            if (transaction != null && !Boolean.TRUE.equals(context.get("DatabaseWriter.TransactionAborted"))) {
                this.symmetricDialect.enableSyncTriggers(transaction);
            }
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
    }

    public void batchInError(DataContext context, Throwable ex) {
        block43: {
            try {
                ISqlTransaction transaction;
                block44: {
                    Batch batch;
                    if (this.currentBatch == null) {
                        throw ex;
                    }
                    if (context.get("bulkWriterToUse") != null && context.get("bulkWriterToUse").equals("bulk")) {
                        this.currentBatch.setBulkLoaderFlag(false);
                        log.info("Bulk loading failed for this batch " + context.getBatch().getBatchId() + ", falling back to default loading. (" + String.valueOf(ex) + ")");
                        log.debug("Bulk loading error.", ex);
                        break block43;
                    }
                    this.engine.getIncomingBatchService().refreshIncomingBatch(this.currentBatch);
                    if (this.currentBatch.getStatus() != AbstractBatch.Status.OK && this.currentBatch.getStatus() != AbstractBatch.Status.IG) {
                        this.currentBatch.setStatus(AbstractBatch.Status.ER);
                        this.currentBatch.setErrorFlag(true);
                    }
                    boolean bl = this.isNewErrorForCurrentBatch = (batch = context.getBatch()) != null && batch.getLineCount() != this.currentBatch.getFailedLineNumber();
                    if (context.getWriter() != null && context.getReader().getStatistics().get(batch) != null && context.getWriter().getStatistics().get(batch) != null) {
                        this.currentBatch.setValues((Statistics)context.getReader().getStatistics().get(batch), (Statistics)context.getWriter().getStatistics().get(batch), false);
                        this.statisticManager.incrementDataLoadedErrors(this.currentBatch.getChannelId(), 1L);
                    } else {
                        log.error("An error caused a batch to fail without attempting to load data for batch " + (batch != null ? batch.getNodeBatchId() : "?"), ex);
                    }
                    this.enableSyncTriggers(context);
                    if (ex instanceof CancellationException) {
                        log.info("Cancelling batch " + this.currentBatch.getNodeBatchId());
                    } else if (ex instanceof ParseException || ExceptionUtils.is((Throwable)ex, (Class[])new Class[]{ProtocolException.class, ZipException.class, BadPaddingException.class, IllegalBlockSizeException.class})) {
                        this.currentBatch.setSqlCode(-888);
                        this.currentBatch.setSqlState("PROTOCOL");
                        if (this.isNewErrorForCurrentBatch) {
                            this.suppressError();
                        } else {
                            log.error(String.format("Failed to parse batch %s", this.currentBatch.getNodeBatchId()), ex);
                        }
                    } else if (ex instanceof IOException || ex instanceof TransportException || ex instanceof IoException) {
                        log.warn("Failed to load batch " + this.currentBatch.getNodeBatchId(), ex);
                        this.currentBatch.setSqlMessage(ex);
                    } else {
                        SQLException se = ExceptionUtils.unwrapSqlException((Throwable)ex);
                        if (ex instanceof ConflictException) {
                            this.currentBatch.setSqlMessage(ex);
                            if (se != null && StringUtils.isNotBlank((CharSequence)se.getMessage())) {
                                this.currentBatch.setSqlMessage(this.currentBatch.getSqlMessage() + " " + se.getMessage());
                            }
                            this.currentBatch.setSqlState("CONFLICT");
                            this.currentBatch.setSqlCode(-999);
                        } else if (se != null) {
                            String sqlState = se.getSQLState();
                            if (sqlState != null && sqlState.length() > 10 && (sqlState = sqlState.replace("JDBC-", "")).length() > 10) {
                                sqlState = sqlState.substring(0, 10);
                            }
                            this.currentBatch.setSqlState(sqlState);
                            this.currentBatch.setSqlCode(se.getErrorCode());
                            this.currentBatch.setSqlMessage(se);
                            ISqlTemplate sqlTemplate = null;
                            sqlTemplate = context.getTable() != null ? this.symmetricDialect.getTargetPlatform(context.getTable().getName()).getSqlTemplate() : this.symmetricDialect.getTargetPlatform().getSqlTemplate();
                            if (sqlTemplate.isForeignKeyViolation((Throwable)se)) {
                                this.currentBatch.setSqlState("FK");
                                this.currentBatch.setSqlCode(-900);
                            } else if (sqlTemplate.isDeadlock((Throwable)se)) {
                                this.currentBatch.setSqlState("DEADLOCK");
                                this.currentBatch.setSqlCode(-911);
                            }
                        } else {
                            this.currentBatch.setSqlMessage(ExceptionUtils.getRootCause((Throwable)ex));
                        }
                        if (ex instanceof TableNotFoundException) {
                            log.error("The incoming batch {} failed: {}", (Object)this.currentBatch.getNodeBatchId(), (Object)ex.getMessage());
                        } else if (this.isNewErrorForCurrentBatch && (this.currentBatch.getSqlCode() == -900 || this.currentBatch.getSqlCode() == -911 || Boolean.TRUE.equals(context.get("DatabaseWriter.TransactionAborted")) && this.currentBatch.getSqlCode() == -999)) {
                            this.suppressError();
                        } else {
                            log.error(String.format("Failed to load batch %s", this.currentBatch.getNodeBatchId()), ex);
                        }
                    }
                    transaction = context.findSymmetricTransaction(this.engine.getTablePrefix());
                    if (Boolean.TRUE.equals(context.get("DatabaseWriter.TransactionAborted"))) {
                        transaction = null;
                    }
                    if (this.currentBatch.getStatus() == AbstractBatch.Status.ER && context.getTable() != null && context.getData() != null) {
                        try {
                            ConflictException conflictEx;
                            Conflict conflict;
                            IncomingError error = new IncomingError();
                            error.setBatchId(this.currentBatch.getBatchId());
                            error.setNodeId(this.currentBatch.getNodeId());
                            error.setTargetCatalogName(context.getTable().getCatalog());
                            error.setTargetSchemaName(context.getTable().getSchema());
                            error.setTargetTableName(context.getTable().getName());
                            error.setColumnNames(Table.getCommaDeliminatedColumns((Column[])context.getTable().getColumns()));
                            error.setPrimaryKeyColumnNames(Table.getCommaDeliminatedColumns((Column[])context.getTable().getPrimaryKeyColumns()));
                            error.setCsvData(context.getData());
                            error.setCurData((String)context.get("DatabaseWriter.CurData"));
                            error.setBinaryEncoding(context.getBatch().getBinaryEncoding());
                            error.setEventType(context.getData().getDataEventType());
                            error.setFailedLineNumber(this.currentBatch.getFailedLineNumber());
                            error.setFailedRowNumber(this.currentBatch.getFailedRowNumber());
                            if (ex instanceof ConflictException && (conflict = (conflictEx = (ConflictException)ex).getConflict()) != null) {
                                error.setConflictId(conflict.getConflictId());
                            }
                            if (context.get("DatabaseWriter.ConflictIgnore") != null) {
                                error.setResolveIgnore(true);
                            }
                            if (transaction != null) {
                                this.dataLoaderService.insertIncomingError(transaction, error);
                            } else {
                                this.dataLoaderService.insertIncomingError(error);
                            }
                        }
                        catch (UniqueKeyException e) {
                            IncomingError error;
                            if (transaction != null) {
                                transaction.rollback();
                            }
                            if (context.get("DatabaseWriter.ConflictIgnore") == null || (error = this.dataLoaderService.getIncomingError(this.currentBatch.getBatchId(), this.currentBatch.getNodeId(), this.currentBatch.getFailedRowNumber())) == null) break block44;
                            error.setResolveIgnore(true);
                            this.dataLoaderService.updateIncomingError(error);
                        }
                    }
                }
                if (transaction != null) {
                    if (this.incomingBatchService.isRecordOkBatchesEnabled() || this.currentBatch.isRetry()) {
                        this.incomingBatchService.updateIncomingBatch(transaction, this.currentBatch);
                    } else {
                        this.incomingBatchService.insertIncomingBatch(transaction, this.currentBatch);
                    }
                } else if (this.incomingBatchService.isRecordOkBatchesEnabled() || this.currentBatch.isRetry()) {
                    this.incomingBatchService.updateIncomingBatch(this.currentBatch);
                } else {
                    this.incomingBatchService.insertIncomingBatch(this.currentBatch);
                }
            }
            catch (Throwable e) {
                log.error("Failed to record status of batch " + (this.currentBatch != null ? this.currentBatch.getNodeBatchId() : context.getBatch().getNodeBatchId()), e);
            }
        }
    }

    protected void suppressError() {
        this.currentBatch.setErrorFlag(false);
        this.currentBatch.setStatus(AbstractBatch.Status.LD);
        this.isNewErrorSuppressed = true;
    }

    public void batchProgressUpdate(DataContext context) {
    }

    public void dataRowProcessed() {
    }

    public List<IncomingBatch> getBatchesProcessed() {
        return this.batchesProcessed;
    }

    public IncomingBatch getCurrentBatch() {
        return this.currentBatch;
    }

    public boolean isNewErrorForCurrentBatch() {
        return this.isNewErrorForCurrentBatch;
    }

    public boolean isErrorSuppressed() {
        return this.isNewErrorSuppressed;
    }
}

