/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.util.Date;
import java.util.Map;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingBatch
extends AbstractBatch {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(IncomingBatch.class);
    private long failedRowNumber;
    private long startTime;
    private boolean retry;

    public IncomingBatch() {
    }

    public IncomingBatch(Batch batch) {
        this.setBatchId(batch.getBatchId());
        this.setNodeId(batch.getSourceNodeId());
        this.setChannelId(batch.getChannelId());
        this.setStatus(AbstractBatch.Status.LD);
        this.setBulkLoaderFlag(batch.isBulkLoaderFlag());
    }

    public void setValues(Statistics readerStatistics, Statistics writerStatistics, boolean isSuccess) {
        if (readerStatistics != null) {
            this.setByteCount(readerStatistics.get("READ_BYTE_COUNT"));
            this.mergeInjectedBatchStatistics(readerStatistics);
        }
        if (writerStatistics != null) {
            this.setFilterMillis(writerStatistics.get("FILTERMILLIS"));
            this.setLoadMillis(writerStatistics.get("LOADMILLIS"));
            this.setLoadRowCount(writerStatistics.get("STATEMENTCOUNT"));
            this.setTransformLoadMillis(writerStatistics.get("TRANSFORMMILLIS"));
            this.setFallbackInsertCount(writerStatistics.get("FALLBACKINSERTCOUNT"));
            this.setFallbackUpdateCount(writerStatistics.get("FALLBACKUPDATECOUNT"));
            this.setConflictWinCount(writerStatistics.get("CONFLICTWINCOUNT"));
            this.setConflictLoseCount(writerStatistics.get("CONFLICTLOSECOUNT"));
            this.setMissingDeleteCount(writerStatistics.get("MISSINGDELETECOUNT"));
            this.setIgnoreCount(writerStatistics.get("IGNORECOUNT"));
            this.setIgnoreRowCount(writerStatistics.get("IGNOREROWCOUNT"));
            this.setStartTime(writerStatistics.get("STARTTIME"));
            this.setLastUpdatedTime(new Date());
            if (!isSuccess) {
                this.failedRowNumber = this.getLoadRowCount();
                this.setFailedLineNumber(writerStatistics.get("LINENUMBER"));
            }
            this.setLoadInsertRowCount(writerStatistics.get("INSERTCOUNT"));
            this.setLoadUpdateRowCount(writerStatistics.get("UPDATECOUNT"));
            this.setLoadDeleteRowCount(writerStatistics.get("DELETECOUNT"));
            this.setTableLoadedCount(writerStatistics.getTableStats());
            if (log.isDebugEnabled()) {
                for (Map.Entry entry : writerStatistics.getTableStats().entrySet()) {
                    for (Map.Entry dmlEntry : ((Map)entry.getValue()).entrySet()) {
                        log.debug("Loaded table: {}, {}, {} rows", new Object[]{entry.getKey(), dmlEntry.getKey(), dmlEntry.getValue()});
                    }
                }
            }
        }
    }

    public void mergeInjectedBatchStatistics(Statistics statistics) {
        if (statistics.contains("LOAD_FLAG")) {
            this.setLoadFlag(statistics.get("LOAD_FLAG") == 1L);
        }
        if (statistics.contains("EXTRACT_COUNT")) {
            this.setExtractCount(statistics.get("EXTRACT_COUNT"));
        }
        if (statistics.contains("SENT_COUNT")) {
            this.setSentCount(statistics.get("SENT_COUNT"));
        }
        if (statistics.contains("LOAD_COUNT")) {
            this.setLoadCount(statistics.get("LOAD_COUNT"));
        }
        if (statistics.contains("LOAD_ID")) {
            this.setLoadId(statistics.get("LOAD_ID"));
        }
        if (statistics.contains("COMMON_FLAG")) {
            this.setCommonFlag(statistics.get("COMMON_FLAG") == 1L);
        }
        if (statistics.contains("ROUTER_MILLIS")) {
            this.setRouterMillis(statistics.get("ROUTER_MILLIS"));
        }
        if (statistics.contains("EXTRACT_MILLIS")) {
            this.setExtractMillis(statistics.get("EXTRACT_MILLIS"));
        }
        if (statistics.contains("TRANSFORM_EXTRACT_MILLIS")) {
            this.setTransformExtractMillis(statistics.get("TRANSFORM_EXTRACT_MILLIS"));
        }
        if (statistics.contains("TRANSFORM_LOAD_MILLIS")) {
            this.setTransformLoadMillis(statistics.get("TRANSFORM_LOAD_MILLIS"));
        }
        if (statistics.contains("RELOAD_ROW_COUNT")) {
            this.setReloadRowCount(statistics.get("RELOAD_ROW_COUNT"));
        }
        if (statistics.contains("OTHER_ROW_COUNT")) {
            this.setOtherRowCount(statistics.get("OTHER_ROW_COUNT"));
        }
        if (statistics.contains("DATA_ROW_COUNT")) {
            this.setDataRowCount(statistics.get("DATA_ROW_COUNT"));
        }
        if (statistics.contains("DATA_INSERT_ROW_COUNT")) {
            this.setDataInsertRowCount(statistics.get("DATA_INSERT_ROW_COUNT"));
        }
        if (statistics.contains("DATA_UPDATE_ROW_COUNT")) {
            this.setDataUpdateRowCount(statistics.get("DATA_UPDATE_ROW_COUNT"));
        }
        if (statistics.contains("DATA_DELETE_ROW_COUNT")) {
            this.setDataDeleteRowCount(statistics.get("DATA_DELETE_ROW_COUNT"));
        }
        if (statistics.contains("EXTRACT_ROW_COUNT")) {
            this.setExtractRowCount(statistics.get("EXTRACT_ROW_COUNT"));
        }
        if (statistics.contains("EXTRACT_INSERT_ROW_COUNT")) {
            this.setExtractInsertRowCount(statistics.get("EXTRACT_INSERT_ROW_COUNT"));
        }
        if (statistics.contains("EXTRACT_UPDATE_ROW_COUNT")) {
            this.setExtractUpdateRowCount(statistics.get("EXTRACT_UPDATE_ROW_COUNT"));
        }
        if (statistics.contains("EXTRACT_DELETE_ROW_COUNT")) {
            this.setExtractDeleteRowCount(statistics.get("EXTRACT_DELETE_ROW_COUNT"));
        }
        if (statistics.contains("FAILED_DATA_ID")) {
            this.setFailedDataId(statistics.get("FAILED_DATA_ID"));
        }
    }

    public void setNodeBatchId(String value) {
        int splitIndex;
        if (value != null && (splitIndex = value.lastIndexOf("-")) > 0) {
            this.setNodeId(value.substring(0, splitIndex));
            this.setBatchId(Long.parseLong(value.substring(splitIndex + 1)));
        }
    }

    public boolean isRetry() {
        return this.retry;
    }

    public void setRetry(boolean isRetry) {
        this.retry = isRetry;
    }

    public long getFailedRowNumber() {
        return this.failedRowNumber;
    }

    public void setFailedRowNumber(long failedRowNumber) {
        this.failedRowNumber = failedRowNumber;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public boolean isPersistable() {
        return this.getBatchId() >= 0L;
    }

    public String toString() {
        return "IncomingBatch " + this.getBatchId();
    }
}

