/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.chartjs.data;

import elemental.json.Json;
import elemental.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.vaadin.addons.chartjs.data.Dataset;
import org.vaadin.addons.chartjs.data.PointStyle;
import org.vaadin.addons.chartjs.data.ScatterData;
import org.vaadin.addons.chartjs.utils.JUtils;

public class ScatterDataset
implements Dataset<ScatterDataset, ScatterData> {
    private static final long serialVersionUID = 8872594003015987324L;
    private String type;
    private List<ScatterData> data;
    private List<String> labels;
    private Map<String, ScatterData> dataMap;
    private Boolean hidden;
    private String label;
    private String xAxisID;
    private String yAxisID;
    private Boolean fill;
    private Double lineTension;
    private String backgroundColor;
    private Integer borderWidth;
    private String borderColor;
    private String borderCapStyle;
    private List<Integer> borderDash;
    private Double borderDashOffset;
    private String borderJoinStyle;
    private List<String> pointBorderColor;
    private List<String> pointBackgroundColor;
    private List<Integer> pointBorderWidth;
    private List<Integer> pointRadius;
    private List<Integer> pointHoverRadius;
    private List<Integer> pointHitRadius;
    private List<String> pointHoverBackgroundColor;
    private List<String> pointHoverBorderColor;
    private List<Integer> pointHoverBorderWidth;
    private PointStyle pointStyle;
    private Boolean showLine;
    private Boolean spanGaps;
    private Boolean steppedLine;

    public ScatterDataset type() {
        this.type = "line";
        return this;
    }

    public ScatterDataset data(ScatterData ... data) {
        this.data = Arrays.asList(data);
        return this;
    }

    public ScatterDataset addData(Double x, Double y) {
        if (this.data == null) {
            this.data = new ArrayList<ScatterData>();
        }
        this.data.add(new ScatterData().x(x).y(y));
        return this;
    }

    @Override
    public ScatterDataset dataAsList(List<ScatterData> data) {
        this.data = data;
        return this;
    }

    @Override
    public List<ScatterData> getData() {
        if (this.dataMap != null) {
            return new ArrayList<ScatterData>(this.dataMap.values());
        }
        return this.data;
    }

    @Override
    public ScatterDataset addLabeledData(String label, ScatterData data) {
        if (label != null && data != null) {
            if (this.labels == null) {
                this.labels = new ArrayList<String>();
            }
            if (!this.labels.contains(label)) {
                this.labels.add(label);
            }
            if (this.dataMap == null) {
                this.dataMap = new LinkedHashMap<String, ScatterData>();
            }
            this.dataMap.put(label, data);
        }
        return this;
    }

    @Override
    public List<String> getDataLabels() {
        return this.labels;
    }

    public ScatterDataset label(String label) {
        this.label = label;
        return this;
    }

    public ScatterDataset xAxisID(String xAxisID) {
        this.xAxisID = xAxisID;
        return this;
    }

    public ScatterDataset yAxisID(String yAxisID) {
        this.yAxisID = yAxisID;
        return this;
    }

    public ScatterDataset fill(boolean fill) {
        this.fill = fill;
        return this;
    }

    public ScatterDataset hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public ScatterDataset lineTension(double lineTension) {
        this.lineTension = lineTension;
        return this;
    }

    public ScatterDataset backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public ScatterDataset borderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public ScatterDataset borderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public ScatterDataset borderCapStyle(String borderCapStyle) {
        this.borderCapStyle = borderCapStyle;
        return this;
    }

    public ScatterDataset borderDash(Integer ... borderDash) {
        this.borderDash = Arrays.asList(borderDash);
        return this;
    }

    public ScatterDataset borderDashOffset(double borderDashOffset) {
        this.borderDashOffset = borderDashOffset;
        return this;
    }

    public ScatterDataset borderJoinStyle(String borderJoinStyle) {
        this.borderJoinStyle = borderJoinStyle;
        return this;
    }

    public ScatterDataset pointBorderColor(String ... pointBorderColor) {
        this.pointBorderColor = Arrays.asList(pointBorderColor);
        return this;
    }

    public ScatterDataset pointBackgroundColor(String ... pointBackgroundColor) {
        this.pointBackgroundColor = Arrays.asList(pointBackgroundColor);
        return this;
    }

    public ScatterDataset pointBorderWidth(Integer ... pointBorderWidth) {
        this.pointBorderWidth = Arrays.asList(pointBorderWidth);
        return this;
    }

    public ScatterDataset pointRadius(Integer ... pointRadius) {
        this.pointRadius = Arrays.asList(pointRadius);
        return this;
    }

    public ScatterDataset pointHoverRadius(Integer ... pointHoverRadius) {
        this.pointHoverRadius = Arrays.asList(pointHoverRadius);
        return this;
    }

    public ScatterDataset pointHitRadius(Integer ... pointHitRadius) {
        this.pointHitRadius = Arrays.asList(pointHitRadius);
        return this;
    }

    public ScatterDataset pointHoverBackgroundColor(String ... pointHoverBackgroundColor) {
        this.pointHoverBackgroundColor = Arrays.asList(pointHoverBackgroundColor);
        return this;
    }

    public ScatterDataset pointHoverBorderColor(String ... pointHoverBorderColor) {
        this.pointHoverBorderColor = Arrays.asList(pointHoverBorderColor);
        return this;
    }

    public ScatterDataset pointHoverBorderWidth(Integer ... pointHoverBorderWidth) {
        this.pointHoverBorderWidth = Arrays.asList(pointHoverBorderWidth);
        return this;
    }

    public ScatterDataset pointStyle(PointStyle pointStyle) {
        this.pointStyle = pointStyle;
        return this;
    }

    public ScatterDataset showLine(boolean showLine) {
        this.showLine = showLine;
        return this;
    }

    public ScatterDataset spanGaps(boolean spanGaps) {
        this.spanGaps = spanGaps;
        return this;
    }

    public ScatterDataset steppedLine(boolean steppedLine) {
        this.steppedLine = steppedLine;
        return this;
    }

    @Override
    public JsonObject buildJson() {
        JsonObject map = Json.createObject();
        JUtils.putNotNull(map, "type", this.type);
        JUtils.putNotNullBuilders(map, "data", this.data);
        JUtils.putNotNull(map, "label", this.label);
        JUtils.putNotNull(map, "xAxisID", this.xAxisID);
        JUtils.putNotNull(map, "yAxisID", this.yAxisID);
        JUtils.putNotNull(map, "fill", this.fill);
        JUtils.putNotNull(map, "hidden", this.hidden);
        JUtils.putNotNull(map, "lineTension", this.lineTension);
        JUtils.putNotNull(map, "backgroundColor", this.backgroundColor);
        JUtils.putNotNull(map, "borderWidth", this.borderWidth);
        JUtils.putNotNull(map, "borderColor", this.borderColor);
        JUtils.putNotNull(map, "borderCapStyle", this.borderCapStyle);
        JUtils.putNotNullIntList(map, "borderDash", this.borderDash);
        JUtils.putNotNull(map, "borderDashOffset", this.borderDashOffset);
        JUtils.putNotNull(map, "borderJoinStyle", this.borderJoinStyle);
        JUtils.putNotNullStringListOrSingle(map, "pointBorderColor", this.pointBorderColor);
        JUtils.putNotNullStringListOrSingle(map, "pointBackgroundColor", this.pointBackgroundColor);
        JUtils.putNotNullIntListOrSingle(map, "pointBorderWidth", this.pointBorderWidth);
        JUtils.putNotNullIntListOrSingle(map, "pointRadius", this.pointRadius);
        JUtils.putNotNullIntListOrSingle(map, "pointHoverRadius", this.pointHoverRadius);
        JUtils.putNotNullIntListOrSingle(map, "pointHitRadius", this.pointHitRadius);
        JUtils.putNotNullStringListOrSingle(map, "pointHoverBackgroundColor", this.pointHoverBackgroundColor);
        JUtils.putNotNullStringListOrSingle(map, "pointHoverBorderColor", this.pointHoverBorderColor);
        JUtils.putNotNullIntListOrSingle(map, "pointHoverBorderWidth", this.pointHoverBorderWidth);
        if (this.pointStyle != null) {
            JUtils.putNotNull(map, "pointStyle", this.pointStyle.name());
        }
        JUtils.putNotNull(map, "showLine", this.showLine);
        JUtils.putNotNull(map, "spanGaps", this.spanGaps);
        JUtils.putNotNull(map, "steppedLine", this.steppedLine);
        return map;
    }
}

