/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.chartjs.data;

import elemental.json.Json;
import elemental.json.JsonObject;
import java.util.Arrays;
import java.util.List;
import org.vaadin.addons.chartjs.data.DoubleDataset;
import org.vaadin.addons.chartjs.data.PointStyle;
import org.vaadin.addons.chartjs.options.FillMode;
import org.vaadin.addons.chartjs.utils.JUtils;

public class RadarDataset
extends DoubleDataset<RadarDataset> {
    private static final long serialVersionUID = -3708453908890787373L;
    private String type;
    private Boolean hidden;
    private String label;
    private Boolean fill;
    private Boolean fillToPlus;
    private Integer fillToDatasetIndex;
    private FillMode fillMode;
    private Double lineTension;
    private String backgroundColor;
    private Integer borderWidth;
    private String borderColor;
    private String borderCapStyle;
    private List<Integer> borderDash;
    private Double borderDashOffset;
    private String borderJoinStyle;
    private List<String> pointBorderColor;
    private List<String> pointBackgroundColor;
    private List<Integer> pointBorderWidth;
    private List<Integer> pointRadius;
    private List<Integer> pointHoverRadius;
    private List<Integer> hitRadius;
    private List<String> pointHoverBackgroundColor;
    private List<String> pointHoverBorderColor;
    private List<Integer> pointHoverBorderWidth;
    private PointStyle pointStyle;

    public RadarDataset type() {
        this.type = "radar";
        return this;
    }

    public RadarDataset label(String label) {
        this.label = label;
        return this;
    }

    public RadarDataset fill(boolean fill) {
        this.fill = fill;
        return this;
    }

    public RadarDataset fill(FillMode fillMode) {
        this.fillMode = fillMode;
        return this;
    }

    public RadarDataset fill(int datasetIndex) {
        this.fillToDatasetIndex = datasetIndex;
        return this;
    }

    public RadarDataset fill(boolean next, int datasetIndex) {
        this.fillToPlus = next;
        this.fillToDatasetIndex = datasetIndex;
        return this;
    }

    public RadarDataset hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public RadarDataset lineTension(double lineTension) {
        this.lineTension = lineTension;
        return this;
    }

    public RadarDataset backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public RadarDataset borderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public RadarDataset borderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public RadarDataset borderCapStyle(String borderCapStyle) {
        this.borderCapStyle = borderCapStyle;
        return this;
    }

    public RadarDataset borderDash(Integer ... borderDash) {
        this.borderDash = Arrays.asList(borderDash);
        return this;
    }

    public RadarDataset borderDashOffset(double borderDashOffset) {
        this.borderDashOffset = borderDashOffset;
        return this;
    }

    public RadarDataset borderJoinStyle(String borderJoinStyle) {
        this.borderJoinStyle = borderJoinStyle;
        return this;
    }

    public RadarDataset pointBorderColor(String ... pointBorderColor) {
        this.pointBorderColor = Arrays.asList(pointBorderColor);
        return this;
    }

    public RadarDataset pointBackgroundColor(String ... pointBackgroundColor) {
        this.pointBackgroundColor = Arrays.asList(pointBackgroundColor);
        return this;
    }

    public RadarDataset pointBorderWidth(Integer ... pointBorderWidth) {
        this.pointBorderWidth = Arrays.asList(pointBorderWidth);
        return this;
    }

    public RadarDataset pointRadius(Integer ... pointRadius) {
        this.pointRadius = Arrays.asList(pointRadius);
        return this;
    }

    public RadarDataset pointHoverRadius(Integer ... pointHoverRadius) {
        this.pointHoverRadius = Arrays.asList(pointHoverRadius);
        return this;
    }

    public RadarDataset hitRadius(Integer ... hitRadius) {
        this.hitRadius = Arrays.asList(hitRadius);
        return this;
    }

    public RadarDataset pointHoverBackgroundColor(String ... pointHoverBackgroundColor) {
        this.pointHoverBackgroundColor = Arrays.asList(pointHoverBackgroundColor);
        return this;
    }

    public RadarDataset pointHoverBorderColor(String ... pointHoverBorderColor) {
        this.pointHoverBorderColor = Arrays.asList(pointHoverBorderColor);
        return this;
    }

    public RadarDataset pointHoverBorderWidth(Integer ... pointHoverBorderWidth) {
        this.pointHoverBorderWidth = Arrays.asList(pointHoverBorderWidth);
        return this;
    }

    public RadarDataset pointStyle(PointStyle pointStyle) {
        this.pointStyle = pointStyle;
        return this;
    }

    @Override
    public JsonObject buildJson() {
        JsonObject map = Json.createObject();
        JUtils.putNotNull(map, "type", this.type);
        JUtils.putNotNullNumbers(map, "data", this.getData());
        JUtils.putNotNull(map, "label", this.label);
        if (this.fillToPlus != null && this.fillToDatasetIndex != null) {
            JUtils.putNotNull(map, "fill", (this.fillToPlus != false ? "+" : "-") + this.fillToDatasetIndex);
        } else if (this.fillToPlus == null && this.fillToDatasetIndex != null) {
            JUtils.putNotNull(map, "fill", this.fillToDatasetIndex);
        } else if (this.fillMode != null) {
            JUtils.putNotNull(map, "fill", this.fillMode.name().toLowerCase());
        } else {
            JUtils.putNotNull(map, "fill", this.fill);
        }
        JUtils.putNotNull(map, "hidden", this.hidden);
        JUtils.putNotNull(map, "lineTension", this.lineTension);
        JUtils.putNotNull(map, "backgroundColor", this.backgroundColor);
        JUtils.putNotNull(map, "borderWidth", this.borderWidth);
        JUtils.putNotNull(map, "borderColor", this.borderColor);
        JUtils.putNotNull(map, "borderCapStyle", this.borderCapStyle);
        JUtils.putNotNullIntList(map, "borderDash", this.borderDash);
        JUtils.putNotNull(map, "borderDashOffset", this.borderDashOffset);
        JUtils.putNotNull(map, "borderJoinStyle", this.borderJoinStyle);
        JUtils.putNotNullStringListOrSingle(map, "pointBorderColor", this.pointBorderColor);
        JUtils.putNotNullStringListOrSingle(map, "pointBackgroundColor", this.pointBackgroundColor);
        JUtils.putNotNullIntListOrSingle(map, "pointBorderWidth", this.pointBorderWidth);
        JUtils.putNotNullIntListOrSingle(map, "pointRadius", this.pointRadius);
        JUtils.putNotNullIntListOrSingle(map, "pointHoverRadius", this.pointHoverRadius);
        JUtils.putNotNullIntListOrSingle(map, "hitRadius", this.hitRadius);
        JUtils.putNotNullStringListOrSingle(map, "pointHoverBackgroundColor", this.pointHoverBackgroundColor);
        JUtils.putNotNullStringListOrSingle(map, "pointHoverBorderColor", this.pointHoverBorderColor);
        JUtils.putNotNullIntListOrSingle(map, "pointHoverBorderWidth", this.pointHoverBorderWidth);
        if (this.pointStyle != null) {
            JUtils.putNotNull(map, "pointStyle", this.pointStyle.name());
        }
        return map;
    }

    @Override
    public RadarDataset getThis() {
        return this;
    }
}

