/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.chartjs.data;

import elemental.json.Json;
import elemental.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.vaadin.addons.chartjs.data.DoubleDataset;
import org.vaadin.addons.chartjs.utils.ColorUtils;
import org.vaadin.addons.chartjs.utils.JUtils;

public class PieDataset
extends DoubleDataset<PieDataset> {
    private static final long serialVersionUID = -8380757524860222004L;
    private String type;
    private Boolean hidden;
    private String label;
    private List<String> backgroundColor;
    private List<String> borderColor;
    private List<Integer> borderWidth;
    private List<String> hoverBackgroundColor;
    private List<String> hoverBorderColor;
    private List<Integer> hoverBorderWidth;
    private boolean randomBackgroundColors;

    public PieDataset donut() {
        this.type = "doughnut";
        return this;
    }

    public PieDataset doughnut() {
        this.type = "doughnut";
        return this;
    }

    public PieDataset pie() {
        this.type = "pie";
        return this;
    }

    public PieDataset label(String label) {
        this.label = label;
        return this;
    }

    public PieDataset hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public PieDataset backgroundColor(String ... backgroundColor) {
        this.backgroundColor = Arrays.asList(backgroundColor);
        return this;
    }

    public PieDataset randomBackgroundColors(boolean randomBackgroundColors) {
        this.randomBackgroundColors = randomBackgroundColors;
        return this;
    }

    public PieDataset borderColor(String ... borderColor) {
        this.borderColor = Arrays.asList(borderColor);
        return this;
    }

    public PieDataset borderWidth(Integer ... borderWidth) {
        this.borderWidth = Arrays.asList(borderWidth);
        return this;
    }

    public PieDataset hoverBackgroundColor(String ... hoverBackgroundColor) {
        this.hoverBackgroundColor = Arrays.asList(hoverBackgroundColor);
        return this;
    }

    public PieDataset hoverBorderColor(String ... hoverBorderColor) {
        this.hoverBorderColor = Arrays.asList(hoverBorderColor);
        return this;
    }

    public PieDataset hoverBorderWidth(Integer ... hoverBorderWidth) {
        this.hoverBorderWidth = Arrays.asList(hoverBorderWidth);
        return this;
    }

    @Override
    public JsonObject buildJson() {
        JsonObject map = Json.createObject();
        JUtils.putNotNull(map, "type", this.type);
        List<Double> data = this.getData();
        JUtils.putNotNullNumbers(map, "data", data);
        JUtils.putNotNull(map, "label", this.label);
        JUtils.putNotNull(map, "hidden", this.hidden);
        if (this.randomBackgroundColors && data != null) {
            ArrayList<String> bgColors = new ArrayList<String>();
            for (int i = 0; i < data.size(); ++i) {
                bgColors.add(ColorUtils.randomColor(0.7));
            }
            this.backgroundColor = bgColors;
        }
        JUtils.putNotNullStringListOrSingle(map, "backgroundColor", this.backgroundColor);
        JUtils.putNotNullStringListOrSingle(map, "borderColor", this.borderColor);
        JUtils.putNotNullIntListOrSingle(map, "borderWidth", this.borderWidth);
        JUtils.putNotNullStringListOrSingle(map, "hoverBackgroundColor", this.hoverBackgroundColor);
        JUtils.putNotNullStringListOrSingle(map, "hoverBorderColor", this.hoverBorderColor);
        JUtils.putNotNullIntListOrSingle(map, "hoverBorderWidth", this.hoverBorderWidth);
        return map;
    }

    @Override
    public PieDataset getThis() {
        return this;
    }
}

