/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.chartjs;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.util.Map;

public class ChartJsUtils {
    public static void safelyExecuteJs(UI ui, String expression, Serializable ... parameters) {
        String modExpression = "try {" + expression + "} catch(e) { if (e instanceof TypeError) { console.log('Chart not found') } else { console.error(e) } }";
        ChartJsUtils.securelyAccessUI(ui, (Command & Serializable)() -> ui.getPage().executeJs(modExpression, parameters));
    }

    public static void securelyAccessUI(UI ui, Command command) {
        if (ui != null && !ui.isClosing() && ui.getSession() != null) {
            ui.access(command);
        }
    }

    public static <T, S> void putNotNull(Map<T, S> map, T key, S value) {
        if (value != null) {
            map.put(key, value);
        }
    }
}

