/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.addons.chartjs;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.dom.Element;
import java.io.Serializable;
import java.util.Map;
import org.vaadin.addons.chartjs.ChartJsUtils;
import org.vaadin.addons.chartjs.config.ChartConfig;
import org.vaadin.addons.chartjs.options.TooltipsCallbacks;
import org.vaadin.addons.chartjs.utils.JUtils;

@JsModule.Container(value={@JsModule(value="./chart/hammer.min.js"), @JsModule(value="./chart/Chart.min.js"), @JsModule(value="./chart/chartjs-plugin-zoom.min.js"), @JsModule(value="./chart/chartjs-plugin-annotation.min.js")})
@Tag(value="chart")
public class ChartJs
extends Component
implements HasSize {
    private boolean connected = false;
    private static final long serialVersionUID = 2999562112373836140L;
    private static final PropertyDescriptor<String, String> chartIdProperty = PropertyDescriptors.propertyWithDefault((String)"id", (String)"");
    private ChartConfig chartConfig;

    public ChartJs() {
        this.setChartTagId("chartjs-" + ((Object)((Object)this)).hashCode() + "-" + System.nanoTime());
        this.getElement().appendChild(new Element[]{new Element("canvas").setAttribute("id", this.getChartCanvasId()).setAttribute("width", "100%").setAttribute("height", "100%")});
    }

    public ChartJs(ChartConfig chartConfig) {
        this();
        this.chartConfig = chartConfig;
    }

    public void addFunction(String domPath, String functionStr) {
        ChartJsUtils.safelyExecuteJs(this.getUI().orElse(UI.getCurrent()), "document.getElementById('" + this.getChartId() + "').chartjs." + domPath + " = " + functionStr, new Serializable[0]);
    }

    public void addAllFunctions() {
        for (Map.Entry<String, String> entry : this.chartConfig.getOptions().tooltips().callbacks().asMap().entrySet()) {
            this.addFunction("config.options.tooltips.callbacks." + entry.getKey(), JUtils.formatJavascriptFunction(entry.getKey(), entry.getValue(), TooltipsCallbacks.argumentMap().get(entry.getKey())));
        }
    }

    public void configure(ChartConfig chartConfig) {
        this.chartConfig = chartConfig;
        if (this.connected) {
            ChartJsUtils.safelyExecuteJs(this.getUI().orElse(UI.getCurrent()), "document.getElementById($0).chartjs.config = $1", new Serializable[]{this.getChartId(), chartConfig.buildJson()});
            this.addAllFunctions();
        }
    }

    protected void onAttach(AttachEvent e) {
        super.onAttach(e);
        if (!this.connected) {
            ChartJsUtils.safelyExecuteJs(this.getUI().orElse(UI.getCurrent()), "document.getElementById($0).chartjs = new Chart(document.getElementById($1).getContext('2d'), $2)", new Serializable[]{this.getChartId(), this.getChartCanvasId(), this.chartConfig.buildJson()});
            this.addAllFunctions();
        }
        this.connected = true;
    }

    protected void onDetach(DetachEvent e) {
        this.destroy();
        this.connected = false;
    }

    public ChartConfig getConfig() {
        return this.chartConfig;
    }

    public void update() {
        this.configure(this.chartConfig);
        if (this.connected) {
            ChartJsUtils.safelyExecuteJs(this.getUI().orElse(UI.getCurrent()), "document.getElementById($0).chartjs.update()", new Serializable[]{this.getChartId()});
        }
    }

    public void destroy() {
        ChartJsUtils.safelyExecuteJs(this.getUI().orElse(UI.getCurrent()), "document.getElementById($0).chartjs.destroy()", new Serializable[]{this.getChartId()});
    }

    @Deprecated
    public void refreshData() {
        this.update();
    }

    public ChartJs setChartTagId(String value) {
        chartIdProperty.set((HasElement)this, (Object)value);
        return this;
    }

    public String getChartId() {
        return (String)chartIdProperty.get((HasElement)this);
    }

    public String getChartCanvasId() {
        return (String)chartIdProperty.get((HasElement)this) + "-canv";
    }
}

