/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.driver;

import org.apache.commons.lang3.StringUtils;
import org.jumpmind.driver.InterceptResult;
import org.jumpmind.driver.PreparedStatementWrapper;
import org.jumpmind.driver.StatementInterceptor;
import org.jumpmind.properties.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementBypassInterceptor
extends StatementInterceptor {
    private static final Logger log = LoggerFactory.getLogger(StatementBypassInterceptor.class);

    public StatementBypassInterceptor(Object wrapped, TypedProperties systemPlusEngineProperties) {
        super(wrapped, systemPlusEngineProperties);
    }

    @Override
    protected InterceptResult preparedStatementPreExecute(PreparedStatementWrapper ps, String methodName, Object[] parameters) {
        String statementLower;
        if (methodName.equals("getUpdateCount")) {
            InterceptResult result = new InterceptResult();
            result.setIntercepted(true);
            result.setInterceptResult(1);
            return result;
        }
        if (methodName.startsWith("execute") && ((statementLower = ps.getStatement().toLowerCase()).startsWith("insert") || statementLower.startsWith("update")) && !statementLower.contains("sym_")) {
            InterceptResult result = new InterceptResult();
            result.setIntercepted(true);
            if (methodName.equals("execute")) {
                result.setInterceptResult(Boolean.FALSE);
            } else if (methodName.equals("executeUpdate")) {
                result.setInterceptResult(1);
            }
            String sql = this.sqlBuilder.buildDynamicSqlForLog(ps.getStatement(), this.psArgs.toArray(), null);
            log.info("PreparedStatement." + methodName + " *BYPASSED* " + StringUtils.abbreviate((String)sql, (int)128));
            return result;
        }
        return super.preparedStatementPreExecute(ps, methodName, parameters);
    }

    @Override
    public void preparedStatementExecute(String methodName, long elapsed, String sql) {
    }
}

