/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.driver;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.jumpmind.driver.ConnectionWrapper;
import org.jumpmind.properties.TypedProperties;
import org.slf4j.MDC;

public class Driver
implements java.sql.Driver {
    private static final String DRIVER_PREFIX = "jdbc:symds:";
    private static final Map<String, TypedProperties> allEngineProperties = new HashMap<String, TypedProperties>();

    public static void register(TypedProperties properties) {
        try {
            if (properties != null) {
                String engineName = properties.get("engine.name");
                allEngineProperties.put(engineName, properties);
            }
            DriverManager.registerDriver(new Driver());
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to register SymmetricDS driver", ex);
        }
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null || !url.toLowerCase().startsWith(DRIVER_PREFIX)) {
            return null;
        }
        String realUrl = this.getRealUrl(url);
        Connection connection = DriverManager.getConnection(realUrl, info);
        String engineName = MDC.get((String)"engineName");
        TypedProperties engineProperties = null;
        if (engineName != null) {
            engineProperties = allEngineProperties.get(engineName);
        } else {
            System.out.println("Unknown engine...");
        }
        ConnectionWrapper connectionWrapper = new ConnectionWrapper(connection);
        connectionWrapper.setEngineProperties(engineProperties);
        return connectionWrapper;
    }

    private String getRealUrl(String url) {
        return url.replace("symds:", "");
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            return false;
        }
        return url.toLowerCase().startsWith(DRIVER_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return null;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        Driver.register(null);
    }
}

