/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.postgresql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.postgresql.PostgreSqlDdlBuilder;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.sql.SymmetricLobHandler;
import org.springframework.jdbc.core.StatementCreatorUtils;

public class PostgreSqlJdbcSqlTemplate
extends JdbcSqlTemplate {
    public PostgreSqlJdbcSqlTemplate(DataSource dataSource, SqlTemplateSettings settings, SymmetricLobHandler lobHandler, DatabaseInfo databaseInfo) {
        super(dataSource, settings, lobHandler, databaseInfo);
        this.requiresAutoCommitFalseToSetFetchSize = true;
        this.primaryKeyViolationSqlStates = new String[]{"23000", "23505"};
        this.primaryKeyViolationMessageParts = new String[]{"duplicate key value violates", "duplicar valor da chave viola a restri\u00e7\u00e3o de unicidade"};
        this.uniqueKeyViolationNameRegex = new String[]{"violates unique constraint \"(.*)\""};
        this.foreignKeyViolationMessageParts = new String[]{"violates foreign key constraint"};
        this.foreignKeyViolationSqlStates = new String[]{"23503"};
        this.foreignKeyChildExistsViolationMessageParts = new String[]{"is still referenced from table"};
        this.dataTruncationStates = new String[]{"22001"};
        this.deadlockSqlStates = new String[]{"40P01"};
        this.objectAlreadyExistsStates = new String[]{"42723", "42P05", "42P06", "42P07", "42712", "42710"};
        this.objectDoesNotExistStates = new String[]{"42883", "42P01", "42704"};
    }

    @Override
    public String getSelectLastInsertIdSql(String sequenceName) {
        if (PostgreSqlDdlBuilder.isUsePseudoSequence()) {
            return "select seq_id from " + sequenceName + "_tbl";
        }
        return "select currval('" + sequenceName + "_seq')";
    }

    @Override
    protected boolean allowsNullForIdentityColumn() {
        return false;
    }

    @Override
    protected void setNanOrNull(PreparedStatement ps, int i, Object arg, int argType) throws SQLException {
        StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)i, (int)6, (Object)Float.valueOf(Float.NaN));
    }
}

