/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.oracle;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;

public class OracleDdlReader
extends AbstractJdbcDdlReader {
    private Pattern oracleIsoDatePattern;
    private Pattern oracleIsoTimePattern;
    private Pattern oracleIsoTimestampPattern;
    private String REGEX_FRACTIONAL_SECOND_PRECISION = "\\([0-9]\\)";

    public OracleDdlReader(IDatabasePlatform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.setDefaultTablePattern("%");
        this.oracleIsoDatePattern = Pattern.compile("TO_DATE\\('([^']*)'\\, 'YYYY\\-MM\\-DD'\\)");
        this.oracleIsoTimePattern = Pattern.compile("TO_DATE\\('([^']*)'\\, 'HH24:MI:SS'\\)");
        this.oracleIsoTimestampPattern = Pattern.compile("TO_DATE\\('([^']*)'\\, 'YYYY\\-MM\\-DD HH24:MI:SS'\\)");
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        boolean tableHasBeenDeleted = this.isTableInRecycleBin(connection, values);
        String schema = (String)values.get(this.getResultSetSchemaName());
        if (!tableHasBeenDeleted && !"SYSTEM".equals(schema)) {
            Table table = super.readTable(connection, metaData, values);
            if (table != null) {
                this.determineAutoIncrementColumns(connection, table);
            }
            return table;
        }
        return null;
    }

    protected boolean isTableInRecycleBin(Connection connection, Map<String, Object> values) throws SQLException {
        String tablename = (String)values.get("TABLE_NAME");
        return StringUtils.isNotBlank((CharSequence)tablename) && tablename.toLowerCase().startsWith("bin$");
    }

    @Override
    protected void genericizeDefaultValuesAndUpdatePlatformColumn(Column column) {
        super.genericizeDefaultValuesAndUpdatePlatformColumn(column);
        String defaultValue = column.getDefaultValue();
        if ("sysdate".equalsIgnoreCase(defaultValue)) {
            column.setDefaultValue("CURRENT_TIMESTAMP");
            column.findPlatformColumn(this.platform.getName()).setDefaultValue(defaultValue);
        }
    }

    @Override
    protected Integer mapUnknownJdbcTypeForColumn(Map<String, Object> values) {
        String typeName = (String)values.get("TYPE_NAME");
        if (typeName != null && typeName.startsWith("DATE")) {
            return 91;
        }
        if (typeName != null && typeName.startsWith("TIMESTAMP") && !typeName.endsWith("TIME ZONE")) {
            return 93;
        }
        if (typeName != null && typeName.startsWith("TIMESTAMP") && typeName.endsWith("WITH TIME ZONE")) {
            return -101;
        }
        if (typeName != null && typeName.startsWith("TIMESTAMP") && typeName.endsWith("WITH LOCAL TIME ZONE")) {
            return -102;
        }
        if (typeName != null && typeName.startsWith("NVARCHAR")) {
            return -9;
        }
        if (typeName != null && typeName.startsWith("LONGNVARCHAR")) {
            return -1;
        }
        if (typeName != null && typeName.startsWith("NCHAR")) {
            return -15;
        }
        if (typeName != null && typeName.startsWith("XML")) {
            return 2009;
        }
        if (typeName != null && typeName.startsWith("NCLOB")) {
            return 2011;
        }
        if (typeName != null && typeName.endsWith("CLOB")) {
            return -1;
        }
        if (typeName != null && typeName.startsWith("BINARY_FLOAT")) {
            return 6;
        }
        if (typeName != null && typeName.startsWith("BINARY_DOUBLE")) {
            return 8;
        }
        if (typeName != null && typeName.startsWith("BFILE")) {
            return 12;
        }
        if (typeName != null && typeName.startsWith("INTERVAL")) {
            return 12;
        }
        if (typeName != null && typeName.startsWith("ROWID")) {
            return 12;
        }
        if (typeName != null && typeName.startsWith("BOOL")) {
            return 16;
        }
        return super.mapUnknownJdbcTypeForColumn(values);
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        if (column.getMappedTypeCode() == 3 || column.getMappedTypeCode() == 2) {
            if (column.getScale() <= -127 || column.getScale() >= 127) {
                if (column.getSizeAsInt() == 0) {
                    if (this.isColumnInteger((String)values.get("TABLE_NAME"), (String)values.get("COLUMN_NAME"))) {
                        column.setMappedTypeCode(-5);
                    }
                } else if (column.getSizeAsInt() <= 63) {
                    column.setMappedTypeCode(7);
                } else {
                    column.setMappedTypeCode(8);
                }
            } else {
                column.setMappedTypeCode(2);
            }
        } else if (column.getMappedTypeCode() == 6) {
            switch (column.getSizeAsInt()) {
                case 63: {
                    column.setMappedTypeCode(7);
                    break;
                }
                case 126: {
                    column.setMappedTypeCode(8);
                }
            }
        } else if (column.getMappedTypeCode() == 91 || column.getMappedTypeCode() == 93 || column.getMappedTypeCode() == -101 || column.getMappedTypeCode() == -102) {
            if (column.getDefaultValue() != null) {
                Timestamp timestamp = null;
                Matcher matcher = this.oracleIsoTimestampPattern.matcher(column.getDefaultValue());
                if (matcher.matches()) {
                    String timestampVal = matcher.group(1);
                    timestamp = Timestamp.valueOf(timestampVal);
                } else {
                    matcher = this.oracleIsoDatePattern.matcher(column.getDefaultValue());
                    if (matcher.matches()) {
                        String dateVal = matcher.group(1);
                        timestamp = new Timestamp(Date.valueOf(dateVal).getTime());
                    } else {
                        matcher = this.oracleIsoTimePattern.matcher(column.getDefaultValue());
                        if (matcher.matches()) {
                            String timeVal = matcher.group(1);
                            timestamp = new Timestamp(Time.valueOf(timeVal).getTime());
                        }
                    }
                }
                if (timestamp != null) {
                    column.setDefaultValue(timestamp.toString());
                }
            }
            if (column.getMappedTypeCode() == 91) {
                column.setSize("0");
                this.removePlatformColumnSize(column);
            } else {
                column.setJdbcTypeName(column.getJdbcTypeName().replaceAll(this.REGEX_FRACTIONAL_SECOND_PRECISION, ""));
                column.setSize(String.valueOf(column.getScale()));
                PlatformColumn platformColumn = column.findPlatformColumn(this.platform.getName());
                if (platformColumn != null) {
                    platformColumn.setType(platformColumn.getType().replaceAll(this.REGEX_FRACTIONAL_SECOND_PRECISION, ""));
                    platformColumn.setSize(column.getSizeAsInt());
                    platformColumn.setDecimalDigits(0);
                }
            }
        } else if (column.getMappedTypeCode() == -2 || column.getMappedTypeCode() == -3) {
            String defaultValue = column.getDefaultValue();
            if (StringUtils.isNotBlank((CharSequence)defaultValue) && defaultValue.startsWith("'") && defaultValue.endsWith("'")) {
                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                column.setDefaultValue(defaultValue);
            }
        } else if (TypeMap.isTextType((int)column.getMappedTypeCode())) {
            String defaultValue = column.getDefaultValue();
            if (StringUtils.isNotBlank((CharSequence)defaultValue) && defaultValue.startsWith("('") && defaultValue.endsWith("')")) {
                defaultValue = defaultValue.substring(2, defaultValue.length() - 2);
            }
            column.setDefaultValue(this.unescape(defaultValue, "'", "''"));
            if (column.getMappedTypeCode() == 2009) {
                column.setGenerated(false);
            }
        }
        return column;
    }

    private boolean isColumnInteger(String tableName, String columnName) {
        return this.platform.getSqlTemplate().queryForInt("select case when data_precision is null and data_scale=0 then 1 else 0 end from all_tab_columns where table_name=? and column_name=?", new Object[]{tableName, columnName}) == 1;
    }

    protected void determineAutoIncrementColumns(Connection connection, Table table) throws SQLException {
        Column[] columns = table.getColumns();
        for (int idx = 0; idx < columns.length; ++idx) {
            columns[idx].setAutoIncrement(this.isAutoIncrement(connection, table, columns[idx]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAutoIncrement(Connection connection, Table table, Column column) throws SQLException {
        PreparedStatement prepStmt = null;
        IDdlBuilder builder = this.getPlatform().getDdlBuilder();
        String triggerName = builder.getConstraintName("TRG", table, column.getName(), null);
        String seqName = builder.getConstraintName("SEQ", table, column.getName(), null);
        if (!this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn()) {
            triggerName = triggerName.toUpperCase();
            seqName = seqName.toUpperCase();
        }
        try {
            prepStmt = connection.prepareStatement("SELECT * FROM user_triggers WHERE trigger_name = ?");
            prepStmt.setString(1, triggerName);
            ResultSet resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) {
                resultSet.close();
                boolean bl = false;
                return bl;
            }
            prepStmt.close();
            prepStmt = connection.prepareStatement("SELECT * FROM user_sequences WHERE sequence_name = ?");
            prepStmt.setString(1, seqName);
            resultSet = prepStmt.executeQuery();
            boolean resultFound = resultSet.next();
            resultSet.close();
            boolean bl = resultFound;
            return bl;
        }
        finally {
            if (prepStmt != null) {
                prepStmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<IIndex> readIndices(Connection connection, DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT a.INDEX_NAME, a.INDEX_TYPE, a.UNIQUENESS, b.COLUMN_NAME, b.COLUMN_POSITION, c.COLUMN_EXPRESSION FROM ALL_INDEXES a ");
        query.append("JOIN ALL_IND_COLUMNS b ON a.table_name = b.table_name AND a.INDEX_NAME=b.INDEX_NAME AND a.TABLE_OWNER = b.TABLE_OWNER ");
        query.append("LEFT JOIN ALL_IND_EXPRESSIONS c ON a.table_name = c.table_name AND a.INDEX_NAME=c.INDEX_NAME AND a.TABLE_OWNER = c.TABLE_OWNER ");
        query.append("WHERE ");
        query.append("a.TABLE_NAME = ? ");
        query.append("AND a.GENERATED='N' ");
        query.append("AND a.TABLE_TYPE='TABLE' ");
        if (metaData.getSchemaPattern() != null) {
            query.append("AND a.TABLE_OWNER = ?");
        }
        LinkedHashMap<String, IIndex> indices = new LinkedHashMap<String, IIndex>();
        try (Statement stmt = null;){
            Set<String> pkIndecies = this.readPkIndecies(connection, metaData.getSchemaPattern(), tableName);
            stmt = connection.prepareStatement(query.toString());
            stmt.setString(1, this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() ? tableName : tableName.toUpperCase());
            if (metaData.getSchemaPattern() != null) {
                stmt.setString(2, metaData.getSchemaPattern().toUpperCase());
            }
            ResultSet rs = stmt.executeQuery();
            HashMap<String, Object> values = new HashMap<String, Object>();
            while (rs.next()) {
                String name = rs.getString(1);
                if (pkIndecies.contains(name)) continue;
                String type = rs.getString(2);
                if (type.startsWith("NORMAL") || type.startsWith("FUNCTION-BASED NORMAL")) {
                    values.put("INDEX_TYPE", (short)3);
                    values.put("INDEX_NAME", name);
                    values.put("NON_UNIQUE", "UNIQUE".equalsIgnoreCase(rs.getString(3)) ? Boolean.FALSE : Boolean.TRUE);
                    if (type.startsWith("NORMAL")) {
                        values.put("COLUMN_NAME", rs.getString(4));
                    } else {
                        Object columnName = rs.getString(6);
                        if (columnName != null) {
                            if (!((String)columnName).contains("(")) {
                                columnName = "(" + (String)columnName + ")";
                            } else if (((String)columnName).startsWith("\"") && ((String)columnName).endsWith("\"")) {
                                columnName = "\"" + (String)columnName + "\"";
                            }
                        }
                        values.put("COLUMN_NAME", columnName);
                    }
                    values.put("ORDINAL_POSITION", rs.getShort(5));
                    this.readIndex(metaData, values, indices);
                    continue;
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Skipping index " + name + " of type " + type);
            }
            rs.close();
        }
        return indices.values();
    }

    @Override
    protected String getTableNamePattern(String tableName) {
        return String.format("%s", tableName).replaceAll("\\_", "/_");
    }

    @Override
    public List<String> getTableNamesFromDatabase(String catalog, String schema, String[] tableTypes) {
        ArrayList<String> tableNames = new ArrayList();
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        StringBuilder sql = new StringBuilder("select TABLE_NAME from ALL_TABLES");
        Object[] params = null;
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            sql.append(" where OWNER=?");
            params = new Object[]{schema};
        }
        tableNames = sqlTemplate.query(sql.toString(), (ISqlRowMapper)new ISqlRowMapper<String>(){

            public String mapRow(Row row) {
                return row.getString("TABLE_NAME");
            }
        }, params);
        return tableNames;
    }

    @Override
    public List<Trigger> getTriggers(String catalog, String schema, String tableName) throws SqlException {
        List<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: {}", (Object)tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "SELECT TRIGGER_NAME, OWNER, TABLE_NAME, STATUS, TRIGGERING_EVENT FROM ALL_TRIGGERS WHERE TABLE_NAME=? and OWNER=?";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger mapRow(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("TRIGGER_NAME"));
                trigger.setSchemaName(row.getString("OWNER"));
                trigger.setTableName(row.getString("TABLE_NAME"));
                trigger.setEnabled(Boolean.valueOf(row.getString("STATUS")).booleanValue());
                trigger.setSource("create ");
                String triggerType = row.getString("TRIGGERING_EVENT");
                if (triggerType.equals("DELETE") || triggerType.equals("INSERT") || triggerType.equals("UPDATE")) {
                    trigger.setTriggerType(Trigger.TriggerType.valueOf((String)triggerType));
                }
                trigger.setMetaData((Map)row);
                return trigger;
            }
        }, new Object[]{tableName, schema});
        for (final Trigger trigger : triggers) {
            String name = trigger.getName();
            String sourceSql = "select TEXT from all_source where OWNER=? AND NAME=? order by LINE";
            final StringBuilder buff = new StringBuilder();
            buff.append(trigger.getSource());
            sqlTemplate.query(sourceSql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

                public Trigger mapRow(Row row) {
                    String line = row.getString("TEXT");
                    buff.append(line);
                    if (!line.endsWith("\n")) {
                        buff.append("\n");
                    }
                    return trigger;
                }
            }, new Object[]{schema, name});
            trigger.setSource(buff.toString());
        }
        return triggers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> readPkIndecies(Connection connection, String schema, String tableName) throws SQLException {
        Object QUERY = "SELECT CONSTRAINT_NAME FROM ALL_CONSTRAINTS c WHERE c.TABLE_NAME = ? AND CONSTRAINT_TYPE = 'P'";
        if (schema != null) {
            QUERY = (String)QUERY + " AND c.OWNER = ?";
        }
        ResultSet rs = null;
        PreparedStatement stmt = null;
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        try {
            stmt = connection.prepareStatement((String)QUERY);
            stmt.setString(1, this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() ? tableName : tableName.toUpperCase());
            if (schema != null) {
                stmt.setString(2, schema.toUpperCase());
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                String pkIndexName = rs.getString(1);
                values.add(pkIndexName);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return values;
    }

    @Override
    protected void readForeignKeyUpdateRule(Map<String, Object> values, ForeignKey fk) {
        fk.setOnUpdateAction(ForeignKey.ForeignKeyAction.NOACTION);
    }
}

