/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.generic;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.alter.ColumnAutoIncrementChange;
import org.jumpmind.db.alter.TableChange;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractDdlBuilder;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.SqlException;

public class GenericJdbcDdlBuilder
extends AbstractDdlBuilder {
    public GenericJdbcDdlBuilder(String databaseName, IDatabasePlatform platform) {
        super(databaseName);
        this.databaseInfo.setTriggersSupported(false);
        this.databaseInfo.setForeignKeysSupported(false);
        this.databaseInfo.setNullAsDefaultValueRequired(true);
        this.databaseInfo.setHasNullDefault(93, true);
        this.databaseInfo.setHasNullDefault(91, true);
        this.databaseInfo.setHasNullDefault(92, true);
        this.databaseInfo.setRequiresAutoCommitForDdl(true);
        DataSource ds = (DataSource)platform.getDataSource();
        Connection c = null;
        try {
            c = ds.getConnection();
            DatabaseMetaData meta = c.getMetaData();
            String quoteString = null;
            try {
                meta.getIdentifierQuoteString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isNotBlank(quoteString)) {
                this.databaseInfo.setDelimiterToken(quoteString);
            } else {
                this.databaseInfo.setDelimitedIdentifiersSupported(false);
                this.databaseInfo.setDelimiterToken("");
            }
            if (!this.setNativeMapping(-1, meta, -1) && !this.setNativeMapping(-1, meta, 2005)) {
                this.setNativeMapping(-1, meta, 12);
            }
        }
        catch (SQLException ex) {
            throw new SqlException((Throwable)ex);
        }
        finally {
            JdbcSqlTemplate.close(c);
        }
    }

    protected void writeColumnAutoIncrementStmt(Table table, Column column, StringBuilder ddl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean setNativeMapping(int targetJdbcType, DatabaseMetaData meta, int acceptableType) throws SQLException {
        ResultSet rs = null;
        try {
            rs = meta.getTypeInfo();
            while (rs.next()) {
                String name = rs.getString("TYPE_NAME");
                int type = rs.getInt("DATA_TYPE");
                if (type != acceptableType) continue;
                this.databaseInfo.addNativeTypeMapping(targetJdbcType, name, acceptableType);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            JdbcSqlTemplate.close(rs);
        }
        return false;
    }

    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Table sourceTable, Table targetTable, List<TableChange> changes, StringBuilder ddl) {
        Iterator<TableChange> changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            TableChange change = changeIt.next();
            if (!(change instanceof ColumnAutoIncrementChange)) continue;
            changeIt.remove();
        }
    }
}

