/*
 * Decompiled with CFR 0.152.
 */
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import java.io.File;

public class SymmetricTargetValidator
implements DataValidator {
    private String errorMessage;
    private String warnMessage;

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMessage;
    }

    @Override
    public String getWarningMessageId() {
        return this.warnMessage;
    }

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        String path = installData.getInstallPath();
        File installDir = new File(path);
        File webDir = new File(path + "/web/WEB-INF/lib");
        String installVar = installData.getVariable("select.install.upgrade");
        DataValidator.Status status = DataValidator.Status.OK;
        if (installVar == null || installVar.equals("true")) {
            if (webDir.exists()) {
                this.errorMessage = "The directory already contains a SymmetricDS installation.  Go back and choose upgrade instead.";
                status = DataValidator.Status.ERROR;
            }
        } else {
            if (!installDir.isDirectory()) {
                this.errorMessage = "The directory path does not exist.  Choose an existing SymmetricDS installation to upgrade.";
                status = DataValidator.Status.ERROR;
            } else if (!webDir.isDirectory()) {
                this.errorMessage = "The directory does not contain a valid SymmetricDS installation.";
                status = DataValidator.Status.ERROR;
            } else {
                File uninstallerFile = new File(path + "/Uninstaller/uninstaller.jar");
                if (!uninstallerFile.isFile()) {
                    this.warnMessage = "The lib and web directories will be renamed with a YYYYMMDD extension to preserve any customizations.  These directories can be removed after a successful upgrade.";
                    status = DataValidator.Status.WARNING;
                }
            }
            if (status != DataValidator.Status.ERROR) {
                SymmetricIzPackHelper.createLockFile(path);
            }
        }
        return status;
    }
}

