/*
 * Decompiled with CFR 0.152.
 */
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.util.Platform;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SymmetricMemoryValidator
implements DataValidator {
    private static Set<Platform.Name> linuxNameSet = new HashSet<Platform.Name>();
    private String errorMessage;
    private String warnMessage;

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMessage;
    }

    @Override
    public String getWarningMessageId() {
        return this.warnMessage;
    }

    @Override
    public DataValidator.Status validateData(InstallData idata) {
        String maxMemoryStr = idata.getVariable("select.memory");
        if (maxMemoryStr != null && maxMemoryStr.equals("0")) {
            maxMemoryStr = idata.getVariable("memory.size");
        }
        int maxMemorySize = 0;
        try {
            maxMemorySize = Integer.parseInt(maxMemoryStr);
            if (maxMemorySize < 32) {
                this.errorMessage = "The memory size must be at least 32 MB.";
                return DataValidator.Status.ERROR;
            }
            String bits = System.getProperty("sun.arch.data.model");
            if (bits != null && bits.equals("32") && maxMemorySize > 1024) {
                this.errorMessage = "The max memory size for 32-bit Java is 1024 MB.";
                return DataValidator.Status.ERROR;
            }
        }
        catch (NumberFormatException e) {
            this.errorMessage = "The memory size must be numeric.";
            return DataValidator.Status.ERROR;
        }
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        long freeMemorySize = 0L;
        Platform.Name name = idata.getPlatform().getName();
        SymmetricIzPackHelper.log("My platform name is " + (Object)((Object)name));
        freeMemorySize = linuxNameSet.contains((Object)name) ? this.getLinuxFreeMemorySize() : this.getFreePhysicalMemorySize(osBean);
        if (freeMemorySize > 0L && (long)maxMemorySize > freeMemorySize) {
            this.warnMessage = "You specified " + maxMemorySize + " MB, but there is only " + freeMemorySize + " MB available.  This may prevent the server from starting.";
            if (idata.getAttribute("is.automated") != null) {
                System.out.println("WARNING: " + this.warnMessage);
            } else {
                return DataValidator.Status.WARNING;
            }
        }
        return DataValidator.Status.OK;
    }

    protected long getLinuxFreeMemorySize() {
        long size = 0L;
        try {
            String[] array;
            ProcessBuilder pb = new ProcessBuilder("free", "-m");
            Process proc = pb.start();
            pb.redirectErrorStream(true);
            BufferedReader stdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = stdout.readLine()) != null && !line.toUpperCase().startsWith("MEM")) {
            }
            stdout.close();
            if (line != null && (array = line.split("\\s+")).length > 3) {
                size = Long.parseLong(array[3]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return size;
    }

    protected long getFreePhysicalMemorySize(OperatingSystemMXBean osBean) {
        long size = 0L;
        try {
            Method method = osBean.getClass().getMethod("getFreePhysicalMemorySize", new Class[0]);
            method.setAccessible(true);
            size = (Long)method.invoke((Object)osBean, new Object[0]) / 0x100000L;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return size;
    }

    static {
        Platform.Name[] names = new Platform.Name[]{Platform.Name.LINUX, Platform.Name.DEBIAN_LINUX, Platform.Name.FEDORA_LINUX, Platform.Name.MANDRAKE_LINUX, Platform.Name.MANDRIVA_LINUX, Platform.Name.RED_HAT_LINUX, Platform.Name.SUSE_LINUX, Platform.Name.UBUNTU_LINUX};
        Collections.addAll(linuxNameSet, names);
    }
}

