/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.utility;

import com.anfcorp.stores.symmetric.corp.OutboundSalesDatabasePublisher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class RepublishSalesTool {
    static final Logger logger = LogManager.getLogger(RepublishSalesTool.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        RepublishSalesTool.loadPropertiesFiles(args);
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("classpath:anf-republish-sales.xml");
        logger.info("Application context loaded successfully. Processing the transactions now");
        List<File> transactionFiles = RepublishSalesTool.findTransactionFiles(args, (ApplicationContext)ctx);
        if (transactionFiles.size() > 0) {
            ThreadPoolExecutor service = (ThreadPoolExecutor)Executors.newFixedThreadPool(10);
            final OutboundSalesDatabasePublisher publisher = (OutboundSalesDatabasePublisher)ctx.getBean(OutboundSalesDatabasePublisher.class);
            for (File file : transactionFiles) {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(file));
                    String transactionString = null;
                    int line = 1;
                    do {
                        if ((transactionString = reader.readLine()) == null) continue;
                        String[] split = transactionString.split(",");
                        if (split.length == 4) {
                            final String storeNumber = split[0].trim();
                            final int sequenceNumber = Integer.parseInt(split[1].trim());
                            final String workstationNumber = split[2].trim();
                            final String businessDay = split[3].trim();
                            service.execute(new Runnable(){

                                @Override
                                public void run() {
                                    logger.info(String.format("Processing transaction for Store #: %s, Transaction #: %s, Workstation #: %s, Business Date: %s", storeNumber, sequenceNumber, workstationNumber, businessDay));
                                    publisher.publishFromDatabase(businessDay, storeNumber, workstationNumber, sequenceNumber);
                                }
                            });
                        } else {
                            logger.warn("Line " + line + " was not formatted correctly: " + transactionString);
                        }
                        ++line;
                    } while (transactionString != null);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            while (service.getActiveCount() > 0) {
                Thread.sleep(1000L);
            }
            logger.info("Successfully posted all the messages");
            System.exit(0);
        } else {
            logger.info("Did not find any transaction files to process");
            System.exit(-1);
        }
    }

    protected static List<File> findTransactionFiles(String[] args, ApplicationContext ctx) {
        ArrayList<File> transactionFiles = new ArrayList<File>();
        String fileLocation = (String)ctx.getBean("fileLocationObject");
        if (StringUtils.isNotBlank((String)fileLocation)) {
            File file = new File(fileLocation);
            if (file.exists()) {
                transactionFiles.add(file);
            } else {
                logger.warn("Could not find the file: " + file.getAbsolutePath());
            }
        }
        return transactionFiles;
    }

    protected static void loadPropertiesFiles(String[] args) throws IOException {
        if (args != null && args.length > 0) {
            for (String arg : args) {
                File file = new File(arg);
                if (!file.exists() || !arg.endsWith(".properties")) continue;
                logger.info("Loading properties from " + file);
                FileInputStream is = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(is);
                is.close();
                System.setProperties(properties);
            }
        }
    }
}

