/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp.cache;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class StoreCountryStateCache
extends HashMap<String, StoreCountryState> {
    private static final long serialVersionUID = 1L;
    private DataSource dataSource;
    private String selectCacheSql;
    private long lastCacheRefreshTimeMs = 0L;
    private static final long CACHE_TIMEOUT_MS = 600000L;

    public long getLastCacheRefreshTimeMs() {
        return this.lastCacheRefreshTimeMs;
    }

    public void setSelectCacheSql(String selectCacheSql) {
        this.selectCacheSql = selectCacheSql;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreCountryState get(Object key) {
        if (this.isCacheTimedOut()) {
            StoreCountryStateCache storeCountryStateCache = this;
            synchronized (storeCountryStateCache) {
                if (this.isCacheTimedOut()) {
                    JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
                    List allStores = jdbcTemplate.query(this.selectCacheSql, (RowMapper)new RowMapper<StoreCountryState>(){

                        public StoreCountryState mapRow(ResultSet rs, int rowNum) throws SQLException {
                            return new StoreCountryState(rs.getString("country"), rs.getString("state"), rs.getString("store"));
                        }
                    });
                    for (StoreCountryState storeCountryState : allStores) {
                        this.put(storeCountryState.getStoreId(), storeCountryState);
                    }
                    this.lastCacheRefreshTimeMs = System.currentTimeMillis();
                }
            }
        }
        return (StoreCountryState)super.get(key);
    }

    public void addStoreCountryState(String storeId, String countryCode, String stateCode) {
        this.lastCacheRefreshTimeMs = System.currentTimeMillis();
        this.put(storeId, new StoreCountryState(countryCode, stateCode, storeId));
    }

    private final boolean isCacheTimedOut() {
        return System.currentTimeMillis() - this.lastCacheRefreshTimeMs > 600000L;
    }

    public class StoreCountryState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String storeId;
        String country;
        String state;

        public StoreCountryState(String country, String state, String storeId) {
            this.country = country;
            this.state = state;
            this.storeId = storeId;
        }

        public String getStoreId() {
            return this.storeId;
        }

        public String getCountry() {
            return this.country;
        }

        public String getState() {
            return this.state;
        }
    }
}

