/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp.cache;

import com.anfcorp.stores.symmetric.corp.model.ParameterBean;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class ParameterCache {
    static final Log logger = LogFactory.getLog(ParameterCache.class);
    private DataSource dataSource;
    private int refreshInterval;
    private String parameterSql;
    private long lastTimeRefreshed = 0L;
    private Map<String, ParameterBean> cachedParameters = new ConcurrentHashMap<String, ParameterBean>();
    private JdbcTemplate jdbcTemplate;
    private static final long CACHE_TIMEOUT_MS = 3600000L;

    public ParameterBean getParameterBean(String category, String subCategory, String paramName) {
        logger.debug((Object)("category=" + category + ", subCategory=" + subCategory + ", paramName=" + paramName));
        return this.doGetParameterBean(category, subCategory, paramName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParameterBean doGetParameterBean(String category, String subCategory, String paramName) {
        String key = this.generateCacheKey(category, subCategory, paramName);
        ParameterBean ret = this.cachedParameters.get(key);
        if (ret == null || this.isCacheTimedOut()) {
            ParameterCache parameterCache = this;
            synchronized (parameterCache) {
                ret = this.cachedParameters.get(key);
                if (ret == null || this.isCacheTimedOut()) {
                    this.cacheParameter(category, subCategory, paramName);
                    ret = this.cachedParameters.get(key);
                }
            }
        }
        return ret;
    }

    private void cacheParameter(String category, String subCategory, String paramName) {
        List<Map<String, Object>> list = this.getListOfParameterBean(category, subCategory, paramName);
        ParameterBean paramBean = this.getParameterBean(list);
        if (paramBean != null) {
            this.lastTimeRefreshed = Calendar.getInstance().getTimeInMillis();
            this.cachedParameters.put(this.generateCacheKey(category, subCategory, paramName), paramBean);
            logger.debug((Object)("cachedParameters=" + this.cachedParameters));
        }
    }

    private List<Map<String, Object>> getListOfParameterBean(String category, String subCategory, String paramName) {
        if (this.jdbcTemplate == null) {
            this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        }
        return this.jdbcTemplate.queryForList(this.parameterSql, new Object[]{category, subCategory, paramName});
    }

    private ParameterBean getParameterBean(List<Map<String, Object>> list) {
        return list.stream().findFirst().map(map -> {
            ParameterBean param = new ParameterBean();
            param.setCategory((String)map.get("CATEGORY"));
            param.setSubCategory((String)map.get("SUB_CATEGORY"));
            param.setParamName((String)map.get("PARAM_NAME"));
            param.setParamValue((String)map.get("PARAM_VALUE"));
            return param;
        }).orElse(null);
    }

    private boolean isCacheTimedOut() {
        return System.currentTimeMillis() - this.lastTimeRefreshed > 3600000L;
    }

    private String generateCacheKey(String category, String subCategory, String paramName) {
        return category + ":" + subCategory + ":" + paramName;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public void setParameterSql(String parameterSql) {
        this.parameterSql = parameterSql;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public String getParameterSql() {
        return this.parameterSql;
    }

    public Map<String, ParameterBean> getCachedParameters() {
        return this.cachedParameters;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

