/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp;

import com.anfcorp.stores.symmetric.corp.OutboundSalesXmlPublisherFilter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;

public class OutboundSalesDatabasePublisher {
    protected static final DateTimeFormatter timestampFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    protected OutboundSalesXmlPublisherFilter outboundSalesXmlPublisherFilter;
    protected DataSource dataSource;
    protected static Map<String, String[]> tableNameToColumnNames = new HashMap<String, String[]>();

    public void publishFromDatabase(String businessDay, String storeNumber, String workstationNumber, int sequenceNumber) {
        DataContext ctx = new DataContext();
        Set<String> tableNames = this.outboundSalesXmlPublisherFilter.getTableNamesToPublishAsGroup();
        for (String tableName : tableNames) {
            String[] columnNames = this.readColumnNames(tableName);
            List<String[]> dataRowsForTable = this.readData(tableName, columnNames, businessDay, storeNumber, workstationNumber, sequenceNumber);
            for (String[] values : dataRowsForTable) {
                Table table = new Table(tableName);
                table.addColumns(columnNames);
                Batch batch = new Batch();
                batch.setSourceNodeId("republish");
                ctx.setBatch(batch);
                CsvData data = new CsvData(DataEventType.INSERT);
                data.putParsedData("rowData", values);
                this.outboundSalesXmlPublisherFilter.beforeWrite(ctx, table, data);
            }
        }
        this.outboundSalesXmlPublisherFilter.batchComplete(ctx);
    }

    protected String[] readColumnNames(final String tableName) {
        String[] columnNames = tableNameToColumnNames.get(tableName);
        if (columnNames == null) {
            JdbcTemplate template = new JdbcTemplate(this.dataSource);
            columnNames = (String[])template.execute((ConnectionCallback)new ConnectionCallback<String[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public String[] doInConnection(Connection con) throws SQLException, DataAccessException {
                    ArrayList<String> columns = new ArrayList<String>();
                    DatabaseMetaData meta = con.getMetaData();
                    ResultSet rs = null;
                    try {
                        rs = meta.getColumns(null, "AFCOADM", tableName, null);
                        while (rs.next()) {
                            columns.add(rs.getString("COLUMN_NAME"));
                        }
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.closeResultSet(rs);
                        throw throwable;
                    }
                    JdbcUtils.closeResultSet((ResultSet)rs);
                    return columns.toArray(new String[columns.size()]);
                }
            });
        }
        return columnNames;
    }

    protected List<String[]> readData(String tableName, final String[] columnNames, String businessDay, String storeNumber, String workstationNumber, int sequenceNumber) {
        List<Object> rows = new ArrayList<String[]>();
        if (columnNames != null && columnNames.length > 0) {
            StringBuilder builder = new StringBuilder("select ");
            for (int i = 0; i < columnNames.length; ++i) {
                String columnName = columnNames[i];
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(columnName);
            }
            builder.append(" from ").append(tableName).append(" where DC_DY_BSN=? and ID_STR_RT=? and ID_WS=? and AI_TRN=?");
            JdbcTemplate template = new JdbcTemplate(this.dataSource);
            rows = template.query(builder.toString(), new Object[]{businessDay, storeNumber, workstationNumber, sequenceNumber}, (RowMapper)new RowMapper<String[]>(){

                public String[] mapRow(ResultSet rs, int rowNum) throws SQLException {
                    String[] data = new String[columnNames.length];
                    for (int i = 1; i <= data.length; ++i) {
                        int type = rs.getMetaData().getColumnType(i);
                        if (type == 2004) {
                            byte[] b = rs.getBytes(i);
                            if (b == null) continue;
                            data[i - 1] = new String(Base64.encodeBase64((byte[])b));
                            continue;
                        }
                        if (type == 93) {
                            Timestamp ts = rs.getTimestamp(i);
                            if (ts == null) continue;
                            data[i - 1] = ts.toLocalDateTime().format(timestampFormatter);
                            continue;
                        }
                        data[i - 1] = rs.getString(i);
                    }
                    return data;
                }
            });
        }
        return rows;
    }

    public void setOutboundSalesXmlPublisherFilter(OutboundSalesXmlPublisherFilter outboundSalesXmlPublisherFilter) {
        this.outboundSalesXmlPublisherFilter = outboundSalesXmlPublisherFilter;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

