/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.INodeGroupExtensionPoint;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterFilterAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditiveDataLoaderFilter
extends DatabaseWriterFilterAdapter
implements INodeGroupExtensionPoint,
ISymmetricEngineAware {
    private static final Logger log = LoggerFactory.getLogger(AdditiveDataLoaderFilter.class);
    private String tableName;
    private String[] additiveColumnNames;
    private String[] overrideColumnNames;
    private String[] nodeGroups;
    protected ISymmetricEngine engine;

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }

    public boolean beforeWrite(DataContext context, Table table, CsvData data) {
        String sourceNodeId = (String)data.getAttribute("sourceNodeId");
        if (!StringUtils.startsWith((String)"rgn", (String)sourceNodeId) && table.getName().equalsIgnoreCase(this.tableName)) {
            if (data.getDataEventType() == DataEventType.DELETE) {
                throw new RuntimeException("delete not supported for AdditiveDataLoaderFilter, table: " + table.getName() + ", key(s): " + data.getCsvData("pkData"));
            }
            if (data.getDataEventType() == DataEventType.INSERT || data.getDataEventType() == DataEventType.UPDATE) {
                return !this.update(context, table, data, data.getParsedData("rowData"), data.getParsedData("pkData"));
            }
        }
        return true;
    }

    protected boolean update(DataContext context, Table table, CsvData data, String[] columnValues, String[] keyValues) {
        Object[] colData = this.engine.getDatabasePlatform().getObjectValues(BinaryEncoding.BASE64, columnValues, table.getColumns());
        StringBuilder s = new StringBuilder();
        s.append("update " + table.getName());
        ArrayList<Object> values = new ArrayList<Object>();
        String setClause = this.buildSetClause(table, data, colData, values);
        if (StringUtils.trimToNull((String)setClause) == null) {
            return false;
        }
        s.append(" set ").append(setClause);
        s.append(this.buildWhereClause(table, colData, values));
        log.debug("Sql", (Object)s);
        return context.findTransaction().prepareAndExecute(s.toString(), values.toArray()) > 0;
    }

    protected String buildSetClause(Table table, CsvData data, Object[] columnValues, List<Object> values) {
        StringBuilder s = new StringBuilder();
        if (this.overrideColumnNames != null || this.additiveColumnNames != null) {
            boolean firstSet = false;
            if (this.overrideColumnNames != null) {
                for (int i = 0; i < this.overrideColumnNames.length; ++i) {
                    int overrideColumnIndex = table.getColumnIndex(this.overrideColumnNames[i]);
                    Object newData = columnValues[overrideColumnIndex];
                    if (newData == null) continue;
                    if (firstSet) {
                        s.append(", ");
                    }
                    firstSet = true;
                    s.append(this.overrideColumnNames[i]);
                    s.append("=?");
                    values.add(newData);
                }
            }
            if (this.additiveColumnNames != null) {
                String[] old = data.getParsedData("oldData");
                if (old == null) {
                    old = data.getParsedData("rowData");
                }
                Object[] oldValues = this.engine.getDatabasePlatform().getObjectValues(BinaryEncoding.BASE64, old, table.getColumns());
                for (int i = 0; i < this.additiveColumnNames.length; ++i) {
                    int additiveColumnIndex = table.getColumnIndex(this.additiveColumnNames[i]);
                    Object oldData = oldValues == null ? null : oldValues[additiveColumnIndex];
                    Object newData = columnValues[additiveColumnIndex];
                    if (newData == null || oldData != null && newData.equals(oldData)) continue;
                    if (firstSet) {
                        s.append(", ");
                    }
                    firstSet = true;
                    s.append(this.additiveColumnNames[i]);
                    s.append("=");
                    s.append(this.additiveColumnNames[i]);
                    s.append("+");
                    s.append(newData);
                    if (oldData == null) continue;
                    s.append("-(");
                    s.append(oldData);
                    s.append(")");
                }
            }
        }
        return s.toString();
    }

    protected String buildWhereClause(Table table, Object[] colData, List<Object> values) {
        StringBuilder s = new StringBuilder();
        s.append(" where ");
        Column[] columns = table.getColumns();
        boolean addedAtLeastOne = false;
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (!column.isPrimaryKey()) continue;
            if (addedAtLeastOne) {
                s.append(" and ");
            } else {
                addedAtLeastOne = true;
            }
            s.append(column.getName());
            s.append("=?");
            values.add(colData[i]);
        }
        return s.toString();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setNodeGroups(String[] nodeGroups) {
        this.nodeGroups = nodeGroups;
    }

    public String[] getNodeGroupIdsToApplyTo() {
        return this.nodeGroups;
    }

    public String[] getAdditiveColumnNames() {
        return this.additiveColumnNames;
    }

    public void setAdditiveColumnNames(String[] additiveColumnNames) {
        this.additiveColumnNames = additiveColumnNames;
    }

    public String[] getOverrideColumnNames() {
        return this.overrideColumnNames;
    }

    public void setOverrideColumnNames(String[] overrideColumnNames) {
        this.overrideColumnNames = overrideColumnNames;
    }
}

