/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.util;

import com.google.gson.annotations.Expose;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.event.Level;

public class LogSummary
implements Comparable<LogSummary> {
    @Expose
    private Level level;
    @Expose
    private String mostRecentThreadName;
    private transient Throwable throwable;
    @Expose
    private long firstOccurranceTime;
    @Expose
    private long mostRecentTime;
    @Expose
    private int count;
    @Expose
    private String message;
    @Expose
    private String stackTrace;
    @Expose
    private Integer levelInt;

    public void setLevel(Level level) {
        this.level = level;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getStackTrace() {
        if (this.stackTrace == null && this.throwable != null) {
            StringWriter st = new StringWriter();
            this.throwable.printStackTrace(new PrintWriter(st));
            this.stackTrace = st.toString();
        }
        return this.stackTrace;
    }

    public void setStackTrace(String st) {
        this.stackTrace = st;
    }

    public Integer getLevelInt() {
        return this.levelInt != null ? this.levelInt : (this.level != null ? this.level.toInt() : 0);
    }

    public void setLevelInt(Integer levelInt) {
        this.levelInt = levelInt;
    }

    public long getFirstOccurranceTime() {
        return this.firstOccurranceTime;
    }

    public void setFirstOccurranceTime(long firstOccurranceDate) {
        this.firstOccurranceTime = firstOccurranceDate;
    }

    public long getMostRecentTime() {
        return this.mostRecentTime;
    }

    public void setMostRecentTime(long mostRecentDate) {
        this.mostRecentTime = mostRecentDate;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMostRecentThreadName(String mostRecentThreadName) {
        this.mostRecentThreadName = mostRecentThreadName;
    }

    public String getMostRecentThreadName() {
        return this.mostRecentThreadName;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public int compareTo(LogSummary other) {
        if (this.mostRecentTime == other.mostRecentTime) {
            return 0;
        }
        return this.mostRecentTime > other.mostRecentTime ? 1 : -1;
    }
}

