/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jumpmind.util.FormatUtils;

public class LinkedCaseInsensitiveMap<V>
extends LinkedHashMap<String, V> {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> caseInsensitiveKeys;
    private final Locale locale;

    public LinkedCaseInsensitiveMap(Map<String, ? extends V> values) {
        this();
        this.putAll(values);
    }

    public LinkedCaseInsensitiveMap() {
        this((Locale)null);
    }

    public LinkedCaseInsensitiveMap(Locale locale) {
        this.caseInsensitiveKeys = new HashMap<String, String>();
        this.locale = locale != null ? locale : Locale.getDefault();
    }

    public LinkedCaseInsensitiveMap(int initialCapacity) {
        this(initialCapacity, null);
    }

    public LinkedCaseInsensitiveMap(int initialCapacity, Locale locale) {
        super(initialCapacity);
        this.caseInsensitiveKeys = new HashMap<String, String>(initialCapacity);
        this.locale = locale != null ? locale : Locale.getDefault();
    }

    @Override
    public V put(String key, V value) {
        this.caseInsensitiveKeys.put(this.convertKey(key), key);
        if (FormatUtils.isInfamousTurkey()) {
            this.caseInsensitiveKeys.put(FormatUtils.stripTurkeyDottedI(this.convertKey(key)), key);
        }
        return super.put(key, value);
    }

    @Override
    public final void putAll(Map<? extends String, ? extends V> map) {
        if (map != null) {
            Set<String> keys = map.keySet();
            for (String string : keys) {
                this.put(string, map.get(string));
            }
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && this.caseInsensitiveKeys.containsKey(this.convertKey((String)key));
    }

    @Override
    public V get(Object key) {
        if (key instanceof String) {
            return super.get(this.caseInsensitiveKeys.get(this.convertKey((String)key)));
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        if (key instanceof String) {
            return super.remove(this.caseInsensitiveKeys.remove(this.convertKey((String)key)));
        }
        return null;
    }

    @Override
    public void clear() {
        this.caseInsensitiveKeys.clear();
        super.clear();
    }

    protected String convertKey(String key) {
        return key.toLowerCase(this.locale);
    }
}

