/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class CustomizableThreadFactory
implements ThreadFactory {
    AtomicInteger threadNumber = new AtomicInteger(1);
    String namePrefix;

    public CustomizableThreadFactory(String name) {
        this.namePrefix = name;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName(this.namePrefix + "-" + this.threadNumber.getAndIncrement());
        if (thread.isDaemon()) {
            thread.setDaemon(false);
        }
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    }
}

