/* Generated By:JavaCC: Do not edit this line. MatchParser.java */
package com.ibm.disthub2.impl.matching.selector;
import com.ibm.disthub2.impl.util.FastVector;
import java.io.StringReader;

/** The MatchParser class provides parsing support for a superset of the JMS selector
 * syntax, returning a Selector tree.  Except for the superset features, the language
 * accepted is that of the JMS specification.
 *
 * MatchParser language features not in JMS:
 *
 * (1) Identifiers can be quoted with " and may contain any character except unescaped ".
 *
 * (2) Identifiers (unquoted) may contain the field separator character '.'.
 *
 * (3) Set predicates allow an arbitrary expression on the left (not restricted to
 * identifier) and a list of arbitrary expressions on the right (not restricted to string
 * literals).
 *
 * (4) There is support for lists.  This support is accessed through the use of [ ]
 * characters and is described in detail elsewhere.
 *
 * The superset features can be turned off by setting the 'strict' flag, causing the
 * parser to recognize only the JMS syntax.
 **/

public class MatchParser implements MatchParserConstants {
  private final static String copyright = "Licensed Material - Property of IBM \n5648-C63 (c) Copyright IBM Corp. 2006 - All Rights Reserved. \nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";


  // Strict mode flag
  private boolean strict;


  /** Prime a MatchParser object with a String form selector so that its QueryExpr method
   * will return the corresponding Selector tree.
   *
   * @param parser an existing MatchParser object to be reused, or null if a new one is to
   * be created.
   *
   * @param selector the String-form selector to be parsed
   *
   * @param strict true if only the JMS standard syntax is to be accepted, false if the
   * extended syntax for identifiers, set expressions, and lists is to be accepted.
   *
   * @return a parser, primed with the supplied selector.  This is the same parser object
   * that was supplied as an argument, if one was supplied.
   **/

  public static MatchParser prime(MatchParser parser, String selector, boolean strict) {
    CharStream inStream = new IBMUnicodeCharStream(new StringReader(selector),1,1);
    if (parser == null)
      parser =  new MatchParser(inStream);
    else
      parser.ReInit(inStream);
    parser.strict = strict;
    return parser;
  }

  /** Return the Selector tree associated with a primed parser.
   *
   * @return a selector tree.  If the parse was successful, the top node of the tree will
   * be of BOOLEAN type; otherwise, it will be of INVALID type.
   **/

  public Selector getSelector() {
    Selector ans;
    try {
      ans = QueryExpr();
      if (!ans.mayBeBoolean())
        ans.type = Selector.INVALID;
    } catch (ParseException e) {
      ans = new Literal(BooleanValue.NULL);
      ans.type = Selector.INVALID;
    }
    return ans;
  }

// QueryExpr ::= BooleanExpr <EOF>
  final public Selector QueryExpr() throws ParseException {
                         Selector ans;
    ans = BooleanExpr();
    jj_consume_token(0);
                              {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// BooleanExpr  ::=  BooleanTerm
//               | BooleanTerm <OR> BooleanExpr
  final public Selector BooleanExpr() throws ParseException {
                           Selector left, right=null;
    left = BooleanTerm();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OR:
      jj_consume_token(OR);
      right = BooleanExpr();
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    if (right == null) {if (true) return left;}
    else {if (true) return new Operator(Operator.OR, left, right);}
    throw new Error("Missing return statement in function");
  }

// BooleanTerm ::= BooleanFactor
//              | BooleanFactor <AND> BooleanTerm
  final public Selector BooleanTerm() throws ParseException {
                           Selector left, right=null;
    left = BooleanFactor();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AND:
      jj_consume_token(AND);
      right = BooleanTerm();
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    if (right == null) {if (true) return left;}
    else {if (true) return new Operator(Operator.AND, left, right);}
    throw new Error("Missing return statement in function");
  }

// BooleanFactor ::= ( <NOT> Predicate ) | Predicate
  final public Selector BooleanFactor() throws ParseException {
                             Selector child; boolean neg=false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
             neg = true;
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
    child = Predicate();
    if (neg) {if (true) return new Operator(Operator.NOT, child);}
    else {if (true) return child;}
    throw new Error("Missing return statement in function");
  }

// Predicate ::= SetPredicate
//            | NullPredicate
//            | ComparisonPredicate
//            | CasePredicate
//            | BetweenPredicate
//            | LikePredicate
//            | EmptyPredicate
//            | Expression
// SetPredicate ::= JMSSetPredicate
//               | GeneralSetPredicate
  final public Selector Predicate() throws ParseException {
                         Selector ans;
    if (jj_2_1(2147483647)) {
      ans = ComparisonPredicate();
    } else if (jj_2_2(2147483647)) {
      ans = NullPredicate();
    } else if (jj_2_3(2147483647)) {
      ans = BetweenPredicate();
    } else if (jj_2_4(2147483647)) {
      ans = LikePredicate();
    } else if (jj_2_5(2147483647)) {
      ans = EmptyPredicate();
    } else if (jj_2_6(2147483647)) {
      ans = CasePredicate();
    } else if (jj_2_7(2147483647)) {
      ans = JMSSetPredicate();
    } else if (jj_2_8(2147483647)) {
      ans = GeneralSetPredicate();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 7:
      case 8:
      case 11:
      case TRUE:
      case FALSE:
      case IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
        ans = Expression();
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// ComparisonPredicate ::= ( Expression ( "<" | ">" | "<=" | ">=" ) Expression
//                      | Expression ( "<>" | "=" ) Expression )
  final public Selector ComparisonPredicate() throws ParseException {
                                   Selector left, right; int op;
    left = Expression();
    op = ComparisonOperator();
    right = Expression();
    {if (true) return new Operator(op, left, right);}
    throw new Error("Missing return statement in function");
  }

  final public int ComparisonOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 1:
      jj_consume_token(1);
        {if (true) return Operator.LT;}
      break;
    case 2:
      jj_consume_token(2);
          {if (true) return Operator.GT;}
      break;
    case 3:
      jj_consume_token(3);
           {if (true) return Operator.LE;}
      break;
    case 4:
      jj_consume_token(4);
           {if (true) return Operator.GE;}
      break;
    case 5:
      jj_consume_token(5);
           {if (true) return Operator.NE;}
      break;
    case 6:
      jj_consume_token(6);
          {if (true) return Operator.EQ;}
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// CasePredicate ::= Identifier <ISA> Identifier
  final public Selector CasePredicate() throws ParseException {
                             Selector left, right;
    left = Identifier();
    jj_consume_token(ISA);
    right = Identifier();
    ((Identifier) right).caseOf = (Identifier) left;
    {if (true) return new Operator(Operator.EQ, left, right);}
    throw new Error("Missing return statement in function");
  }

// Expression ::= Term
//             | Term PlusMinus Expression
  final public Selector Expression() throws ParseException {
                          Selector left, right=null; int op = -1;
    left = Term();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 7:
    case 8:
      op = PlusMinus();
      right = Expression();
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    if (right == null) {if (true) return left;}
    else {if (true) return new Operator(op, left, right);}
    throw new Error("Missing return statement in function");
  }

// PlusMinus ::= "+" | "-"
  final public int PlusMinus() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 7:
      jj_consume_token(7);
        {if (true) return Operator.PLUS;}
      break;
    case 8:
      jj_consume_token(8);
          {if (true) return Operator.MINUS;}
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// Term ::= Primary
//       | Primary TimesDiv Term
  final public Selector Term() throws ParseException {
                    Selector left, right=null; int op = -1;
    left = Primary(false);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 9:
    case 10:
      op = TimesDiv();
      right = Term();
      break;
    default:
      jj_la1[7] = jj_gen;
      ;
    }
    if (right == null) {if (true) return left;}
    else {if (true) return new Operator(op, left, right);}
    throw new Error("Missing return statement in function");
  }

// TimesDiv ::= "*" | "/"
  final public int TimesDiv() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 9:
      jj_consume_token(9);
        {if (true) return Operator.TIMES;}
      break;
    case 10:
      jj_consume_token(10);
          {if (true) return Operator.DIV;}
      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// Primary ::= PlusMinus Primary
//          | PrimaryNotPlusMinus
  final public Selector Primary(boolean negated) throws ParseException {
                                      Selector ans; int op = Operator.PLUS;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 11:
    case TRUE:
    case FALSE:
    case IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
      ans = PrimaryNotPlusMinus(negated);
      break;
    case 7:
    case 8:
      op = PlusMinus();
                         negated ^= (op == Operator.MINUS);
      ans = Primary(negated);
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// PrimaryNotPlusMinus ::= <TRUE>
//                   | <FALSE>
//                   | "(" BooleanExpr ")"
//                   | <INTEGER_LITERAL>
//                   | <FLOATING_POINT_LITERAL>
//                   | <STRING_LITERAL>
//                   | FieldRef
  final public Selector PrimaryNotPlusMinus(boolean negated) throws ParseException {
                                                  Selector ans; Token tok;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
             ans = new Literal(BooleanValue.TRUE);
      break;
    case FALSE:
      jj_consume_token(FALSE);
              ans = new Literal(BooleanValue.FALSE);
      break;
    case 11:
      jj_consume_token(11);
      ans = BooleanExpr();
      jj_consume_token(12);
      break;
    case INTEGER_LITERAL:
      tok = jj_consume_token(INTEGER_LITERAL);
    ans = ParseUtil.parseIntegerLiteral(((negated) ? "-" : "") + tok.image);
    negated = false;
      break;
    case FLOATING_POINT_LITERAL:
      tok = jj_consume_token(FLOATING_POINT_LITERAL);
    ans = ParseUtil.parseFloatingLiteral(((negated) ? "-" : "") + tok.image);
    negated = false;
      break;
    case STRING_LITERAL:
      tok = jj_consume_token(STRING_LITERAL);
                             ans = ParseUtil.parseStringLiteral(tok.image);
      break;
    case IDENTIFIER:
    case QUOTED_IDENTIFIER:
      ans = FieldRef();

      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (negated) {if (true) return new Operator(Operator.NEG, ans);}
    else {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// NullPredicate ::= FieldRef <IS> ( <NOT> )? <NULL>
  final public Selector NullPredicate() throws ParseException {
                             boolean not=false; Selector ans;
    ans = FieldRef();
    jj_consume_token(IS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                                    not = true;
      break;
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    jj_consume_token(NULL);
    ans = new Operator(Operator.ISNULL, ans);
    if (not) {if (true) return new Operator(Operator.NOT, ans);}
    else {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// JMSSetPredicate ::= FieldRef ( <NOT> )? <IN> SetString
  final public Selector JMSSetPredicate() throws ParseException {
                               Selector id; FastVector set; boolean neg=false;
    id = FieldRef();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                              neg = true;
      break;
    default:
      jj_la1[12] = jj_gen;
      ;
    }
    jj_consume_token(IN);
    set = SetString();
    Selector ans = ParseUtil.convertSet(id, set);
    if (neg) {if (true) return new Operator(Operator.NOT, ans);}
    else {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// GeneralSetPredicate ::= Expression ( <NOT> )? <IN> SetExpr
  final public Selector GeneralSetPredicate() throws ParseException {
                                   Selector expr; FastVector set; boolean neg=false;
    if (strict) {if (true) throw generateParseException();}
    expr = Expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                                  neg = true;
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
    jj_consume_token(IN);
    set = SetExpr();
    Selector ans = ParseUtil.convertSet(expr, set);
    if (neg) ans = new Operator(Operator.NOT, ans);
    {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// SetExpr ::= "(" Expression ( "," Expression )* ")"
  final public FastVector SetExpr() throws ParseException {
                         FastVector ans = new FastVector(); Selector elem;
    jj_consume_token(11);
    elem = Expression();
                              ans.addElement(elem);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 13:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_1;
      }
      jj_consume_token(13);
      elem = Expression();
                                ans.addElement(elem);
    }
    jj_consume_token(12);
    {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// SetString ::= "(" <STRING_LITERAL> ( "," <STRING_LITERAL> )* ")"
  final public FastVector SetString() throws ParseException {
                           FastVector ans = new FastVector(); Token tok;
    jj_consume_token(11);
    tok = jj_consume_token(STRING_LITERAL);
      ans.addElement(ParseUtil.parseStringLiteral(tok.image));
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 13:
        ;
        break;
      default:
        jj_la1[15] = jj_gen;
        break label_2;
      }
      jj_consume_token(13);
      tok = jj_consume_token(STRING_LITERAL);
        ans.addElement(ParseUtil.parseStringLiteral(tok.image));
    }
    jj_consume_token(12);
    {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// BetweenPredicate ::= Expression ( <NOT> )? <BETWEEN> Expression <AND> Expression
  final public Selector BetweenPredicate() throws ParseException {
                                Selector expr1, expr2, expr3; boolean neg=false;
    expr1 = Expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                                   neg = true;
      break;
    default:
      jj_la1[16] = jj_gen;
      ;
    }
    jj_consume_token(BETWEEN);
    expr2 = Expression();
    jj_consume_token(AND);
    expr3 = Expression();
    Selector ans = ParseUtil.convertRange(expr1, expr2, expr3);
    if (neg) {if (true) return new Operator(Operator.NOT, ans);}
    else {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// LikePredicate ::= FieldRef ( <NOT> )? <LIKE> <STRING_LITERAL>
//   ( <ESCAPE> <STRING_LITERAL> )?
  final public Selector LikePredicate() throws ParseException {
                             Selector id; Token pat; Token esc=null; boolean neg=false;
    id = FieldRef();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                              neg = true;
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    jj_consume_token(LIKE);
    pat = jj_consume_token(STRING_LITERAL);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ESCAPE:
      jj_consume_token(ESCAPE);
      esc = jj_consume_token(STRING_LITERAL);
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    Selector ans = new LikeOperator(id, pat.image, (esc==null) ? null : esc.image);
    if (neg) {if (true) return new Operator(Operator.NOT, ans);}
    else {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// FieldRef ::= Identifier ( Selections "." Identifier )*
  final public Selector FieldRef() throws ParseException {
                        Selector ans; Selector[] sel; Selector id;
    ans = Identifier();
    label_3:
    while (true) {
      if (jj_2_9(2147483647)) {
        ;
      } else {
        break label_3;
      }
      sel = Selections();
      jj_consume_token(14);
      id = Identifier();
      Selector select = sel[0];
      Selector index = sel[1];
      if (select != null)
        ans = new Operator(Operator.SELECT, ans, select);
      if (index == null)
        index = new Literal(new NumericValue(0));
      ans = new Operator(Operator.FIELD, new Operator(Operator.INDEX, ans, index), id);
    }
    {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// Selections ::= Index
//              | SelectExpr ( Index )?
  final public Selector[] Selections() throws ParseException {
                            Selector select = null, index = null;
    if (strict) {if (true) throw generateParseException();}
    if (jj_2_10(2147483647)) {
      index = Index();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 15:
        select = SelectExpr();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 15:
          index = Index();
          break;
        default:
          jj_la1[19] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[20] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return new Selector[] { select, index };}
    throw new Error("Missing return statement in function");
  }

// Identifier ::=  <IDENTIFIER>
//              |  <QUOTED_IDENTIFIER>
  final public Selector Identifier() throws ParseException {
                          Token tok; String id;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      tok = jj_consume_token(IDENTIFIER);
                         id = tok.image;
                         // Identifiers with '.' in their name are not JMS conformant
                         if (strict && id.indexOf('.') != -1)
                         {if (true) throw generateParseException();}
      break;
    case QUOTED_IDENTIFIER:
      tok = jj_consume_token(QUOTED_IDENTIFIER);
                                  if (strict) {if (true) throw generateParseException();}
                                  id = tok.image.substring(1, tok.image.length()-1);
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    Selector ans = new Identifier(id);
    {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// SelectExpr ::= "[" BooleanExpr "]"
  final public Selector SelectExpr() throws ParseException {
                          Selector ans;
    jj_consume_token(15);
    ans = BooleanExpr();
    jj_consume_token(16);
    {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// Index ::= "[" <INTEGER_LITERAL> "]"
  final public Selector Index() throws ParseException {
                     Token tok;
    jj_consume_token(15);
    tok = jj_consume_token(INTEGER_LITERAL);
    jj_consume_token(16);
    {if (true) return ParseUtil.parseIntegerLiteral(tok.image);}
    throw new Error("Missing return statement in function");
  }

// EmptyPredicate ::= FieldRef ( SelectExpr )? <IS> ( <NOT> )? <EMPTY>
  final public Selector EmptyPredicate() throws ParseException {
                              Selector ans, select = null; boolean not=false;
    if (strict) {if (true) throw generateParseException();}
    ans = FieldRef();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 15:
      select = SelectExpr();
      break;
    default:
      jj_la1[22] = jj_gen;
      ;
    }
    jj_consume_token(IS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                                                                not = true;
      break;
    default:
      jj_la1[23] = jj_gen;
      ;
    }
    jj_consume_token(EMPTY);
    if (select != null)
      ans = new Operator(Operator.SELECT, ans, select);
    ans = new Operator(Operator.ISEMPTY, ans);
    if (not) {if (true) return new Operator(Operator.NOT, ans);}
    else {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_1();
    jj_save(0, xla);
    return retval;
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_2();
    jj_save(1, xla);
    return retval;
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_3();
    jj_save(2, xla);
    return retval;
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_4();
    jj_save(3, xla);
    return retval;
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_5();
    jj_save(4, xla);
    return retval;
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_6();
    jj_save(5, xla);
    return retval;
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_7();
    jj_save(6, xla);
    return retval;
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_8();
    jj_save(7, xla);
    return retval;
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_9();
    jj_save(8, xla);
    return retval;
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_10();
    jj_save(9, xla);
    return retval;
  }

  final private boolean jj_3R_36() {
    if (jj_scan_token(5)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_3R_13()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_40() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_35() {
    if (jj_scan_token(4)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_34() {
    if (jj_scan_token(3)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_23() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_33() {
    if (jj_scan_token(2)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_15() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_scan_token(1)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_44()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_20() {
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_3R_11()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_3R_10()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_28() {
    if (jj_3R_13()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_3R_9()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_8()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_4() {
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_15()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_7()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_12() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_28()) {
    jj_scanpos = xsp;
    if (jj_3R_29()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_6()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_5()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_3R_12()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(14)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_78() {
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_4()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_77() {
    if (jj_3R_11()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_76() {
    if (jj_3R_10()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_75() {
    if (jj_3R_9()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_3R_8()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_3R_7()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_19() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_3R_6()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_71() {
    if (jj_3R_5()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_38() {
    if (jj_3R_12()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(14)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_3R_4()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_69() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_scan_token(AND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_54()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_18() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_16() {
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_38()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_55() {
    if (jj_scan_token(OR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_48()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_7() {
    if (jj_3R_16()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_19()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LIKE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_20()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_68() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_59() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_68()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_69()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_6() {
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_18()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(AND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_3R_59()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_60()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_scan_token(13)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_3R_54()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_55()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_scan_token(11)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_42()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_scan_token(12)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_scan_token(13)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_27() {
    if (jj_scan_token(11)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_43()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_scan_token(12)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_17() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_11() {
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_26()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(IN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_27()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_10() {
    if (jj_3R_16()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_24()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(IN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_25()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_5() {
    if (jj_3R_16()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(IS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_17()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NULL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_22() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_3R_16()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_65() {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_64() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_63() {
    if (jj_scan_token(11)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_48()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(12)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_scan_token(FALSE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_scan_token(TRUE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_56() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_3R_51()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_30()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_3R_47()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_45()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_49() {
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_21() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_45() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_scan_token(10)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_51() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_scan_token(9)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_3R_47()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_30() {
    if (jj_3R_45()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_46()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_8() {
    if (jj_3R_16()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_21()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(IS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_22()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(EMPTY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_scan_token(8)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_47() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_scan_token(7)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_13() {
    if (jj_scan_token(15)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(16)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_3R_13()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_14() {
    if (jj_3R_30()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_31()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_scan_token(15)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_48()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(16)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_41() {
    if (jj_scan_token(QUOTED_IDENTIFIER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_9() {
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ISA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_37() {
    if (jj_scan_token(6)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  public MatchParserTokenManager token_source;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[24];
  final private int[] jj_la1_0 = {0x8000000,0x10000000,0x20000000,0x80000980,0x7e,0x180,0x180,0x600,0x600,0x80000980,0x80000800,0x20000000,0x20000000,0x20000000,0x2000,0x2000,0x20000000,0x20000000,0x4000000,0x8000,0x8000,0x0,0x8000,0x20000000,};
  final private int[] jj_la1_1 = {0x0,0x0,0x0,0xb19,0x0,0x0,0x0,0x0,0x0,0xb19,0xb19,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18,0x0,0x0,};
  final private JJCalls[] jj_2_rtns = new JJCalls[10];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public MatchParser(CharStream stream) {
    token_source = new MatchParserTokenManager(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 24; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 24; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public MatchParser(MatchParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 24; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(MatchParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 24; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    return (jj_scanpos.kind != kind);
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration enum = jj_expentries.elements(); enum.hasMoreElements();) {
        int[] oldentry = (int[])(enum.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[44];
    for (int i = 0; i < 44; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 24; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 44; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 10; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
  private final static String copyright = "Licensed Material - Property of IBM \n5648-C63 (c) Copyright IBM Corp. 2006 - All Rights Reserved. \nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
