/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.interbase;

import javax.sql.DataSource;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.interbase.InterbaseDdlBuilder;
import org.jumpmind.db.platform.interbase.InterbaseDdlReader;
import org.jumpmind.db.platform.interbase.InterbaseJdbcSqlTemplate;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class InterbaseDatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "interbase.interclient.Driver";
    public static final String JDBC_SUBPROTOCOL = "interbase";

    public InterbaseDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
    }

    protected InterbaseDdlBuilder createDdlBuilder() {
        return new InterbaseDdlBuilder();
    }

    @Override
    protected InterbaseDdlReader createDdlReader() {
        return new InterbaseDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected InterbaseJdbcSqlTemplate createSqlTemplate() {
        return new InterbaseJdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
    }

    public String getName() {
        return JDBC_SUBPROTOCOL;
    }

    public String getDefaultCatalog() {
        return null;
    }

    public String getDefaultSchema() {
        return null;
    }

    @Override
    protected ISqlTemplate createSqlTemplateDirty() {
        return this.sqlTemplate;
    }

    public PermissionResult getDropSymTriggerPermission() {
        PermissionResult result = new PermissionResult(PermissionType.DROP_TRIGGER, "UNIMPLEMENTED");
        result.setStatus(PermissionResult.Status.UNIMPLEMENTED);
        return result;
    }

    public String getTruncateSql(Table table) {
        Object sql = super.getTruncateSql(table);
        sql = (String)sql + " cascade";
        return sql;
    }

    public String getDeleteSql(Table table) {
        Object sql = super.getDeleteSql(table);
        sql = (String)sql + " cascade";
        return sql;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String massageForLimitOffset(String sql, int limit, int offset) {
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql + " rows " + (offset + 1) + " to " + (offset + limit);
    }

    public boolean supportsParametersInSelect() {
        return false;
    }
}

