/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.ingres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.ingres.IngresDatabasePlatform;
import org.jumpmind.db.sql.IConnectionCallback;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.JdbcSqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;

public class IngresDdlReader
extends AbstractJdbcDdlReader {
    public IngresDdlReader(IDatabasePlatform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.setDefaultTablePattern(null);
        this.setDefaultColumnPattern(null);
    }

    @Override
    protected Integer mapUnknownJdbcTypeForColumn(Map<String, Object> values) {
        String typeName = (String)values.get("TYPE_NAME");
        if (typeName != null && typeName.equalsIgnoreCase("INTEGER1")) {
            return -6;
        }
        if (typeName != null && typeName.equalsIgnoreCase("INTEGER2")) {
            return 5;
        }
        if (typeName != null && typeName.equalsIgnoreCase("INTEGER4")) {
            return 4;
        }
        if (typeName != null && typeName.equalsIgnoreCase("INTEGER8")) {
            return -5;
        }
        if (typeName != null && typeName.equalsIgnoreCase("LONG VARCHAR")) {
            return -1;
        }
        if (typeName != null && typeName.equalsIgnoreCase("LONG NVARCHAR")) {
            return -16;
        }
        if (typeName != null && typeName.equalsIgnoreCase("TEXT")) {
            return 12;
        }
        if (typeName != null && typeName.equalsIgnoreCase("LONG BYTE")) {
            return -4;
        }
        return super.mapUnknownJdbcTypeForColumn(values);
    }

    @Override
    public Database readTables(final String catalog, final String schema, final String[] tableTypes) {
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
        Database database = null;
        try (ISqlTransaction transaction = sqlTemplate.startSqlTransaction();){
            database = this.postprocessModelFromDatabase(((JdbcSqlTransaction)transaction).executeCallback(new IConnectionCallback<Database>(){

                @Override
                public Database execute(Connection connection) throws SQLException {
                    Database db = new Database();
                    db.setName(Table.getFullyQualifiedTablePrefix((String)catalog, (String)schema));
                    db.setCatalog(catalog);
                    db.setSchema(schema);
                    db.addTables(IngresDdlReader.this.readTables(connection, catalog, schema, tableTypes));
                    db.initialize();
                    return db;
                }
            }));
            transaction.commit();
        }
        return database;
    }

    @Override
    public Table readTable(final String catalog, final String schema, final String table) {
        Table tableObject = null;
        try {
            this.log.debug("reading table: " + table);
            JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
            try (ISqlTransaction transaction = sqlTemplate.startSqlTransaction();){
                tableObject = this.postprocessTableFromDatabase(((JdbcSqlTransaction)transaction).executeCallback(new IConnectionCallback<Table>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Table execute(Connection connection) throws SQLException {
                        ResultSet tableData;
                        block5: {
                            DatabaseMetaDataWrapper metaData;
                            block4: {
                                Table table2;
                                metaData = new DatabaseMetaDataWrapper();
                                metaData.setMetaData(connection.getMetaData());
                                metaData.setCatalog(catalog);
                                metaData.setSchemaPattern(schema);
                                metaData.setTableTypes(null);
                                tableData = null;
                                try {
                                    IngresDdlReader.this.log.debug("getting table metadata for {}", (Object)table);
                                    tableData = metaData.getTables(IngresDdlReader.this.getTableNamePattern(StringUtils.lowerCase((String)table)));
                                    IngresDdlReader.this.log.debug("done getting table metadata for {}", (Object)table);
                                    if (tableData == null || !tableData.next()) break block4;
                                    Map values = IngresDdlReader.this.readMetaData(tableData, IngresDdlReader.this.initColumnsForTable());
                                    table2 = IngresDdlReader.this.readTable(connection, metaData, values);
                                }
                                catch (Throwable throwable) {
                                    IngresDdlReader.this.close(tableData);
                                    throw throwable;
                                }
                                IngresDdlReader.this.close(tableData);
                                return table2;
                            }
                            IngresDdlReader.this.close(tableData);
                            tableData = metaData.getTables(IngresDdlReader.this.getTableNamePattern(StringUtils.upperCase((String)table)));
                            if (tableData == null || !tableData.next()) break block5;
                            Map values = IngresDdlReader.this.readMetaData(tableData, IngresDdlReader.this.initColumnsForTable());
                            Table table3 = IngresDdlReader.this.readTable(connection, metaData, values);
                            IngresDdlReader.this.close(tableData);
                            return table3;
                        }
                        IngresDdlReader.this.log.debug("table {} not found", (Object)table);
                        Table table4 = null;
                        IngresDdlReader.this.close(tableData);
                        return table4;
                    }
                }));
            }
        }
        catch (SqlException e) {
            if (e.getMessage() != null && Strings.CI.contains((CharSequence)e.getMessage(), (CharSequence)"does not exist")) {
                return null;
            }
            this.log.error("Failed to get metadata for {}", (Object)Table.getFullyQualifiedTableName((String)catalog, (String)schema, (String)table));
            throw e;
        }
        return tableObject;
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Table table = super.readTable(connection, metaData, values);
        String schema = table.getSchema();
        boolean setTableOwner = schema != null && schema.length() > 0;
        StringBuilder sql = new StringBuilder("select column_name,  column_always_ident, column_bydefault_ident, column_default_val ").append("from iicolumns ").append("where table_name=? ").append(schema != null && schema.length() > 0 ? " and table_owner=? " : "");
        Object[] args = new Object[]{table.getName()};
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.prepareStatement(sql.toString());
            ps.setString(1, table.getName());
            if (setTableOwner) {
                ps.setString(2, schema);
            }
            ps.setQueryTimeout(((IngresDatabasePlatform)this.platform).getSettings().getQueryTimeout());
            rs = ps.executeQuery();
            this.processAdditionalColumnInformation(table, rs);
        }
        catch (SQLException e) {
            try {
                this.log.error(sql.toString(), (Object)args, (Object)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(ps);
                throw throwable;
            }
        }
        this.close(rs);
        this.close(ps);
        return table;
    }

    @Override
    protected void readIndex(DatabaseMetaDataWrapper metaData, Map<String, Object> values, Map<String, IIndex> knownIndices) throws SQLException {
        super.readIndex(metaData, values, knownIndices);
        StringBuilder sql = new StringBuilder("select count(*) from iiindexes ").append("where index_name=? ").append("and index_owner=? and system_use=? ");
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        Object[] args = new Object[]{values.get("INDEX_NAME"), values.get("index_qualifier"), "G"};
        int count = sqlTemplate.queryForInt(sql.toString(), args);
        if (count > 0) {
            knownIndices.remove(values.get("INDEX_NAME"));
        }
    }

    private void processAdditionalColumnInformation(Table table, ResultSet rs) throws SQLException {
        block0: while (rs.next()) {
            String columnName = StringUtils.trim((String)rs.getString("COLUMN_NAME"));
            String columnAlwaysIdent = StringUtils.trim((String)rs.getString("COLUMN_ALWAYS_IDENT"));
            String columnBydefaultIdent = StringUtils.trim((String)rs.getString("COLUMN_BYDEFAULT_IDENT"));
            String columnDefaultVal = StringUtils.trim((String)rs.getString("COLUMN_DEFAULT_VAL"));
            for (Column column : table.getColumnsAsList()) {
                if (!column.getName().equalsIgnoreCase(columnName)) continue;
                if (columnAlwaysIdent != null && columnAlwaysIdent.equalsIgnoreCase("Y") || columnBydefaultIdent != null && columnBydefaultIdent.equalsIgnoreCase("Y")) {
                    column.setAutoIncrement(true);
                    continue block0;
                }
                if (columnDefaultVal == null) continue block0;
                column.setDefaultValue(columnDefaultVal);
                continue block0;
            }
        }
    }

    @Override
    protected void readForeignKeyUpdateRule(Map<String, Object> values, ForeignKey fk) {
        int i;
        StringBuilder result = new StringBuilder();
        this.getForeignKeyRule(values, result);
        String findInString = " ON UPDATE ";
        if (result.length() > 0 && (i = result.indexOf(" ON UPDATE ")) > -1) {
            this.setForeignKeyAction(result.substring(i += findInString.length()).trim().toUpperCase(), fk, true);
        }
    }

    @Override
    protected void readForeignKeyDeleteRule(Map<String, Object> values, ForeignKey fk) {
        StringBuilder result = new StringBuilder();
        this.getForeignKeyRule(values, result);
        String findInString = " ON DELETE ";
        int i = result.indexOf(" ON DELETE ");
        if (i > -1) {
            this.setForeignKeyAction(result.substring(i += findInString.length()).trim().toUpperCase(), fk, true);
        }
    }

    private void getForeignKeyRule(Map<String, Object> values, StringBuilder result) {
        StringBuilder sql = new StringBuilder("select text_segment from iiconstraints ").append("where constraint_type='R' and constraint_name=? ").append("and schema_name=? and table_name=? ").append("order by text_sequence");
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        Object[] args = new Object[]{values.get("FK_NAME"), values.get("PKTABLE_SCHEM"), values.get("PKTABLE_NAME")};
        List rows = sqlTemplate.query(sql.toString(), args);
        for (Row row : rows) {
            result.append(row.getString("TEXT_SEGMENT"));
        }
    }

    private void setForeignKeyAction(String s, ForeignKey fk, boolean onUpdate) {
        if (s.startsWith(ForeignKey.ForeignKeyAction.CASCADE.getForeignKeyActionName())) {
            if (onUpdate) {
                fk.setOnUpdateAction(ForeignKey.ForeignKeyAction.CASCADE);
            } else {
                fk.setOnDeleteAction(ForeignKey.ForeignKeyAction.CASCADE);
            }
        } else if (s.startsWith(ForeignKey.ForeignKeyAction.RESTRICT.getForeignKeyActionName())) {
            if (onUpdate) {
                fk.setOnUpdateAction(ForeignKey.ForeignKeyAction.RESTRICT);
            } else {
                fk.setOnDeleteAction(ForeignKey.ForeignKeyAction.RESTRICT);
            }
        } else if (s.startsWith(ForeignKey.ForeignKeyAction.SETNULL.getForeignKeyActionName())) {
            if (onUpdate) {
                fk.setOnUpdateAction(ForeignKey.ForeignKeyAction.SETNULL);
            } else {
                fk.setOnDeleteAction(ForeignKey.ForeignKeyAction.SETNULL);
            }
        } else if (s.startsWith(ForeignKey.ForeignKeyAction.SETDEFAULT.getForeignKeyActionName())) {
            if (onUpdate) {
                fk.setOnUpdateAction(ForeignKey.ForeignKeyAction.SETDEFAULT);
            } else {
                fk.setOnDeleteAction(ForeignKey.ForeignKeyAction.SETDEFAULT);
            }
        } else if (s.startsWith(ForeignKey.ForeignKeyAction.NOACTION.getForeignKeyActionName())) {
            if (onUpdate) {
                fk.setOnUpdateAction(ForeignKey.ForeignKeyAction.NOACTION);
            } else {
                fk.setOnDeleteAction(ForeignKey.ForeignKeyAction.NOACTION);
            }
        } else if (onUpdate) {
            fk.setOnUpdateAction(ForeignKey.ForeignKeyAction.NOACTION);
        } else {
            fk.setOnDeleteAction(ForeignKey.ForeignKeyAction.NOACTION);
        }
    }
}

