/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.hsqldb2;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;

public class HsqlDb2DdlReader
extends AbstractJdbcDdlReader {
    public HsqlDb2DdlReader(IDatabasePlatform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        String autoIncrement;
        Column column = super.readColumn(metaData, values);
        if (column.isGenerated() && column.getDefaultValue() == null) {
            JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
            String sql = "SELECT generation_expression\nFROM information_schema.columns\nWHERE table_name = ?\nAND column_name = ?\n";
            ArrayList<String> l = new ArrayList<String>();
            String schemaName = (String)values.get("TABLE_SCHEM");
            String tableName = (String)values.get("TABLE_NAME");
            l.add(tableName);
            l.add(column.getName());
            String definition = sqlTemplate.queryForString(sql, l.toArray());
            definition = definition.replace(schemaName + "." + tableName + ".", "");
            column.setDefaultValue(definition);
        }
        if (TypeMap.isTextType((int)column.getMappedTypeCode()) && column.getDefaultValue() != null) {
            column.setDefaultValue(this.unescape(column.getDefaultValue(), "'", "''"));
        }
        if ((autoIncrement = (String)values.get("IS_AUTOINCREMENT")) != null) {
            column.setAutoIncrement("YES".equalsIgnoreCase(autoIncrement.trim()));
        }
        if (column.getMappedTypeCode() == 93) {
            this.adjustColumnSize(column, -20, 3);
        }
        if (column.getMappedTypeCode() == 92) {
            this.adjustColumnSize(column, -9, 3);
        }
        if (column.getMappedTypeCode() == 91) {
            this.removeColumnSize(column);
        }
        return column;
    }

    @Override
    protected boolean isInternalForeignKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, ForeignKey fk, IIndex index) {
        String name = index.getName();
        return name != null && name.startsWith("SYS_IDX_");
    }

    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) {
        String name = index.getName();
        return name != null && (name.startsWith("SYS_PK_") || name.startsWith("SYS_IDX_"));
    }

    @Override
    protected Integer mapUnknownJdbcTypeForColumn(Map<String, Object> values) {
        String typeName = (String)values.get("TYPE_NAME");
        String size = (String)values.get("COLUMN_SIZE");
        if (typeName != null && typeName.startsWith("VARCHAR") && StringUtils.isNotBlank((CharSequence)size)) {
            long sizeAsNumber = Long.parseLong(size);
            if (sizeAsNumber >= 0x1000000L) {
                return -1;
            }
            return super.mapUnknownJdbcTypeForColumn(values);
        }
        return super.mapUnknownJdbcTypeForColumn(values);
    }

    @Override
    public List<Trigger> getTriggers(String catalog, String schema, String tableName) throws SqlException {
        ArrayList<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "SELECT * FROM INFORMATION_SCHEMA.TRIGGERS WHERE TABLE_NAME=? and TRIGGER_SCHEMA=? and TRIGGER_CATALOG=? ;";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger mapRow(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("TRIGGER_NAME"));
                trigger.setCatalogName(row.getString("TRIGGER_CATALOG"));
                trigger.setSchemaName(row.getString("TRIGGER_SCHEMA"));
                trigger.setTableName(row.getString("TABLE_NAME"));
                trigger.setEnabled(true);
                trigger.setSource(row.getString("SQL"));
                row.remove((Object)"SQL");
                String triggerType = row.getString("TRIGGER_TYPE");
                if (triggerType.equals("DELETE") || triggerType.equals("INSERT") || triggerType.equals("UPDATE")) {
                    trigger.setTriggerType(Trigger.TriggerType.valueOf((String)triggerType));
                }
                trigger.setMetaData((Map)row);
                return trigger;
            }
        }, new Object[]{tableName, schema, catalog});
        return triggers;
    }
}

