/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.hana;

import javax.sql.DataSource;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.platform.IDdlReader;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.hana.HanaDdlBuilder;
import org.jumpmind.db.platform.hana.HanaDdlReader;
import org.jumpmind.db.platform.hana.HanaSqlJdbcSqlTemplate;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class HanaDatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "com.sap.db.jdbc.Driver";
    public static final String JDBC_SUBPROTOCOL = "sap";

    public HanaDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
    }

    @Override
    public ISqlTemplate getSqlTemplate() {
        return new HanaSqlJdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
    }

    public String getName() {
        return "hdb";
    }

    public String getDefaultSchema() {
        return null;
    }

    public String getDefaultCatalog() {
        return null;
    }

    @Override
    protected IDdlBuilder createDdlBuilder() {
        return new HanaDdlBuilder();
    }

    @Override
    protected IDdlReader createDdlReader() {
        return new HanaDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected ISqlTemplate createSqlTemplateDirty() {
        JdbcSqlTemplate template = (JdbcSqlTemplate)super.createSqlTemplateDirty();
        template.setIsolationLevel(2);
        return template;
    }

    protected PermissionResult getCreateSymTriggerPermission() {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        String triggerSql = "CREATE TRIGGER TEST_TRIGGER AFTER UPDATE ON " + delimiter + "SYM_PERMISSION_TEST" + delimiter + " BEGIN DECLARE PERMISSION_COUNT INT;      SELECT COUNT(*) INTO PERMISSION_COUNT FROM SYM_PERMISSION_TEST; END";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, triggerSql);
        try {
            this.getSqlTemplate().update(triggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE TRIGGER permission or TRIGGER permission");
        }
        return result;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String massageForLimitOffset(String sql, int limit, int offset) {
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql + " limit " + limit + " offset " + offset;
    }

    public boolean canColumnBeUsedInWhereClause(Column column) {
        return super.canColumnBeUsedInWhereClause(column) && !this.isLob(column);
    }
}

