/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.firebird;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.platform.firebird.FirebirdDdlBuilder;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;

public class FirebirdDdlReader
extends AbstractJdbcDdlReader {
    protected boolean isLegacyJaybird;

    public FirebirdDdlReader(IDatabasePlatform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.setDefaultTablePattern("%");
        String classpath = System.getProperty("java.class.path");
        this.isLegacyJaybird = classpath.contains("jaybird-2.1");
        if (this.isLegacyJaybird) {
            this.log.info("Detected older Jaybird driver");
        }
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Table table = super.readTable(connection, metaData, values);
        if (table != null) {
            this.determineAutoIncrementColumns(connection, table);
            this.setPrimaryKeyConstraintName(connection, table);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPrimaryKeyConstraintName(Connection connection, Table table) throws SQLException {
        String sql = "select RDB$CONSTRAINT_NAME from RDB$RELATION_CONSTRAINTS where RDB$RELATION_NAME=? and RDB$CONSTRAINT_TYPE='PRIMARY KEY'";
        PreparedStatement pstmt = null;
        try {
            pstmt = connection.prepareStatement(sql);
            pstmt.setString(1, table.getName());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                table.setPrimaryKeyConstraintName(rs.getString(1).trim());
            }
            rs.close();
        }
        finally {
            JdbcSqlTemplate.close(pstmt);
        }
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        if (column.isGenerated() && column.getDefaultValue() == null) {
            JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
            String sql = "SELECT rdb$computed_source\nFROM rdb$fields f JOIN rdb$relation_fields rf\nON f.rdb$field_name = rf.rdb$field_source\nWHERE rf.rdb$relation_name = ?\nAND rf.rdb$field_name = ?";
            ArrayList<String> l = new ArrayList<String>();
            l.add((String)values.get("TABLE_NAME"));
            l.add(column.getName());
            String definition = sqlTemplate.queryForString(sql, l.toArray());
            column.setDefaultValue(definition);
        }
        if (column.getMappedTypeCode() == 6) {
            column.setMappedTypeCode(7);
        } else if (TypeMap.isTextType((int)column.getMappedTypeCode())) {
            column.setDefaultValue(this.unescape(column.getDefaultValue(), "'", "''"));
        }
        if (column.getJdbcTypeCode() == 93) {
            this.resetColumnSize(column, "3");
            this.removePlatformColumnSize(column);
        } else if (column.getJdbcTypeCode() == 92) {
            this.resetColumnSize(column, "0");
            this.removePlatformColumnSize(column);
        } else if (column.getJdbcTypeCode() == 91) {
            this.removeColumnSize(column);
        }
        return column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void determineAutoIncrementColumns(Connection connection, Table table) throws SQLException {
        Column[] columns = table.getColumns();
        HashMap<String, Column> names = new HashMap<String, Column>();
        for (int idx = 0; idx < columns.length; ++idx) {
            String name = ((FirebirdDdlBuilder)this.getPlatform().getDdlBuilder()).getTriggerName(table, columns[idx]);
            if (!this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn()) {
                name = name.toUpperCase();
            }
            names.put(name, columns[idx]);
        }
        PreparedStatement stmt = connection.prepareStatement("SELECT RDB$TRIGGER_NAME FROM RDB$TRIGGERS WHERE RDB$RELATION_NAME=?");
        stmt.setString(1, table.getName());
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery();
            while (rs.next()) {
                String triggerName = rs.getString(1).trim();
                Column column = (Column)names.get(triggerName);
                if (column == null) continue;
                column.setAutoIncrement(true);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<IIndex> readIndices(Connection connection, DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        ListOrderedMap indices = new ListOrderedMap();
        StringBuilder query = new StringBuilder();
        query.append("SELECT a.RDB$INDEX_NAME INDEX_NAME, b.RDB$RELATION_NAME TABLE_NAME, b.RDB$UNIQUE_FLAG NON_UNIQUE,");
        query.append(" a.RDB$FIELD_POSITION ORDINAL_POSITION, a.RDB$FIELD_NAME COLUMN_NAME, 3 INDEX_TYPE");
        query.append(" FROM RDB$INDEX_SEGMENTS a, RDB$INDICES b WHERE a.RDB$INDEX_NAME=b.RDB$INDEX_NAME AND b.RDB$RELATION_NAME = ?");
        PreparedStatement stmt = connection.prepareStatement(query.toString());
        stmt.setString(1, this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() ? tableName : tableName.toUpperCase());
        try (ResultSet indexData = null;){
            indexData = stmt.executeQuery();
            while (indexData.next()) {
                Map<String, Object> values;
                values.put("NON_UNIQUE", Boolean.FALSE.equals((values = this.readMetaData(indexData, this.getColumnsForIndex())).get("NON_UNIQUE")) ? Boolean.TRUE : Boolean.FALSE);
                values.put("INDEX_NAME", ((String)values.get("INDEX_NAME")).trim());
                values.put("TABLE_NAME", ((String)values.get("TABLE_NAME")).trim());
                values.put("COLUMN_NAME", ((String)values.get("COLUMN_NAME")).trim());
                this.readIndex(metaData, values, (Map<String, IIndex>)indices);
            }
        }
        return indices.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) throws SQLException {
        IDdlBuilder builder = this.getPlatform().getDdlBuilder();
        String tableName = builder.getTableName(table.getName());
        String indexName = builder.getIndexName(index);
        StringBuilder query = new StringBuilder();
        query.append("SELECT RDB$CONSTRAINT_NAME FROM RDB$RELATION_CONSTRAINTS where RDB$RELATION_NAME=? AND RDB$CONSTRAINT_TYPE=? AND RDB$INDEX_NAME=?");
        try (PreparedStatement stmt = connection.prepareStatement(query.toString());){
            stmt.setString(1, this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() ? tableName : tableName.toUpperCase());
            stmt.setString(2, "PRIMARY KEY");
            stmt.setString(3, indexName);
            ResultSet resultSet = stmt.executeQuery();
            boolean bl = resultSet.next();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isInternalForeignKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, ForeignKey fk, IIndex index) throws SQLException {
        IDdlBuilder builder = this.getPlatform().getDdlBuilder();
        String tableName = builder.getTableName(table.getName());
        String indexName = builder.getIndexName(index);
        String fkName = builder.getForeignKeyName(table, fk);
        StringBuilder query = new StringBuilder();
        query.append("SELECT RDB$CONSTRAINT_NAME FROM RDB$RELATION_CONSTRAINTS where RDB$RELATION_NAME=? AND RDB$CONSTRAINT_TYPE=? AND RDB$CONSTRAINT_NAME=? AND RDB$INDEX_NAME=?");
        try (PreparedStatement stmt = connection.prepareStatement(query.toString());){
            stmt.setString(1, this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() ? tableName : tableName.toUpperCase());
            stmt.setString(2, "FOREIGN KEY");
            stmt.setString(3, fkName);
            stmt.setString(4, indexName);
            ResultSet resultSet = stmt.executeQuery();
            boolean bl = resultSet.next();
            return bl;
        }
    }

    @Override
    protected String getTableNamePattern(String tableName) {
        if (this.isLegacyJaybird) {
            return String.format("\"%s\"", tableName).replaceAll("\\_", "\\\\_");
        }
        return String.format("%s", tableName).replaceAll("\\_", "\\\\_");
    }

    @Override
    protected String getTableNamePatternForConstraints(String tableName) {
        if (this.isLegacyJaybird) {
            return String.format("\"%s\"", tableName).replaceAll("\\_", "\\\\_");
        }
        return super.getTableNamePatternForConstraints(tableName);
    }

    @Override
    public List<Trigger> getTriggers(String catalog, String schema, String tableName) throws SqlException {
        ArrayList<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "select TRIG.RDB$TRIGGER_NAME as TRIGGER_NAME, TRIG.RDB$RELATION_NAME as TABLE_NAME, TYPES1.RDB$TYPE_NAME as TRIGGER_TYPE, TRIG.RDB$TRIGGER_SEQUENCE as TRIGGER_SEQUENCE, TRIG.RDB$TRIGGER_BLR as TRIGGER_BLR, TRIG.RDB$DESCRIPTION as DESCRIPTION, TRIG.RDB$TRIGGER_INACTIVE as TRIGGER_INACTIVE, TYPES2.RDB$TYPE_NAME as SYSTEM_FLAG, TRIG.RDB$FLAGS as FLAGS, TRIG.RDB$VALID_BLR as VALID_BLR, TRIG.RDB$DEBUG_INFO as DEBUG_INFO,TRIG.RDB$TRIGGER_SOURCE as TRIGGER_SOURCE from RDB$TRIGGERS as TRIG inner join RDB$TYPES as TYPES1 on TYPES1.RDB$FIELD_NAME = 'RDB$TRIGGER_TYPE' and TYPES1.RDB$TYPE = TRIG.RDB$TRIGGER_TYPE inner join RDB$TYPES as TYPES2 on TYPES2.RDB$FIELD_NAME = 'RDB$SYSTEM_FLAG' and TYPES2.RDB$TYPE = TRIG.RDB$SYSTEM_FLAG where RDB$RELATION_NAME = ? ;";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger mapRow(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("TRIGGER_NAME"));
                trigger.setTableName(row.getString("TABLE_NAME"));
                trigger.setEnabled(true);
                trigger.setSource(row.getString("TRIGGER_SOURCE"));
                row.remove((Object)"TRIGGER_SOURCE");
                String triggerType = row.getString("TRIGGER_TYPE");
                if (triggerType.contains("STORE")) {
                    trigger.setTriggerType(Trigger.TriggerType.INSERT);
                } else if (triggerType.contains("ERASE")) {
                    trigger.setTriggerType(Trigger.TriggerType.DELETE);
                } else if (triggerType.contains("MODIFY")) {
                    trigger.setTriggerType(Trigger.TriggerType.UPDATE);
                }
                trigger.setMetaData((Map)row);
                return trigger;
            }
        }, new Object[]{tableName});
        return triggers;
    }
}

