/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.ase;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.ase.AseDdlBuilder;
import org.jumpmind.db.platform.ase.AseDdlReader;
import org.jumpmind.db.platform.ase.AseJdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.util.BinaryEncoding;

public class AseDatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "com.sybase.jdbc4.jdbc.SybDriver";
    public static final String JDBC_DRIVER_OLD = "com.sybase.jdbc4.jdbc.SybDriver";
    public static final String JDBC_SUBPROTOCOL = "sybase:Tds";
    public static final long MAX_TEXT_SIZE = Integer.MAX_VALUE;
    private Map<String, String> sqlScriptReplacementTokens = super.getSqlScriptReplacementTokens();
    private boolean usingJtds;

    public AseDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
        if (this.sqlScriptReplacementTokens == null) {
            this.sqlScriptReplacementTokens = new HashMap<String, String>();
        }
        this.sqlScriptReplacementTokens.put("current_timestamp", "getdate()");
        this.useMultiThreadSyncTriggers = false;
        if (this.getSqlTemplate().getDatabaseMajorVersion() <= 12) {
            this.ddlBuilder.getDatabaseInfo().setMaxIdentifierLength(30);
        }
    }

    protected AseDdlBuilder createDdlBuilder() {
        String dbUrl = this.settings.getProperties().get("db.url");
        this.usingJtds = dbUrl != null && dbUrl.startsWith("jdbc:jtds");
        AseDdlBuilder ddlBuilder = new AseDdlBuilder();
        ddlBuilder.setUsingJtds(this.usingJtds);
        return ddlBuilder;
    }

    @Override
    protected AseDdlReader createDdlReader() {
        return new AseDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected AseJdbcSqlTemplate createSqlTemplate() {
        return new AseJdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
    }

    public String getName() {
        return "ase";
    }

    public String getDefaultCatalog() {
        if (StringUtils.isBlank((CharSequence)this.defaultCatalog)) {
            this.defaultCatalog = (String)this.getSqlTemplate().queryForObject("select DB_NAME()", String.class, new Object[0]);
        }
        return this.defaultCatalog;
    }

    public String getDefaultSchema() {
        if (StringUtils.isBlank((CharSequence)this.defaultSchema)) {
            this.defaultSchema = (String)this.getSqlTemplate().queryForObject("select USER_NAME()", String.class, new Object[0]);
        }
        return this.defaultSchema;
    }

    public Map<String, String> getSqlScriptReplacementTokens() {
        return this.sqlScriptReplacementTokens;
    }

    public boolean canColumnBeUsedInWhereClause(Column column) {
        return !this.isLob(column) && super.canColumnBeUsedInWhereClause(column);
    }

    public PermissionResult getCreateSymTriggerPermission() {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        String triggerSql = "create trigger TEST_TRIGGER on " + delimiter + "SYM_PERMISSION_TEST" + delimiter + " for insert as begin select 1 end";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, triggerSql);
        try {
            this.getSqlTemplate().update(triggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE TRIGGER permission or TRIGGER permission");
        }
        return result;
    }

    protected Object getObjectValue(String value, Column column, BinaryEncoding encoding, boolean useVariableDates, boolean fitToColumn) throws DecoderException {
        Object objectValue = value;
        String typeName = column.getJdbcTypeName();
        if (typeName.equalsIgnoreCase("unichar") || typeName.equalsIgnoreCase("unitext") || typeName.equalsIgnoreCase("univarchar")) {
            String stringValue = this.cleanTextForTextBasedColumns((String)objectValue);
            int size = column.getSizeAsInt();
            if (this.settings.isRightTrimCharValues()) {
                stringValue = StringUtils.stripEnd((String)stringValue, null);
            }
            if (fitToColumn && size > 0 && stringValue != null && stringValue.length() > size) {
                stringValue = stringValue.substring(0, size);
            }
            objectValue = stringValue;
            if (stringValue != null && typeName.equalsIgnoreCase("unitext")) {
                objectValue = stringValue.getBytes(StandardCharsets.UTF_16LE);
            }
            return objectValue;
        }
        return super.getObjectValue(value, column, encoding, useVariableDates, fitToColumn);
    }

    public String getCsvStringValue(BinaryEncoding encoding, Column[] metaData, Row row, boolean[] isColumnPositionUsingTemplate) {
        StringBuilder concatenatedRow = new StringBuilder();
        Set names = row.keySet();
        int i = 0;
        for (String name : names) {
            Column column = metaData[i];
            int type = column.getJdbcTypeCode();
            if (i > 0) {
                concatenatedRow.append(",");
            }
            if (row.get((Object)name) != null) {
                if (column.getJdbcTypeName().equalsIgnoreCase("unitext")) {
                    concatenatedRow.append("\"").append(row.getString(name).replace("\\", "\\\\").replace("\"", "\\\"")).append("\"");
                } else if (isColumnPositionUsingTemplate[i]) {
                    concatenatedRow.append(row.getString(name));
                } else if (type == 16 || type == -7) {
                    concatenatedRow.append(row.getBoolean(name) ? "1" : "0");
                } else if (column.isOfNumericType()) {
                    concatenatedRow.append(row.getString(name));
                } else if (column.isTimestampWithTimezone()) {
                    this.appendString(concatenatedRow, this.getTimestampTzStringValue(name, type, row, false));
                } else if (type == 91 || type == 92) {
                    this.appendString(concatenatedRow, this.getDateTimeStringValue(name, type, row, false));
                } else if (type == 93) {
                    this.appendString(concatenatedRow, this.getTimestampStringValue(name, type, row, false));
                } else if (column.isOfBinaryType()) {
                    byte[] bytes = row.getBytes(name);
                    if (bytes.length == 0) {
                        concatenatedRow.append("\"\"");
                    } else if (encoding == BinaryEncoding.NONE) {
                        concatenatedRow.append(row.getString(name));
                    } else if (encoding == BinaryEncoding.BASE64) {
                        concatenatedRow.append(new String(Base64.encodeBase64((byte[])bytes), Charset.defaultCharset()));
                    } else if (encoding == BinaryEncoding.HEX) {
                        concatenatedRow.append(new String(Hex.encodeHex((byte[])bytes)));
                    }
                } else {
                    concatenatedRow.append("\"").append(row.getString(name).replace("\\", "\\\\").replace("\"", "\\\"")).append("\"");
                }
            }
            ++i;
        }
        return concatenatedRow.toString();
    }

    public String[] getStringValues(BinaryEncoding encoding, Column[] metaData, Row row, boolean useVariableDates, boolean indexByPosition) {
        String[] values = new String[metaData.length];
        Set keys = row.keySet();
        int i = 0;
        for (String key : keys) {
            Column column = metaData[i];
            String name = indexByPosition ? key : column.getName();
            int type = column.getJdbcTypeCode();
            if (row.get((Object)name) != null) {
                if (column.getJdbcTypeName().equalsIgnoreCase("unitext")) {
                    values[i] = row.getString(name);
                } else if (type == 16 || type == -7) {
                    values[i] = row.getBoolean(name) ? "1" : "0";
                } else if (column.isOfNumericType()) {
                    values[i] = row.getString(name);
                } else if (!(column.isTimestampWithTimezone() || type != 91 && type != 92)) {
                    values[i] = this.getDateTimeStringValue(name, type, row, useVariableDates);
                } else if (!column.isTimestampWithTimezone() && type == 93) {
                    values[i] = this.getTimestampStringValue(name, type, row, useVariableDates);
                } else if (column.isOfBinaryType()) {
                    byte[] bytes = row.getBytes(name);
                    if (encoding == BinaryEncoding.NONE) {
                        values[i] = row.getString(name);
                    } else if (encoding == BinaryEncoding.BASE64) {
                        values[i] = new String(Base64.encodeBase64((byte[])bytes), Charset.defaultCharset());
                    } else if (encoding == BinaryEncoding.HEX) {
                        values[i] = new String(Hex.encodeHex((byte[])bytes));
                    }
                } else {
                    values[i] = row.getString(name);
                }
            }
            ++i;
        }
        return values;
    }
}

