/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridMultiSelectionModel;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.grid.contextmenu.GridContextMenu;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.menubar.MenuBarVariant;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.data.selection.MultiSelectionEvent;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlReader;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.CustomSplitLayout;
import org.jumpmind.vaadin.ui.common.Label;
import org.jumpmind.vaadin.ui.common.TabSheet;
import org.jumpmind.vaadin.ui.sqlexplorer.DatabaseInfoPanel;
import org.jumpmind.vaadin.ui.sqlexplorer.DbExportDialog;
import org.jumpmind.vaadin.ui.sqlexplorer.DbFillDialog;
import org.jumpmind.vaadin.ui.sqlexplorer.DbImportDialog;
import org.jumpmind.vaadin.ui.sqlexplorer.DbTree;
import org.jumpmind.vaadin.ui.sqlexplorer.DbTreeNode;
import org.jumpmind.vaadin.ui.sqlexplorer.DefaultButtonBar;
import org.jumpmind.vaadin.ui.sqlexplorer.DefaultSettingsProvider;
import org.jumpmind.vaadin.ui.sqlexplorer.IContentTab;
import org.jumpmind.vaadin.ui.sqlexplorer.IDb;
import org.jumpmind.vaadin.ui.sqlexplorer.IDbMenuItem;
import org.jumpmind.vaadin.ui.sqlexplorer.IDbProvider;
import org.jumpmind.vaadin.ui.sqlexplorer.IInfoPanel;
import org.jumpmind.vaadin.ui.sqlexplorer.ISettingsProvider;
import org.jumpmind.vaadin.ui.sqlexplorer.QueryPanel;
import org.jumpmind.vaadin.ui.sqlexplorer.SettingsDialog;
import org.jumpmind.vaadin.ui.sqlexplorer.SqlExplorerTabPanel;
import org.jumpmind.vaadin.ui.sqlexplorer.TableInfoPanel;
import org.jumpmind.vaadin.ui.sqlexplorer.TriggerInfoPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CssImport(value="./sqlexplorer.css")
public class SqlExplorer
extends CustomSplitLayout {
    private static final long serialVersionUID = 1L;
    final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    static final VaadinIcon QUERY_ICON = VaadinIcon.FILE_O;
    static final double DEFAULT_SPLIT_POS = 20.0;
    IDbProvider databaseProvider;
    ISettingsProvider settingsProvider;
    MenuItem showButton;
    DbTree dbTree;
    SelectionListener<Grid<DbTreeNode>, DbTreeNode> listener;
    Registration listenerRegistration;
    SqlExplorerTabPanel contentTabs;
    MenuBar contentMenuBar;
    IContentTab selected;
    double savedSplitPosition = 20.0;
    String user = "nouser";
    IDbMenuItem[] additionalMenuItems;
    Set<IInfoPanel> infoTabs = new HashSet<IInfoPanel>();

    public SqlExplorer(String configDir, IDbProvider databaseProvider, ISettingsProvider settingsProvider, String user) {
        this(configDir, databaseProvider, settingsProvider, user, 20.0, new IDbMenuItem[0]);
    }

    public SqlExplorer(String configDir, IDbProvider databaseProvider, String user, IDbMenuItem ... additionalMenuItems) {
        this(configDir, databaseProvider, (ISettingsProvider)new DefaultSettingsProvider(configDir, user), user, 20.0, additionalMenuItems);
    }

    public SqlExplorer(String configDir, IDbProvider databaseProvider, ISettingsProvider settingsProvider, String user, IDbMenuItem ... additionalMenuItems) {
        this(configDir, databaseProvider, settingsProvider, user, 20.0, additionalMenuItems);
    }

    public SqlExplorer(String configDir, IDbProvider databaseProvider, String user, double leftSplitPos) {
        this(configDir, databaseProvider, (ISettingsProvider)new DefaultSettingsProvider(configDir, user), user, leftSplitPos, new IDbMenuItem[0]);
    }

    public SqlExplorer(String configDir, IDbProvider databaseProvider, ISettingsProvider settingsProvider, String user, double leftSplitSize, IDbMenuItem ... additionalMenuItems) {
        this.databaseProvider = databaseProvider;
        this.settingsProvider = settingsProvider;
        this.user = user;
        this.savedSplitPosition = leftSplitSize;
        this.additionalMenuItems = additionalMenuItems;
        this.setSizeFull();
        this.addClassName("sqlexplorer");
        VerticalLayout leftLayout = new VerticalLayout();
        leftLayout.setClassName("sqlexplorer-left");
        leftLayout.setMargin(false);
        leftLayout.setSpacing(false);
        leftLayout.setPadding(false);
        leftLayout.setSizeFull();
        leftLayout.add(new Component[]{this.buildLeftMenu()});
        Scroller scrollable = new Scroller();
        scrollable.setSizeFull();
        this.dbTree = this.buildDbTree();
        scrollable.setContent((Component)this.dbTree);
        leftLayout.addAndExpand(new Component[]{scrollable});
        VerticalLayout rightLayout = new VerticalLayout();
        rightLayout.setClassName("sqlexplorer-right");
        rightLayout.setMargin(false);
        rightLayout.setSpacing(false);
        rightLayout.setPadding(false);
        rightLayout.setSizeFull();
        HorizontalLayout rightMenuWrapper = new HorizontalLayout();
        rightMenuWrapper.setMargin(false);
        rightMenuWrapper.setSpacing(false);
        rightMenuWrapper.setPadding(false);
        rightMenuWrapper.setWidthFull();
        this.contentMenuBar = new MenuBar();
        this.contentMenuBar.addThemeVariants((ThemeVariant[])new MenuBarVariant[]{MenuBarVariant.LUMO_TERTIARY});
        this.contentMenuBar.setWidthFull();
        this.addShowButton(this.contentMenuBar);
        Span spacer = new Span();
        spacer.setWidth("0");
        spacer.setHeight("40px");
        rightMenuWrapper.add(new Component[]{this.contentMenuBar, spacer});
        rightLayout.add(new Component[]{rightMenuWrapper});
        this.contentTabs = new SqlExplorerTabPanel(this);
        this.contentTabs.addSelectedTabChangeListener((ComponentEventListener<Tabs.SelectedChangeEvent>)(ComponentEventListener & Serializable)event -> {
            if (event.getSelectedTab() != null) {
                this.selectContentTab((IContentTab)((TabSheet.EnhancedTab)event.getSelectedTab()).getComponent());
            }
        });
        rightLayout.addAndExpand(new Component[]{this.contentTabs});
        this.addToPrimary(new Component[]{leftLayout});
        this.addToSecondary(new Component[]{rightLayout});
        this.setSplitterPosition(this.savedSplitPosition);
    }

    protected MenuBar buildLeftMenu() {
        MenuBar leftMenu = new MenuBar();
        leftMenu.addThemeVariants((ThemeVariant[])new MenuBarVariant[]{MenuBarVariant.LUMO_TERTIARY});
        leftMenu.setWidthFull();
        MenuItem hideButton = leftMenu.addItem((Component)CommonUiUtils.createMenuBarIcon(VaadinIcon.MENU), (ComponentEventListener & Serializable)event -> {
            this.savedSplitPosition = this.getSplitterPosition() > 10.0 ? this.getSplitterPosition() : 20.0;
            this.setSplitterPosition(0.0);
            this.setPrimaryStyle("max-width", "0%");
            this.showButton.setVisible(true);
            this.resetContentMenuBar();
            if (this.selected instanceof QueryPanel) {
                ((DefaultButtonBar)((QueryPanel)this.selected).getButtonBar()).populate(this.contentMenuBar);
            }
        });
        hideButton.getElement().setAttribute("title", "Hide the database explorer");
        MenuItem refreshButton = leftMenu.addItem((Component)CommonUiUtils.createMenuBarIcon(VaadinIcon.REFRESH), (ComponentEventListener & Serializable)event -> {
            this.dbTree.refresh(true);
            TabSheet.EnhancedTab tab = this.contentTabs.getSelectedTab();
            if (tab instanceof QueryPanel && this.findQueryPanelForDb((IDb)((QueryPanel)((Object)((Object)((Object)tab)))).db).suggester != null) {
                this.findQueryPanelForDb((IDb)((QueryPanel)((Object)((Object)((Object)tab)))).db).suggester.clearCaches();
            }
        });
        refreshButton.getElement().setAttribute("title", "Refresh the database explorer");
        MenuItem selectionMode = leftMenu.addItem((Component)CommonUiUtils.createMenuBarIcon(VaadinIcon.GRID_BIG_O), (ComponentEventListener & Serializable)event -> {
            MenuItem source = (MenuItem)event.getSource();
            source.removeAll();
            if (this.dbTree.getSelectionModel() instanceof GridMultiSelectionModel) {
                this.dbTree.setSelectionMode(Grid.SelectionMode.SINGLE);
                source.add(new Component[]{new Icon(VaadinIcon.GRID_BIG_O)});
                source.getElement().setAttribute("title", "Switch to multi-select mode");
            } else {
                this.dbTree.setSelectionMode(Grid.SelectionMode.MULTI);
                source.add(new Component[]{new Icon(VaadinIcon.THIN_SQUARE)});
                source.getElement().setAttribute("title", "Switch to single-select mode");
            }
            this.listenerRegistration.remove();
            this.listenerRegistration = this.dbTree.addSelectionListener(this.listener);
            this.dbTree.refresh(true);
        });
        selectionMode.getElement().setAttribute("title", "Switch to multi-select mode");
        MenuItem openQueryTab = leftMenu.addItem((Component)CommonUiUtils.createMenuBarIcon(QUERY_ICON), (ComponentEventListener & Serializable)event -> this.openQueryWindow(this.dbTree.getSelectedItems()));
        openQueryTab.getElement().setAttribute("title", "Open a query tab");
        MenuItem settings = leftMenu.addItem((Component)CommonUiUtils.createMenuBarIcon(VaadinIcon.COG), (ComponentEventListener & Serializable)event -> {
            SettingsDialog dialog = new SettingsDialog(this);
            dialog.show();
        });
        settings.getElement().setAttribute("title", "Modify sql explorer settings");
        return leftMenu;
    }

    protected void addShowButton(MenuBar contentMenuBar) {
        boolean visible = this.showButton != null ? this.showButton.isVisible() : false;
        this.showButton = contentMenuBar.addItem((Component)new Icon(VaadinIcon.MENU), (ComponentEventListener & Serializable)event -> {
            this.setSplitterPosition(this.savedSplitPosition);
            this.setPrimaryStyle("max-width", "100%");
            this.showButton.setVisible(false);
        });
        this.showButton.getElement().setAttribute("title", "Show the database explorer");
        this.showButton.setVisible(visible);
    }

    protected void selectContentTab(IContentTab tab) {
        if (tab != null) {
            if (this.selected != null) {
                this.selected.unselected();
            }
            this.contentTabs.setSelectedTab((Component)tab);
            this.resetContentMenuBar();
            if (tab instanceof QueryPanel) {
                ((DefaultButtonBar)((QueryPanel)tab).getButtonBar()).populate(this.contentMenuBar);
            }
            tab.selected();
            this.selected = tab;
        }
    }

    public void resetContentMenuBar() {
        this.contentMenuBar.removeAll();
        this.addShowButton(this.contentMenuBar);
    }

    protected QueryPanel openQueryWindow(DbTreeNode node) {
        return this.openQueryWindow(this.dbTree.getDbForNode(node));
    }

    protected QueryPanel openQueryWindow(IDb db) {
        String dbName = db.getName();
        DefaultButtonBar buttonBar = new DefaultButtonBar();
        QueryPanel panel = new QueryPanel(db, this.settingsProvider, buttonBar, this.user);
        buttonBar.init(db, this.settingsProvider, panel, this.additionalMenuItems);
        TabSheet.EnhancedTab tab = this.contentTabs.add((Component)panel, this.getTabName(dbName));
        tab.setCloseable(true);
        tab.setIcon(new Icon(QUERY_ICON));
        this.selectContentTab(panel);
        return panel;
    }

    protected void openQueryWindow(Set<DbTreeNode> nodes) {
        HashSet<String> dbNames = new HashSet<String>();
        for (DbTreeNode node : nodes) {
            IDb db = this.dbTree.getDbForNode(node);
            String dbName = db.getName();
            if (dbNames.contains(dbName)) continue;
            dbNames.add(dbName);
            this.openQueryWindow(node);
        }
    }

    public void refreshQueryPanels() {
        Iterator<Component> panelIterator = this.contentTabs.iterator();
        while (panelIterator.hasNext()) {
            Component panel = panelIterator.next();
            if (!(panel instanceof QueryPanel)) continue;
            QueryPanel queryPanel = (QueryPanel)panel;
            if (this.settingsProvider.get().getProperties().is("sql.explorer.show.results.in.new.tabs")) {
                queryPanel.removeGeneralResultsTab();
            } else if (!this.settingsProvider.get().getProperties().is("sql.explorer.show.results.in.new.tabs")) {
                queryPanel.createGeneralResultsTab();
            }
            boolean autoCompleteEnabled = this.settingsProvider.get().getProperties().is("sql.explorer.auto.complete");
            queryPanel.setAutoCompleteEnabled(autoCompleteEnabled);
        }
    }

    public QueryPanel findQueryPanelForDb(IDb db) {
        QueryPanel panel = null;
        if (this.contentTabs.getComponentCount() > 0) {
            QueryPanel prospectiveQueryPanel;
            TabSheet.EnhancedTab comp = this.contentTabs.getSelectedTab();
            if (comp instanceof QueryPanel && (prospectiveQueryPanel = (QueryPanel)((Object)comp)).getDb().getName().equals(db.getName())) {
                panel = prospectiveQueryPanel;
            }
            if (panel == null) {
                Iterator<Component> i = this.contentTabs.iterator();
                while (i.hasNext()) {
                    QueryPanel prospectiveQueryPanel2;
                    comp = i.next();
                    if (!(comp instanceof QueryPanel) || !(prospectiveQueryPanel2 = (QueryPanel)((Object)comp)).getDb().getName().equals(db.getName())) continue;
                    panel = prospectiveQueryPanel2;
                    break;
                }
            }
            if (panel == null) {
                panel = this.openQueryWindow(db);
            }
        }
        return panel;
    }

    protected void generateSelectForSelectedTables() {
        Set<DbTreeNode> tableNodes = this.dbTree.getSelected("Table");
        for (DbTreeNode treeNode : tableNodes) {
            IDb db = this.dbTree.getDbForNode(treeNode);
            QueryPanel panel = this.findQueryPanelForDb(db);
            IDatabasePlatform platform = db.getPlatform();
            Table table = treeNode.getTableFor();
            DmlStatement dmlStatement = platform.createDmlStatement(DmlStatement.DmlType.SELECT_ALL, table, null);
            panel.appendSql(dmlStatement.getSql());
            this.contentTabs.setSelectedTab((Component)panel);
        }
    }

    protected void generateDmlForSelectedTables(DmlStatement.DmlType dmlType) {
        Set<DbTreeNode> tableNodes = this.dbTree.getSelected("Table");
        for (DbTreeNode treeNode : tableNodes) {
            Column[] columns;
            IDb db = this.dbTree.getDbForNode(treeNode);
            QueryPanel panel = this.findQueryPanelForDb(db);
            IDatabasePlatform platform = db.getPlatform();
            Table table = treeNode.getTableFor();
            DmlStatement dmlStatement = platform.createDmlStatement(dmlType, table, null);
            Row row = new Row(table.getColumnCount());
            for (Column column : columns = table.getColumns()) {
                String value = null;
                value = column.getParsedDefaultValue() == null ? CommonUiUtils.getJdbcTypeValue(column.getJdbcTypeName()) : column.getParsedDefaultValue().toString();
                row.put(column.getName(), (Object)value);
            }
            String sql = dmlStatement.buildDynamicSql(BinaryEncoding.HEX, row, false, true);
            panel.appendSql(sql);
            this.contentTabs.setSelectedTab((Component)panel);
        }
    }

    protected void dropSelectedTables() {
        Set<DbTreeNode> tableNodes = this.dbTree.getSelected("Table");
        ArrayList<Table> tables = new ArrayList();
        HashMap<Table, DbTreeNode> tableToTreeNode = new HashMap<Table, DbTreeNode>();
        for (DbTreeNode treeNode : tableNodes) {
            Table table = treeNode.getTableFor();
            tables.add(table);
            tableToTreeNode.put(table, treeNode);
        }
        tables = Database.sortByForeignKeys(tables);
        Collections.reverse(tables);
        this.dropTables(tables, tableToTreeNode);
    }

    private void dropTables(List<Table> tables, Map<Table, DbTreeNode> tableToTreeNode) {
        String msg = null;
        if (tables.size() > 1) {
            msg = "Do you want to drop " + tables.size() + " tables?";
        } else if (tables.size() == 1) {
            Table table = tables.get(0);
            msg = "Do you want to drop " + table.getFullyQualifiedTableName() + "?";
        }
        new ConfirmDialog("Drop Tables?", msg, "Ok", (ComponentEventListener & Serializable)e -> {
            for (Table table : tables) {
                DbTreeNode treeNode = (DbTreeNode)tableToTreeNode.get(table);
                IDb db = this.dbTree.getDbForNode(treeNode);
                try {
                    db.getPlatform().dropTables(false, new Table[]{table});
                }
                catch (Exception ex) {
                    String message = "Failed to drop " + table.getFullyQualifiedTableName() + ".  ";
                    CommonUiUtils.notify(message + "See log file for more details");
                    this.log.warn(message, (Throwable)ex);
                }
            }
            for (IContentTab iContentTab : this.infoTabs) {
                this.contentTabs.remove(this.contentTabs.getTab((Component)iContentTab));
            }
            this.infoTabs.clear();
            this.dbTree.refresh(true);
        }, "Cancel", (ComponentEventListener & Serializable)e -> {}).open();
    }

    protected DbTree buildDbTree() {
        DbTree tree = new DbTree(this.databaseProvider, this.settingsProvider);
        tree.addThemeVariants(new GridVariant[]{GridVariant.LUMO_COMPACT});
        tree.setHeightFull();
        this.listener = (SelectionListener & Serializable)event -> {
            Set nodes;
            MultiSelectionEvent multiSelectEvent = null;
            if (event instanceof MultiSelectionEvent) {
                multiSelectEvent = (MultiSelectionEvent)event;
            }
            if (!((nodes = this.dbTree.getSelectedItems()) == null || multiSelectEvent != null && multiSelectEvent.getAddedSelection().isEmpty())) {
                IDb db;
                String selectedTabCaption = null;
                for (IInfoPanel panel : this.infoTabs) {
                    selectedTabCaption = panel.getSelectedTabCaption();
                    TabSheet.EnhancedTab tab = this.contentTabs.getTab((Component)panel);
                    if (tab == null) continue;
                    this.contentTabs.remove(tab);
                }
                this.infoTabs.clear();
                if (nodes.size() > 0) {
                    DbTreeNode treeNode = multiSelectEvent != null ? (DbTreeNode)multiSelectEvent.getAddedSelection().iterator().next() : (DbTreeNode)nodes.iterator().next();
                    if (treeNode != null && treeNode.getType().equals("Database")) {
                        IDb db2 = this.dbTree.getDbForNode(treeNode);
                        DatabaseInfoPanel databaseInfoTab = new DatabaseInfoPanel(db2, this.settingsProvider.get(), selectedTabCaption);
                        TabSheet.EnhancedTab tab = this.contentTabs.add((Component)databaseInfoTab, db2.getName(), new Icon(VaadinIcon.DATABASE), 0);
                        tab.setCloseable(true);
                        this.infoTabs.add(databaseInfoTab);
                    }
                    if (treeNode != null && treeNode.getType().equals("Table")) {
                        table = treeNode.getTableFor();
                        if (table != null) {
                            db = this.dbTree.getDbForNode(treeNode);
                            TableInfoPanel tableInfoTab = new TableInfoPanel(table, this.user, db, this.settingsProvider.get(), this, selectedTabCaption);
                            TabSheet.EnhancedTab tab = this.contentTabs.add((Component)tableInfoTab, table.getFullyQualifiedTableName(), new Icon(VaadinIcon.TABLE), 0);
                            tab.setCloseable(true);
                            this.infoTabs.add(tableInfoTab);
                            this.selectContentTab(tableInfoTab);
                        }
                    } else if (treeNode != null && treeNode.getType().equals("Trigger")) {
                        table = treeNode.getParent().getTableFor();
                        IDdlReader reader = this.dbTree.getDbForNode(treeNode).getPlatform().getDdlReader();
                        Trigger trigger = reader.getTriggerFor(table, treeNode.getName());
                        if (trigger != null) {
                            IDb db3 = this.dbTree.getDbForNode(treeNode);
                            TriggerInfoPanel triggerInfoTab = new TriggerInfoPanel(trigger, db3, this.settingsProvider.get(), selectedTabCaption);
                            TabSheet.EnhancedTab tab = this.contentTabs.add((Component)triggerInfoTab, trigger.getName(), new Icon(VaadinIcon.CROSSHAIRS), 0);
                            tab.setCloseable(true);
                            this.infoTabs.add(triggerInfoTab);
                            this.selectContentTab(triggerInfoTab);
                        }
                    }
                }
                for (DbTreeNode treeNode : nodes) {
                    db = this.dbTree.getDbForNode(treeNode);
                    QueryPanel panel = this.getQueryPanelForDb(db);
                    if (panel == null && db != null) {
                        this.openQueryWindow(db);
                    }
                    if (db == null || treeNode.getParent() != null) continue;
                    this.selectContentTab(this.getQueryPanelForDb(db));
                }
            }
        };
        this.listenerRegistration = tree.addSelectionListener(this.listener);
        GridContextMenu contextMenu = new GridContextMenu((Grid)tree);
        contextMenu.setDynamicContentHandler((SerializablePredicate & Serializable)clickedNode -> {
            contextMenu.removeAll();
            Set selectedNodes = this.dbTree.getSelectedItems();
            if (clickedNode != null) {
                switch (clickedNode.getType()) {
                    case "Table": {
                        contextMenu.addItem((Component)this.createItem("Query", QUERY_ICON), (ComponentEventListener & Serializable)item -> this.openQueryWindow(selectedNodes));
                        contextMenu.addItem((Component)this.createItem("Select", QUERY_ICON), (ComponentEventListener & Serializable)item -> this.generateSelectForSelectedTables());
                        if (this.settingsProvider.get().isAllowDml()) {
                            contextMenu.addItem((Component)this.createItem("Insert", QUERY_ICON), (ComponentEventListener & Serializable)item -> this.generateDmlForSelectedTables(DmlStatement.DmlType.INSERT));
                            contextMenu.addItem((Component)this.createItem("Update", QUERY_ICON), (ComponentEventListener & Serializable)item -> this.generateDmlForSelectedTables(DmlStatement.DmlType.UPDATE));
                            contextMenu.addItem((Component)this.createItem("Delete", QUERY_ICON), (ComponentEventListener & Serializable)item -> this.generateDmlForSelectedTables(DmlStatement.DmlType.DELETE));
                            contextMenu.addItem((Component)this.createItem("Drop", VaadinIcon.ARROW_DOWN), (ComponentEventListener & Serializable)item -> this.dropSelectedTables());
                        }
                        if (this.settingsProvider.get().isAllowImport()) {
                            contextMenu.addItem((Component)this.createItem("Import", VaadinIcon.DOWNLOAD), (ComponentEventListener & Serializable)item -> {
                                if (!selectedNodes.isEmpty()) {
                                    IDb db = this.dbTree.getDbForNode((DbTreeNode)selectedNodes.iterator().next());
                                    new DbImportDialog(db.getPlatform(), this.dbTree.getSelectedTables()).showAtSize(0.6);
                                }
                            });
                        }
                        if (this.settingsProvider.get().isAllowExport()) {
                            contextMenu.addItem((Component)this.createItem("Export", VaadinIcon.UPLOAD), (ComponentEventListener & Serializable)item -> {
                                if (!selectedNodes.isEmpty()) {
                                    IDb db = this.dbTree.getDbForNode((DbTreeNode)selectedNodes.iterator().next());
                                    String excludeTablesRegex = this.settingsProvider.get().getProperties().get("sql.explorer.exclude.tables.regex");
                                    new DbExportDialog(db.getPlatform(), this.dbTree.getSelectedTables(), this.findQueryPanelForDb(db), excludeTablesRegex).showAtSize(0.6);
                                }
                            });
                        }
                        if (this.settingsProvider.get().isAllowFill()) {
                            contextMenu.addItem((Component)this.createItem("Fill", VaadinIcon.FILL), (ComponentEventListener & Serializable)item -> {
                                if (!selectedNodes.isEmpty()) {
                                    IDb db = this.dbTree.getDbForNode((DbTreeNode)selectedNodes.iterator().next());
                                    String excludeTablesRegex = this.settingsProvider.get().getProperties().get("sql.explorer.exclude.tables.regex");
                                    new DbFillDialog(db.getPlatform(), this.dbTree.getSelectedTables(), this.findQueryPanelForDb(db), excludeTablesRegex).showAtSize(0.6);
                                }
                            });
                        }
                        contextMenu.addItem((Component)this.createItem("Copy Name", VaadinIcon.COPY), (ComponentEventListener & Serializable)item -> {
                            for (DbTreeNode treeNode : selectedNodes) {
                                IDb db = this.dbTree.getDbForNode((DbTreeNode)selectedNodes.iterator().next());
                                DatabaseInfo dbInfo = db.getPlatform().getDatabaseInfo();
                                String quote = dbInfo.getDelimiterToken();
                                String catalogSeparator = dbInfo.getCatalogSeparator();
                                String schemaSeparator = dbInfo.getSchemaSeparator();
                                Table table = treeNode.getTableFor();
                                if (table == null) continue;
                                QueryPanel panel = this.findQueryPanelForDb(db);
                                panel.appendSql(table.getQualifiedTableName(quote, catalogSeparator, schemaSeparator));
                                this.contentTabs.setSelectedTab((Component)panel);
                            }
                        });
                        break;
                    }
                    case "Database": 
                    case "Catalog": 
                    case "Schema": {
                        contextMenu.addItem((Component)this.createItem("Query", QUERY_ICON), (ComponentEventListener & Serializable)item -> this.openQueryWindow(selectedNodes));
                        break;
                    }
                    case "Trigger": {
                        contextMenu.addItem((Component)this.createItem("Export", VaadinIcon.UPLOAD), (ComponentEventListener & Serializable)item -> {
                            if (!selectedNodes.isEmpty()) {
                                IDb db = this.dbTree.getDbForNode((DbTreeNode)selectedNodes.iterator().next());
                                String excludeTablesRegex = this.settingsProvider.get().getProperties().get("sql.explorer.exclude.tables.regex");
                                new DbExportDialog(db.getPlatform(), this.dbTree.getSelectedTables(), this.findQueryPanelForDb(db), excludeTablesRegex).showAtSize(0.6);
                            }
                        });
                    }
                }
                return true;
            }
            return false;
        });
        return tree;
    }

    protected Label createItem(String text, VaadinIcon icon) {
        return new Label(icon, text);
    }

    protected QueryPanel getQueryPanelForDb(IDb db) {
        if (db != null) {
            Iterator<Component> i = this.contentTabs.iterator();
            while (i.hasNext()) {
                QueryPanel panel;
                Component c = i.next();
                if (!(c instanceof QueryPanel) || !(panel = (QueryPanel)c).getDb().getName().equals(db.getName())) continue;
                return panel;
            }
        }
        return null;
    }

    protected String getTabName(String name) {
        Object tabName;
        int tabs = this.contentTabs.getTabCount();
        Object object = tabName = tabs > 0 ? null : name;
        if (tabName == null) {
            for (int j = 0; j < 10; ++j) {
                boolean alreadyUsed = false;
                Object suffix = "";
                for (int i = 0; i < tabs; ++i) {
                    TabSheet.EnhancedTab tab = this.contentTabs.getTab(i);
                    String currentTabName = tab.getName();
                    if (j > 0) {
                        suffix = "-" + j;
                    }
                    if (!currentTabName.equals(name + (String)suffix)) continue;
                    alreadyUsed = true;
                }
                if (alreadyUsed) continue;
                tabName = name + (String)suffix;
                break;
            }
        }
        return tabName;
    }

    public ISettingsProvider getSettingsProvider() {
        return this.settingsProvider;
    }

    public IDbProvider getDatabaseProvider() {
        return this.databaseProvider;
    }

    public void refresh() {
        this.dbTree.refresh(false);
    }

    public void focus() {
        this.dbTree.focus();
    }

    public void addResultsTab(String caption, Icon icon, IContentTab panel) {
        TabSheet.EnhancedTab tab = this.contentTabs.add((Component)panel, caption, icon);
        tab.setCloseable(true);
        this.selectContentTab(panel);
    }

    public void putResultsInQueryTab(String value, IDb db) {
        this.openQueryWindow(db).appendSql(value);
    }
}

