/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.StringToIntegerConverter;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.text.DecimalFormat;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.ResizableDialog;
import org.jumpmind.vaadin.ui.sqlexplorer.ISettingsProvider;
import org.jumpmind.vaadin.ui.sqlexplorer.Settings;
import org.jumpmind.vaadin.ui.sqlexplorer.SqlExplorer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsDialog
extends ResizableDialog {
    private static final long serialVersionUID = 1L;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private TextField rowsToFetchField;
    private Binder<Integer> binder;
    private Checkbox autoCommitBox;
    private Checkbox autoCompleteBox;
    private TextField delimiterField;
    private TextField excludeTablesWithPrefixField;
    private Checkbox resultAsTextBox;
    private Checkbox ignoreErrorsWhenRunningScript;
    private Checkbox showRowNumbersBox;
    private Checkbox showResultsInNewTabsBox;
    private Checkbox showTriggersBox;
    ISettingsProvider settingsProvider;
    SqlExplorer explorer;

    public SettingsDialog(SqlExplorer explorer) {
        super("Settings");
        this.explorer = explorer;
        this.settingsProvider = explorer.getSettingsProvider();
        this.setCloseOnOutsideClick(false);
        this.setWidth("800px");
        this.add((Component)this.createSettingsLayout(), 1);
        this.createButtonLayout();
    }

    protected HorizontalLayout createSettingsLayout() {
        HorizontalLayout layout = new HorizontalLayout();
        layout.setWidth("700px");
        layout.getStyle().set("margin", "0 16px");
        FormLayout settingsLayout = new FormLayout();
        Settings settings = this.settingsProvider.get();
        TypedProperties properties = settings.getProperties();
        this.rowsToFetchField = new TextField("Max Results");
        this.rowsToFetchField.setWidth("6em");
        this.binder = new Binder();
        this.binder.forField((HasValue)this.rowsToFetchField).withConverter((Converter)new StringToIntegerConverter("Could not convert value to Integer")).withValidator((SerializablePredicate & Serializable)value -> value != null, "Invalid value").bind((ValueProvider & Serializable)integer -> integer, (Setter & Serializable)(integer, value) -> {
            integer = value;
        });
        this.rowsToFetchField.setValue(properties.getProperty("sql.explorer.max.results", "100"));
        settingsLayout.add(new Component[]{this.rowsToFetchField});
        this.delimiterField = new TextField("Delimiter");
        this.delimiterField.setValue(properties.getProperty("sql.explorer.delimiter", ";"));
        settingsLayout.add(new Component[]{this.delimiterField});
        this.excludeTablesWithPrefixField = new TextField("Hide Tables (regex)");
        this.excludeTablesWithPrefixField.setValue(properties.getProperty("sql.explorer.exclude.tables.regex"));
        settingsLayout.add(new Component[]{this.excludeTablesWithPrefixField});
        this.resultAsTextBox = new Checkbox("Result As Text");
        String resultAsTextValue = properties.getProperty("sql.explorer.result.as.text", "false");
        if (resultAsTextValue.equals("true")) {
            this.resultAsTextBox.setValue((Object)true);
        } else {
            this.resultAsTextBox.setValue((Object)false);
        }
        settingsLayout.add(new Component[]{this.resultAsTextBox});
        this.ignoreErrorsWhenRunningScript = new Checkbox("Ignore Errors When Running Scripts");
        String ignoreErrorsWhenRunningScriptTextValue = properties.getProperty("sql.explorer.ignore.errors.when.running.scripts", "false");
        if (ignoreErrorsWhenRunningScriptTextValue.equals("true")) {
            this.ignoreErrorsWhenRunningScript.setValue((Object)true);
        } else {
            this.ignoreErrorsWhenRunningScript.setValue((Object)false);
        }
        settingsLayout.add(new Component[]{this.ignoreErrorsWhenRunningScript});
        this.autoCommitBox = new Checkbox("Auto Commit");
        String autoCommitValue = properties.getProperty("sql.explorer.auto.commit", "true");
        if (autoCommitValue.equals("true")) {
            this.autoCommitBox.setValue((Object)true);
        } else {
            this.autoCommitBox.setValue((Object)false);
        }
        settingsLayout.add(new Component[]{this.autoCommitBox});
        this.autoCompleteBox = new Checkbox("Auto Complete");
        String autoCompleteValue = properties.getProperty("sql.explorer.auto.complete", "true");
        if (autoCompleteValue.equals("true")) {
            this.autoCompleteBox.setValue((Object)true);
        } else {
            this.autoCompleteBox.setValue((Object)false);
        }
        settingsLayout.add(new Component[]{this.autoCompleteBox});
        this.showRowNumbersBox = new Checkbox("Show Row Numbers");
        String showRowNumbersValue = properties.getProperty("sql.explorer.show.row.numbers", "true");
        if (showRowNumbersValue.equals("true")) {
            this.showRowNumbersBox.setValue((Object)true);
        } else {
            this.showRowNumbersBox.setValue((Object)false);
        }
        settingsLayout.add(new Component[]{this.showRowNumbersBox});
        this.showResultsInNewTabsBox = new Checkbox("Always Put Results In New Tabs");
        String showResultsInNewTabsValue = properties.getProperty("sql.explorer.show.results.in.new.tabs", "false");
        if (showResultsInNewTabsValue.equals("true")) {
            this.showResultsInNewTabsBox.setValue((Object)true);
        } else {
            this.showResultsInNewTabsBox.setValue((Object)false);
        }
        settingsLayout.add(new Component[]{this.showResultsInNewTabsBox});
        this.showTriggersBox = new Checkbox("Show Triggers");
        String showTriggersValue = properties.getProperty("sql.explorer.show.triggers", "false");
        this.showTriggersBox.setValue((Object)showTriggersValue.equals("true"));
        settingsLayout.add(new Component[]{this.showTriggersBox});
        layout.add(new Component[]{settingsLayout});
        return layout;
    }

    protected void createButtonLayout() {
        Button saveButton = CommonUiUtils.createPrimaryButton("Save", (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
            if (this.save()) {
                this.close();
            }
        });
        this.buildButtonFooter(new Component[]{new Button("Cancel", (ComponentEventListener)new ResizableDialog.CloseButtonListener()), saveButton});
    }

    protected boolean save() {
        if (this.binder.validate().isOk()) {
            Settings settings = this.settingsProvider.get();
            TypedProperties properties = settings.getProperties();
            try {
                properties.setProperty("sql.explorer.max.results", new DecimalFormat().parse(this.rowsToFetchField.getValue()).intValue());
                properties.setProperty("sql.explorer.auto.commit", String.valueOf(this.autoCommitBox.getValue()));
                properties.setProperty("sql.explorer.auto.complete", String.valueOf(this.autoCompleteBox.getValue()));
                properties.setProperty("sql.explorer.delimiter", this.delimiterField.getValue());
                properties.setProperty("sql.explorer.result.as.text", String.valueOf(this.resultAsTextBox.getValue()));
                properties.setProperty("sql.explorer.show.row.numbers", String.valueOf(this.showRowNumbersBox.getValue()));
                properties.setProperty("sql.explorer.exclude.tables.regex", this.excludeTablesWithPrefixField.getValue());
                properties.setProperty("sql.explorer.ignore.errors.when.running.scripts", String.valueOf(this.ignoreErrorsWhenRunningScript.getValue()));
                properties.setProperty("sql.explorer.show.results.in.new.tabs", String.valueOf(this.showResultsInNewTabsBox.getValue()));
                properties.setProperty("sql.explorer.show.triggers", String.valueOf(this.showTriggersBox.getValue()));
                this.settingsProvider.save(settings);
                this.explorer.refreshQueryPanels();
                return true;
            }
            catch (Exception ex) {
                this.log.error(ex.getMessage(), (Throwable)ex);
                CommonUiUtils.notifyError(opened -> this.enableEscapeShortcut(opened == false));
                return false;
            }
        }
        CommonUiUtils.notify("Save Failed", "Ensure that all fields are valid", opened -> this.enableEscapeShortcut(opened == false));
        return false;
    }
}

