/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.vaadin.ui.sqlexplorer.SqlHistory;

public class Settings
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SQL_EXPLORER_EXCLUDE_TABLES_REGEX = "sql.explorer.exclude.tables.regex";
    public static final String SQL_EXPLORER_SHOW_ROW_NUMBERS = "sql.explorer.show.row.numbers";
    public static final String SQL_EXPLORER_AUTO_COMMIT = "sql.explorer.auto.commit";
    public static final String SQL_EXPLORER_AUTO_COMPLETE = "sql.explorer.auto.complete";
    public static final String SQL_EXPLORER_RESULT_AS_TEXT = "sql.explorer.result.as.text";
    public static final String SQL_EXPLORER_IGNORE_ERRORS_WHEN_RUNNING_SCRIPTS = "sql.explorer.ignore.errors.when.running.scripts";
    public static final String SQL_EXPLORER_DELIMITER = "sql.explorer.delimiter";
    public static final String SQL_EXPLORER_MAX_RESULTS = "sql.explorer.max.results";
    public static final String SQL_EXPLORER_MAX_HISTORY = "sql.explorer.max.history";
    public static final String SQL_EXPLORER_SHOW_RESULTS_IN_NEW_TABS = "sql.explorer.show.results.in.new.tabs";
    public static final String SQL_EXPLORER_SHOW_TRIGGERS = "sql.explorer.show.triggers";
    protected List<SqlHistory> sqlHistory = new ArrayList<SqlHistory>();
    protected TypedProperties properties = new TypedProperties();
    protected boolean allowQueries = true;
    protected boolean allowDml = true;
    protected boolean allowImport = true;
    protected boolean allowExport = true;
    protected boolean allowFill = true;
    protected boolean allowCompare = true;
    protected boolean allowRepair = true;

    public Settings() {
        this.properties.put((Object)SQL_EXPLORER_DELIMITER, (Object)";");
        this.properties.put((Object)SQL_EXPLORER_SHOW_ROW_NUMBERS, (Object)"true");
        this.properties.put((Object)SQL_EXPLORER_AUTO_COMMIT, (Object)"true");
        this.properties.put((Object)SQL_EXPLORER_AUTO_COMPLETE, (Object)"true");
        this.properties.put((Object)SQL_EXPLORER_RESULT_AS_TEXT, (Object)"false");
        this.properties.put((Object)SQL_EXPLORER_EXCLUDE_TABLES_REGEX, (Object)"(SYM_)\\w+");
        this.properties.put((Object)SQL_EXPLORER_MAX_RESULTS, (Object)"1000");
        this.properties.put((Object)SQL_EXPLORER_MAX_HISTORY, (Object)"100");
        this.properties.put((Object)SQL_EXPLORER_IGNORE_ERRORS_WHEN_RUNNING_SCRIPTS, (Object)"false");
        this.properties.put((Object)SQL_EXPLORER_SHOW_RESULTS_IN_NEW_TABS, (Object)"false");
        this.properties.put((Object)SQL_EXPLORER_SHOW_TRIGGERS, (Object)"true");
    }

    public TypedProperties getProperties() {
        return this.properties;
    }

    public void setProperties(TypedProperties properties) {
        this.properties = properties;
    }

    public void addSqlHistory(SqlHistory history) {
        int maxSize = Integer.parseInt(this.properties.get(SQL_EXPLORER_MAX_HISTORY));
        if (this.sqlHistory.size() > maxSize) {
            SqlHistory oldest = null;
            for (SqlHistory s : this.sqlHistory) {
                if (oldest != null && !oldest.getLastExecuteTime().before(s.getLastExecuteTime())) continue;
                oldest = s;
            }
            this.sqlHistory.remove(oldest);
        }
        this.sqlHistory.add(history);
    }

    public List<SqlHistory> getSqlHistory() {
        return this.sqlHistory;
    }

    public void setSqlHistory(List<SqlHistory> sqlHistory) {
        this.sqlHistory = sqlHistory;
    }

    public SqlHistory getSqlHistory(String sql) {
        sql = sql.trim();
        for (SqlHistory sqlHistory2 : this.sqlHistory) {
            if (!sqlHistory2.getSqlStatement().equals(sql)) continue;
            return sqlHistory2;
        }
        return null;
    }

    public boolean isAllowQueries() {
        return this.allowQueries;
    }

    public void setAllowQueries(boolean allowQueries) {
        this.allowQueries = allowQueries;
    }

    public boolean isAllowDml() {
        return this.allowDml;
    }

    public void setAllowDml(boolean allowAnySql) {
        this.allowDml = allowAnySql;
    }

    public boolean isAllowImport() {
        return this.allowImport;
    }

    public void setAllowImport(boolean allowImport) {
        this.allowImport = allowImport;
    }

    public boolean isAllowExport() {
        return this.allowExport;
    }

    public void setAllowExport(boolean allowExport) {
        this.allowExport = allowExport;
    }

    public boolean isAllowFill() {
        return this.allowFill;
    }

    public void setAllowFill(boolean allowFill) {
        this.allowFill = allowFill;
    }

    public boolean isAllowCompare() {
        return this.allowCompare;
    }

    public void setAllowCompare(boolean allowCompare) {
        this.allowCompare = allowCompare;
    }

    public boolean isAllowRepair() {
        return this.allowRepair;
    }

    public void setAllowRepair(boolean allowRepair) {
        this.allowRepair = allowRepair;
    }
}

