/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.value.ValueChangeMode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.io.data.DbFill;
import org.jumpmind.symmetric.io.data.DmlWeight;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.ResizableDialog;
import org.jumpmind.vaadin.ui.sqlexplorer.QueryPanel;
import org.jumpmind.vaadin.ui.sqlexplorer.TableSelectionLayout;

public class DbFillDialog
extends ResizableDialog {
    private static final long serialVersionUID = 1L;
    private Button cancelButton;
    private ShortcutRegistration cancelShortcutRegistration;
    private Button nextButton;
    private ShortcutRegistration nextShortcutRegistration;
    private Button previousButton;
    private Button fillButton;
    private ShortcutRegistration fillShortcutRegistration;
    private TableSelectionLayout tableSelectionLayout;
    private Scroller optionLayout;
    private Checkbox continueBox;
    private Checkbox cascadeBox;
    private Checkbox cascadeSelectBox;
    private Checkbox truncateBox;
    private Checkbox verboseBox;
    private TextField countField;
    private TextField intervalField;
    private TextField insertWeightField;
    private TextField updateWeightField;
    private TextField deleteWeightField;
    private TextField commitRowSizeField;
    private DbFill dbFill;
    private RadioButtonGroup<String> oGroup;
    private QueryPanel queryPanel;
    private IDatabasePlatform databasePlatform;

    public DbFillDialog(IDatabasePlatform databasePlatform, QueryPanel queryPanel, String excludeTablesRegex) {
        this(databasePlatform, new HashSet<Table>(0), queryPanel, excludeTablesRegex);
    }

    public DbFillDialog(IDatabasePlatform databasePlatform, Set<Table> selectedTableSet, QueryPanel queryPanel, String excludeTablesRegex) {
        super("Database Fill", false);
        this.setModal(true);
        this.setHeight("500px");
        this.setWidth("605px");
        this.databasePlatform = databasePlatform;
        this.queryPanel = queryPanel;
        this.tableSelectionLayout = new TableSelectionLayout(databasePlatform, selectedTableSet, excludeTablesRegex){
            private static final long serialVersionUID = 1L;

            @Override
            protected void selectionChanged() {
                DbFillDialog.this.nextButton.setEnabled(DbFillDialog.this.tableSelectionLayout.getSelectedTables().size() > 0);
            }
        };
        this.tableSelectionLayout.setHeight("318px");
        this.createOptionLayout();
        this.add((Component)this.tableSelectionLayout, 1);
        this.addButtons();
        this.nextShortcutRegistration = this.nextButton.addClickShortcut(Key.ENTER, new KeyModifier[0]);
    }

    protected void addButtons() {
        this.nextButton = CommonUiUtils.createPrimaryButton("Next", (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> this.next());
        this.nextButton.setEnabled(this.tableSelectionLayout.getSelectedTables().size() > 0);
        this.cancelButton = new Button("Close", (ComponentEventListener & Serializable)event -> this.close());
        this.cancelShortcutRegistration = this.cancelButton.addClickShortcut(Key.ESCAPE, new KeyModifier[0]);
        this.previousButton = new Button("Previous", (ComponentEventListener & Serializable)event -> this.previous());
        this.previousButton.setVisible(false);
        this.fillButton = CommonUiUtils.createPrimaryButton("Fill...", (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
            this.createDbFill();
            if (!this.dbFill.getPrint()) {
                this.confirm();
            } else {
                List<String> tables = this.getSelectedTables();
                for (String tableName : tables) {
                    Table table = this.databasePlatform.getTableFromCache(this.tableSelectionLayout.catalogSelect.getValue() != null ? ((String)this.tableSelectionLayout.catalogSelect.getValue()).toString() : null, this.tableSelectionLayout.schemaSelect.getValue() != null ? ((String)this.tableSelectionLayout.schemaSelect.getValue()).toString() : null, tableName, false);
                    if (table == null) continue;
                    for (int i = 0; i < this.dbFill.getRecordCount(); ++i) {
                        String sql;
                        int j;
                        for (j = 0; j < this.dbFill.getInsertWeight(); ++j) {
                            sql = this.dbFill.createDynamicRandomInsertSql(table);
                            this.queryPanel.appendSql(sql);
                        }
                        for (j = 0; j < this.dbFill.getUpdateWeight(); ++j) {
                            sql = this.dbFill.createDynamicRandomUpdateSql(table);
                            this.queryPanel.appendSql(sql);
                        }
                        for (j = 0; j < this.dbFill.getDeleteWeight(); ++j) {
                            sql = this.dbFill.createDynamicRandomDeleteSql(table);
                            this.queryPanel.appendSql(sql);
                        }
                    }
                }
                this.close();
            }
        });
        this.fillButton.setVisible(false);
        this.buildButtonFooter(new Component[]{this.cancelButton, this.previousButton, this.nextButton, this.fillButton});
    }

    protected void createOptionLayout() {
        VerticalLayout optionContent = new VerticalLayout();
        optionContent.setMargin(false);
        optionContent.setSpacing(true);
        optionContent.setSizeFull();
        optionContent.add(new Component[]{new Span("Please choose from the following options")});
        FormLayout formLayout = new FormLayout();
        formLayout.setSizeFull();
        optionContent.addAndExpand(new Component[]{formLayout});
        this.countField = new TextField("Count (# of rows to fill)");
        this.countField.setValue("1");
        this.countField.setValueChangeMode(ValueChangeMode.EAGER);
        this.countField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.fillButton.setEnabled(this.enableFillButton()));
        formLayout.add(new Component[]{this.countField});
        this.intervalField = new TextField("Interval (ms)");
        this.intervalField.setValue("0");
        this.intervalField.setValueChangeMode(ValueChangeMode.EAGER);
        this.intervalField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.fillButton.setEnabled(this.enableFillButton()));
        formLayout.add(new Component[]{this.intervalField});
        this.insertWeightField = new TextField("Insert Weight");
        this.insertWeightField.setValue("1");
        this.insertWeightField.setValueChangeMode(ValueChangeMode.EAGER);
        this.insertWeightField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.fillButton.setEnabled(this.enableFillButton()));
        formLayout.add(new Component[]{this.insertWeightField});
        this.updateWeightField = new TextField("Update Weight");
        this.updateWeightField.setValue("0");
        this.updateWeightField.setValueChangeMode(ValueChangeMode.EAGER);
        this.updateWeightField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.fillButton.setEnabled(this.enableFillButton()));
        formLayout.add(new Component[]{this.updateWeightField});
        this.deleteWeightField = new TextField("Delete Weight");
        this.deleteWeightField.setValue("0");
        this.deleteWeightField.setValueChangeMode(ValueChangeMode.EAGER);
        this.deleteWeightField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.fillButton.setEnabled(this.enableFillButton()));
        formLayout.add(new Component[]{this.deleteWeightField});
        this.continueBox = new Checkbox("Continue (ignore ANY errors and continue to modify)");
        this.continueBox.setValue((Object)true);
        formLayout.add(new Component[]{this.continueBox});
        this.cascadeBox = new Checkbox("Fill dependent tables also.");
        this.cascadeBox.setValue((Object)false);
        formLayout.add(new Component[]{this.cascadeBox});
        this.cascadeSelectBox = new Checkbox("Fill dependent tables by selecting existing data.");
        this.cascadeSelectBox.setValue((Object)false);
        formLayout.add(new Component[]{this.cascadeSelectBox});
        this.verboseBox = new Checkbox("Turn on verbose logging during fill.");
        this.verboseBox.setValue((Object)false);
        formLayout.add(new Component[]{this.verboseBox});
        this.truncateBox = new Checkbox("Truncate table(s) before filling.");
        this.truncateBox.setValue((Object)false);
        formLayout.add(new Component[]{this.truncateBox});
        this.oGroup = new RadioButtonGroup();
        this.oGroup.setItems((Object[])new String[]{"Fill Table(s)", "Send to Sql Editor"});
        this.oGroup.setValue((Object)"Fill Table(s)");
        formLayout.add(new Component[]{this.oGroup});
        this.commitRowSizeField = new TextField("Commit Row Size");
        this.commitRowSizeField.setValue("1");
        this.commitRowSizeField.setValueChangeMode(ValueChangeMode.EAGER);
        this.commitRowSizeField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.fillButton.setEnabled(this.enableFillButton()));
        formLayout.add(new Component[]{this.commitRowSizeField});
        this.optionLayout = new Scroller((Component)optionContent);
        this.optionLayout.setScrollDirection(Scroller.ScrollDirection.VERTICAL);
        this.optionLayout.setSizeFull();
    }

    protected void confirm() {
        this.enableShortcuts(false);
        new ConfirmDialog("Confirm", "Are you sure?  Please note that this will affect data in the selected tables.  Make sure you have a backup of your data.", "Ok", (ComponentEventListener & Serializable)e -> {
            this.fill();
            this.close();
        }, "Cancel", (ComponentEventListener & Serializable)e -> this.enableShortcuts(true)).open();
    }

    protected void enableShortcuts(boolean enabled) {
        if (enabled && this.cancelShortcutRegistration == null && this.fillShortcutRegistration == null) {
            this.cancelShortcutRegistration = this.cancelButton.addClickShortcut(Key.ESCAPE, new KeyModifier[0]);
            this.fillShortcutRegistration = this.fillButton.addClickShortcut(Key.ENTER, new KeyModifier[0]);
        } else if (!enabled && this.cancelShortcutRegistration != null && this.fillShortcutRegistration != null) {
            this.cancelShortcutRegistration.remove();
            this.cancelShortcutRegistration = null;
            this.fillShortcutRegistration.remove();
            this.fillShortcutRegistration = null;
        }
    }

    protected void fill() {
        List<String> temp = this.getSelectedTables();
        String[] tables = new String[temp.size()];
        temp.toArray(tables);
        this.dbFill.fillTables(tables);
    }

    protected void createDbFill() {
        this.dbFill = new DbFill(this.databasePlatform);
        this.dbFill.setCatalog(this.tableSelectionLayout.catalogSelect.getValue() != null ? ((String)this.tableSelectionLayout.catalogSelect.getValue()).toString() : null);
        this.dbFill.setSchema(this.tableSelectionLayout.schemaSelect.getValue() != null ? ((String)this.tableSelectionLayout.schemaSelect.getValue()).toString() : null);
        this.dbFill.setContinueOnError(((Boolean)this.continueBox.getValue()).booleanValue());
        this.dbFill.setCascading(((Boolean)this.cascadeBox.getValue()).booleanValue());
        this.dbFill.setCascadingSelect(((Boolean)this.cascadeSelectBox.getValue()).booleanValue());
        this.dbFill.setVerbose(((Boolean)this.verboseBox.getValue()).booleanValue());
        this.dbFill.setRecordCount(Integer.parseInt(this.countField.getValue().toString()));
        this.dbFill.setInterval(Integer.parseInt(this.intervalField.getValue().toString()));
        this.dbFill.setDmlWeight(new DmlWeight(Integer.parseInt(this.insertWeightField.getValue()), Integer.parseInt(this.updateWeightField.getValue()), Integer.parseInt(this.deleteWeightField.getValue())));
        this.dbFill.setMaxRowsCommit(Integer.parseInt(this.commitRowSizeField.getValue()));
        if (((String)this.oGroup.getValue()).toString().equals("Send to Sql Editor")) {
            this.dbFill.setPrint(true);
        }
    }

    protected void previous() {
        this.innerContent.remove(new Component[]{this.optionLayout});
        this.innerContent.addComponentAtIndex(0, (Component)this.tableSelectionLayout);
        this.innerContent.expand(new Component[]{this.tableSelectionLayout});
        this.fillButton.setVisible(false);
        if (this.fillShortcutRegistration != null) {
            this.fillShortcutRegistration.remove();
            this.fillShortcutRegistration = null;
        }
        this.previousButton.setVisible(false);
        this.nextButton.setVisible(true);
        if (this.nextShortcutRegistration == null) {
            this.nextShortcutRegistration = this.nextButton.addClickShortcut(Key.ENTER, new KeyModifier[0]);
        }
    }

    protected void next() {
        this.innerContent.remove(new Component[]{this.tableSelectionLayout});
        this.innerContent.addComponentAtIndex(0, (Component)this.optionLayout);
        this.innerContent.expand(new Component[]{this.optionLayout});
        this.nextButton.setVisible(false);
        if (this.nextShortcutRegistration != null) {
            this.nextShortcutRegistration.remove();
            this.nextShortcutRegistration = null;
        }
        this.previousButton.setVisible(true);
        this.fillButton.setVisible(true);
        if (this.fillShortcutRegistration == null) {
            this.fillShortcutRegistration = this.fillButton.addClickShortcut(Key.ENTER, new KeyModifier[0]);
        }
    }

    protected boolean enableFillButton() {
        return !this.countField.getValue().equals("") && !this.intervalField.getValue().equals("") && !this.insertWeightField.getValue().equals("") && !this.updateWeightField.getValue().equals("") && !this.deleteWeightField.getValue().equals("");
    }

    public List<String> getSelectedTables() {
        return new ArrayList<String>(this.tableSelectionLayout.listOfTablesGrid.getSelectedItems());
    }
}

