/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.common;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResizableDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected VerticalLayout innerContent;
    protected ShortcutRegistration escapeShortcutRegistration;

    public ResizableDialog() {
        this("");
    }

    public ResizableDialog(String caption) {
        this(caption, true);
    }

    public ResizableDialog(String caption, boolean addEscapeShortcut) {
        this(caption, addEscapeShortcut, false);
    }

    public ResizableDialog(String caption, boolean addEscapeShortcut, boolean addCloseIcon) {
        this.setModal(true);
        this.setResizable(true);
        VerticalLayout content = new VerticalLayout();
        content.setSizeFull();
        content.setPadding(false);
        content.setSpacing(false);
        super.add(new Component[]{content});
        if (caption != null) {
            this.setHeaderTitle(caption);
        }
        if (addCloseIcon) {
            this.getHeader().add(new Component[]{this.buildCloseIcon()});
        }
        this.innerContent = new VerticalLayout();
        this.innerContent.setWidthFull();
        this.innerContent.setMargin(false);
        this.innerContent.setSpacing(false);
        content.addAndExpand(new Component[]{this.innerContent});
        UI.getCurrent().addShortcutListener((Command & Serializable)() -> {
            if (!"100%".equals(this.getWidth())) {
                this.setWidth("100%");
                this.setHeight("100%");
            } else {
                this.setWidth(null);
                this.setHeight(null);
            }
        }, Key.KEY_M, new KeyModifier[]{KeyModifier.CONTROL});
        if (addEscapeShortcut) {
            this.escapeShortcutRegistration = UI.getCurrent().addShortcutListener((Command & Serializable)() -> this.close(), Key.ESCAPE, new KeyModifier[0]);
        }
    }

    protected void add(Component component, int expandRatio) {
        this.innerContent.add(new Component[]{component});
        this.innerContent.setFlexGrow((double)expandRatio, new HasElement[]{component});
    }

    protected void add(Component component) {
        this.innerContent.add(new Component[]{component});
    }

    protected void addComponents(Component ... components) {
        for (Component component : components) {
            this.innerContent.add(new Component[]{component});
        }
    }

    protected Icon buildCloseIcon() {
        Icon closeIcon = new Icon(VaadinIcon.CLOSE);
        closeIcon.setSize("36px");
        closeIcon.getStyle().set("min-width", "36px");
        closeIcon.setClassName("mouse_pointer");
        closeIcon.addClickListener((ComponentEventListener & Serializable)event -> this.close());
        return closeIcon;
    }

    protected Button buildCloseButton() {
        Button closeButton = new Button("Close");
        closeButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        closeButton.addClickListener((ComponentEventListener)new CloseButtonListener());
        closeButton.focus();
        return closeButton;
    }

    protected void buildButtonFooter(Component ... toTheRightButtons) {
        this.buildButtonFooter((Component[])null, toTheRightButtons);
    }

    protected void buildButtonFooter(List<Component> toTheLeftButtons, Component ... toTheRightButtons) {
        this.buildButtonFooter(toTheLeftButtons.toArray(new Component[toTheLeftButtons.size()]), toTheRightButtons);
    }

    protected void buildButtonFooter(Component[] toTheLeftButtons, Component ... toTheRightButtons) {
        int buttonCount;
        if (toTheLeftButtons != null && (buttonCount = toTheLeftButtons.length) > 0) {
            for (int i = 0; i < buttonCount - 1; ++i) {
                this.getFooter().add(new Component[]{toTheLeftButtons[i]});
            }
            toTheLeftButtons[buttonCount - 1].getStyle().set("margin-right", "auto");
            this.getFooter().add(new Component[]{toTheLeftButtons[buttonCount - 1]});
        }
        if (toTheRightButtons != null) {
            this.getFooter().add(toTheRightButtons);
        }
    }

    protected boolean onClose() {
        return true;
    }

    public void show() {
        this.open();
    }

    public void showAtSize(double percentOfBrowserSize) {
        UI.getCurrent().getPage().retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver & Serializable)details -> {
            this.setHeight((double)details.getWindowInnerHeight() * percentOfBrowserSize + "px");
            this.setWidth((double)details.getWindowInnerWidth() * percentOfBrowserSize + "px");
        });
        this.show();
    }

    public void bringToFront() {
        if (this.getElement().getNode().isAttached()) {
            super.getElement().executeJs("$0._bringOverlayToFront()", new Serializable[0]);
        }
    }

    protected void enableEscapeShortcut(boolean enable) {
        if (enable && this.escapeShortcutRegistration == null) {
            this.escapeShortcutRegistration = UI.getCurrent().addShortcutListener((Command & Serializable)() -> this.close(), Key.ESCAPE, new KeyModifier[0]);
        } else if (!enable && this.escapeShortcutRegistration != null) {
            this.escapeShortcutRegistration.remove();
            this.escapeShortcutRegistration = null;
        }
    }

    public class CloseButtonListener
    implements ComponentEventListener<ClickEvent<Button>> {
        private static final long serialVersionUID = 1L;

        public void onComponentEvent(ClickEvent<Button> event) {
            if (ResizableDialog.this.onClose()) {
                ResizableDialog.this.close();
            }
        }
    }
}

