/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.common;

import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.function.ValueProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jumpmind.vaadin.ui.common.IDataProvider;

public class GridDataProvider<T>
implements IDataProvider<T> {
    private Grid<T> grid;
    private Map<Grid.Column<T>, ValueProvider<T, Object>> valueProviderMap;

    public GridDataProvider(Grid<T> grid, Map<Grid.Column<T>, ValueProvider<T, Object>> valueProviderMap) {
        this.grid = grid;
        this.valueProviderMap = valueProviderMap;
    }

    @Override
    public Collection<T> getRowItems() {
        return this.grid.getDataProvider().fetch(new Query()).collect(Collectors.toList());
    }

    @Override
    public List<?> getColumns() {
        return this.grid.getColumns();
    }

    @Override
    public Object getCellValue(T item, Object column) {
        if (column instanceof Grid.Column && this.valueProviderMap.get(column) != null) {
            return this.valueProviderMap.get(column).apply(item);
        }
        return null;
    }

    @Override
    public String getKeyValue(Object column) {
        return ((Grid.Column)column).getKey();
    }
}

