/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.server;

import com.ibm.mq.MQConnectionOptions;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMD;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQOD;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQXAVerbs;
import com.ibm.mq.Pint;
import com.ibm.mq.Pthrowable;
import com.ibm.mq.XAtoJTA;
import com.ibm.mq.server.MQThread;
import com.ibm.mq.server.MQXAi;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.Xid;

public class MQSESSION
extends com.ibm.mq.MQSESSION
implements MQXAVerbs {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/server/MQSESSION.java, java, j600, j600-202-070608 1.81.1.8 07/05/17 08:09:02";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String clsName = "MQSESSION";
    private static final String DEFR_LIBNAME = "mqjbdf";
    private static final String DEFR_VERSION = "02";
    private static final int MQCNO_HANDLE_SHARE_NO_BLOCK = 128;
    private static final int MQRC_APPL_JMS_NO_AUTH = 901;
    private boolean multiThreaded = true;
    private boolean useWorkerThread = false;
    private boolean forceThreadAffinity = false;
    private MQThread connThread = null;
    private boolean inUseByQM = false;
    private boolean inUseByXA = false;
    private Exception xaInvalidStateException = null;
    private boolean v2SupportResolved = false;
    private Object mqiLock = new Object();
    boolean spiSuppDeferred = false;
    boolean spiSuppInherited = false;
    static boolean deferredLibLoaded = false;

    static void loadDefMsgLibrary() {
        if (Trace.isOn) {
            Trace.entry(clsName, "loadDefMsgLibrary");
        }
        if (zSeries) {
            if (Trace.isOn) {
                Trace.trace(clsName, "Running on zSeries so don't load separate deferred library");
            }
            return;
        }
        if (!deferredLibLoaded) {
            final String string = MQSESSION.getLibraryPath() + DEFR_LIBNAME + DEFR_VERSION;
            if (Trace.isOn) {
                Trace.trace(clsName, "Attempting to load auxiliary library " + string);
            }
            PrivilegedAction privilegedAction = new PrivilegedAction(){

                public Object run() {
                    com.ibm.mq.MQSESSION.loadLib(string);
                    return null;
                }
            };
            AccessController.doPrivileged(privilegedAction);
            deferredLibLoaded = true;
        }
        if (Trace.isOn) {
            Trace.exit(clsName, "loadDefMsgLibrary");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void XAREGISTER(XAConnection xAConnection) throws MQException, SQLException, Exception {
        Exception exception = null;
        if (Trace.isOn) {
            Trace.entry(this, "XAREGISTER");
        }
        try {
            Object object;
            this.xaInvalidStateException = MQXAi.getInvalidStateException();
            if (this.useWorkerThread) {
                if (this.connThread == null) throw this.xaInvalidStateException;
                exception = this.connThread.XAREGISTER(xAConnection);
            } else {
                object = this.mqiLock;
                synchronized (object) {
                    exception = MQSESSION._XAREGISTER(xAConnection);
                }
            }
            if (exception == null) return;
            Trace.trace(this, "attempting to cast returned exception: " + exception);
            try {
                object = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("javax.transaction.xa.XAException");
                            return clazz;
                        }
                        catch (AccessControlException accessControlException) {
                            if (Trace.isOn) {
                                Trace.exceptionTrace(3, MQSESSION.clsName, accessControlException);
                            }
                            return null;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if (Trace.isOn) {
                                Trace.trace(MQSESSION.clsName, "javax.transaction.xa.XAException class not found");
                            }
                            return null;
                        }
                    }
                });
            }
            catch (Exception exception2) {
                object = null;
            }
            if (exception instanceof MQException) {
                throw (MQException)exception;
            }
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            if (object != null && ((Class)object).isInstance(exception)) {
                throw exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            Trace.trace(this, "internal error: XAREGISTER method wasn't coded to cope with exception: " + exception);
            throw new MQException(2, 2195, this);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "XAREGISTER");
            }
        }
    }

    protected static Exception _XAREGISTER(XAConnection xAConnection) {
        try {
            XAtoJTA.registerResource(xAConnection);
        }
        catch (Exception exception) {
            return exception;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deregisterResource(XAConnection xAConnection) throws Exception {
        Exception exception = null;
        if (Trace.isOn) {
            Trace.entry(this, "deregisterResource");
        }
        try {
            this.xaInvalidStateException = MQXAi.getInvalidStateException();
            if (this.useWorkerThread) {
                if (this.connThread == null) throw this.xaInvalidStateException;
                exception = this.connThread.deregisterResource(xAConnection);
            } else {
                Object object = this.mqiLock;
                synchronized (object) {
                    exception = MQSESSION._deregisterResource(xAConnection);
                }
            }
            if (exception == null) return;
            throw exception;
        }
        catch (MQException mQException) {
            Trace.trace(this, "throwing " + mQException);
            throw mQException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "deregisterResource");
            }
        }
    }

    protected static Exception _deregisterResource(XAConnection xAConnection) {
        Exception exception = null;
        try {
            XAtoJTA.deregisterResource(xAConnection);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int XAOPEN(String string, int n, int n2) throws Exception {
        int n3;
        block12: {
            n3 = -1;
            if (Trace.isOn) {
                Trace.entry(this, "XAOPEN");
            }
            try {
                this.xaInvalidStateException = MQXAi.getInvalidStateException();
                if (this.useWorkerThread) {
                    if (this.connThread != null) {
                        n3 = this.connThread.XAOPEN(string, n, n2);
                        this.inUseByXA = true;
                        break block12;
                    }
                    throw this.xaInvalidStateException;
                }
                Object object = this.mqiLock;
                synchronized (object) {
                    n3 = MQSESSION._XAOPEN(string, n, n2);
                }
            }
            catch (Exception exception) {
                Trace.trace(this, "throwing " + exception);
                throw exception;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "XAOPEN");
                }
            }
        }
        return n3;
    }

    protected static int _XAOPEN(String string, int n, int n2) {
        return MQXAi.xa_open(string, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int XACLOSE(String string, int n, int n2) throws Exception {
        int n3;
        block14: {
            n3 = -1;
            if (Trace.isOn) {
                Trace.entry(this, "XACLOSE");
            }
            try {
                if (this.useWorkerThread) {
                    if (this.connThread != null) {
                        n3 = this.connThread.XACLOSE(string, n, n2);
                        if (n3 == 0) {
                            this.inUseByXA = false;
                            if (!this.inUseByQM) {
                                Trace.trace(this, "XACLOSE stopping worker thread");
                                this.connThread.STOPTHREAD();
                                this.connThread = null;
                            }
                        }
                        break block14;
                    }
                    throw this.xaInvalidStateException;
                }
                Object object = this.mqiLock;
                synchronized (object) {
                    n3 = MQSESSION._XACLOSE(string, n, n2);
                }
            }
            catch (Exception exception) {
                Trace.trace(this, "throwing " + exception);
                throw exception;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "XACLOSE");
                }
            }
        }
        return n3;
    }

    protected static int _XACLOSE(String string, int n, int n2) {
        return MQXAi.xa_close(string, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int XASTART(Xid xid, int n, int n2) throws Exception {
        int n3;
        block12: {
            n3 = -1;
            if (Trace.isOn) {
                Trace.entry(this, "XASTART");
            }
            try {
                if (this.useWorkerThread) {
                    if (this.connThread != null) {
                        n3 = this.connThread.XASTART(xid, n, n2);
                        break block12;
                    }
                    throw this.xaInvalidStateException;
                }
                Object object = this.mqiLock;
                synchronized (object) {
                    n3 = MQSESSION._XASTART(xid, n, n2);
                }
            }
            catch (Exception exception) {
                Trace.trace(this, "throwing " + exception);
                throw exception;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "XASTART");
                }
            }
        }
        return n3;
    }

    protected static int _XASTART(Xid xid, int n, int n2) {
        return MQXAi.xa_start(xid, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int XAEND(Xid xid, int n, int n2) throws Exception {
        int n3;
        block12: {
            n3 = -1;
            if (Trace.isOn) {
                Trace.entry(this, "XAEND");
            }
            try {
                if (this.useWorkerThread) {
                    if (this.connThread != null) {
                        n3 = this.connThread.XAEND(xid, n, n2);
                        break block12;
                    }
                    throw this.xaInvalidStateException;
                }
                Object object = this.mqiLock;
                synchronized (object) {
                    n3 = MQSESSION._XAEND(xid, n, n2);
                }
            }
            catch (Exception exception) {
                Trace.trace(this, "throwing " + exception);
                throw exception;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "XAEND");
                }
            }
        }
        return n3;
    }

    protected static int _XAEND(Xid xid, int n, int n2) {
        return MQXAi.xa_end(xid, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int XAPREPARE(Xid xid, int n, int n2) throws Exception {
        int n3;
        block12: {
            n3 = -1;
            if (Trace.isOn) {
                Trace.entry(this, "XAPREPARE");
            }
            try {
                if (this.useWorkerThread) {
                    if (this.connThread != null) {
                        n3 = this.connThread.XAPREPARE(xid, n, n2);
                        break block12;
                    }
                    throw this.xaInvalidStateException;
                }
                Object object = this.mqiLock;
                synchronized (object) {
                    n3 = MQSESSION._XAPREPARE(xid, n, n2);
                }
            }
            catch (Exception exception) {
                Trace.trace(this, "throwing " + exception);
                throw exception;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "XAPREPARE");
                }
            }
        }
        return n3;
    }

    protected static int _XAPREPARE(Xid xid, int n, int n2) {
        return MQXAi.xa_prepare(xid, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int XACOMMIT(Xid xid, int n, int n2) throws Exception {
        int n3;
        block12: {
            n3 = -1;
            if (Trace.isOn) {
                Trace.entry(this, "XACOMMIT");
            }
            try {
                if (this.useWorkerThread) {
                    if (this.connThread != null) {
                        n3 = this.connThread.XACOMMIT(xid, n, n2);
                        break block12;
                    }
                    throw this.xaInvalidStateException;
                }
                Object object = this.mqiLock;
                synchronized (object) {
                    n3 = MQSESSION._XACOMMIT(xid, n, n2);
                }
            }
            catch (Exception exception) {
                Trace.trace(this, "throwing " + exception);
                throw exception;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "XACOMMIT");
                }
            }
        }
        return n3;
    }

    protected static int _XACOMMIT(Xid xid, int n, int n2) {
        return MQXAi.xa_commit(xid, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int XAROLLBACK(Xid xid, int n, int n2) throws Exception {
        int n3;
        block12: {
            n3 = -1;
            if (Trace.isOn) {
                Trace.entry(this, "XAROLLBACK");
            }
            try {
                if (this.useWorkerThread) {
                    if (this.connThread != null) {
                        n3 = this.connThread.XAROLLBACK(xid, n, n2);
                        break block12;
                    }
                    throw this.xaInvalidStateException;
                }
                Object object = this.mqiLock;
                synchronized (object) {
                    n3 = MQSESSION._XAROLLBACK(xid, n, n2);
                }
            }
            catch (Exception exception) {
                Trace.trace(this, "throwing " + exception);
                throw exception;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "XAROLLBACK");
                }
            }
        }
        return n3;
    }

    protected static int _XAROLLBACK(Xid xid, int n, int n2) {
        return MQXAi.xa_rollback(xid, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int XAFORGET(Xid xid, int n, int n2) throws Exception {
        int n3;
        block12: {
            n3 = -1;
            if (Trace.isOn) {
                Trace.entry(this, "XAFORGET");
            }
            try {
                if (this.useWorkerThread) {
                    if (this.connThread != null) {
                        n3 = this.connThread.XAFORGET(xid, n, n2);
                        break block12;
                    }
                    throw this.xaInvalidStateException;
                }
                Object object = this.mqiLock;
                synchronized (object) {
                    n3 = MQSESSION._XAFORGET(xid, n, n2);
                }
            }
            catch (Exception exception) {
                Trace.trace(this, "throwing " + exception);
                throw exception;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "XAFORGET");
                }
            }
        }
        return n3;
    }

    protected static int _XAFORGET(Xid xid, int n, int n2) {
        return MQXAi.xa_forget(xid, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int XARECOVER(Xid[] xidArray, int n, int n2) throws Exception {
        int n3;
        block12: {
            n3 = -1;
            if (Trace.isOn) {
                Trace.entry(this, "XARECOVER");
            }
            try {
                if (this.useWorkerThread) {
                    if (this.connThread != null) {
                        n3 = this.connThread.XARECOVER(xidArray, n, n2);
                        break block12;
                    }
                    throw this.xaInvalidStateException;
                }
                Object object = this.mqiLock;
                synchronized (object) {
                    n3 = MQSESSION._XARECOVER(xidArray, n, n2);
                }
            }
            catch (Exception exception) {
                Trace.trace(this, "throwing " + exception);
                throw exception;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "XARECOVER");
                }
            }
        }
        return n3;
    }

    protected static int _XARECOVER(Xid[] xidArray, int n, int n2) {
        return MQXAi.xa_recover(xidArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQBACK(int n, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "MQBACK");
            Trace.trace(2, this, "Connection handle = " + n);
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.MQBACK(n, pint, pint2);
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._MQBACK(n, pint, pint2);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint.x = 2195;
                pint2.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQBACK");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQBEGIN(int n, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "MQBEGIN");
            Trace.trace(2, this, "Conn Handle = " + n);
        }
        int n2 = 0;
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.MQBEGIN(n, n2, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                MQSESSION._MQBEGINWrapper(n, n2, pint, pint2);
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQBEGIN");
        }
    }

    static void _MQBEGINWrapper(int n, int n2, Pint pint, Pint pint2) {
        XAtoJTA.resetRC();
        try {
            MQSESSION._MQBEGIN(n, n2, pint, pint2);
        }
        catch (MQInternalException mQInternalException) {
            Trace.exceptionTrace(2, null, mQInternalException);
            pint.x = 2;
            pint2.x = 2195;
        }
        catch (RuntimeException runtimeException) {
            Trace.exceptionTrace(2, null, runtimeException);
            throw runtimeException;
        }
        int n3 = XAtoJTA.getRC();
        if (n3 != 0) {
            Trace.trace(clsName, "overriding reason code from " + pint2.x + " to " + n3);
            pint.x = 2;
            pint2.x = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQCONNX(String string, MQConnectionOptions mQConnectionOptions, Pint pint, Pint pint2, Pint pint3, Pthrowable pthrowable) {
        Object object;
        boolean bl = false;
        if (Trace.isOn) {
            Trace.entry(this, "MQCONNX");
            Trace.trace(2, this, sccsid);
            if (string != null) {
                Trace.trace(1, this, "Queue Manager = '" + string + "'");
            } else {
                Trace.trace(1, this, "Connecting to default queue manager");
            }
            Trace.trace(2, this, "MQCNO version is:" + mQConnectionOptions.getVersion());
            Trace.trace(2, this, "Connection options are: " + mQConnectionOptions.getOptions());
            if (mQConnectionOptions.getConnTag() != null) {
                Trace.trace(2, this, "ConnTag is: " + new String(mQConnectionOptions.getConnTag()));
            }
        }
        if (!this.useWorkerThread && this.multiThreaded) {
            try {
                object = this.mqiLock;
                synchronized (object) {
                    mQConnectionOptions.setOptions(mQConnectionOptions.getOptions() | 0x80);
                    if (Trace.isOn) {
                        Trace.trace(2, this, "Calling _MQCONNX with added option MQCNO_HANDLE_SHARE_NO_BLOCK");
                    }
                    MQSESSION._MQCONNX(string, mQConnectionOptions, pint, pint2, pint3);
                }
                if (pint2.x == 2 && pint3.x == 2046) {
                    if (Trace.isOn) {
                        Trace.trace(2, this, "Call to _MQCONNX failed with reason code 2046");
                    }
                    this.useWorkerThread = true;
                } else {
                    bl = true;
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint2.x = 2195;
                pint3.x = 2;
                bl = true;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        if (!bl) {
            mQConnectionOptions.setOptions(mQConnectionOptions.getOptions() & 0xFFFFFF7F);
            if (this.useWorkerThread) {
                this.connThread = new MQThread();
                if (this.connThread != null) {
                    if (Trace.isOn) {
                        Trace.trace(2, this, "Calling Thread.MQCONNX()");
                    }
                    this.connThread.MQCONNX(string, mQConnectionOptions, pint, pint2, pint3);
                    if (pint2.x != 0 && pint2.x != 1) {
                        if (Trace.isOn) {
                            Trace.trace(2, this, "Call to Thread.MQCONNX() failed with reason code " + pint3.x);
                        }
                        this.connThread.STOPTHREAD();
                    }
                } else {
                    Trace.trace(1, this, "WARNING: connThread==null");
                    pint.x = -1;
                    pint2.x = 2;
                    pint3.x = 2195;
                }
                this.inUseByQM = true;
            } else {
                try {
                    object = this.mqiLock;
                    synchronized (object) {
                        MQSESSION._MQCONNX(string, mQConnectionOptions, pint, pint2, pint3);
                    }
                }
                catch (MQInternalException mQInternalException) {
                    Trace.exceptionTrace(2, this, mQInternalException);
                    pint2.x = 2195;
                    pint3.x = 2;
                }
                catch (RuntimeException runtimeException) {
                    Trace.exceptionTrace(2, this, runtimeException);
                    throw runtimeException;
                }
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "MQCONNX returning hConn " + pint.x);
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQCONNX");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQCLOSE(int n, Pint pint, int n2, Pint pint2, Pint pint3) {
        if (Trace.isOn) {
            Trace.entry(this, "MQCLOSE");
            Trace.trace(2, this, "Conn Handle = " + n + " Object Handle = " + pint.x);
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.MQCLOSE(n, pint, n2, pint2, pint3);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint2.x = 2;
                pint3.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._MQCLOSE(n, pint, n2, pint2, pint3);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint2.x = 2195;
                pint3.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQCLOSE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQCMIT(int n, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "MQCMIT");
            Trace.trace(2, this, "Handle = " + n);
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.MQCMIT(n, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._MQCMIT(n, pint, pint2);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint.x = 2195;
                pint2.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQCMIT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQCONN(String string, Pint pint, Pint pint2, Pint pint3, Pthrowable pthrowable) {
        Object object;
        boolean bl = false;
        if (Trace.isOn) {
            Trace.entry(this, "MQCONN");
            Trace.trace(2, this, sccsid);
            if (string != null) {
                Trace.trace(1, this, "Queue Manager = '" + string + "'");
            } else {
                Trace.trace(1, this, "Connecting to default queue manager");
            }
        }
        if (!this.useWorkerThread && this.multiThreaded) {
            try {
                object = this.mqiLock;
                synchronized (object) {
                    MQConnectionOptions mQConnectionOptions = new MQConnectionOptions();
                    mQConnectionOptions.setOptions(128);
                    MQSESSION._MQCONNX(string, mQConnectionOptions, pint, pint2, pint3);
                }
                if (pint2.x == 2 && pint3.x == 2046) {
                    this.useWorkerThread = true;
                } else {
                    bl = true;
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint2.x = 2195;
                pint3.x = 2;
                bl = true;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        if (!bl) {
            if (this.useWorkerThread) {
                this.connThread = new MQThread();
                if (this.connThread != null) {
                    this.connThread.MQCONN(string, pint, pint2, pint3);
                    if (pint2.x != 0 && pint2.x != 1) {
                        this.connThread.STOPTHREAD();
                    }
                } else {
                    Trace.trace(1, this, "WARNING: connThread==null");
                    pint.x = -1;
                    pint2.x = 2;
                    pint3.x = 2195;
                }
                this.inUseByQM = true;
            } else {
                try {
                    object = this.mqiLock;
                    synchronized (object) {
                        MQSESSION._MQCONN(string, pint, pint2, pint3);
                    }
                }
                catch (MQInternalException mQInternalException) {
                    Trace.exceptionTrace(2, this, mQInternalException);
                    pint2.x = 2195;
                    pint3.x = 2;
                }
                catch (RuntimeException runtimeException) {
                    Trace.exceptionTrace(2, this, runtimeException);
                    throw runtimeException;
                }
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "MQCONN returning hConn " + pint.x);
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQCONN");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQDISC(Pint pint, Pint pint2, Pint pint3) {
        if (Trace.isOn) {
            Trace.entry(this, "MQDISC");
            Trace.trace(1, this, "Handle = " + pint.x);
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                int n = pint.x;
                this.connThread.MQDISC(pint, pint2, pint3);
                if (pint2.x == 0) {
                    this.inUseByQM = false;
                    if (!this.inUseByXA) {
                        Trace.trace(this, "MQDISC stopping worker thread");
                        this.connThread.STOPTHREAD();
                        this.connThread = null;
                    }
                } else if (pint2.x == 2 && pint3.x == 2009) {
                    if (Trace.isOn) {
                        Trace.trace(this, "conn broken, killing thread");
                    }
                    this.inUseByQM = false;
                    this.connThread.STOPTHREAD();
                    this.connThread = null;
                }
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint2.x = 2;
                pint3.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._MQDISC(pint, pint2, pint3);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint2.x = 2195;
                pint3.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQDISC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQGET(int n, int n2, MQMD mQMD, MQGetMessageOptions mQGetMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2, Pint pint3) {
        if (Trace.isOn) {
            Trace.entry(this, "MQGET");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        if (mQMD == null) {
            pint2.x = 2;
            pint3.x = 2026;
            Trace.exit(this, "MQGET (null message descriptor)");
            return;
        }
        if (mQGetMessageOptions == null) {
            pint2.x = 2;
            pint3.x = 2186;
            Trace.exit(this, "MQGET (null get message options)");
            return;
        }
        if (byArray == null) {
            pint2.x = 2;
            pint3.x = 2004;
            Trace.exit(this, "MQGET (null message buffer)");
            return;
        }
        if (n3 > byArray.length) {
            pint2.x = 2;
            pint3.x = 2005;
            Trace.exit(this, "MQGET (buffer too small)");
            return;
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.MQGET(n, n2, mQMD, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint2.x = 2;
                pint3.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._MQGET(n, n2, mQMD, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint2.x = 2195;
                pint3.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQGET");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQGET(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2, Pint pint3) {
        if (Trace.isOn) {
            Trace.entry(this, "MQGET (MQMsg2)");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        if (mQMsg2 == null) {
            pint2.x = 2;
            pint3.x = 2026;
            Trace.exit(this, "MQGET (MQMsg2) (null message descriptor)");
            return;
        }
        if (mQGetMessageOptions == null) {
            pint2.x = 2;
            pint3.x = 2186;
            Trace.exit(this, "MQGET (MQMsg2) (null get message options)");
            return;
        }
        if (byArray == null) {
            pint2.x = 2;
            pint3.x = 2004;
            Trace.exit(this, "MQGET (MQMsg2) (null message buffer)");
            return;
        }
        if (n3 > byArray.length) {
            pint2.x = 2;
            pint3.x = 2005;
            Trace.exit(this, "MQGET (MQMsg2) (buffer too small)");
            return;
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.MQGET(n, n2, mQMsg2, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint2.x = 2;
                pint3.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._MQGETMSG2(n, n2, mQMsg2, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint2.x = 2195;
                pint3.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQGET (MQMsg2)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQINQ(int n, int n2, int n3, int[] nArray, int n4, int[] nArray2, int n5, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "MQINQ");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        if (nArray == null) {
            pint.x = 2;
            pint2.x = 2067;
            Trace.exit(this, "MQINQ (null selectors array)");
            return;
        }
        if (nArray.length < n3) {
            pint.x = 2;
            pint2.x = 2065;
            Trace.exit(this, "MQINQ (selector array too small)");
            return;
        }
        if (nArray2 == null && n4 != 0) {
            pint.x = 2;
            pint2.x = 2021;
            Trace.exit(this, "MQINQ (null integer attributes array)");
            return;
        }
        if (nArray2 != null && nArray2.length < n4) {
            pint.x = 2;
            pint2.x = 2021;
            Trace.exit(this, "MQINQ (integer attributes array too small)");
            return;
        }
        if (byArray == null && n5 != 0) {
            pint.x = 2;
            pint2.x = 2006;
            Trace.exit(this, "MQINQ (null characters array)");
            return;
        }
        if (byArray != null && byArray.length < n5) {
            pint.x = 2;
            pint2.x = 2006;
            Trace.exit(this, "MQINQ (characters array too small)");
            return;
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.MQINQ(n, n2, n3, nArray, n4, nArray2, n5, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._MQINQ(n, n2, n3, nArray, n4, nArray2, n5, byArray, pint, pint2);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint.x = 2195;
                pint2.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQINQ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String MQINQ(int n, int n2, int n3, int n4, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "MQINQ(String)");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        String string = null;
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                string = this.connThread.MQINQ(n, n2, n3, n4, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    string = MQSESSION._MQINQ(n, n2, n3, n4, pint, pint2);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint.x = 2195;
                pint2.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQINQ(String)");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQOPEN(int n, MQOD mQOD, int n2, Pint pint, Pint pint2, Pint pint3) {
        if (Trace.isOn) {
            Trace.entry(this, "MQOPEN");
            Trace.trace(2, this, "hConn = " + n);
        }
        if (mQOD == null) {
            pint.x = -1;
            pint2.x = 2;
            pint3.x = 2044;
            return;
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.MQOPEN(n, mQOD, n2, pint, pint2, pint3);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = -1;
                pint2.x = 2;
                pint3.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._MQOPEN(n, mQOD, n2, pint, pint2, pint3);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint2.x = 2195;
                pint3.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        mQOD.updateDistributionListItems();
        if (Trace.isOn) {
            Trace.trace(2, this, "MQOPEN returning hObj " + pint.x);
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQOPEN");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQPUT(int n, int n2, MQMD mQMD, MQPutMessageOptions mQPutMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "MQPUT");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        if (byArray == null) {
            pint.x = 2;
            pint2.x = 2004;
            Trace.exit(this, "MQPUT (null message buffer)");
            return;
        }
        if (n3 > byArray.length) {
            pint.x = 2;
            pint2.x = 2005;
            Trace.exit(this, "MQPUT (buffer too small)");
            return;
        }
        if (mQMD == null) {
            pint.x = 2;
            pint2.x = 2026;
            Trace.exit(this, "MQPUT (null message descriptor)");
            return;
        }
        if (mQPutMessageOptions == null) {
            pint.x = 2;
            pint2.x = 2173;
            Trace.exit(this, "MQPUT (null put message options)");
            return;
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.MQPUT(n, n2, mQMD, mQPutMessageOptions, n3, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._MQPUT(n, n2, mQMD, mQPutMessageOptions, n3, byArray, pint, pint2);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint.x = 2195;
                pint2.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        mQPutMessageOptions.updateDistributionListItems();
        this.updateDestinationCounts(mQPutMessageOptions, pint, pint2);
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQPUT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQPUT(int n, int n2, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "MQPUT (MQMsg2)");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        if (mQMsg2 == null) {
            pint.x = 2;
            pint2.x = 2026;
            Trace.exit(this, "MQPUT (MQMsg2) (null message descriptor)");
            return;
        }
        if (mQPutMessageOptions == null) {
            pint.x = 2;
            pint2.x = 2173;
            Trace.exit(this, "MQPUT (MQMsg2) (null put message options)");
            return;
        }
        if (byArray == null) {
            pint.x = 2;
            pint2.x = 2004;
            Trace.exit(this, "MQPUT (MQMsg2) (null message buffer)");
            return;
        }
        if (n3 > byArray.length) {
            pint.x = 2;
            pint2.x = 2005;
            Trace.exit(this, "MQPUT (MQMsg2) (buffer too small)");
            return;
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.MQPUT(n, n2, mQMsg2, mQPutMessageOptions, n3, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._MQPUTMSG2(n, n2, mQMsg2, mQPutMessageOptions, n3, byArray, pint, pint2);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint.x = 2195;
                pint2.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        mQPutMessageOptions.updateDistributionListItems();
        this.updateDestinationCounts(mQPutMessageOptions, pint, pint2);
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQPUT (MQMsg2)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQPUT1(int n, MQOD mQOD, MQMD mQMD, MQPutMessageOptions mQPutMessageOptions, int n2, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "MQPUT1");
            Trace.trace(2, this, "hConn = " + n);
        }
        if (byArray == null) {
            pint.x = 2;
            pint2.x = 2004;
            Trace.exit(this, "MQPUT1 (buffer was null)");
            return;
        }
        if (n2 > byArray.length) {
            pint.x = 2;
            pint2.x = 2005;
            Trace.exit(this, "MQPUT1 (buffer too small)");
            return;
        }
        if (mQOD == null) {
            pint.x = 2;
            pint2.x = 2044;
            Trace.exit(this, "MQPUT1 (obj descriptor was null)");
            return;
        }
        if (mQMD == null) {
            pint.x = 2;
            pint2.x = 2026;
            Trace.exit(this, "MQPUT1 (msg descriptor was null)");
            return;
        }
        if (mQPutMessageOptions == null) {
            pint.x = 2;
            pint2.x = 2173;
            Trace.exit(this, "MQPUT1 (put msg options was null)");
            return;
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.MQPUT1(n, mQOD, mQMD, mQPutMessageOptions, n2, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._MQPUT1(n, mQOD, mQMD, mQPutMessageOptions, n2, byArray, pint, pint2);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint.x = 2195;
                pint2.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        mQPutMessageOptions.updateDistributionListItems();
        this.updateDestinationCounts(mQPutMessageOptions, pint, pint2);
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQPUT1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQPUT1(int n, MQOD mQOD, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, int n2, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "MQPUT1 - MQMsg2 version");
            Trace.trace(2, this, "hConn = " + n);
        }
        if (byArray == null) {
            pint.x = 2;
            pint2.x = 2004;
            Trace.exit(this, "MQPUT1 - MQMsg2 (buffer was null)");
            return;
        }
        if (n2 > byArray.length) {
            pint.x = 2;
            pint2.x = 2005;
            Trace.exit(this, "MQPUT1 - MQMsg2 (buffer too small)");
            return;
        }
        if (mQOD == null) {
            pint.x = 2;
            pint2.x = 2044;
            Trace.exit(this, "MQPUT1 - MQMsg2 (obj descriptor was null)");
            return;
        }
        if (mQMsg2 == null) {
            pint.x = 2;
            pint2.x = 2026;
            Trace.exit(this, "MQPUT1 - MQMsg2 (msg descriptor was null)");
            return;
        }
        if (mQPutMessageOptions == null) {
            pint.x = 2;
            pint2.x = 2173;
            Trace.exit(this, "MQPUT1 - MQMsg2 (put msg options was null)");
            return;
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.MQPUT1(n, mQOD, mQMsg2, mQPutMessageOptions, n2, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._MQPUT1MSG2(n, mQOD, mQMsg2, mQPutMessageOptions, n2, byArray, pint, pint2);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint.x = 2195;
                pint2.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        mQPutMessageOptions.updateDistributionListItems();
        this.updateDestinationCounts(mQPutMessageOptions, pint, pint2);
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQPUT1 - MQMsg2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQSET(int n, int n2, int n3, int[] nArray, int n4, int[] nArray2, int n5, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "MQSET");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        if (nArray == null || nArray.length == 0) {
            pint.x = 2;
            pint2.x = 2067;
            Trace.exit(this, "MQSET (null selectors array)");
            return;
        }
        if (nArray.length < n3) {
            pint.x = 2;
            pint2.x = 2065;
            Trace.exit(this, "MQSET (selectors array too small)");
            return;
        }
        if (nArray2 == null && n4 != 0) {
            pint.x = 2;
            pint2.x = 2021;
            Trace.exit(this, "MQSET (null integer attributes array)");
            return;
        }
        if (nArray2 != null && nArray2.length < n4) {
            pint.x = 2;
            pint2.x = 2021;
            Trace.exit(this, "MQSET (integer attributes array too small)");
            return;
        }
        if (byArray == null && n5 != 0) {
            pint.x = 2;
            pint2.x = 2006;
            Trace.exit(this, "MQSET (null characters array)");
            return;
        }
        if (byArray != null && byArray.length < n5) {
            pint.x = 2;
            pint2.x = 2006;
            Trace.exit(this, "MQSET (character attributes array too small)");
            return;
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.MQSET(n, n2, n3, nArray, n4, nArray2, n5, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._MQSET(n, n2, n3, nArray, n4, nArray2, n5, byArray, pint, pint2);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint.x = 2195;
                pint2.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQSET");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQSET(int n, int n2, int n3, String string, int n4, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "MQSET (String)");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.MQSET(n, n2, n3, string, n4, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._MQSET(n, n2, n3, string, n4, pint, pint2);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint.x = 2195;
                pint2.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQSET(String)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void honourRRSInternal(int n, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "honourRRSInternal");
            Trace.trace(2, this, "hConn = " + n);
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.honourRRSInternal(n, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._honourRRSInternal(n, pint, pint2);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint.x = 2195;
                pint2.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "honourRRSInternal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spiConnect(String string, MQConnectionOptions mQConnectionOptions, Pint pint, Pint pint2, Pint pint3, Pthrowable pthrowable) {
        Object object;
        int n = 0;
        boolean bl = false;
        if (mQConnectionOptions == null) {
            mQConnectionOptions = new MQConnectionOptions();
        }
        if (Trace.isOn) {
            Trace.entry(this, "spiConnect");
            Trace.trace(2, this, sccsid);
            if (string != null) {
                Trace.trace(1, this, "Queue Manager = '" + string + "'");
            } else {
                Trace.trace(1, this, "Connecting to default queue manager");
            }
            Trace.trace(1, this, "MQCNO version is:" + mQConnectionOptions.getVersion());
            Trace.trace(1, this, "Connection options are: " + mQConnectionOptions.getOptions());
            if (mQConnectionOptions.getConnTag() != null) {
                Trace.trace(1, this, "ConnTag is: " + new String(mQConnectionOptions.getConnTag()));
            }
        }
        if (!this.useWorkerThread && this.multiThreaded) {
            object = this.mqiLock;
            synchronized (object) {
                try {
                    mQConnectionOptions.setOptions(mQConnectionOptions.getOptions() | 0x80);
                    if (Trace.isOn) {
                        Trace.trace(1, this, "Calling _spiConnect with added option MQCNO_HANDLE_SHARE_NO_BLOCK");
                    }
                    n = MQSESSION._spiConnect(string, mQConnectionOptions, pint, pint2, pint3);
                    if (pint2.x == 2 && pint3.x == 2046) {
                        if (Trace.isOn) {
                            Trace.trace(2, this, "Call to _spiConnect failed with reason code 2046");
                        }
                        this.useWorkerThread = true;
                    } else {
                        bl = true;
                    }
                }
                catch (MQInternalException mQInternalException) {
                    Trace.exceptionTrace(2, this, mQInternalException);
                    pint2.x = 2195;
                    pint3.x = 2;
                    bl = true;
                }
                catch (RuntimeException runtimeException) {
                    Trace.exceptionTrace(2, this, runtimeException);
                    throw runtimeException;
                }
            }
        }
        if (!bl) {
            mQConnectionOptions.setOptions(mQConnectionOptions.getOptions() & 0xFFFFFF7F);
            if (this.useWorkerThread) {
                this.connThread = new MQThread();
                if (this.connThread != null) {
                    if (Trace.isOn) {
                        Trace.trace(1, this, "Calling Thread.spiConnect()");
                    }
                    n = this.connThread.spiConnect(string, mQConnectionOptions, pint, pint2, pint3);
                    if (pint2.x != 0 && pint2.x != 1) {
                        if (Trace.isOn) {
                            Trace.trace(2, this, "Thread.spiConnect() failed with reason code" + pint3.x);
                        }
                        this.connThread.STOPTHREAD();
                    }
                } else {
                    Trace.trace(1, this, "WARNING: connThread==null");
                    pint.x = -1;
                    pint2.x = 2;
                    pint3.x = 2195;
                }
                this.inUseByQM = true;
            } else {
                try {
                    object = this.mqiLock;
                    synchronized (object) {
                        n = MQSESSION._spiConnect(string, mQConnectionOptions, pint, pint2, pint3);
                    }
                }
                catch (MQInternalException mQInternalException) {
                    Trace.exceptionTrace(2, this, mQInternalException);
                    pint2.x = 2195;
                    pint3.x = 2;
                }
                catch (RuntimeException runtimeException) {
                    Trace.exceptionTrace(2, this, runtimeException);
                    throw runtimeException;
                }
            }
        }
        this.spiSuppDeferred = n & true;
        boolean bl2 = this.spiSuppInherited = (n & 2) == 2;
        if (pint2.x == 0 && this.spiSuppDeferred) {
            MQSESSION.loadDefMsgLibrary();
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "spiConnect returning hConn " + pint.x);
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "spiConnect");
        }
    }

    public boolean spiSupportsInherited() {
        if (Trace.isOn) {
            Trace.entry(clsName, "spiSupportsInherited");
            Trace.exit(clsName, "spiSupportsInherited");
        }
        return this.spiSuppInherited;
    }

    public boolean spiSupportsDeferred() {
        if (Trace.isOn) {
            Trace.entry(clsName, "spiSupportsDeferred");
            Trace.exit(clsName, "spiSupportsDeferred");
        }
        return this.spiSuppDeferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spiDefPut(int n, int n2, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "spiDefPut");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        if (!this.spiSuppDeferred) {
            pint.x = 2;
            pint2.x = 2195;
            Trace.exit(this, "spiDefPut (Deferred messages not supported)");
        }
        if (mQMsg2 == null) {
            pint.x = 2;
            pint2.x = 2026;
            Trace.exit(this, "spiDefPut (null message descriptor)");
            return;
        }
        if (mQPutMessageOptions == null) {
            pint.x = 2;
            pint2.x = 2173;
            Trace.exit(this, "spiDefPut (null put message options)");
            return;
        }
        if (byArray == null) {
            pint.x = 2;
            pint2.x = 2004;
            Trace.exit(this, "spiDefPut (null message buffer)");
            return;
        }
        if (n3 > byArray.length) {
            pint.x = 2;
            pint2.x = 2005;
            Trace.exit(this, "spiDefPut (buffer too small)");
            return;
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.spiDefPut(n, n2, mQMsg2, mQPutMessageOptions, n3, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._spiDefPut(n, n2, mQMsg2, mQPutMessageOptions, n3, byArray, pint, pint2);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint.x = 2195;
                pint2.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        mQPutMessageOptions.updateDistributionListItems();
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "spiDefPut");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spiDefActivate(int n, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "spiDefActivate");
            Trace.trace(2, this, "hConn = " + n);
        }
        if (!this.spiSuppDeferred) {
            pint.x = 2;
            pint2.x = 2195;
            Trace.exit(this, "spiDefActivate (Deferred messages not supported)");
        }
        if (byArray == null || byArray.length != 24) {
            pint.x = 2;
            pint2.x = 2195;
            Trace.exit(this, "spiDefActivate - Unexpected error: bad msg id");
            return;
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.spiDefActivate(n, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._spiDefActivate(n, byArray, pint, pint2);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint.x = 2195;
                pint2.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "spiDefActivate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spiDefCancel(int n, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "spiDefCancel");
            Trace.trace(2, this, "hConn = " + n);
        }
        if (!this.spiSuppDeferred) {
            pint.x = 2;
            pint2.x = 2195;
            Trace.exit(this, "spiDefActivate (Deferred messages not supported)");
        }
        if (byArray == null || byArray.length != 24) {
            pint.x = 2;
            pint2.x = 2195;
            Trace.exit(this, "spiDefCancel - Unexpected error: bad msg id");
            return;
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.spiDefCancel(n, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._spiDefCancel(n, byArray, pint, pint2);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint.x = 2195;
                pint2.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "spiDefCancel");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void spiGet(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions, int n3, int n4, byte[] byArray, Pint pint, Pint pint2, Pint pint3) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "spiGet");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        if (!this.spiSuppInherited) {
            pint2.x = 2;
            pint3.x = 2195;
            Trace.exit(this, "spiGet (Inherited transactions not supported)");
        }
        if (mQMsg2 == null) {
            pint2.x = 2;
            pint3.x = 2026;
            Trace.exit(this, "spiGet (null message descriptor)");
            return;
        }
        if (mQGetMessageOptions == null) {
            pint2.x = 2;
            pint3.x = 2173;
            Trace.exit(this, "spiGet (null put message options)");
            return;
        }
        if (byArray == null) {
            pint2.x = 2;
            pint3.x = 2004;
            Trace.exit(this, "spiGet (null message buffer)");
            return;
        }
        if (n4 > byArray.length) {
            pint2.x = 2;
            pint3.x = 2005;
            Trace.exit(this, "spiGet (buffer too small)");
            return;
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.spiGet(n, n2, mQMsg2, mQGetMessageOptions, n3, n4, byArray, pint, pint2, pint3);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint2.x = 2;
                pint3.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._spiGet(n, n2, mQMsg2, mQGetMessageOptions, n3, n4, byArray, pint, pint2, pint3);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint2.x = 2195;
                pint3.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "spiGet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void spiPut(int n, int n2, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, int n3, int n4, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "spiPut");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        if (!this.spiSuppInherited) {
            pint.x = 2;
            pint2.x = 2195;
            Trace.exit(this, "spiPut (Inherited transactions not supported)");
            return;
        }
        if (mQMsg2 == null) {
            pint.x = 2;
            pint2.x = 2026;
            Trace.exit(this, "spiPut (null message descriptor)");
            return;
        }
        if (mQPutMessageOptions == null) {
            pint.x = 2;
            pint2.x = 2173;
            Trace.exit(this, "spiPut (null put message options)");
            return;
        }
        if (byArray == null) {
            pint.x = 2;
            pint2.x = 2004;
            Trace.exit(this, "spiPut (null message buffer)");
            return;
        }
        if (n4 > byArray.length) {
            pint.x = 2;
            pint2.x = 2005;
            Trace.exit(this, "spiPut (buffer too small)");
            return;
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.spiPut(n, n2, mQMsg2, mQPutMessageOptions, n3, n4, byArray, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._spiPut(n, n2, mQMsg2, mQPutMessageOptions, n3, n4, byArray, pint, pint2);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint.x = 2195;
                pint2.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        mQPutMessageOptions.updateDistributionListItems();
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "spiPut");
        }
    }

    public boolean authenticate(int n, String string, String string2, Pint pint, Pint pint2) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "authenticate");
            }
            if (string != null && !string.trim().equals("") && MQSESSION.getLibraryName().startsWith("wmqjrrs") && this.getAuthenticateBindings()) {
                Trace.trace(1, clsName, "Attempting authenticate in queue manager");
                boolean bl = MQSESSION._authenticate(n, string, string2, pint, pint2);
                if (pint2.x != 901) {
                    boolean bl2 = bl;
                    return bl2;
                }
                Trace.trace(1, clsName, "queue manager does not support authenticate...");
                Trace.trace(1, clsName, "Defaulting to dummy test");
                String string3 = string;
                String string4 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty("user.name");
                    }
                });
                if (!string4.equals(string3)) {
                    pint.x = 2;
                    pint2.x = 2035;
                    boolean bl3 = false;
                    return bl3;
                }
                pint.x = 0;
                pint2.x = 0;
                boolean bl4 = true;
                return bl4;
            }
            Trace.trace(1, clsName, "authenticate called outside WebSphere zOS, accepting.");
            pint.x = 0;
            pint2.x = 0;
            boolean bl = true;
            return bl;
        }
        catch (MQInternalException mQInternalException) {
            Trace.exceptionTrace(2, this, mQInternalException);
            pint.x = 2195;
            pint2.x = 2;
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException runtimeException) {
            Trace.exceptionTrace(2, this, runtimeException);
            throw runtimeException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "authenticate");
            }
        }
    }

    static native void _MQBACK(int var0, Pint var1, Pint var2) throws MQInternalException;

    static native void _MQCLOSE(int var0, Pint var1, int var2, Pint var3, Pint var4) throws MQInternalException;

    static native void _MQCMIT(int var0, Pint var1, Pint var2) throws MQInternalException;

    static native void _MQDISC(Pint var0, Pint var1, Pint var2) throws MQInternalException;

    static native void _MQGET(int var0, int var1, MQMD var2, MQGetMessageOptions var3, int var4, byte[] var5, Pint var6, Pint var7, Pint var8) throws MQInternalException;

    static native void _MQGETMSG2(int var0, int var1, MQMsg2 var2, MQGetMessageOptions var3, int var4, byte[] var5, Pint var6, Pint var7, Pint var8) throws MQInternalException;

    static native void _MQINQ(int var0, int var1, int var2, int[] var3, int var4, int[] var5, int var6, byte[] var7, Pint var8, Pint var9) throws MQInternalException;

    static native String _MQINQ(int var0, int var1, int var2, int var3, Pint var4, Pint var5) throws MQInternalException;

    static native void _MQOPEN(int var0, MQOD var1, int var2, Pint var3, Pint var4, Pint var5) throws MQInternalException;

    static native void _MQPUT(int var0, int var1, MQMD var2, MQPutMessageOptions var3, int var4, byte[] var5, Pint var6, Pint var7) throws MQInternalException;

    static native void _MQPUTMSG2(int var0, int var1, MQMsg2 var2, MQPutMessageOptions var3, int var4, byte[] var5, Pint var6, Pint var7) throws MQInternalException;

    static native void _MQPUT1(int var0, MQOD var1, MQMD var2, MQPutMessageOptions var3, int var4, byte[] var5, Pint var6, Pint var7) throws MQInternalException;

    static native void _MQPUT1MSG2(int var0, MQOD var1, MQMsg2 var2, MQPutMessageOptions var3, int var4, byte[] var5, Pint var6, Pint var7) throws MQInternalException;

    static native void _MQSET(int var0, int var1, int var2, int[] var3, int var4, int[] var5, int var6, byte[] var7, Pint var8, Pint var9) throws MQInternalException;

    static native void _MQSET(int var0, int var1, int var2, String var3, int var4, Pint var5, Pint var6) throws MQInternalException;

    static native void _MQCONNX(String var0, MQConnectionOptions var1, Pint var2, Pint var3, Pint var4) throws MQInternalException;

    static native void _MQBEGIN(int var0, int var1, Pint var2, Pint var3) throws MQInternalException;

    static synchronized native void _MQCONN(String var0, Pint var1, Pint var2, Pint var3) throws MQInternalException;

    static synchronized native boolean _authenticate(int var0, String var1, String var2, Pint var3, Pint var4) throws MQInternalException;

    private static native boolean init_conversion() throws MQInternalException;

    static native void _honourRRSInternal(int var0, Pint var1, Pint var2) throws MQInternalException;

    static native int _spiConnect(String var0, MQConnectionOptions var1, Pint var2, Pint var3, Pint var4) throws MQInternalException;

    static native void _spiDefPut(int var0, int var1, MQMsg2 var2, MQPutMessageOptions var3, int var4, byte[] var5, Pint var6, Pint var7) throws MQInternalException;

    static native void _spiDefActivate(int var0, byte[] var1, Pint var2, Pint var3) throws MQInternalException;

    static native void _spiDefCancel(int var0, byte[] var1, Pint var2, Pint var3) throws MQInternalException;

    static native void _spiGet(int var0, int var1, MQMsg2 var2, MQGetMessageOptions var3, int var4, int var5, byte[] var6, Pint var7, Pint var8, Pint var9) throws MQInternalException;

    static native void _spiPut(int var0, int var1, MQMsg2 var2, MQPutMessageOptions var3, int var4, int var5, byte[] var6, Pint var7, Pint var8) throws MQInternalException;

    static native void _spiAsyncCmit(int var0, Pint var1, Pint var2) throws MQInternalException;

    protected void resolveV2Support(int n, int n2, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "resolveV2Support");
            Trace.exit(this, "resolveV2Support");
        }
        this.v2SupportResolved = true;
        this.supportsQAT2 = zSeries;
    }

    public final boolean supportsV2Structures(int n) {
        if (this.v2SupportResolved) {
            if (Trace.isOn) {
                Trace.entry(this, "supportsV2Structures");
                Trace.trace(2, this, "supportsV2Structures returning true");
                Trace.exit(this, "supportsV2Structures");
            }
            return true;
        }
        if (Trace.isOn) {
            Trace.entry(this, "supportsV2Structures");
            Trace.exit(this, "supportsV2Structures (via exception)");
        }
        throw new IllegalStateException("Internal error: resolveV2Support not called");
    }

    protected void setThreadAccess(String string, Boolean bl) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "setThreadAccess");
        }
        if (bl != null && bl instanceof Boolean && bl.booleanValue()) {
            this.forceThreadAffinity = true;
        }
        if (string == null) {
            if (MQSESSION.getLibraryName().equals("wmqjcics")) {
                this.multiThreaded = false;
                Trace.trace(2, this, "Thread switch disabled (in CICS)");
            } else if (MQSESSION.getLibraryName().startsWith("wmqjrrs")) {
                this.multiThreaded = false;
                Trace.trace(2, this, "Thread switch disabled (using RRS adapter)");
            } else {
                this.multiThreaded = true;
                Trace.trace(2, this, "Thread switch enabled");
                if (zSeries) {
                    this.useWorkerThread = true;
                    Trace.trace(2, this, "Force worker thread (using mqi adapter on zSeries)");
                }
            }
        } else if (string.equals("MULTI_THREAD")) {
            if (MQSESSION.getLibraryName().equals("wmqjcics")) {
                Trace.trace(2, this, "Multi-threaded requested under CICS");
                Trace.exit(this, "setThreadAccess (via exception)");
                throw new MQException(2, 2012, this);
            }
            if (MQSESSION.getLibraryName().startsWith("wmqjrrs")) {
                this.multiThreaded = false;
                Trace.trace(2, this, "MULTI_THREAD ignored - using RRS adapter");
            } else {
                this.multiThreaded = true;
                Trace.trace(2, this, "Thread switch enabled");
                if (zSeries) {
                    this.useWorkerThread = true;
                    Trace.trace(2, this, "Force worker thread (using mqi adapter on zSeries)");
                }
            }
        } else if (string.equals("SINGLE_THREAD")) {
            this.multiThreaded = false;
            Trace.trace(2, this, "Thread switch disabled");
        } else {
            Trace.trace(2, this, "Unknown thread access mode specified");
            Trace.exit(this, "setThreadAccess (via exception)");
            throw new MQException(2, 2012, this);
        }
        if (this.multiThreaded && this.forceThreadAffinity) {
            this.useWorkerThread = true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "setThreadAccess");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spiAsyncCmit(int n, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "spiAsyncCmit");
            Trace.trace(this, "Handle = " + n);
        }
        if (!this.spiSuppInherited) {
            pint.x = 2;
            pint2.x = 2195;
            Trace.exit(this, "spiAsyncCmit (Inherited transactions not supported)");
        }
        if (this.useWorkerThread) {
            if (this.connThread != null) {
                this.connThread.spiAsyncCmit(n, pint, pint2);
            } else {
                Trace.trace(1, this, "WARNING: connThread==null");
                pint.x = 2;
                pint2.x = 2195;
            }
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    MQSESSION._spiAsyncCmit(n, pint, pint2);
                }
            }
            catch (MQInternalException mQInternalException) {
                Trace.exceptionTrace(2, this, mQInternalException);
                pint.x = 2195;
                pint2.x = 2;
            }
            catch (RuntimeException runtimeException) {
                Trace.exceptionTrace(2, this, runtimeException);
                throw runtimeException;
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "spiAsyncCmit");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.trace(clsName, sccsid);
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                com.ibm.mq.MQSESSION.loadLib(com.ibm.mq.MQSESSION.getLibraryPath() + MQSESSION.getLibraryName());
                return null;
            }
        });
        try {
            if (!MQSESSION.init_conversion()) {
                Trace.trace(1, clsName, "Failed to setup conversion");
            }
        }
        catch (MQInternalException mQInternalException) {
            Trace.exceptionTrace(2, null, mQInternalException);
        }
    }
}

