/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.MQXid;
import com.ibm.mqservices.Trace;
import java.lang.reflect.Constructor;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAtoJTA
implements ConnectionEventListener {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/XAtoJTA.java, java, j600, j600-202-070608 1.17.1.3 07/02/07 16:12:20";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String clsName = "XAtoJTA";
    private static final int INITIAL_BEGINRC = 2121;
    public static final int TMNOFLAGS = 0;
    public static final int XA_NOMIGRATE = 9;
    public static final int XA_HEURHAZ = 8;
    public static final int XA_HEURCOM = 7;
    public static final int XA_HEURRB = 6;
    public static final int XA_HEURMIX = 5;
    public static final int XA_RETRY = 4;
    public static final int XA_RDONLY = 3;
    public static final int XA_OK = 0;
    public static final int XAER_ASYNC = -2;
    public static final int XAER_RMERR = -3;
    private static Hashtable instancesByThread = new Hashtable(10);
    private static boolean useOra816;
    private Hashtable resourcesByRmid = new Hashtable(10);
    private Hashtable resourcesByConn = new Hashtable(10);
    private Hashtable spareRmids = new Hashtable();
    private Vector spareXAConns = new Stack();
    private Vector dirtyResources = new Vector();
    private int openCount = 0;
    private int openedResources = 0;
    private boolean inTransaction = false;
    private int beginRC;
    static /* synthetic */ Class array$B;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XAtoJTA() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "constructor");
                Trace.trace(this, sccsid);
            }
            instancesByThread.put(Thread.currentThread(), this);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "constructor");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(ConnectionEvent connectionEvent) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "connectionClosed");
                Trace.trace(this, "event is: " + connectionEvent);
            }
            if (useOra816) {
                if (Trace.isOn) {
                    Trace.trace(this, "ignoring event because useOra816 flag is set");
                }
            } else {
                XAConnection xAConnection = (XAConnection)connectionEvent.getSource();
                this._deregisterResource(xAConnection);
                xAConnection.close();
            }
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.trace(this, "ignoring " + exception);
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "connectionClosed");
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        if (Trace.isOn) {
            Trace.trace(this, "connectionErrorOccurred: " + connectionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XAtoJTA getInstance() {
        try {
            XAtoJTA xAtoJTA;
            if (Trace.isOn) {
                Trace.entry(clsName, "getInstance");
            }
            if ((xAtoJTA = (XAtoJTA)instancesByThread.get(Thread.currentThread())) == null) {
                xAtoJTA = new XAtoJTA();
            }
            XAtoJTA xAtoJTA2 = xAtoJTA;
            return xAtoJTA2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(clsName, "getInstance");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        try {
            XAConnection xAConnection;
            if (Trace.isOn) {
                Trace.entry(this, "close");
            }
            Enumeration<Object> enumeration = this.spareXAConns.elements();
            while (enumeration.hasMoreElements()) {
                block13: {
                    xAConnection = (XAConnection)enumeration.nextElement();
                    try {
                        xAConnection.removeConnectionEventListener(this);
                    }
                    catch (Exception exception) {
                        if (!Trace.isOn) break block13;
                        Trace.trace(this, "error whilst deregistering as connection event listener: " + exception);
                    }
                }
                try {
                    xAConnection.close();
                }
                catch (SQLException sQLException) {
                    if (!Trace.isOn) continue;
                    Trace.trace(this, "trying to close JDBC connection, ignoring " + sQLException);
                }
            }
            enumeration = this.resourcesByConn.keys();
            while (enumeration.hasMoreElements()) {
                xAConnection = (XAConnection)enumeration.nextElement();
                try {
                    xAConnection.close();
                }
                catch (SQLException sQLException) {
                    if (!Trace.isOn) continue;
                    Trace.trace(this, "trying to close JDBC connection, ignoring " + sQLException);
                }
            }
            this.spareRmids.clear();
            this.spareXAConns.removeAllElements();
            this.dirtyResources.removeAllElements();
            this.resourcesByRmid.clear();
            this.resourcesByConn.clear();
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "close");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Connection helpGetConnection(XADataSource xADataSource, String string, String string2, MQSESSION mQSESSION) throws SQLException, MQException, Exception {
        try {
            if (Trace.isOn) {
                Trace.entry(clsName, "helpGetConnection");
            }
            Trace.trace(clsName, "userid=" + string);
            if (string2 != null) {
                Trace.trace(clsName, "password is not-null");
                Trace.trace(clsName, "password length=" + string2.length());
            } else {
                Trace.trace(clsName, "password is null");
            }
            XAConnection xAConnection = string != null ? xADataSource.getXAConnection(string, string2) : xADataSource.getXAConnection();
            mQSESSION.XAREGISTER(xAConnection);
            Connection connection = xAConnection.getConnection();
            return connection;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(clsName, "helpGetConnection");
            }
        }
    }

    public static void registerResource(XAConnection xAConnection) throws MQException, SQLException, XAException {
        try {
            if (Trace.isOn) {
                Trace.entry(clsName, "registerResource");
            }
            XAtoJTA xAtoJTA = XAtoJTA.getInstance();
            xAtoJTA._registerResource(xAConnection);
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.trace(clsName, "throwing " + mQException);
            }
            throw mQException;
        }
        catch (SQLException sQLException) {
            if (Trace.isOn) {
                Trace.trace(clsName, "throwing " + sQLException);
            }
            throw sQLException;
        }
        catch (XAException xAException) {
            if (Trace.isOn) {
                Trace.trace(clsName, "throwing " + xAException);
            }
            throw xAException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(clsName, "registerResource");
            }
        }
    }

    public static void deregisterResource(XAConnection xAConnection) throws XAException {
        try {
            if (Trace.isOn) {
                Trace.entry(clsName, "deregisterResource");
            }
            XAtoJTA xAtoJTA = XAtoJTA.getInstance();
            xAtoJTA._deregisterResource(xAConnection);
            return;
        }
        catch (XAException xAException) {
            if (Trace.isOn) {
                Trace.trace(clsName, "throwing " + xAException);
            }
            throw xAException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(clsName, "deregisterResource");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetRC() {
        try {
            if (Trace.isOn) {
                Trace.entry(clsName, "resetRC");
            }
            XAtoJTA xAtoJTA = XAtoJTA.getInstance();
            xAtoJTA._resetRC();
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(clsName, "resetRC");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRC() {
        try {
            if (Trace.isOn) {
                Trace.entry(clsName, "getRC");
            }
            XAtoJTA xAtoJTA = XAtoJTA.getInstance();
            int n = xAtoJTA._getRC();
            return n;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(clsName, "getRC");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized int XAOpen(String string, int n, int n2, int n3) {
        try {
            XAtoJTA xAtoJTA;
            if (Trace.isOn) {
                Trace.entry(clsName, "XAOpen");
                Trace.trace(clsName, "open string '" + string + "', rmid " + n);
            }
            if ((xAtoJTA = XAtoJTA.getInstance()) == null) {
                int n4 = -3;
                return n4;
            }
            int n5 = xAtoJTA.xa_open(n, n2);
            return n5;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(clsName, "XAOpen");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized int XAClose(String string, int n, int n2) {
        try {
            XAtoJTA xAtoJTA;
            if (Trace.isOn) {
                Trace.entry(clsName, "XAClose");
                Trace.trace(clsName, "close string '" + string + "', rmid " + n);
            }
            if ((xAtoJTA = XAtoJTA.getInstance()) == null) {
                int n3 = -3;
                return n3;
            }
            int n4 = xAtoJTA.xa_close(n, n2);
            return n4;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(clsName, "XAClose");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized int XAStart(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        try {
            XAtoJTA xAtoJTA;
            if (Trace.isOn) {
                Trace.entry(clsName, "XAStart");
            }
            if ((xAtoJTA = XAtoJTA.getInstance()) == null) {
                int n4 = -3;
                return n4;
            }
            int n5 = xAtoJTA.xa_start(byArray, byArray2, n, n2, n3);
            return n5;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(clsName, "XAStart");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int XAEnd(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        try {
            XAtoJTA xAtoJTA;
            if (Trace.isOn) {
                Trace.entry(clsName, "XAEnd");
            }
            if ((xAtoJTA = XAtoJTA.getInstance()) == null) {
                int n4 = -3;
                return n4;
            }
            int n5 = xAtoJTA.xa_end(byArray, byArray2, n, n2, n3);
            return n5;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(clsName, "XAEnd");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int xa_open(int n, int n2) {
        if (Trace.isOn) {
            Trace.entry(this, "xa_open");
        }
        int n3 = -3;
        try {
            ++this.openCount;
            if (Trace.isOn) {
                Trace.trace(this, "open count is now " + this.openCount);
            }
            Integer n4 = new Integer(n);
            RR rR = new RR();
            rR.rmId = n4;
            this.spareRmids.put(n4, rR);
            n3 = 0;
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.trace(this, "failed with " + exception);
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "xa_open");
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int xa_close(int n, int n2) {
        int n3 = -3;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "xa_close");
            }
            Integer n4 = new Integer(n);
            this.close();
            --this.openCount;
            n3 = 0;
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.trace(this, "caught " + exception);
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "xa_close");
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int xa_start(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4 = -3;
        try {
            Xid xid;
            Object object;
            if (Trace.isOn) {
                Trace.entry(this, "xa_start");
                Trace.trace(this, "XAStart: rmid is " + n2);
            }
            if (this.beginRC == 2121) {
                if (Trace.isOn) {
                    Trace.trace(this, "resetting beginRc to MQRC_NONE");
                }
                this.beginRC = 0;
            }
            if (!this.inTransaction && this.spareXAConns.size() > this.spareRmids.size()) {
                if (Trace.isOn) {
                    Trace.trace(this, "not enough rmids for registered connections");
                }
                this.beginRC = 2372;
                int n5 = -3;
                return n5;
            }
            if (n3 != 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "unexpected value of flags: " + n3 + ", returning RMERR");
                }
                int n6 = -3;
                return n6;
            }
            this.inTransaction = true;
            Integer n7 = new Integer(n2);
            if (useOra816) {
                try {
                    if (Trace.isOn) {
                        Trace.trace(this, "creating oracle xid");
                    }
                    object = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("oracle.jdbc.xa.OracleXid");
                                return clazz;
                            }
                            catch (AccessControlException accessControlException) {
                                if (Trace.isOn) {
                                    Trace.exceptionTrace(3, "XAtoJTA", accessControlException);
                                }
                                return null;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                if (Trace.isOn) {
                                    Trace.trace("XAtoJTA", "OracleXid not found not found");
                                }
                                return null;
                            }
                        }
                    });
                    Class[] classArray = new Class[]{Integer.TYPE, array$B == null ? (array$B = XAtoJTA.class$("[B")) : array$B, array$B == null ? (array$B = XAtoJTA.class$("[B")) : array$B};
                    Constructor constructor = ((Class)object).getConstructor(classArray);
                    Object[] objectArray = new Object[]{new Integer(n), byArray, byArray2};
                    xid = (Xid)constructor.newInstance(objectArray);
                }
                catch (Exception exception) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Failed to create oracle specific xid: " + exception);
                    }
                    int n8 = -3;
                    if (Trace.isOn) {
                        Trace.exit(this, "xa_start");
                    }
                    return n8;
                }
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "creating a standard xid");
                }
                xid = new MQXid(n, byArray, byArray2);
            }
            RR rR = (RR)this.resourcesByRmid.get(n7);
            if (rR == null) {
                if (this.spareXAConns.isEmpty()) {
                    if (Trace.isOn) {
                        Trace.trace(this, "no connection available for rmid " + n2 + ", must be spare");
                    }
                    if ((object = (RR)this.spareRmids.get(n7)) == null) {
                        if (Trace.isOn) {
                            Trace.trace(this, "problem: rmId " + n7 + " missing from the spareRmids list - returning error");
                        }
                        int n9 = -3;
                        return n9;
                    }
                    ((RR)object).xid = xid;
                    int n10 = 0;
                    return n10;
                }
                object = (XAConnection)this.spareXAConns.lastElement();
                this.spareXAConns.removeElement(object);
                rR = (RR)this.spareRmids.remove(n7);
                if (rR == null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "can't find rmid on spareRmids list (2nd position)" + n2);
                    }
                    int n11 = -3;
                    return n11;
                }
                rR.res = object.getXAResource();
                rR.rmId = n7;
                this.resourcesByRmid.put(n7, rR);
                this.resourcesByConn.put(object, rR);
            }
            object = rR.res;
            rR.xid = xid;
            if (Trace.isOn) {
                Trace.trace(this, "XAStart, xid '" + xid + "', flags " + n3);
            }
            object.start(xid, n3);
            n4 = 0;
        }
        catch (XAException xAException) {
            if (Trace.isOn) {
                Trace.trace(this, "caught " + xAException);
            }
            n4 = xAException.errorCode;
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.trace(this, "caught " + exception);
                Trace.trace(this, "converting to XAER_RMERR return code");
            }
            n4 = -3;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "xa_start");
            }
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int xa_end(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4 = -3;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "xa_end");
                Trace.trace(this, "XAEnd: rmid is " + n2);
            }
            this.inTransaction = false;
            this.dirtyResources.removeAllElements();
            Integer n5 = new Integer(n2);
            RR rR = (RR)this.resourcesByRmid.get(n5);
            if (rR == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "rmid not assigned");
                }
                int n6 = 0;
                return n6;
            }
            XAResource xAResource = rR.res;
            if (xAResource == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "odd: assigned rmid with null XAResouce");
                }
                int n7 = 0;
                return n7;
            }
            Xid xid = rR.xid;
            if (xid == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "odd: assigned rmid with null xid");
                }
                int n8 = 0;
                return n8;
            }
            if (Trace.isOn) {
                Trace.trace(this, "xid is '" + xid + "', flags are " + n3);
            }
            xAResource.end(xid, n3);
            n4 = 0;
        }
        catch (XAException xAException) {
            if (Trace.isOn) {
                Trace.trace(this, "caught " + xAException);
            }
            n4 = xAException.errorCode;
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.trace(this, "caught " + exception);
            }
            n4 = -3;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "xa_end");
            }
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _deregisterResource(XAConnection xAConnection) throws XAException {
        try {
            RR rR;
            if (Trace.isOn) {
                Trace.entry(this, "_deregisterResource");
            }
            if ((rR = (RR)this.resourcesByConn.get(xAConnection)) == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "conn not assigned, checking spares");
                }
                if (!this.spareXAConns.removeElement(xAConnection)) {
                    if (Trace.isOn) {
                        Trace.trace(this, "conn not found in spare list either");
                    }
                } else if (Trace.isOn) {
                    Trace.trace(this, "found conn in spares list");
                }
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "found RR for xaconn");
                }
                XAResource xAResource = rR.res;
                Integer n = rR.rmId;
                if (this.inTransaction) {
                    Xid xid = rR.xid;
                    if (xid == null) {
                        if (Trace.isOn) {
                            Trace.trace(this, "odd - no xid for rmid " + n);
                        }
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(this, "doing xa_end");
                        }
                        xAResource.end(xid, 0x4000000);
                        this.dirtyResources.addElement(xAResource);
                    }
                } else if (Trace.isOn) {
                    Trace.trace(this, "not in transaction, skipping xa_end");
                }
                this.resourcesByConn.remove(xAConnection);
                this.resourcesByRmid.remove(n);
                if (Trace.isOn) {
                    Trace.trace(this, "putting rmId " + n + " back onto spares list");
                }
                this.spareRmids.put(n, rR);
            }
            return;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "_deregisterResource");
            }
        }
    }

    private void _registerResource(XAConnection xAConnection) throws MQException, SQLException, XAException {
        RR rR = null;
        try {
            XAResource xAResource;
            Object object;
            if (Trace.isOn) {
                Trace.entry(this, "_registerResource");
            }
            XAResource xAResource2 = xAConnection.getXAResource();
            Enumeration<Object> enumeration = this.spareXAConns.elements();
            while (enumeration.hasMoreElements()) {
                object = (XAConnection)enumeration.nextElement();
                xAResource = object.getXAResource();
                if (!xAResource2.isSameRM(xAResource)) continue;
                if (Trace.isOn) {
                    Trace.trace(this, "xaResource matches previously registered connection, returning an error");
                }
                throw new MQException(2, 2195, this);
            }
            enumeration = this.resourcesByConn.keys();
            while (enumeration.hasMoreElements()) {
                object = (XAConnection)enumeration.nextElement();
                xAResource = object.getXAResource();
                if (!xAResource2.isSameRM(xAResource)) continue;
                if (Trace.isOn) {
                    Trace.trace(this, "xaResource matches previously registered connection, returning an error");
                }
                throw new MQException(2, 2195, this);
            }
            if (!this.inTransaction) {
                if (Trace.isOn) {
                    Trace.trace(this, "not in transaction, adding to spare conns");
                }
                this.spareXAConns.addElement(xAConnection);
                xAConnection.addConnectionEventListener(this);
            } else {
                enumeration = this.dirtyResources.elements();
                while (enumeration.hasMoreElements()) {
                    object = (XAResource)enumeration.nextElement();
                    if (!xAResource2.isSameRM((XAResource)object)) continue;
                    if (Trace.isOn) {
                        Trace.trace(this, "XAResource found on dirty list - app confused - throwing exception to tell MQSESSION to rollback");
                    }
                    throw new MQException(2, 2003, this);
                }
                if (this.spareRmids.isEmpty()) {
                    if (Trace.isOn) {
                        Trace.trace(this, "no spare rmids available, throwing an exception");
                    }
                    throw new MQException(2, 2372, this);
                }
                enumeration = this.spareRmids.keys();
                Integer n = (Integer)enumeration.nextElement();
                rR = (RR)this.spareRmids.remove(n);
                if (Trace.isOn) {
                    Trace.trace(this, "in transaction, driving xa_start");
                }
                rR.res = xAResource2;
                xAResource2.start(rR.xid, 0);
                this.resourcesByRmid.put(n, rR);
                this.resourcesByConn.put(xAConnection, rR);
                xAConnection.addConnectionEventListener(this);
            }
        }
        catch (XAException xAException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + xAException);
            }
            throw xAException;
        }
        catch (SQLException sQLException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + sQLException);
            }
            throw sQLException;
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + mQException);
            }
            throw mQException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "_registerResource");
            }
        }
    }

    private void _resetRC() {
        if (Trace.isOn) {
            Trace.trace(this, "resetting beginRC");
        }
        this.beginRC = 2121;
    }

    private int _getRC() {
        if (Trace.isOn) {
            Trace.trace(this, "returning beginRC=" + this.beginRC);
        }
        return this.beginRC;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("MQ_JDBC_ORA816");
                }
                catch (AccessControlException accessControlException) {
                    if (Trace.isOn) {
                        Trace.trace(clsName, "failed to lookup system property for MQ_JDBC_ORA816: " + accessControlException);
                    }
                    return null;
                }
            }
        });
        if (string != null) {
            if (Trace.isOn) {
                Trace.trace(clsName, "setting flag for Oracle 8.1.6 JDBC driver");
            }
            useOra816 = true;
        } else {
            useOra816 = false;
        }
    }

    private class RR {
        public XAResource res;
        public Integer rmId;
        public Xid xid;

        private RR() {
        }
    }
}

