/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import javax.transaction.xa.Xid;

public class MQXid
implements Xid {
    private int formatId;
    private byte[] gtrid;
    private byte[] bqual;
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 2004, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final char[] Hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public MQXid(int n, byte[] byArray, byte[] byArray2) {
        this.formatId = n;
        this.gtrid = byArray;
        this.bqual = byArray2;
    }

    public int getFormatId() {
        return this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this.gtrid;
    }

    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("format: " + this.formatId);
        stringBuffer.append(", gtrid: " + MQXid.byteToHex(this.gtrid));
        stringBuffer.append(", bqual: " + MQXid.byteToHex(this.bqual));
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        Xid xid = null;
        if (!(object instanceof Xid)) {
            return false;
        }
        xid = (Xid)object;
        if (this.formatId != xid.getFormatId()) {
            return false;
        }
        byte[] byArray = xid.getGlobalTransactionId();
        if (this.gtrid.length != byArray.length) {
            return false;
        }
        for (int i = 0; i < this.gtrid.length; ++i) {
            if (this.gtrid[i] == byArray[i]) continue;
            return false;
        }
        byte[] byArray2 = xid.getBranchQualifier();
        if (this.bqual.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < this.bqual.length; ++i) {
            if (this.bqual[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    static String byteToHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(Hex[byArray[i] >> 4 & 0xF]);
                stringBuffer.append(Hex[byArray[i] & 0xF]);
            }
        }
        return stringBuffer.toString();
    }
}

