/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQOD;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.Pint;
import com.ibm.mqservices.Trace;

public class MQProcess
extends MQManagedObject {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQProcess.java, java, j600, j600-201-061220 1.23.1.1 05/05/25 15:37:32";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int MQOT_PROCESS = 3;
    private Pint completionCode = new Pint();
    private Pint reason = new Pint();
    private MQSESSION osession = null;

    protected MQProcess() {
        if (Trace.isOn) {
            Trace.entry(this, "MQProcess constructor");
            Trace.trace(2, this, sccsid);
            Trace.exit(this, "MQProcess constructor");
        }
    }

    public MQProcess(MQQueueManager mQQueueManager, String string, int n, String string2, String string3) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "MQProcess public constructor");
            Trace.trace(2, this, sccsid);
        }
        if (mQQueueManager == null) {
            if (Trace.isOn) {
                Trace.exit(this, "MQProcess constructor (via exception)");
            }
            throw new MQException(2, 2018, (Object)this, 1);
        }
        if (this.osession == null) {
            this.osession = mQQueueManager.getSession();
        }
        if (!mQQueueManager.connected || this.osession == null) {
            if (Trace.isOn) {
                Trace.exit(this, "MQProcess public constructor (via exception)");
            }
            throw new MQException(2, 2018, (Object)this, 2);
        }
        MQOD mQOD = new MQOD();
        mQOD.ObjectType = 3;
        if (string != null && string.length() > 0) {
            mQOD.ObjectName = string;
        }
        if (string2 != null && string2.length() > 0) {
            mQOD.ObjectQMgrName = string2;
        }
        if (string3 != null && string3.length() > 0) {
            mQOD.AlternateUserId = string3;
        }
        this.Hconn = mQQueueManager.Hconn;
        this.connected = mQQueueManager.connected;
        n |= 0x20;
        if (Trace.isOn) {
            Trace.trace(2, this, "process = " + mQOD.ObjectName + "\nqueue manager = " + mQOD.ObjectQMgrName + "\nalternate user id = " + mQOD.AlternateUserId + "\noptions = " + n);
        }
        this.osession.MQOPEN(this.Hconn.x, mQOD, n, this.Hobj, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            this.resourceOpen = false;
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            mQQueueManager.errorOccurred(mQException);
            if (Trace.isOn) {
                Trace.exit(this, "MQProcess public constructor (via exception)");
            }
            throw mQException;
        }
        this.resourceOpen = true;
        mQQueueManager.registerProcess(this);
        this.name = string;
        this.openOptions = n;
        this.isOpen = true;
        this.openStatus = true;
        this.parentQmgr = mQQueueManager;
        this.connectionReference = mQQueueManager;
        if (string3 != null) {
            this.alternateUserId = string3;
        }
        this.mqca_description = 2011;
        if (Trace.isOn) {
            Trace.exit(this, "MQProcess public constructor");
        }
    }

    public synchronized void close() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        super.close();
        if (this.connectionReference != null) {
            this.connectionReference.unregisterProcess(this);
        }
        this.connectionReference = null;
        if (Trace.isOn) {
            Trace.exit(this, "close");
        }
    }

    public String getApplicationId() throws MQException {
        return this.getString(2001, 256);
    }

    public int getApplicationType() throws MQException {
        return this.getInt(1);
    }

    public String getEnvironmentData() throws MQException {
        return this.getString(2007, 128);
    }

    public String getUserData() throws MQException {
        return this.getString(2021, 128);
    }
}

