/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQC;
import com.ibm.mq.MQCcsidTable;
import com.ibm.mq.MQDateConverter;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQSESSION;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class MQMsg2 {
    private static final String sccsid = "@(#)  javabase/com/ibm/mq/MQMsg2.java, java, j600, j600-201-061220 1.32.1.1 05/05/25 15:41:43";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String CLASSNAME = "com.ibm.mq.MQMsg2";
    protected static final int sizeofMQMDv1 = 324;
    protected static final int sizeofMQMDv2 = 364;
    private static final byte[] NULL_MQCHAR48 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int INITIAL_MSG_SIZE = 2048;
    private static final byte[] eyecatcherMQMD = new byte[]{77, 68, 32, 32};
    private static final byte[] blank8 = new byte[]{32, 32, 32, 32, 32, 32, 32, 32};
    private int report = 0;
    private int messageType = 8;
    private int expiry = -1;
    private int feedback = 0;
    private int encoding = 273;
    private int characterSet = 0;
    private int priority = -1;
    private int persistence = 2;
    private int backoutCount = 0;
    private int putApplicationType = 0;
    private int messageSequenceNumber = 1;
    private int offset = 0;
    private int messageFlags = 0;
    private int originalLength = -1;
    private int version = 2;
    private byte[] dateText = new byte[8];
    private byte[] timeText = new byte[8];
    private long putTimeMillis;
    private boolean putTimeCached = false;
    private int ccsidForStrings;
    private boolean stringsNeedCcsidConversion = false;
    private boolean ccsidForStringsIsAscii;
    private byte cachedPadByte;
    private boolean cachedPadByteValid = false;
    private int cachedPadByteCcsid;
    private String cachedCcsidStr = null;
    private int cachedCcsid;
    private byte[] messageId = new byte[24];
    private byte[] correlationId = new byte[24];
    private byte[] accountingToken = new byte[32];
    private byte[] groupId = new byte[24];
    private byte[] format = new byte[8];
    private String formatStr = "        ";
    private boolean formatCached = false;
    private byte[] replyToQueueName = new byte[48];
    private String replyToQueueNameStr = "";
    private boolean replyToQueueNameCached = false;
    private byte[] replyToQueueManagerName = new byte[48];
    private String replyToQueueManagerNameStr = "";
    private boolean replyToQueueManagerNameCached = false;
    private byte[] userId = new byte[12];
    private String userIdStr = "";
    private boolean userIdCached = false;
    private byte[] applicationIdData = new byte[32];
    private String applicationIdDataStr = "";
    private boolean applicationIdDataCached = false;
    private byte[] putApplicationName = new byte[28];
    private String putApplicationNameStr = "";
    private boolean putApplicationNameCached = false;
    private byte[] applicationOriginData = new byte[4];
    private String applicationOriginDataStr = "";
    private boolean applicationOriginDataCached = false;
    private byte[] messageData = null;
    private int messageDataOffset = 0;
    private int readCursor = 0;
    private static String currentCcsidName = null;
    private static int currentCcsidValue;
    private static final int EXPAND_TUNING = 1024;

    public MQMsg2() {
        if (Trace.isOn) {
            Trace.entry(this, "MQMsg2 constructor");
            Trace.trace(2, this, sccsid);
        }
        this.characterSet = MQSESSION.getDefaultCCSID();
        this.messageData = new byte[2048];
        if (Trace.isOn) {
            Trace.exit(this, "MQMsg2 constructor");
        }
    }

    private void copyStrIntoBytes(String string, byte[] byArray, int n, boolean bl, boolean bl2) throws MQException {
        int n2;
        int n3;
        boolean bl3 = false;
        if (string == null) {
            n3 = 0;
            if (this.stringsNeedCcsidConversion && bl) {
                bl3 = true;
            } else if (!this.stringsNeedCcsidConversion) {
                bl3 = true;
            }
        } else {
            n3 = string.length();
            if (this.stringsNeedCcsidConversion) {
                if (bl) {
                    if (bl2) {
                        bl3 = true;
                    } else {
                        bl3 = true;
                        for (n2 = 0; n2 < n3 && bl3; ++n2) {
                            bl3 = string.charAt(n2) < '\u0080';
                        }
                    }
                }
            } else {
                bl3 = true;
            }
        }
        if (bl3) {
            if (byArray.length > n3) {
                for (n2 = n3; n2 < byArray.length; ++n2) {
                    byArray[n2] = 32;
                }
            } else if (n3 > byArray.length) {
                n3 = byArray.length;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                byArray[n2] = (byte)string.charAt(n2);
            }
        } else {
            if (this.cachedCcsidStr == null || this.cachedCcsid != n) {
                String string2 = String.valueOf(n);
                this.cachedCcsidStr = MQCcsidTable.lookup(string2);
                if (this.cachedCcsidStr == null) {
                    this.cachedCcsidStr = string2;
                }
                this.cachedCcsid = n;
            }
            if (n3 < byArray.length) {
                if (bl) {
                    this.cachedPadByte = (byte)32;
                    this.cachedPadByteValid = true;
                } else if (!this.cachedPadByteValid || this.cachedPadByteCcsid != n) {
                    try {
                        this.cachedPadByte = new String(" ").getBytes(this.cachedCcsidStr)[0];
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        this.cachedCcsidStr = null;
                        throw new MQInternalException(2, 2195, 87, this.cachedCcsidStr);
                    }
                    this.cachedPadByteCcsid = n;
                    this.cachedPadByteValid = true;
                }
                for (n2 = n3; n2 < byArray.length; ++n2) {
                    byArray[n2] = this.cachedPadByte;
                }
            }
            if (n3 > byArray.length) {
                n3 = byArray.length;
            }
            if (n3 > 0) {
                try {
                    byte[] byArray2 = string.getBytes(this.cachedCcsidStr);
                    System.arraycopy(byArray2, 0, byArray, 0, n3);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new MQInternalException(2, 2195, 87, this.cachedCcsidStr);
                }
            }
        }
    }

    private String createStrFromBytes(byte[] byArray, int n, boolean bl, boolean bl2) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "createStrFromBytes");
        }
        boolean bl3 = false;
        String string = null;
        if (this.stringsNeedCcsidConversion) {
            if (bl) {
                if (bl2) {
                    bl3 = true;
                } else {
                    bl3 = true;
                    for (int i = 0; i < byArray.length && bl3; ++i) {
                        bl3 = byArray[i] >= 0;
                    }
                }
            }
        } else {
            bl3 = true;
        }
        if (Trace.isOn) {
            Trace.trace(this, "codepage: " + n);
            Trace.trace(this, "codepageIsAscii: " + bl);
            Trace.trace(this, "bytesAreInvariant: " + bl2);
            Trace.trace(this, "doQuickConversion: " + bl3);
            Trace.trace(this, "stringsNeedCcsidConversion: " + this.stringsNeedCcsidConversion);
        }
        if (bl3) {
            char[] cArray = new char[byArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = (char)byArray[i];
            }
            string = new String(cArray);
        } else {
            if (Trace.isOn) {
                Trace.trace(this, "----------------------------");
                Trace.trace(this, "cachedCcsidStr: " + this.cachedCcsidStr);
                Trace.trace(this, "cachedCcsid: " + this.cachedCcsid);
            }
            if (this.cachedCcsidStr == null || this.cachedCcsid != n) {
                String string2 = String.valueOf(n);
                this.cachedCcsidStr = MQCcsidTable.lookup(string2);
                if (this.cachedCcsidStr == null) {
                    this.cachedCcsidStr = string2;
                }
                this.cachedCcsidStr = String.valueOf(n);
                this.cachedCcsid = n;
                if (Trace.isOn) {
                    Trace.trace(this, "  inside if statement.");
                    Trace.trace(this, "  codepageStr: " + string2);
                    Trace.trace(this, "  cachedCcsidStr: " + this.cachedCcsidStr);
                    Trace.trace(this, "  cachedCcsidStr: " + this.cachedCcsidStr);
                    Trace.trace(this, "  exit if statement.");
                }
            }
            try {
                string = new String(byArray, this.cachedCcsidStr);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (Trace.isOn) {
                    Trace.trace(this, "UnsupportedEncodingExc: " + unsupportedEncodingException);
                    Trace.exit(this, "createStrFromBytes");
                }
                this.cachedCcsidStr = null;
                throw new MQInternalException(2, 2195, 87, this.cachedCcsidStr);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "createStrFromBytes");
        }
        return string;
    }

    public String getFormat() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "getFormat");
        }
        if (!this.formatCached) {
            if (Trace.isOn) {
                Trace.trace(this, "format: " + this.format[0] + " " + this.format[1] + " " + this.format[2] + " " + this.format[3] + " " + this.format[4] + " " + this.format[5] + " " + this.format[6] + " " + this.format[7] + " ");
            }
            this.formatStr = this.createStrFromBytes(this.format, this.ccsidForStrings, this.ccsidForStringsIsAscii, false);
            this.formatCached = true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "getFormat");
        }
        return this.formatStr;
    }

    public long getFormatAsLong() throws MQException {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l <<= 8;
            long l2 = this.format[i];
            if (l2 < 0L) {
                l2 += 256L;
            }
            l += l2;
        }
        return l;
    }

    public void setFormat(String string) throws MQException {
        this.formatStr = string;
        this.copyStrIntoBytes(string, this.format, this.ccsidForStrings, this.ccsidForStringsIsAscii, false);
        this.formatCached = true;
    }

    public String getReplyToQueueName() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "getReplyToQueueName");
        }
        if (!this.replyToQueueNameCached) {
            this.replyToQueueNameStr = this.createStrFromBytes(this.replyToQueueName, this.ccsidForStrings, this.ccsidForStringsIsAscii, true);
            this.replyToQueueNameCached = true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "getReplyToQueueName");
        }
        return this.replyToQueueNameStr;
    }

    public void setReplyToQueueName(String string) throws MQException {
        this.replyToQueueNameStr = string;
        this.copyStrIntoBytes(string, this.replyToQueueName, this.ccsidForStrings, this.ccsidForStringsIsAscii, true);
        this.replyToQueueNameCached = true;
    }

    public void resetReplyToQueueName() throws MQException {
        System.arraycopy(NULL_MQCHAR48, 0, this.replyToQueueName, 0, this.replyToQueueName.length);
        this.replyToQueueNameCached = true;
    }

    public String getReplyToQueueManagerName() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "getReplyToQueueManagerName");
        }
        if (!this.replyToQueueManagerNameCached) {
            this.replyToQueueManagerNameStr = this.createStrFromBytes(this.replyToQueueManagerName, this.ccsidForStrings, this.ccsidForStringsIsAscii, true);
            this.replyToQueueManagerNameCached = true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "getReplyToQueueManagerName");
        }
        return this.replyToQueueManagerNameStr;
    }

    public void setReplyToQueueManagerName(String string) throws MQException {
        this.replyToQueueManagerNameStr = string;
        this.copyStrIntoBytes(string, this.replyToQueueManagerName, this.ccsidForStrings, this.ccsidForStringsIsAscii, true);
        this.replyToQueueManagerNameCached = true;
    }

    public void resetReplyToQueueManagerName() throws MQException {
        System.arraycopy(NULL_MQCHAR48, 0, this.replyToQueueManagerName, 0, this.replyToQueueManagerName.length);
        this.replyToQueueManagerNameCached = true;
    }

    public String getUserId() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "getUserId");
        }
        if (!this.userIdCached) {
            this.userIdStr = this.createStrFromBytes(this.userId, this.ccsidForStrings, this.ccsidForStringsIsAscii, false);
            this.userIdCached = true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "getUserId");
        }
        return this.userIdStr;
    }

    public byte[] getUserIdAsBytes() {
        return this.userId;
    }

    public void setUserId(String string) throws MQException {
        this.userIdStr = string;
        this.copyStrIntoBytes(string, this.userId, this.ccsidForStrings, this.ccsidForStringsIsAscii, false);
        this.userIdCached = true;
    }

    public String getApplicationIdData() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "getApplicationIdData");
        }
        if (!this.applicationIdDataCached) {
            this.applicationIdDataStr = this.createStrFromBytes(this.applicationIdData, this.ccsidForStrings, this.ccsidForStringsIsAscii, false);
            this.applicationIdDataCached = true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "getApplicationIdData");
        }
        return this.applicationIdDataStr;
    }

    public void setApplicationIdData(String string) throws MQException {
        this.applicationIdDataStr = string;
        this.copyStrIntoBytes(string, this.applicationIdData, this.ccsidForStrings, this.ccsidForStringsIsAscii, false);
        this.applicationIdDataCached = true;
    }

    public String getPutApplicationName() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "getPutApplicationName");
        }
        if (!this.putApplicationNameCached) {
            this.putApplicationNameStr = this.createStrFromBytes(this.putApplicationName, this.ccsidForStrings, this.ccsidForStringsIsAscii, false);
            this.putApplicationNameCached = true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "getPutApplicationName");
        }
        return this.putApplicationNameStr;
    }

    public byte[] getPutApplicationNameAsBytes() {
        return this.putApplicationName;
    }

    public void setPutApplicationName(String string) throws MQException {
        this.putApplicationNameStr = string;
        this.copyStrIntoBytes(string, this.putApplicationName, this.ccsidForStrings, this.ccsidForStringsIsAscii, false);
        this.putApplicationNameCached = true;
    }

    public String getApplicationOriginData() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "getApplicationOriginData");
        }
        if (!this.applicationOriginDataCached) {
            this.applicationOriginDataStr = this.createStrFromBytes(this.applicationOriginData, this.ccsidForStrings, this.ccsidForStringsIsAscii, false);
            this.applicationOriginDataCached = true;
        }
        return this.applicationOriginDataStr;
    }

    public void setApplicationOriginData(String string) throws MQException {
        this.applicationOriginDataStr = string;
        this.copyStrIntoBytes(string, this.applicationOriginData, this.ccsidForStrings, this.ccsidForStringsIsAscii, false);
        this.applicationOriginDataCached = true;
    }

    public int getReport() {
        return this.report;
    }

    public void setReport(int n) {
        this.report = n;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int n) {
        this.messageType = n;
    }

    public int getExpiry() {
        return this.expiry;
    }

    public void setExpiry(int n) {
        this.expiry = n;
    }

    public int getFeedback() {
        return this.feedback;
    }

    public void setFeedback(int n) {
        this.feedback = n;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public void setEncoding(int n) {
        this.encoding = n;
    }

    public int getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(int n) {
        this.characterSet = n;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public int getPersistence() {
        return this.persistence;
    }

    public void setPersistence(int n) {
        this.persistence = n;
    }

    public int getBackoutCount() {
        return this.backoutCount;
    }

    public void setBackoutCount(int n) {
        this.backoutCount = n;
    }

    public int getPutApplicationType() {
        return this.putApplicationType;
    }

    public void setPutApplicationType(int n) {
        this.putApplicationType = n;
    }

    public int getMessageSequenceNumber() {
        return this.messageSequenceNumber;
    }

    public void setMessageSequenceNumber(int n) {
        this.messageSequenceNumber = n;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int getMessageFlags() {
        return this.messageFlags;
    }

    public void setMessageFlags(int n) {
        this.messageFlags = n;
    }

    public int getOriginalLength() {
        return this.originalLength;
    }

    public void setOriginalLength(int n) {
        this.originalLength = n;
    }

    public byte[] getMessageId() {
        byte[] byArray = new byte[this.messageId.length];
        System.arraycopy(this.messageId, 0, byArray, 0, this.messageId.length);
        return byArray;
    }

    public void setMessageId(byte[] byArray) {
        int n = byArray.length;
        if (n > this.messageId.length) {
            n = this.messageId.length;
        }
        System.arraycopy(byArray, 0, this.messageId, 0, n);
        for (int i = n; i < this.messageId.length; ++i) {
            this.messageId[i] = 0;
        }
    }

    public byte[] getMessageIdRef() {
        return this.messageId;
    }

    public void setMessageIdRef(byte[] byArray) {
        this.messageId = byArray;
    }

    public byte[] getCorrelationId() {
        byte[] byArray = new byte[this.correlationId.length];
        System.arraycopy(this.correlationId, 0, byArray, 0, this.correlationId.length);
        return byArray;
    }

    public void setCorrelationId(byte[] byArray) {
        int n = byArray.length;
        if (n > this.correlationId.length) {
            n = this.correlationId.length;
        }
        System.arraycopy(byArray, 0, this.correlationId, 0, n);
        for (int i = n; i < this.correlationId.length; ++i) {
            this.correlationId[i] = 0;
        }
    }

    public byte[] getCorrelationIdRef() {
        return this.correlationId;
    }

    public void setCorrelationIdRef(byte[] byArray) {
        this.correlationId = byArray;
    }

    public byte[] getAccountingToken() {
        byte[] byArray = new byte[this.accountingToken.length];
        System.arraycopy(this.accountingToken, 0, byArray, 0, this.accountingToken.length);
        return byArray;
    }

    public void setAccountingToken(byte[] byArray) {
        int n = byArray.length;
        if (n > this.accountingToken.length) {
            n = this.accountingToken.length;
        }
        System.arraycopy(byArray, 0, this.accountingToken, 0, n);
        for (int i = n; i < this.accountingToken.length; ++i) {
            this.accountingToken[i] = 0;
        }
    }

    public byte[] getGroupId() {
        byte[] byArray = new byte[this.groupId.length];
        System.arraycopy(this.groupId, 0, byArray, 0, this.groupId.length);
        return byArray;
    }

    public void setGroupId(byte[] byArray) {
        int n = byArray.length;
        if (n > this.groupId.length) {
            n = this.groupId.length;
        }
        System.arraycopy(byArray, 0, this.groupId, 0, n);
        for (int i = n; i < this.groupId.length; ++i) {
            this.groupId[i] = 0;
        }
    }

    public byte[] getPutDateAsBytes() {
        return this.dateText;
    }

    public byte[] getPutTimeAsBytes() {
        return this.timeText;
    }

    public int getVersion() {
        return this.version;
    }

    public long getPutTimeMillis() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "getPutTimeMillis");
        }
        if (!this.putTimeCached) {
            this.putTimeMillis = MQDateConverter.mqDateTimeToMillis(this.timeText, this.dateText);
            this.putTimeCached = true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "getPutTimeMillis");
        }
        return this.putTimeMillis;
    }

    public int _getCcsid() {
        return this.ccsidForStrings;
    }

    public boolean _getIsCcsidAscii() {
        return this.ccsidForStringsIsAscii;
    }

    public boolean _doStringsNeedCcsidConversion() {
        return this.stringsNeedCcsidConversion;
    }

    private synchronized String getCcsidName() {
        if (Trace.isOn) {
            Trace.entry(this, "getEncodingName");
        }
        String string = null;
        if (currentCcsidName == null || currentCcsidValue != this.characterSet) {
            String string2;
            if (this.characterSet == 0) {
                this.characterSet = MQSESSION.getDefaultCCSID();
            }
            if ((string = MQCcsidTable.lookup(string2 = Integer.toString(this.characterSet))) == null) {
                string = string2;
            }
            if (Trace.isOn) {
                Trace.trace(2, this, "Mapped " + this.characterSet + " -> " + string);
            }
            currentCcsidName = string;
            currentCcsidValue = this.characterSet;
        } else {
            string = currentCcsidName;
        }
        if (Trace.isOn) {
            Trace.exit(this, "getEncodingName");
        }
        return string;
    }

    public void setCharacterSetToDefault() {
        this.characterSet = MQSESSION.getDefaultCCSID();
    }

    private boolean isVersion1Safe() {
        boolean bl = false;
        if (this.groupId != null) {
            for (int i = 0; i < this.groupId.length && !bl; ++i) {
                if (this.groupId[i] == 0) continue;
                bl = true;
            }
        }
        return !bl && this.messageSequenceNumber == 1 && this.offset == 0 && this.messageFlags == 0 && this.originalLength == -1;
    }

    public void setVersion(int n) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "setVersion");
            Trace.trace(2, this, "newVersion = " + n);
        }
        if (n > 2 || n < 1) {
            if (Trace.isOn) {
                Trace.exit(this, "setVersion (via exception)");
            }
            throw new MQException(2, 2026, this, 117, "" + n);
        }
        if (n == 1 && !this.isVersion1Safe()) {
            if (Trace.isOn) {
                Trace.exit(this, "setVersion (via exception)");
            }
            throw new MQException(2, 2026, (Object)this, 97);
        }
        this.version = n;
        if (Trace.isOn) {
            Trace.exit(this, "setVersion");
        }
    }

    protected final int sizeOfMQMD() {
        if (this.version == 1) {
            return 324;
        }
        return 364;
    }

    public final DataOutputStream writeTo(DataOutputStream dataOutputStream, int n, boolean bl) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "writeTo");
        }
        this.stringsNeedCcsidConversion = true;
        dataOutputStream = n == this.ccsidForStrings ? this.writeToWithoutConversion(dataOutputStream) : this.writeToWithConversion(dataOutputStream, n, bl);
        if (Trace.isOn) {
            Trace.exit(this, "writeTo");
        }
        return dataOutputStream;
    }

    private DataOutputStream writeToWithoutConversion(DataOutputStream dataOutputStream) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "writeToWithoutConversion");
        }
        dataOutputStream.write(eyecatcherMQMD);
        dataOutputStream.writeInt(this.version);
        dataOutputStream.writeInt(this.report);
        dataOutputStream.writeInt(this.messageType);
        dataOutputStream.writeInt(this.expiry);
        dataOutputStream.writeInt(this.feedback);
        dataOutputStream.writeInt(this.encoding);
        dataOutputStream.writeInt(this.characterSet);
        dataOutputStream.write(this.format);
        dataOutputStream.writeInt(this.priority);
        dataOutputStream.writeInt(this.persistence);
        dataOutputStream.write(this.messageId);
        dataOutputStream.write(this.correlationId);
        dataOutputStream.writeInt(this.backoutCount);
        dataOutputStream.write(this.replyToQueueName);
        dataOutputStream.write(this.replyToQueueManagerName);
        dataOutputStream.write(this.userId);
        dataOutputStream.write(this.accountingToken);
        dataOutputStream.write(this.applicationIdData);
        dataOutputStream.writeInt(this.putApplicationType);
        dataOutputStream.write(this.putApplicationName);
        dataOutputStream.write(blank8);
        dataOutputStream.write(blank8);
        dataOutputStream.write(this.applicationOriginData);
        if (this.version > 1) {
            dataOutputStream.write(this.groupId);
            dataOutputStream.writeInt(this.messageSequenceNumber);
            dataOutputStream.writeInt(this.offset);
            dataOutputStream.writeInt(this.messageFlags);
            dataOutputStream.writeInt(this.originalLength);
        }
        if (Trace.isOn) {
            Trace.exit(this, "writeToWithoutConversion");
        }
        return dataOutputStream;
    }

    private boolean asciiInvariant(byte[] byArray) {
        boolean bl = true;
        for (int i = 0; i < byArray.length && bl; ++i) {
            bl = byArray[i] >= 0;
        }
        return bl;
    }

    private DataOutputStream writeToWithConversion(DataOutputStream dataOutputStream, int n, boolean bl) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "writeToWithConversion");
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        try {
            String string13;
            String string14;
            if (this.cachedCcsidStr == null || this.cachedCcsid != n) {
                string14 = String.valueOf(n);
                this.cachedCcsidStr = MQCcsidTable.lookup(string14);
                if (this.cachedCcsidStr == null) {
                    this.cachedCcsidStr = string14;
                }
                this.cachedCcsid = n;
            }
            if (bl) {
                if (!this.asciiInvariant(this.format)) {
                    string2 = new String(this.format, this.cachedCcsidStr);
                }
                if (!this.asciiInvariant(this.userId)) {
                    string7 = new String(this.userId, this.cachedCcsidStr);
                }
                if (!this.asciiInvariant(this.applicationIdData)) {
                    string9 = new String(this.applicationIdData, this.cachedCcsidStr);
                }
                if (!this.asciiInvariant(this.putApplicationName)) {
                    string10 = new String(this.putApplicationName, this.cachedCcsidStr);
                }
                if (!this.asciiInvariant(this.applicationOriginData)) {
                    string11 = new String(this.applicationOriginData, this.cachedCcsidStr);
                }
            } else {
                string = new String(eyecatcherMQMD, this.cachedCcsidStr);
                string2 = new String(this.format, this.cachedCcsidStr);
                string3 = new String(this.messageId, this.cachedCcsidStr);
                string4 = new String(this.correlationId, this.cachedCcsidStr);
                string5 = new String(this.replyToQueueName, this.cachedCcsidStr);
                string6 = new String(this.replyToQueueManagerName, this.cachedCcsidStr);
                string7 = new String(this.userId, this.cachedCcsidStr);
                string8 = new String(this.accountingToken, this.cachedCcsidStr);
                string9 = new String(this.applicationIdData, this.cachedCcsidStr);
                string10 = new String(this.putApplicationName, this.cachedCcsidStr);
                string11 = new String(this.applicationOriginData, this.cachedCcsidStr);
                string12 = new String(blank8, this.cachedCcsidStr);
            }
            if ((string13 = MQCcsidTable.lookup(string14 = String.valueOf(n))) == null) {
                string13 = string14;
            }
            if (string != null) {
                dataOutputStream.write(string.getBytes(string13));
            } else {
                dataOutputStream.write(eyecatcherMQMD);
            }
            dataOutputStream.writeInt(this.version);
            dataOutputStream.writeInt(this.report);
            dataOutputStream.writeInt(this.messageType);
            dataOutputStream.writeInt(this.expiry);
            dataOutputStream.writeInt(this.feedback);
            dataOutputStream.writeInt(this.encoding);
            dataOutputStream.writeInt(this.characterSet);
            if (string2 != null) {
                dataOutputStream.write(string2.getBytes(string13));
            } else {
                dataOutputStream.write(this.format);
            }
            dataOutputStream.writeInt(this.priority);
            dataOutputStream.writeInt(this.persistence);
            if (string3 != null) {
                dataOutputStream.write(string3.getBytes(string13));
            } else {
                dataOutputStream.write(this.messageId);
            }
            if (string4 != null) {
                dataOutputStream.write(string4.getBytes(string13));
            } else {
                dataOutputStream.write(this.correlationId);
            }
            dataOutputStream.writeInt(this.backoutCount);
            if (string5 != null) {
                dataOutputStream.write(string5.getBytes(string13));
            } else {
                dataOutputStream.write(this.replyToQueueName);
            }
            if (string6 != null) {
                dataOutputStream.write(string6.getBytes(string13));
            } else {
                dataOutputStream.write(this.replyToQueueManagerName);
            }
            if (string7 != null) {
                dataOutputStream.write(string7.getBytes(string13));
            } else {
                dataOutputStream.write(this.userId);
            }
            if (string8 != null) {
                dataOutputStream.write(string8.getBytes(string13));
            } else {
                dataOutputStream.write(this.accountingToken);
            }
            if (string9 != null) {
                dataOutputStream.write(string9.getBytes(string13));
            } else {
                dataOutputStream.write(this.applicationIdData);
            }
            dataOutputStream.writeInt(this.putApplicationType);
            if (string10 != null) {
                dataOutputStream.write(string10.getBytes(string13));
            } else {
                dataOutputStream.write(this.putApplicationName);
            }
            if (string12 != null) {
                byte[] byArray = string12.getBytes(string13);
                dataOutputStream.write(byArray);
                dataOutputStream.write(byArray);
            } else {
                dataOutputStream.write(blank8);
                dataOutputStream.write(blank8);
            }
            if (string11 != null) {
                dataOutputStream.write(string11.getBytes(string13));
            } else {
                dataOutputStream.write(this.applicationOriginData);
            }
            if (this.version > 1) {
                dataOutputStream.write(this.groupId);
                dataOutputStream.writeInt(this.messageSequenceNumber);
                dataOutputStream.writeInt(this.offset);
                dataOutputStream.writeInt(this.messageFlags);
                dataOutputStream.writeInt(this.originalLength);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (Trace.isOn) {
                Trace.exit(this, "writeToWithConversion via Exception");
            }
            throw new MQInternalException(2, 2195, 84);
        }
        if (Trace.isOn) {
            Trace.exit(this, "writeToWithConversion");
        }
        return dataOutputStream;
    }

    public final DataInputStream readFrom(DataInputStream dataInputStream, int n, boolean bl) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "readFrom");
        }
        if (dataInputStream.available() < 324) {
            Trace.exit(this, "readFrom (via exception)");
            throw new MQInternalException(2, 2195, 84);
        }
        this.ccsidForStrings = n;
        this.ccsidForStringsIsAscii = bl;
        this.stringsNeedCcsidConversion = true;
        byte[] byArray = new byte[4];
        dataInputStream.read(byArray, 0, 4);
        if (byArray[0] != 77 || byArray[1] != 68 || byArray[2] != 32 || byArray[3] != 32) {
            Trace.exit(this, "readFrom (via exception)");
            throw new MQInternalException(2, 2195, 83, MQEnvironment.stringFromBytes(byArray));
        }
        this.version = dataInputStream.readInt();
        this.report = dataInputStream.readInt();
        this.messageType = dataInputStream.readInt();
        this.expiry = dataInputStream.readInt();
        this.feedback = dataInputStream.readInt();
        this.encoding = dataInputStream.readInt();
        this.characterSet = dataInputStream.readInt();
        dataInputStream.read(this.format, 0, 8);
        this.formatCached = false;
        this.priority = dataInputStream.readInt();
        this.persistence = dataInputStream.readInt();
        dataInputStream.read(this.messageId, 0, 24);
        dataInputStream.read(this.correlationId, 0, 24);
        this.backoutCount = dataInputStream.readInt();
        dataInputStream.read(this.replyToQueueName, 0, 48);
        this.replyToQueueNameCached = false;
        dataInputStream.read(this.replyToQueueManagerName, 0, 48);
        this.replyToQueueManagerNameCached = false;
        dataInputStream.read(this.userId, 0, 12);
        this.userIdCached = false;
        dataInputStream.read(this.accountingToken, 0, 32);
        dataInputStream.read(this.applicationIdData, 0, 32);
        this.applicationIdDataCached = false;
        this.putApplicationType = dataInputStream.readInt();
        dataInputStream.read(this.putApplicationName, 0, 28);
        this.putApplicationNameCached = false;
        dataInputStream.read(this.dateText, 0, 8);
        dataInputStream.read(this.timeText, 0, 8);
        this.putTimeCached = false;
        dataInputStream.read(this.applicationOriginData, 0, 4);
        this.applicationOriginDataCached = false;
        if (this.version > 1) {
            dataInputStream.read(this.groupId, 0, 24);
            this.messageSequenceNumber = dataInputStream.readInt();
            this.offset = dataInputStream.readInt();
            this.messageFlags = dataInputStream.readInt();
            this.originalLength = dataInputStream.readInt();
        } else {
            this.groupId = MQC.MQGI_NONE;
            this.messageSequenceNumber = 1;
            this.offset = 0;
            this.messageFlags = 0;
            this.originalLength = -1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "readFrom");
        }
        return dataInputStream;
    }

    private void expandMessageData(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.messageData, 0, byArray, 0, this.messageDataOffset);
        this.messageData = byArray;
    }

    public byte[] getMessageData() {
        byte[] byArray = null;
        byArray = new byte[this.messageDataOffset];
        System.arraycopy(this.messageData, 0, byArray, 0, this.messageDataOffset);
        return byArray;
    }

    public byte[] getMessageDataRef() {
        return this.messageData;
    }

    public void setMessageData(byte[] byArray) throws MQException {
        this.setMessageData(byArray, byArray.length);
    }

    public void setMessageData(byte[] byArray, int n) {
        if (n == byArray.length) {
            if (Trace.isOn) {
                Trace.trace(3, this, "Using reference to buffer for byte array");
            }
            this.messageData = byArray;
        } else {
            if (Trace.isOn) {
                Trace.trace(3, this, "Array size mismatch: Making copy of byte array");
            }
            this.messageData = new byte[n];
            System.arraycopy(byArray, 0, this.messageData, 0, n);
        }
        this.messageDataOffset = n;
        this.readCursor = 0;
    }

    protected void setInternalBuffer(byte[] byArray, int n) {
        this.messageData = byArray;
        this.messageDataOffset = n;
        this.readCursor = 0;
    }

    protected byte[] getInternalBuffer() {
        return this.messageData;
    }

    public final void appendInt(int n, int n2) throws IOException, MQException {
        if (this.messageData.length < this.messageDataOffset + 4) {
            this.expandMessageData(this.messageDataOffset + 4);
        }
        try {
            switch (n2 & 0xF) {
                case 0: 
                case 1: {
                    this.messageData[this.messageDataOffset + 0] = (byte)(n >>> 24 & 0xFF);
                    this.messageData[this.messageDataOffset + 1] = (byte)(n >>> 16 & 0xFF);
                    this.messageData[this.messageDataOffset + 2] = (byte)(n >>> 8 & 0xFF);
                    this.messageData[this.messageDataOffset + 3] = (byte)(n >>> 0 & 0xFF);
                    this.messageDataOffset += 4;
                    break;
                }
                case 2: {
                    this.messageData[this.messageDataOffset + 3] = (byte)(n >>> 24 & 0xFF);
                    this.messageData[this.messageDataOffset + 2] = (byte)(n >>> 16 & 0xFF);
                    this.messageData[this.messageDataOffset + 1] = (byte)(n >>> 8 & 0xFF);
                    this.messageData[this.messageDataOffset + 0] = (byte)(n >>> 0 & 0xFF);
                    this.messageDataOffset += 4;
                    break;
                }
                default: {
                    Trace.trace(1, this, "Invalid encoding: " + (n2 & 0xF));
                    Trace.exit(this, "readInt (via exception)");
                    throw new IOException();
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (Trace.isOn) {
                Trace.exit(this, "appendInt (via exception)");
            }
            throw new IOException();
        }
    }

    public final void appendByteArray(byte[] byArray) throws IOException, MQException {
        if (this.messageData.length < this.messageDataOffset + byArray.length) {
            this.expandMessageData(this.messageDataOffset + byArray.length);
        }
        System.arraycopy(byArray, 0, this.messageData, this.messageDataOffset, byArray.length);
        this.messageDataOffset += byArray.length;
    }

    public void appendByteArray(byte[] byArray, int n, int n2) throws IOException, MQException {
        if (this.messageData.length < this.messageDataOffset + n2) {
            this.expandMessageData(this.messageDataOffset + n2);
        }
        System.arraycopy(byArray, n, this.messageData, this.messageDataOffset, n2);
        this.messageDataOffset += n2;
    }

    public int getMessageDataLength() {
        return this.messageDataOffset;
    }

    public void clearMessageData() {
        this.messageDataOffset = 0;
        this.readCursor = 0;
    }

    public int readInt(int n) throws IOException, EOFException, MQInternalException {
        int n2;
        if (Trace.isOn) {
            Trace.entry(this, "readInt");
        }
        if (this.messageData.length - this.readCursor < 4) {
            Trace.exit(this, "readInt (via exception)");
            throw new EOFException();
        }
        int n3 = this.messageData[this.readCursor + 0];
        int n4 = this.messageData[this.readCursor + 1];
        int n5 = this.messageData[this.readCursor + 2];
        int n6 = this.messageData[this.readCursor + 3];
        this.readCursor += 4;
        if (n3 < 0) {
            n3 += 256;
        }
        if (n4 < 0) {
            n4 += 256;
        }
        if (n5 < 0) {
            n5 += 256;
        }
        if (n6 < 0) {
            n6 += 256;
        }
        try {
            switch (n & 0xF) {
                case 0: 
                case 1: {
                    n2 = (n3 << 24) + (n4 << 16) + (n5 << 8) + n6;
                    break;
                }
                case 2: {
                    n2 = (n6 << 24) + (n5 << 16) + (n4 << 8) + n3;
                    break;
                }
                default: {
                    Trace.trace(1, this, "Invalid encoding: " + (n & 0xF));
                    Trace.exit(this, "readInt (via exception)");
                    throw new IOException();
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (Trace.isOn) {
                Trace.exit(this, "readInt (via exception)");
            }
            throw new IOException();
        }
        if (Trace.isOn) {
            Trace.exit(this, "readInt");
        }
        return n2;
    }

    public void skipReadingBytes(int n) throws MQInternalException {
        this.readCursor += n;
    }

    public int read(byte[] byArray) throws MQInternalException {
        int n;
        if (Trace.isOn) {
            Trace.entry(this, "read");
        }
        if (this.messageDataOffset - this.readCursor < (n = byArray.length)) {
            n = this.messageDataOffset - this.readCursor;
        }
        if (n > 0) {
            System.arraycopy(this.messageData, this.readCursor, byArray, 0, n);
        }
        this.readCursor += n;
        if (Trace.isOn) {
            Trace.exit(this, "read");
        }
        return n > 0 ? n : -1;
    }

    public void resetReadPosition() throws MQInternalException {
        this.readCursor = 0;
    }
}

