/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQChannelDefinition;
import com.ibm.mq.MQChannelExit;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.SSLHelper;
import com.ibm.mqservices.Trace;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;

public class MQExternalUserExit {
    static boolean nativeLibraryLoaded;
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQExternalUserExit.java, jms, j600, j600-201-061220 1.24.1.11 06/08/18 13:24:10";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2002, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String className;
    protected String sslCipherSpec = "";
    protected String[] exitLibraries = new String[]{""};
    protected String[] exitEntries = new String[]{""};
    protected String[] dataStrings = new String[]{""};
    protected long[] exitBuffers = new long[]{0L};
    protected long[] exitBufferLengths = new long[]{0L};
    protected byte[][] dllHandles = new byte[1][8];
    protected byte[][] fnPointers = new byte[1][8];
    protected int reasonCode;
    protected long sendExitBank = 0L;
    protected long recieveExitBank = 0L;
    protected long securityExitBank = 0L;
    private byte[] newBufferFromExit = null;
    private int exitCount = 0;
    private Object exitLock = new Object();

    public void setNewBuffer(byte[] byArray) {
        this.newBufferFromExit = byArray;
    }

    protected MQExternalUserExit() {
        String string;
        String string2 = className + " constructor";
        if (Trace.isOn) {
            Trace.entry(this, string2);
            Trace.trace(2, this, sccsid);
        }
        if ((string = MQEnvironment.sslCipherSuite) != null) {
            this.sslCipherSpec = SSLHelper.translate(string, 0);
        }
        if (Trace.isOn) {
            Trace.exit(this, string2);
        }
    }

    protected MQExternalUserExit(String string, String string2, String string3) {
        String string4;
        String string5 = className + " constructor";
        if (Trace.isOn) {
            Trace.entry(this, string5);
            Trace.trace(2, this, sccsid);
        }
        if ((string4 = MQEnvironment.sslCipherSuite) != null) {
            this.sslCipherSpec = SSLHelper.translate(string4, 0);
        }
        System.loadLibrary("mqjexitstub01");
        this.setLibraryName(string);
        this.setEntryPointName(string2);
        this.setUserData(string3);
        if (Trace.isOn) {
            Trace.exit(this, string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] userExit(MQChannelExit mQChannelExit, MQChannelDefinition mQChannelDefinition, byte[] byArray) {
        int n = 0;
        String string = "userExit";
        Trace.entry(className, string);
        this.reasonCode = 0;
        if (mQChannelDefinition.sslPeerName == null) {
            mQChannelDefinition.sslPeerName = "";
        }
        if (mQChannelDefinition.remoteUserId == null) {
            mQChannelDefinition.remoteUserId = "";
        }
        if (mQChannelExit.exitUserArea == null) {
            mQChannelExit.exitUserArea = new byte[0];
        }
        int n2 = mQChannelExit.exitReason;
        boolean bl = false;
        if (11 == n2) {
            Object object = this.exitLock;
            synchronized (object) {
                if (Trace.isOn) {
                    Trace.trace("MQExternalUserExit.UserExit", "MQXR_INIT - attempt to route 1st call to exit. exitCount=" + this.exitCount);
                }
                if (this.exitCount <= 0) {
                    bl = true;
                }
                ++this.exitCount;
            }
        } else if (12 == n2) {
            Object object = this.exitLock;
            synchronized (object) {
                if (Trace.isOn) {
                    Trace.trace("MQExternalUserExit.UserExit", "MQXR_TERM - attempt to route last call to exit. prior to decrement exitCount=" + this.exitCount);
                }
                --this.exitCount;
                if (this.exitCount <= 0) {
                    bl = true;
                }
            }
        } else {
            if (Trace.isOn) {
                Trace.trace("MQExternalUserExit.UserExit", "Got exitreason=" + n2 + " sending direct to exit.");
            }
            bl = true;
        }
        if (bl) {
            this.newBufferFromExit = null;
            n = this.jniChannelExit(mQChannelExit, mQChannelDefinition, byArray);
            if (this.newBufferFromExit != null) {
                byArray = this.newBufferFromExit;
            }
        }
        Trace.trace(className, "trace code returned from jniChannelExit is " + n % 256);
        switch (n / 256) {
            case 0: {
                this.reasonCode = 0;
                break;
            }
            case 2: 
            case 3: {
                this.reasonCode = 2406;
                break;
            }
            default: {
                this.reasonCode = 2407;
            }
        }
        Trace.trace(className, "reason code after jniChannelExit is " + this.reasonCode);
        Trace.exit(className, string);
        return byArray;
    }

    private native int jniChannelExit(MQChannelExit var1, MQChannelDefinition var2, byte[] var3);

    public static native String getExitClasspath();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL[] getWMQExitClasspath() {
        if (Trace.isOn) {
            Trace.entry("MQExternalUserExit", "getWMQExitClasspath");
        }
        try {
            Object[] objectArray;
            Vector<URL> vector;
            block22: {
                vector = new Vector<URL>();
                String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return System.getProperty("com.ibm.mq.exitClasspath");
                        }
                        catch (AccessControlException accessControlException) {
                            Trace.exceptionTrace(3, null, accessControlException);
                            return "";
                        }
                    }
                });
                if (Trace.isOn) {
                    Trace.trace("MQExternalUserExit", "getWMQExitClasspath::located sys property com.ibm.mq.exitClasspath=" + string);
                }
                if (string != "" && string != null) {
                    objectArray = string.split(File.pathSeparator);
                    for (int i = 0; i < objectArray.length; ++i) {
                        try {
                            vector.add(new File((String)objectArray[i]).toURL());
                            continue;
                        }
                        catch (MalformedURLException malformedURLException) {
                            if (Trace.isOn) {
                                Trace.trace("MQExternalUserExit.getWMQExitClasspath", "Problem parsing sysproperty classapath");
                            }
                            if (!Trace.isOn) continue;
                            Trace.exceptionTrace(3, null, malformedURLException);
                        }
                    }
                }
                if (nativeLibraryLoaded) {
                    try {
                        File file;
                        block23: {
                            objectArray = MQExternalUserExit.getExitClasspath();
                            if (Trace.isOn) {
                                Trace.trace("MQExternalUserExit.getWMQExitClasspath", (String)objectArray);
                            }
                            if (objectArray == null || objectArray == "" || !(file = new File((String)objectArray)).isDirectory()) break block22;
                            try {
                                vector.add(file.toURL());
                            }
                            catch (MalformedURLException malformedURLException) {
                                if (Trace.isOn) {
                                    Trace.trace("MQExternalUserExit.getWMQExitClasspath", "Problem parseing WMQ Exit Classpath");
                                }
                                if (!Trace.isOn) break block23;
                                Trace.exceptionTrace(3, null, malformedURLException);
                            }
                        }
                        FilenameFilter filenameFilter = new FilenameFilter(){

                            public boolean accept(File file2, String string) {
                                return file2.equals(file) && string.endsWith(".jar");
                            }
                        };
                        File[] fileArray = file.listFiles(filenameFilter);
                        for (int i = 0; i < fileArray.length; ++i) {
                            try {
                                vector.add(fileArray[i].toURL());
                                continue;
                            }
                            catch (MalformedURLException malformedURLException) {
                                if (Trace.isOn) {
                                    Trace.trace("MQExternalUserExit.getWMQExitClasspath", "Problem adding files to URL Vector");
                                }
                                if (!Trace.isOn) continue;
                                Trace.exceptionTrace(3, null, malformedURLException);
                            }
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        if (!Trace.isOn) break block22;
                        Trace.trace("MQExternalUserExit.getWMQExitClasspath", "Failed to call native fn - but library reported as loaded. Version mismatch?");
                    }
                }
            }
            objectArray = new URL[vector.size()];
            URL[] uRLArray = (URL[])vector.toArray(objectArray);
            return uRLArray;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit("MQExternalUserExit", "getWMQExitClasspath");
            }
        }
    }

    public void setEntryPointName(String string) {
        String string2 = "setEntryPointName";
        Trace.entry(className, string2);
        Trace.trace(className, "entryPointName is " + string);
        this.exitEntries[0] = string == null ? "" : string;
        Trace.exit(className, string2);
    }

    static String[] augment(String[] stringArray, String string) {
        String string2 = "augment";
        Trace.entry(className, string2);
        int n = stringArray.length;
        String[] stringArray2 = new String[1 + n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[n] = string;
        Trace.trace(className, "New array is " + stringArray2);
        Trace.exit(className, string2);
        return stringArray2;
    }

    public void setLibraryName(String string) {
        String string2 = "setLibraryName";
        Trace.entry(className, string2);
        Trace.trace(className, "New library name is " + string);
        this.exitLibraries[0] = string == null ? "" : string;
        Trace.exit(className, string2);
    }

    public void setUserData(String string) {
        String string2 = "setUserData";
        Trace.entry(className, string2);
        Trace.trace(className, "New user data is " + string);
        this.dataStrings[0] = string == null ? "" : string;
        Trace.exit(className, string2);
    }

    public String getUserData() {
        String string = "getUserData";
        Trace.entry(className, string);
        Trace.trace(className, "New user data is " + this.dataStrings[0]);
        Trace.exit(className, string);
        return this.dataStrings[0];
    }

    protected String getEntryPointName() {
        String string = "getEntryPointName";
        Trace.entry(className, string);
        Trace.trace(className, "Entry point name is " + this.exitEntries[0]);
        Trace.exit(className, string);
        return this.exitEntries[0];
    }

    protected String getLibraryName() {
        String string = "getLibraryName";
        Trace.entry(className, string);
        Trace.trace(className, "Library name is " + this.exitEntries[0]);
        Trace.exit(className, string);
        return this.exitLibraries[0];
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    static {
        block3: {
            nativeLibraryLoaded = false;
            try {
                if (Trace.isOn) {
                    Trace.trace("MQExternalUserExit.<clinit>", "Loading mqjexitstub01");
                }
                System.loadLibrary("mqjexitstub01");
                nativeLibraryLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                nativeLibraryLoaded = false;
                if (!Trace.isOn) break block3;
                Trace.exceptionTrace(3, null, unsatisfiedLinkError);
            }
        }
        className = "MQExternalUserExit";
    }
}

