/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mqservices.Trace;
import java.util.GregorianCalendar;
import java.util.TimeZone;

class MQDateConverter {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQDateConverter.java, java, j600, j600-201-061220 1.11.1.1 05/05/25 15:41:36";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private GregorianCalendar calendar = null;
    private long[] millisAtMonthStart;
    private int firstMonthInTable;
    private static MQDateConverter instance = null;

    private MQDateConverter() {
        if (Trace.isOn) {
            Trace.entry(this, "MQDateConverter (constructor)");
            Trace.trace(2, this, sccsid);
        }
        this.calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        this.calendar.set(14, 0);
        this.firstMonthInTable = this.calendar.get(2) > 6 ? (this.calendar.get(1) - 1970) * 12 : (this.calendar.get(1) - 1970) * 12 - 6;
        this.millisAtMonthStart = new long[12];
        for (int i = this.firstMonthInTable; i < this.firstMonthInTable + 12; ++i) {
            this.calendar.set(i / 12 + 1970, i % 12, 1, 0, 0, 0);
            this.millisAtMonthStart[i - this.firstMonthInTable] = this.calendar.getTime().getTime();
        }
        if (Trace.isOn) {
            Trace.exit(this, "MQDateConverter (constructor)");
        }
    }

    private void updateTable() {
        int n;
        if (Trace.isOn) {
            Trace.entry(this, "updateTable");
        }
        for (n = 6; n < 12; ++n) {
            this.millisAtMonthStart[n - 6] = this.millisAtMonthStart[n];
        }
        this.calendar.set(14, 0);
        this.firstMonthInTable += 6;
        for (n = this.firstMonthInTable + 6; n < this.firstMonthInTable + 12; ++n) {
            this.calendar.set(n / 12 + 1970, n % 12, 1, 0, 0, 0);
            this.millisAtMonthStart[n - this.firstMonthInTable] = this.calendar.getTime().getTime();
        }
        if (Trace.isOn) {
            Trace.exit(this, "updateTable");
        }
    }

    private long fastDateToMillis(byte[] byArray, byte[] byArray2) {
        if (Trace.isOn) {
            Trace.entry(this, "fastDateToMillis");
        }
        int n = (byArray2[0] - 48) * 1000 + (byArray2[1] - 48) * 100 + (byArray2[2] - 48) * 10 + (byArray2[3] - 48);
        int n2 = (byArray2[4] - 48) * 10 + (byArray2[5] - 48);
        long l = (byArray2[6] - 48) * 10 + (byArray2[7] - 48);
        long l2 = (byArray[0] - 48) * 10 + (byArray[1] - 48);
        long l3 = (byArray[2] - 48) * 10 + (byArray[3] - 48);
        long l4 = (byArray[4] - 48) * 10 + (byArray[5] - 48);
        long l5 = (byArray[6] - 48) * 100 + (byArray[7] - 48) * 10;
        int n3 = (n - 1970) * 12 + n2;
        long l6 = 0L;
        if (n3 > this.firstMonthInTable + 12) {
            Trace.trace(2, this, "date beyond last in table");
            if (System.currentTimeMillis() > this.millisAtMonthStart[11]) {
                this.updateTable();
                l6 = this.millisAtMonthStart[n3 - this.firstMonthInTable - 1] + (l - 1L) * 86400000L + l2 * 3600000L + l3 * 60000L + l4 * 1000L + l5;
            } else {
                l6 = this.slowDateToMillis(n, n2, l, l2, l3, l4, l5);
            }
        } else {
            l6 = n3 > this.firstMonthInTable ? this.millisAtMonthStart[n3 - this.firstMonthInTable - 1] + (l - 1L) * 86400000L + l2 * 3600000L + l3 * 60000L + l4 * 1000L + l5 : this.slowDateToMillis(n, n2, l, l2, l3, l4, l5);
        }
        if (Trace.isOn) {
            Trace.exit(this, "fastDateToMillis");
        }
        return l6;
    }

    private long slowDateToMillis(int n, int n2, long l, long l2, long l3, long l4, long l5) {
        if (Trace.isOn) {
            Trace.entry(this, "slowDateToMillis");
        }
        this.calendar.set(n, n2 - 1, (int)l, (int)l2, (int)l3, (int)l4);
        this.calendar.set(14, (int)l5);
        if (Trace.isOn) {
            Trace.exit(this, "slowDateToMillis");
        }
        return this.calendar.getTime().getTime();
    }

    public static synchronized long mqDateTimeToMillis(byte[] byArray, byte[] byArray2) {
        return instance.fastDateToMillis(byArray, byArray2);
    }

    static {
        instance = new MQDateConverter();
    }
}

