/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.web;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.Arrays;
import org.jumpmind.symmetric.Version;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@OpenAPIDefinition
public class SwaggerConfig {
    private static final String API_KEY_NAME = "SymmetricDS REST";

    @Bean
    public OpenAPI openApi() {
        return new OpenAPI().info(new Info().title("SymmetricDS").version(Version.version())).components(new Components().addSecuritySchemes("api_key", this.securityScheme())).security(Arrays.asList(new SecurityRequirement().addList("api_key")));
    }

    private SecurityScheme securityScheme() {
        return new SecurityScheme().type(SecurityScheme.Type.APIKEY).description(API_KEY_NAME).in(SecurityScheme.In.HEADER).name("X-REST-API-KEY");
    }
}

