/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.log;

import com.jumpmind.symmetric.console.impl.eV;
import com.jumpmind.symmetric.console.impl.hF;
import com.jumpmind.symmetric.console.impl.hm;
import com.jumpmind.symmetric.console.impl.hp;
import com.jumpmind.symmetric.console.impl.hr;
import com.jumpmind.symmetric.console.impl.hs;
import com.jumpmind.symmetric.console.impl.hu;
import com.jumpmind.symmetric.log.b;
import com.jumpmind.symmetric.log.c;
import com.jumpmind.symmetric.log.g;
import com.jumpmind.symmetric.log.h;
import com.jumpmind.symmetric.log.i;
import com.jumpmind.symmetric.log.j;
import com.jumpmind.symmetric.log.l;
import com.jumpmind.symmetric.log.m;
import com.jumpmind.symmetric.log.r;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.NotImplementedException;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.mariadb.MariaDBDatabasePlatform;
import org.jumpmind.db.platform.mysql.MySqlDatabasePlatform;
import org.jumpmind.db.platform.oracle.OracleDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class y
implements h {
    private final Logger r = LoggerFactory.getLogger((String)"com.jumpmind.symmetric.log.TransactionMiner");
    protected final HashSet<String> a = new HashSet<String>(Arrays.asList("INSERT", "UPDATE", "DELETE", "COMMIT", "ROLLBACK", "LOB_WRITE", "LOB_TRIM", "XML DOC BEGIN", "XML DOC WRITE", "XML DOC END"));
    protected ISymmetricEngine b;
    protected IDatabasePlatform c;
    protected ITriggerRouterService d;
    protected hs e;
    protected hu f;
    protected Map<String, l> g;
    protected Collection<j> h;
    protected long i;
    protected b j;
    protected Map<String, b> k = new HashMap<String, b>();
    protected int l;
    protected long m;
    protected boolean n;
    protected Map<String, hm> o = new HashMap<String, hm>();
    protected Map<String, i> p;
    protected Set<String> q = new HashSet<String>();

    public y(ISymmetricEngine engine) {
        this.b = engine;
        this.d = engine.getTriggerRouterService();
        this.c = engine.getTargetDialect().getPlatform();
        this.n = engine.getTargetDialect().getBinaryEncoding().equals((Object)BinaryEncoding.BASE64);
        DataSource dataSource = ((JdbcSqlTemplate)this.c.getSqlTemplate()).getDataSource();
        this.f = new hu(dataSource);
        this.f.b(this.a);
        if (this.c instanceof OracleDatabasePlatform) {
            this.e = new hF(this.f);
        } else if (this.c instanceof MariaDBDatabasePlatform) {
            this.e = new m(engine, this.c, this.f);
        } else if (this.c instanceof MySqlDatabasePlatform) {
            this.e = new r(engine, this.c, this.f);
        } else if (this.c instanceof eV) {
            this.e = new c(engine, this.c, this.f);
        } else {
            throw new NotImplementedException("No miner is available for database platform " + this.c.getName());
        }
    }

    @Override
    public boolean handlesSaveOfNextID() {
        return false;
    }

    @Override
    public void savePositionAndCommit(ISqlTransaction transaction) {
    }

    @Override
    public void setLogTriggerMap(Map<String, l> logTriggerMap) {
        this.g = logTriggerMap;
    }

    @Override
    public void setStartId(long id) {
        this.f.a(id);
        this.i = id;
    }

    @Override
    public void setEndId(long id) {
        this.f.b(id);
    }

    @Override
    public void setOpenTransactions(Collection<j> openTransactions) {
        this.h = openTransactions;
    }

    @Override
    public long getCurrentId() {
        if (this.i == 0L) {
            this.i = this.e.c();
        }
        return this.i;
    }

    @Override
    public long getTotalRowsScanned() {
        return this.m;
    }

    @Override
    public void open() {
        this.l = this.b.getParameterService().getInt("log.miner.xid.queue.threshold");
        this.m = 0L;
        this.b();
        if (this.r.isDebugEnabled()) {
            this.r.debug("Scanning for {} tables: [{}]", (Object)this.g.size(), (Object)com.jumpmind.symmetric.log.l.a(this.g));
        }
        if (this.e instanceof hF) {
            LinkedHashSet<String> owners = new LinkedHashSet<String>();
            boolean ownersUseSpecialSymbols = false;
            for (Trigger trigger : this.b.getTriggerRouterService().getTriggersForCurrentNode(false)) {
                String owner = trigger.getSourceSchemaName() != null ? trigger.getSourceSchemaName() : this.c.getDefaultSchema();
                if (owners.contains(owner)) continue;
                if (owner.contains("*") || owner.contains("!") || owner.contains(",") || owner.contains("$(")) {
                    ownersUseSpecialSymbols = true;
                    break;
                }
                owners.add(owner.toUpperCase());
            }
            if (ownersUseSpecialSymbols) {
                owners.clear();
            }
            if (this.r.isDebugEnabled()) {
                this.r.debug("Oracle log miner will filter by the following owners: " + String.valueOf(owners));
            }
            this.f.c(owners);
            ((hF)this.e).b(this.f);
        }
        this.e.a();
        if (this.e instanceof g) {
            ((g)this.e).a(this.g);
        }
    }

    @Override
    public boolean hasData() {
        if (this.j == null || this.j.size() == 0) {
            long ts;
            long startTime = ts = System.currentTimeMillis();
            long dataCount = 0L;
            long uncommittedCount = 0L;
            hm row = null;
            while ((row = this.e.b()) != null) {
                long logTs;
                this.i = row.a();
                ++dataCount;
                ++this.m;
                int type = row.b();
                String xid = row.f();
                i incomingTransaction = this.p.get(xid);
                if (incomingTransaction != null) {
                    row.a("sourceNodeId", incomingTransaction.b());
                }
                if (row.i()) {
                    this.j = new b(this.b.getStagingManager(), xid, this.l);
                    this.j.a(row);
                    this.a(incomingTransaction);
                    return true;
                }
                if (type == 7) {
                    this.j = this.k.remove(xid);
                    this.a(xid);
                    this.a(incomingTransaction);
                    if (this.j != null) {
                        this.r.debug("Commit XID {}", (Object)xid);
                        return true;
                    }
                } else if (type == 36) {
                    b removeQueue = this.k.remove(xid);
                    this.a(xid);
                    this.a(incomingTransaction);
                    if (removeQueue != null) {
                        this.r.debug("Rollback XID {}", (Object)xid);
                        removeQueue.h();
                    }
                } else {
                    l logTrigger = this.g.get(row.k());
                    if (logTrigger == null) {
                        this.r.debug("Ignoring table {} because it is not configured for capture", (Object)row.k());
                    } else if (!logTrigger.a(row.b())) {
                        this.r.debug("Ignoring {} event for table {} because it is not configured for capture", (Object)row.b(), (Object)row.k());
                    } else if (incomingTransaction != null && !logTrigger.a().isSyncOnIncomingBatch()) {
                        this.r.debug("Loopback prevention for transaction {} from source node {}", (Object)xid, (Object)incomingTransaction.b());
                    } else if (logTrigger.b(this.a(row.b())) && !logTrigger.a(this.a(row))) {
                        this.r.debug("Ignoring {} event for table {} because it doesn't meet the sync condition", (Object)row.b(), (Object)row.k());
                    } else {
                        ++uncommittedCount;
                        this.a(xid, row);
                    }
                }
                if ((logTs = System.currentTimeMillis() - ts) <= 60000L) continue;
                this.r.info("Scanning to find committed data has been processing for {} seconds and {} total rows with {} matching rows", new Object[]{(System.currentTimeMillis() - startTime) / 1000L, dataCount, uncommittedCount});
                ts = System.currentTimeMillis();
            }
            return false;
        }
        return true;
    }

    private void a(String xid) {
        if (this.h != null) {
            Iterator<j> it = this.h.iterator();
            while (it.hasNext()) {
                j lm = it.next();
                if (!lm.a().equals(xid)) continue;
                it.remove();
                break;
            }
        }
    }

    protected void a(String xid, hm row) {
        b dataQueue = this.k.get(xid);
        if (dataQueue == null) {
            dataQueue = new b(this.b.getStagingManager(), xid, this.l);
            this.k.put(xid, dataQueue);
        }
        dataQueue.a(row);
    }

    protected void a(i incomingTransaction) {
        if (incomingTransaction != null) {
            this.q.add(incomingTransaction.a());
        }
    }

    @Override
    public Data readData() {
        Data data = null;
        if (this.j != null) {
            if (this.j.size() > 0) {
                data = this.a(this.j.d());
            }
            if (this.j.size() == 0) {
                this.o.clear();
                this.j.h();
                this.j = null;
            }
        }
        return data;
    }

    private DataEventType a(int type) {
        DataEventType eventType;
        if (type == 1) {
            eventType = DataEventType.INSERT;
        } else if (type == 3) {
            eventType = DataEventType.UPDATE;
        } else if (type == 2) {
            eventType = DataEventType.DELETE;
        } else {
            throw new NotImplementedException("Event type of " + type + " is not supported");
        }
        return eventType;
    }

    protected Data a(hm dataObject) {
        String transactionId = dataObject.f();
        String tableName = dataObject.e();
        DataEventType eventType = null;
        int type = dataObject.b();
        eventType = this.a(type);
        Map<String, hp> map = dataObject.c().g();
        Map<String, hp> pkData = map.get("idData").g();
        Map<String, hp> rowData = map.get("rowData").g();
        Map<String, hp> oldData = null;
        if (!eventType.equals((Object)DataEventType.INSERT)) {
            oldData = map.get("oldData").g();
        }
        Data data = new Data();
        data.setDataEventType(eventType);
        data.setTableName(tableName);
        data.setTransactionId(transactionId);
        data.setSourceNodeId(dataObject.a("sourceNodeId"));
        l logTrigger = this.g.get(dataObject.k());
        if (logTrigger != null) {
            if (dataObject.g() > 0) {
                this.r.debug("Handling rollback of savepoint");
                pkData = this.b(dataObject);
                rowData = this.d(dataObject);
                oldData = this.e(dataObject);
            } else {
                this.c(dataObject);
            }
            TriggerHistory triggerHistory = logTrigger.b();
            Trigger trigger = logTrigger.a();
            data.setChannelId(trigger.getChannelId());
            if (!trigger.isSourceWildCarded() && !trigger.isSourceTableNameExpanded()) {
                data.setTableName(triggerHistory.getSourceTableName());
            }
            data.setTriggerHistory(triggerHistory);
            data.putParsedData("rowData", this.a(rowData, triggerHistory.getParsedColumnNames()));
            data.putParsedData("oldData", this.a(oldData, triggerHistory.getParsedColumnNames()));
            data.putParsedData("pkData", this.a(pkData, triggerHistory.getParsedPkColumnNames()));
        }
        return data;
    }

    private Map<String, hp> b(hm dataObject) {
        Map<String, hp> map;
        hm originalDataObject = this.o.get(dataObject.h());
        Map<String, hp> pkData = null;
        if (originalDataObject != null && (map = originalDataObject.c().g()) != null) {
            pkData = map.get("idData").g();
        }
        this.r.debug("Found pkData: " + String.valueOf(pkData));
        return pkData;
    }

    private void c(hm dataObject) {
        this.o.put(dataObject.h(), dataObject);
    }

    private Map<String, hp> d(hm dataObject) {
        Map<String, hp> rowData = null;
        if (this.a(dataObject.b()) != DataEventType.DELETE) {
            Map<String, hp> map;
            Map<String, hp> originalRowData = null;
            hm originalDataObject = this.o.get(dataObject.h());
            if (originalDataObject != null && (map = dataObject.c().g()) != null) {
                rowData = map.get("rowData").g();
                Map<String, hp> originalMap = originalDataObject.c().g();
                if (originalMap != null && (originalRowData = originalMap.get("rowData").g()) != null) {
                    for (Map.Entry<String, hp> s2 : originalRowData.entrySet()) {
                        if (rowData.containsKey(s2.getKey())) continue;
                        rowData.put(s2.getKey(), s2.getValue());
                    }
                }
            }
            this.r.debug("originalRowData: " + String.valueOf(originalRowData) + " rowData: " + String.valueOf(rowData));
        }
        return rowData;
    }

    private Map<String, hp> e(hm dataObject) {
        Map<String, hp> originalMap;
        Map<String, hp> oldData = null;
        hm originalDataObject = this.o.get(dataObject.h());
        if (originalDataObject != null && (originalMap = originalDataObject.c().g()) != null) {
            oldData = originalMap.get("rowData").g();
        }
        return oldData;
    }

    protected String[] a(Map<String, hp> data, String[] columnNames) {
        ArrayList<String> list = new ArrayList<String>(columnNames.length);
        if (data != null && data.size() > 0) {
            for (String columnName : columnNames) {
                String value;
                hp element = data.get(columnName);
                String string = value = element == null ? null : element.toString();
                if (this.n && element != null && element instanceof hr && value != null) {
                    try {
                        value = new String(Base64.encodeBase64((byte[])Hex.decodeHex((String)value)));
                    }
                    catch (DecoderException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                list.add(value);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Collection<j> getOpenTransactions() {
        if (this.h == null) {
            this.a();
        }
        return this.h;
    }

    protected void a() {
        this.h = new ArrayList<j>();
        for (Map.Entry<String, b> entry : this.k.entrySet()) {
            String xid = entry.getKey();
            long dataId = entry.getValue().c().a();
            this.h.add(new j(xid, dataId));
        }
    }

    protected void b() {
        HashSet<String> xidsToRecover = new HashSet<String>();
        long minStartId = 0L;
        if (this.h != null && this.k.size() == 0) {
            for (j marker : this.h) {
                b dataQueue = null;
                if (this.l != -1) {
                    dataQueue = com.jumpmind.symmetric.log.b.a(this.b.getStagingManager(), marker.a());
                }
                if (dataQueue != null) {
                    this.k.put(marker.a(), dataQueue);
                    xidsToRecover.remove(marker.a());
                    continue;
                }
                if (marker.b() < minStartId || minStartId == 0L) {
                    minStartId = marker.b();
                }
                xidsToRecover.add(marker.a());
            }
            this.h = null;
        }
        if (xidsToRecover.size() > 0) {
            long ts = System.currentTimeMillis();
            if (this.r.isDebugEnabled()) {
                this.r.debug("Loading {} open XIDs: {}", (Object)xidsToRecover.size(), (Object)com.jumpmind.symmetric.log.j.b(xidsToRecover));
            }
            long originalStartId = this.f.d();
            long originalEndId = this.f.e();
            this.f.a(minStartId);
            this.f.b(originalStartId - 1L);
            try {
                this.e.a();
                hm row = null;
                while ((row = this.e.b()) != null) {
                    b removeQueue;
                    String xid = row.f();
                    if (!xidsToRecover.contains(xid)) continue;
                    if (row.j()) {
                        this.a(xid, row);
                        continue;
                    }
                    int type = row.b();
                    if (type == 7) {
                        if (this.j != null) continue;
                        this.j = this.k.remove(xid);
                        if (this.j == null) continue;
                        this.r.debug("Loading committed XID {}", (Object)xid);
                        continue;
                    }
                    if (type != 36 || (removeQueue = this.k.remove(xid)) == null) continue;
                    removeQueue.h();
                }
                this.e.d();
                this.r.debug("Loading open XIDs took {} ms", (Object)(System.currentTimeMillis() - ts));
            }
            catch (Exception e2) {
                if (this.f.d() <= this.f.e()) {
                    throw new RuntimeException(e2);
                }
                this.r.warn("Failed to recover {} open XIDs: {}", new Object[]{xidsToRecover.size(), com.jumpmind.symmetric.log.j.b(xidsToRecover), e2});
            }
            this.f.a(originalStartId);
            this.f.b(originalEndId);
        }
    }

    @Override
    public void close() {
        this.i = 0L;
        if (this.j != null) {
            if (this.j.size() == 0) {
                this.j.h();
                this.j = null;
            } else {
                this.j.i();
            }
        }
        for (b dataQueue : this.k.values()) {
            dataQueue.i();
        }
        this.e.e();
        this.a();
    }

    @Override
    public boolean isWaitsForCommit() {
        return false;
    }

    @Override
    public boolean needsIncomingTransactions() {
        return true;
    }

    @Override
    public void setIncomingTransactions(Map<String, i> incomingTransactions) {
        this.p = incomingTransactions;
    }

    @Override
    public Set<String> getIncomingMinedTransactionIds() {
        return this.q;
    }

    @Override
    public void setTransaction(ISqlTransaction transaction) {
    }
}

