/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.cosmos;

import com.azure.cosmos.ChangeFeedProcessor;
import com.azure.cosmos.ChangeFeedProcessorBuilder;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.models.ChangeFeedProcessorOptions;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerRequestOptions;
import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.ThroughputProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.jumpmind.symmetric.db.cosmos.e;
import com.jumpmind.symmetric.log.h;
import com.jumpmind.symmetric.log.i;
import com.jumpmind.symmetric.log.j;
import com.jumpmind.symmetric.log.l;
import com.jumpmind.symmetric.log.z;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.scheduler.Schedulers;

public class g
implements h {
    private final Logger j = LoggerFactory.getLogger((String)g.class.getName());
    protected ISymmetricEngine a;
    protected CosmosClient b = null;
    protected CosmosAsyncClient c = null;
    private static AtomicBoolean k = new AtomicBoolean(false);
    private Map<String, ChangeFeedProcessor> l = new HashMap<String, ChangeFeedProcessor>();
    private Queue<Data> m = new LinkedList<Data>();
    protected Map<String, l> d;
    protected String e;
    protected String f = null;
    protected boolean g;
    protected String h;
    protected CosmosAsyncContainer i;

    public g(ISymmetricEngine engine) {
        this.a = engine;
        this.b = ((e)engine.getTargetDialect().getTargetPlatform()).a(true);
        this.c = ((e)engine.getTargetDialect().getTargetPlatform()).b(true);
        this.h = ((e)engine.getTargetDialect().getTargetPlatform()).getDefaultCatalog();
        this.f = engine.getContextService().getString("log.miner.next.id");
        List triggerRouters = engine.getTriggerRouterService().getAllTriggerRoutersForCurrentNode(engine.getNodeService().findIdentity().getNodeGroupId());
        for (TriggerRouter triggerRouter : triggerRouters) {
            if (triggerRouter.getTrigger().getSourceTableNameLowerCase().startsWith(engine.getSymmetricDialect().getTablePrefix()) || this.l.containsKey(triggerRouter.getTrigger().getFullyQualifiedSourceTableName())) continue;
            ChangeFeedProcessor changeFeedProcessorInstance = this.a(this.c, triggerRouter.getRouter().getTargetCatalogName() == null ? this.h : triggerRouter.getRouter().getTargetCatalogName(), triggerRouter.getRouter().getTargetTableName() == null ? triggerRouter.getTrigger().getSourceTableName() : triggerRouter.getRouter().getTargetTableName());
            this.a(changeFeedProcessorInstance);
            this.l.put(triggerRouter.getTrigger().getFullyQualifiedSourceTableName(), changeFeedProcessorInstance);
        }
    }

    @Override
    public void setLogTriggerMap(Map<String, l> logTriggerMap) {
        this.d = logTriggerMap;
    }

    @Override
    public void setStartId(long id) {
    }

    @Override
    public void setEndId(long id) {
    }

    @Override
    public void setOpenTransactions(Collection<j> openTransactions) {
    }

    @Override
    public boolean hasData() throws z {
        return this.m.size() > 0;
    }

    @Override
    public Data readData() {
        return this.m.poll();
    }

    @Override
    public void savePositionAndCommit(ISqlTransaction transaction) {
        if (this.f != null && !this.g) {
            if (this.j.isDebugEnabled()) {
                this.j.debug("Change processor saving position at continuation token {} ", (Object)this.f);
            }
            this.a.getContextService().save(transaction, "log.miner.next.id", this.f);
            transaction.commit();
            this.g = true;
        }
    }

    @Override
    public void open() throws z {
    }

    protected void a(ChangeFeedProcessor changeFeedProcessorInstance) {
        try {
            changeFeedProcessorInstance.start().subscribeOn(Schedulers.boundedElastic()).doOnSuccess(aVoid -> k.set(true)).subscribe();
            while (!k.get()) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ChangeFeedProcessor a(CosmosAsyncClient client, String databaseName, String collectionName) {
        if (this.i == null) {
            this.i = this.c(client, databaseName, "symmetricds-leases");
        }
        ChangeFeedProcessorOptions options = new ChangeFeedProcessorOptions();
        options.setStartContinuation(this.f);
        this.j.info("Creating change processor for continuation token {} ", (Object)this.f);
        return new ChangeFeedProcessorBuilder().hostName("host - " + collectionName).feedContainer(this.b(client, databaseName, collectionName)).leaseContainer(this.i).options(options).handleChanges(docs -> {
            for (JsonNode document : docs) {
                Data data = new Data();
                try {
                    this.j.debug("Change processor document read: " + document.toPrettyString());
                    l logTrigger = this.d.get(databaseName + "." + collectionName);
                    data.setDataEventType(DataEventType.UPDATE);
                    data.setTableName(collectionName);
                    data.setTransactionId(document.get("_lsn") == null ? this.a() : document.get("_lsn").toString());
                    TriggerHistory history = logTrigger.b();
                    data.setTriggerHistory(history);
                    data.setChannelId(logTrigger.a().getChannelId());
                    StringBuilder rowData = new StringBuilder();
                    for (String columnName : history.getParsedColumnNames()) {
                        JsonNode value;
                        if (rowData.length() > 0) {
                            rowData.append(",");
                        }
                        rowData.append((value = document.findValue(columnName)) == null ? "" : value.toPrettyString());
                    }
                    data.setRowData(rowData.toString());
                    this.m.add(data);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                finally {
                    if (data.getTransactionId() == null) continue;
                    this.f = data.getTransactionId();
                    this.g = false;
                    this.j.debug("Continuation token read in from change processor : " + this.f);
                }
            }
        }).buildChangeFeedProcessor();
    }

    public String a() {
        return String.valueOf(new Random().nextLong());
    }

    public CosmosAsyncContainer b(CosmosAsyncClient client, String databaseName, String collectionName) {
        CosmosAsyncDatabase databaseLink = client.getDatabase(databaseName);
        CosmosAsyncContainer collectionLink = databaseLink.getContainer(collectionName);
        if (collectionLink != null) {
            return collectionLink;
        }
        CosmosContainerResponse containerResponse = null;
        try {
            containerResponse = (CosmosContainerResponse)collectionLink.read().block();
            if (containerResponse != null) {
                throw new IllegalArgumentException(String.format("Collection %s already exists in database %s.", collectionName, databaseName));
            }
        }
        catch (RuntimeException ex2) {
            if (ex2 instanceof CosmosException) {
                CosmosException CosmosException2 = (CosmosException)ex2;
                if (CosmosException2.getStatusCode() != 404) {
                    throw ex2;
                }
            }
            throw ex2;
        }
        CosmosContainerProperties containerSettings = new CosmosContainerProperties(collectionName, "/pk");
        CosmosContainerRequestOptions requestOptions = new CosmosContainerRequestOptions();
        ThroughputProperties throughputProperties = ThroughputProperties.createManualThroughput((int)10000);
        containerResponse = (CosmosContainerResponse)databaseLink.createContainer(containerSettings, throughputProperties, requestOptions).block();
        if (containerResponse == null) {
            throw new RuntimeException(String.format("Failed to create collection %s in database %s.", collectionName, databaseName));
        }
        return databaseLink.getContainer(containerResponse.getProperties().getId());
    }

    public CosmosAsyncContainer c(CosmosAsyncClient client, String databaseName, String leaseCollectionName) {
        CosmosAsyncDatabase databaseLink = client.getDatabase(databaseName);
        CosmosAsyncContainer leaseCollectionLink = databaseLink.getContainer(leaseCollectionName);
        CosmosContainerResponse leaseContainerResponse = null;
        try {
            leaseContainerResponse = (CosmosContainerResponse)leaseCollectionLink.read().block();
            if (leaseContainerResponse != null) {
                leaseCollectionLink.delete().block();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        catch (RuntimeException ex3) {
            if (ex3 instanceof CosmosException) {
                CosmosException CosmosException2 = (CosmosException)ex3;
                if (CosmosException2.getStatusCode() != 404) {
                    throw ex3;
                }
            }
            throw ex3;
        }
        CosmosContainerProperties containerSettings = new CosmosContainerProperties(leaseCollectionName, "/id");
        CosmosContainerRequestOptions requestOptions = new CosmosContainerRequestOptions();
        ThroughputProperties throughputProperties = ThroughputProperties.createManualThroughput((int)400);
        leaseContainerResponse = (CosmosContainerResponse)databaseLink.createContainer(containerSettings, throughputProperties, requestOptions).block();
        if (leaseContainerResponse == null) {
            throw new RuntimeException(String.format("Failed to create collection %s in database %s.", leaseCollectionName, databaseName));
        }
        return databaseLink.getContainer(leaseContainerResponse.getProperties().getId());
    }

    @Override
    public long getCurrentId() {
        return this.f == null ? 0L : (long)Integer.parseInt(this.f);
    }

    @Override
    public long getTotalRowsScanned() {
        return 0L;
    }

    @Override
    public Collection<j> getOpenTransactions() {
        return null;
    }

    @Override
    public boolean isWaitsForCommit() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean handlesSaveOfNextID() {
        return true;
    }

    @Override
    public boolean needsIncomingTransactions() {
        return false;
    }

    @Override
    public void setIncomingTransactions(Map<String, i> incomingTransactions) {
    }

    @Override
    public Set<String> getIncomingMinedTransactionIds() {
        return null;
    }

    @Override
    public void setTransaction(ISqlTransaction transaction) {
    }
}

