/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.bulk;

import java.io.FileInputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.JdbcSqlTransaction;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.db.util.ResettableBasicDataSource;
import org.jumpmind.symmetric.io.AbstractBulkDatabaseWriter;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class y
extends AbstractBulkDatabaseWriter {
    private static final Logger j = LoggerFactory.getLogger(y.class);
    protected IStagingManager a;
    protected IStagedResource b;
    protected String c = "\r\n";
    protected String d = ",";
    protected int e = 0;
    protected boolean f;
    protected boolean g;
    protected Table h = null;
    protected int i;

    public y(IDatabasePlatform symmetricPlatform, IDatabasePlatform tar, String tablePrefix, IStagingManager stagingManager, DatabaseWriterSettings settings) {
        super(symmetricPlatform, tar, tablePrefix);
        this.a = stagingManager;
        this.writerSettings = settings;
    }

    public boolean start(Table table) {
        this.h = table;
        if (super.start(table) && this.targetTable != null) {
            this.f = false;
            if (this.batch.getBinaryEncoding() != BinaryEncoding.HEX) {
                for (Column column : this.targetTable.getColumns()) {
                    if (!column.isOfBinaryType()) continue;
                    this.f = true;
                    break;
                }
            }
            this.g = false;
            if (this.b == null) {
                this.c();
            }
        }
        return true;
    }

    public void end(Table table) {
        try {
            this.a();
            if (this.b != null) {
                this.b.close();
                this.b.delete();
            }
        }
        finally {
            super.end(table);
        }
    }

    protected void bulkWrite(CsvData data) {
        DataEventType dataEventType = data.getDataEventType();
        switch (dataEventType) {
            case INSERT: {
                ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
                try {
                    int i2;
                    String[] parsedData = data.getParsedData("rowData");
                    if (this.f) {
                        Column[] columns = this.targetTable.getColumns();
                        for (i2 = 0; i2 < columns.length; ++i2) {
                            if (!columns[i2].isOfBinaryType() || this.batch.getBinaryEncoding() != BinaryEncoding.BASE64 || parsedData[i2] == null) continue;
                            parsedData[i2] = new String(Hex.encodeHex((byte[])Base64.decodeBase64((byte[])parsedData[i2].getBytes(Charset.defaultCharset()))));
                        }
                    }
                    OutputStream out = this.b.getOutputStream();
                    if (!this.g) {
                        String[] columnNames = this.targetTable.getColumnNames();
                        for (int i3 = 0; i3 < columnNames.length; ++i3) {
                            if (columnNames[i3] != null) {
                                out.write(columnNames[i3].getBytes(Charset.defaultCharset()));
                                this.i += columnNames[i3].getBytes(Charset.defaultCharset()).length;
                            }
                            if (i3 + 1 >= columnNames.length) continue;
                            out.write(this.d.getBytes(Charset.defaultCharset()));
                            this.i += this.d.getBytes(Charset.defaultCharset()).length;
                        }
                        out.write(this.c.getBytes(Charset.defaultCharset()));
                        this.i += this.c.getBytes(Charset.defaultCharset()).length;
                        this.g = true;
                    }
                    for (i2 = 0; i2 < parsedData.length; ++i2) {
                        if (parsedData[i2] != null) {
                            out.write(parsedData[i2].getBytes(Charset.defaultCharset()));
                            this.i += parsedData[i2].getBytes(Charset.defaultCharset()).length;
                        }
                        if (i2 + 1 >= parsedData.length) continue;
                        out.write(this.d.getBytes(Charset.defaultCharset()));
                        this.i += this.d.getBytes(Charset.defaultCharset()).length;
                    }
                    out.write(this.c.getBytes(Charset.defaultCharset()));
                    this.i += this.c.getBytes(Charset.defaultCharset()).length;
                    ++this.e;
                    break;
                }
                catch (Exception ex2) {
                    throw this.getPlatform(this.h).getSqlTemplate().translate((Throwable)ex2);
                }
                finally {
                    ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
                    ((Statistics)this.statistics.get(this.batch)).increment("STATEMENTCOUNT");
                    ((Statistics)this.statistics.get(this.batch)).increment("LINENUMBER");
                }
            }
            default: {
                this.a();
                this.writeDefault(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a() {
        if (this.e > 0 && this.b != null) {
            this.b.close();
            ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
            Connection c2 = null;
            ResettableBasicDataSource ds2 = null;
            Statement ps = null;
            Object fastLoadConnectionString = "TMODE=ANSI,CHARSET=UTF8,TYPE=FASTLOADCSV";
            DatabaseInfo dbInfo = this.getPlatform().getDatabaseInfo();
            String quote = dbInfo.getDelimiterToken();
            String catalogSeparator = dbInfo.getCatalogSeparator();
            String schemaSeparator = dbInfo.getSchemaSeparator();
            String tableName = this.getTargetTable().getQualifiedTableName(quote, catalogSeparator, schemaSeparator);
            try {
                boolean lastCharSlash;
                this.a(tableName, false);
                IDatabasePlatform platform = this.getPlatform();
                ds2 = (ResettableBasicDataSource)platform.getDataSource();
                boolean containsCommas = ds2.getUrl().indexOf(",") > 0;
                boolean bl2 = lastCharSlash = ds2.getUrl().charAt(ds2.getUrl().length() - 1) == '/';
                fastLoadConnectionString = (lastCharSlash && containsCommas ? "," : (lastCharSlash ? "" : "/")) + (String)fastLoadConnectionString;
                if (ds2.getUrl().indexOf((String)fastLoadConnectionString) < 0) {
                    ds2.setUrl(ds2.getUrl() + (String)fastLoadConnectionString);
                }
                c2 = DriverManager.getConnection(ds2.getUrl(), ds2.getUserName(), ds2.getPassword());
                String sql = String.format("INSERT INTO " + tableName + " VALUES " + this.b(), new Object[0]);
                ps = c2.prepareStatement(sql);
                FileInputStream dataStream = new FileInputStream(this.b.getFile());
                ps.setAsciiStream(1, dataStream, -1);
                ps.executeUpdate();
                j.info("Fast load complete.");
            }
            catch (SQLException e2) {
                while (e2 != null) {
                    j.error("SQL State = " + e2.getSQLState() + ", Error Code = " + e2.getErrorCode());
                    if ((e2 = e2.getNextException()).getErrorCode() != 2636) continue;
                    j.warn("In order to use the teradata bulk loader the target table " + tableName + " must me empty");
                }
                throw this.getPlatform().getSqlTemplate().translate((Throwable)e2);
            }
            catch (Exception e2) {
            }
            finally {
                ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
                this.i = 0;
                this.a(tableName, false);
                if (c2 != null) {
                    try {
                        c2.close();
                    }
                    catch (SQLException sqle) {
                        j.error("Unable to close teradata connection", (Throwable)sqle);
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sqle) {
                        j.error("Unable to close teradata prepared statement", (Throwable)sqle);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(String tableName, boolean clearTargetTable) {
        JdbcSqlTransaction jdbcTransaction = (JdbcSqlTransaction)this.getTargetTransaction();
        Connection normalConnection = jdbcTransaction.getConnection();
        Statement stmt = null;
        if (clearTargetTable) {
            try {
                stmt = normalConnection.createStatement();
                stmt.execute("delete from " + tableName);
            }
            catch (Exception e2) {
                j.info("Unable to delete from teradata table + " + tableName + " before fast load.");
            }
            finally {
                this.a(stmt);
            }
        }
        try {
            normalConnection.setAutoCommit(true);
            stmt = normalConnection.createStatement();
            stmt.execute("drop table " + tableName + "_ERR_1");
        }
        catch (Exception e3) {
            j.info("Unable to drop teradata table + " + tableName + "_ERR_1 before fast load.");
        }
        finally {
            this.a(stmt);
        }
        try {
            normalConnection.setAutoCommit(true);
            stmt = normalConnection.createStatement();
            stmt.execute("drop table " + tableName + "_ERR_2");
        }
        catch (Exception e4) {
            j.info("Unable to drop teradata table + " + tableName + "_ERR_2 before fast load.");
        }
        finally {
            this.a(stmt);
        }
    }

    protected void a(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sqle) {
                j.error("Unable to close statement", (Throwable)sqle);
            }
        }
    }

    protected String b() {
        StringBuilder sql = new StringBuilder("(");
        for (int i2 = 0; i2 < this.getTargetTable().getColumnCount(); ++i2) {
            if (i2 > 0) {
                sql.append(",");
            }
            sql.append("?");
        }
        sql.append(")");
        return sql.toString();
    }

    protected void c() {
        this.b = this.a.create(new Object[]{"bulkloaddir", this.h.getName() + this.getBatch().getBatchId() + ".csv"});
    }
}

